/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.flipkart.krystal.lattice.core.LatticeAppBootstrap;
import com.flipkart.krystal.lattice.core.LatticeAppConfig;
import com.flipkart.krystal.lattice.core.di.DependencyInjectionBinder;
import com.flipkart.krystal.lattice.core.di.DependencyInjector;
import com.flipkart.krystal.lattice.core.doping.Dopant;
import com.flipkart.krystal.lattice.core.doping.DopantConfig;
import com.flipkart.krystal.lattice.core.doping.DopantSpec;
import com.flipkart.krystal.lattice.core.doping.DopantSpecBuilder;
import com.flipkart.krystal.lattice.core.doping.DopantSpecBuilderWithAnnotation;
import com.flipkart.krystal.lattice.core.doping.DopantSpecBuilderWithConfig;
import com.flipkart.krystal.lattice.core.doping.DopantType;
import com.flipkart.krystal.lattice.core.doping.SimpleDopantSpecBuilder;
import com.flipkart.krystal.lattice.core.doping.SpecBuilders;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public abstract class LatticeApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LatticeApplication.class);
    private final ObjectMapper configMapper = ((YAMLMapper)YAMLMapper.builder().build()).registerModule((Module)new GuavaModule()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(SerializationFeature.FAIL_ON_SELF_REFERENCES);

    public abstract DependencyInjectionBinder getDependencyInjectionBinder();

    public final void init(String[] args) throws Exception {
        URL configResource;
        DependencyInjectionBinder dependencyInjectionBinder = this.getDependencyInjectionBinder();
        dependencyInjectionBinder.bindToInstance(DependencyInjectionBinder.class, dependencyInjectionBinder);
        Option latticeConfigFileOption = new Option("l", "lattice_config_file", true, "Lattice app config file");
        CommandLine commandLine = new DefaultParser().parse(new Options().addOption(latticeConfigFileOption), args);
        String latticeConfigFile = commandLine.getOptionValue(latticeConfigFileOption);
        LatticeAppBootstrap bootstrap = new LatticeAppBootstrap();
        this.bootstrap(bootstrap);
        ImmutableMap allSpecBuilders = ImmutableMap.copyOf(bootstrap.specBuilders());
        BiMap<String, Class<? extends DopantConfig>> configTypesByDopantTypes = this.getConfigTypesByDopantTypes((ImmutableMap<Class<? extends DopantSpecBuilder>, DopantSpecBuilder>)allSpecBuilders);
        this.configMapper.registerSubtypes((NamedType[])configTypesByDopantTypes.entrySet().stream().map(e -> new NamedType((Class)e.getValue(), (String)e.getKey())).toArray(NamedType[]::new));
        ImmutableMap<String, Annotation> annotationsByDopantType = this.getAppAnnotationsByDopantType();
        annotationsByDopantType.forEach((dopantType, annotation) -> dependencyInjectionBinder.bindToInstance(annotation.annotationType(), annotation));
        System.err.println("Lattice app args in APP: " + Arrays.deepToString(args));
        LatticeAppConfig latticeAppConfig = latticeConfigFile == null ? new LatticeAppConfig() : ((configResource = Objects.requireNonNull(this.getClass().getClassLoader()).getResource(latticeConfigFile)) == null ? new LatticeAppConfig() : (LatticeAppConfig)this.configMapper.readValue(configResource, LatticeAppConfig.class));
        latticeAppConfig.configsByDopantType().forEach((dopantType, config) -> {
            Class configType = (Class)configTypesByDopantTypes.get(dopantType);
            if (configType != null) {
                dependencyInjectionBinder.bindToInstance(configType, config);
            }
        });
        Collection<Object> currentIteration = new ArrayList(allSpecBuilders.values());
        LinkedHashMap accumulator = new LinkedHashMap((Map<Class<?>, DopantSpecBuilder<?, ?, ?>>)allSpecBuilders);
        while (!currentIteration.isEmpty()) {
            LinkedHashMap newBatch = new LinkedHashMap();
            for (DopantSpecBuilder specBuilder : currentIteration) {
                List<DopantSpecBuilder<?, ?, ?>> additionalDopants = specBuilder.getAdditionalDopants();
                Iterator<DopantSpecBuilder<?, ?, ?>> iterator = additionalDopants.iterator();
                while (iterator.hasNext()) {
                    DopantSpecBuilder<?, ?, ?> additionalDopant = iterator.next();
                    Class<?> newType = additionalDopant.getClass();
                    if (accumulator.containsKey(newType)) continue;
                    newBatch.put(newType, additionalDopant);
                    accumulator.put(newType, additionalDopant);
                }
            }
            currentIteration = newBatch.values();
        }
        Collection values = accumulator.values();
        SpecBuilders specBuilders = new SpecBuilders((ImmutableMap<Class<? extends DopantSpecBuilder>, DopantSpecBuilder>)allSpecBuilders);
        values.forEach(builder -> builder._configure(specBuilders));
        List<DopantSpec> specs = values.stream().map(builder -> {
            boolean noAnnotation = DopantConfig.NoAnnotation.class.isAssignableFrom(builder._annotationType());
            Class configurationType = builder._configurationType();
            boolean noConfig = DopantConfig.NoConfiguration.class.isAssignableFrom(configurationType);
            if (noAnnotation && noConfig) {
                if (builder instanceof SimpleDopantSpecBuilder) {
                    SimpleDopantSpecBuilder simpleDSB = (SimpleDopantSpecBuilder)builder;
                    return Optional.of(simpleDSB._buildSpec());
                }
                log.error("Expected '{}' to extend 'SimpleDopantSpecBuilder' as dopantSpec has no annotation and no configuration", builder.getClass());
            } else {
                String dopantType = builder._dopantType();
                if (noAnnotation) {
                    if (builder instanceof DopantSpecBuilderWithConfig) {
                        DopantSpecBuilderWithConfig builderWithConfig = (DopantSpecBuilderWithConfig)builder;
                        DopantConfig dopantConfig = latticeAppConfig.configsByDopantType().get(dopantType);
                        return Optional.of(builderWithConfig._buildSpec(dopantConfig));
                    }
                    log.error("Expected '{}' to extend 'DopantSpecBuilderWithConfig' dopantSpec has no annotation and has a configuration", builder.getClass());
                } else if (noConfig) {
                    if (builder instanceof DopantSpecBuilderWithAnnotation) {
                        DopantSpecBuilderWithAnnotation builderWithAnno = (DopantSpecBuilderWithAnnotation)builder;
                        Annotation annotation = (Annotation)annotationsByDopantType.get((Object)dopantType);
                        return Optional.of(builderWithAnno._buildSpec(annotation));
                    }
                    log.error("Expected '{}' to extend 'DopantSpecBuilderWithAnnotation' dopantSpec has no configuration and has an annotation", builder.getClass());
                } else {
                    Annotation annotation = (Annotation)annotationsByDopantType.get((Object)dopantType);
                    DopantConfig dopantConfig = latticeAppConfig.configsByDopantType().get(dopantType);
                    return Optional.of(builder._buildSpec(annotation, dopantConfig));
                }
            }
            return Optional.empty();
        }).filter(Optional::isPresent).map(Optional::get).toList();
        for (DopantSpec spec2 : specs) {
            Class<?> aClass = spec2.getClass();
            dependencyInjectionBinder.bindToInstance(aClass, spec2);
            Class dopantClass = spec2.dopantClass();
            if (Modifier.isAbstract(dopantClass.getModifiers())) continue;
            dependencyInjectionBinder.bindInSingleton(dopantClass);
        }
        DependencyInjector injector = dependencyInjectionBinder.getInjector();
        List<Dopant> dopants = specs.stream().map(spec -> {
            Class clazz = spec.dopantClass();
            Dopant instance = injector.getInstance(clazz);
            return instance;
        }).toList();
        for (Dopant dopant : dopants) {
            dopant.start(args);
        }
        ListIterator<Dopant> itr = dopants.listIterator(dopants.size());
        while (itr.hasPrevious()) {
            itr.previous().tryMainMethodExit();
        }
    }

    private ImmutableMap<String, Annotation> getAppAnnotationsByDopantType() {
        Annotation[] annotations = this.getClass().getAnnotations();
        LinkedHashMap<String, Annotation> dopantAnnotations = new LinkedHashMap<String, Annotation>();
        for (Annotation annotation : annotations) {
            DopantType dopantTypeAnno = annotation.annotationType().getAnnotation(DopantType.class);
            if (dopantTypeAnno == null) continue;
            dopantAnnotations.put(dopantTypeAnno.value(), annotation);
        }
        return ImmutableMap.copyOf(dopantAnnotations);
    }

    public abstract void bootstrap(LatticeAppBootstrap var1);

    private BiMap<String, Class<? extends DopantConfig>> getConfigTypesByDopantTypes(ImmutableMap<Class<? extends DopantSpecBuilder>, DopantSpecBuilder> allSpecBuilders) {
        HashBiMap configTypesByName = HashBiMap.create();
        for (DopantSpecBuilder specBuilder : allSpecBuilders.values()) {
            Class configurationType = specBuilder._configurationType();
            if (DopantConfig.NoConfiguration.class.isAssignableFrom(configurationType)) continue;
            DopantType dopantTypeAnno = configurationType.getAnnotation(DopantType.class);
            if (dopantTypeAnno == null) {
                log.error("Configuration type '{}' of SpecBuilder Type '{}' doesn't have the annotation '{}'. Ignoring this configuration.", new Object[]{configurationType, specBuilder.getClass(), DopantType.class});
                continue;
            }
            String dopantType = dopantTypeAnno.value();
            if (configTypesByName.containsKey((Object)dopantType)) {
                log.error("Dopant type '{}' of config class '{}' clashes with dopant type of config class '{}'. Ignoring this config type", new Object[]{dopantType, configurationType, configTypesByName.get((Object)dopantType)});
                continue;
            }
            configTypesByName.put((Object)dopantType, configurationType);
        }
        return configTypesByName;
    }
}

