/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenContext;
import com.flipkart.krystal.lattice.codegen.spi.LatticeAppImplContributor;
import com.flipkart.krystal.lattice.codegen.spi.LatticeCodeGeneratorProvider;
import com.flipkart.krystal.lattice.codegen.spi.di.DepInjectBinderGen;
import com.flipkart.krystal.lattice.core.LatticeApp;
import com.flipkart.krystal.lattice.core.LatticeApplication;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@AutoService(value={LatticeCodeGeneratorProvider.class})
public final class LatticeAppImplGenProvider
implements LatticeCodeGeneratorProvider {
    @Override
    public CodeGenerator create(LatticeCodegenContext latticeCodegenContext) {
        return new LatticeAppImplGen(latticeCodegenContext);
    }

    public static final class LatticeAppImplGen
    implements CodeGenerator {
        private final LatticeCodegenContext context;
        private final CodeGenUtility util;
        private final DepInjectBinderGen depInjectBinderGen;

        public LatticeAppImplGen(LatticeCodegenContext context) {
            this.context = context;
            this.util = context.codeGenUtility().codegenUtil();
            List<DepInjectBinderGen> services = ServiceLoader.load(DepInjectBinderGen.class, this.getClass().getClassLoader()).stream().map(ServiceLoader.Provider::get).filter(s -> s.isApplicable(context)).toList();
            if (services.size() > 1) {
                throw this.util.errorAndThrow("Found more than one Service Providers for 'DepInjectBinderGen'. This is not allowed", new Element[0]);
            }
            if (services.isEmpty()) {
                throw this.util.errorAndThrow("Could not find any Service Providers for 'DepInjectBinderGen'", new Element[0]);
            }
            this.depInjectBinderGen = services.get(0);
        }

        public void generate() {
            if (!this.isApplicable()) {
                return;
            }
            TypeElement latticeApp = this.context.latticeAppTypeElement();
            String packageName = this.util.processingEnv().getElementUtils().getPackageOf(latticeApp).getQualifiedName().toString();
            ClassName latticeAppImplClassName = ClassName.get((String)packageName, (String)(latticeApp.getSimpleName().toString() + "_Impl"), (String[])new String[0]);
            TypeSpec.Builder classBuilder = this.util.classBuilder(latticeAppImplClassName.simpleName(), latticeApp.getQualifiedName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(latticeApp.asType()).addMethod(this.getMainMethod(latticeAppImplClassName, latticeApp, this.context)).addMethods(ServiceLoader.load(LatticeAppImplContributor.class, this.getClass().getClassLoader()).stream().map(ServiceLoader.Provider::get).map(contrib -> contrib.methods(this.context)).flatMap(Collection::stream).toList()).addFields(ServiceLoader.load(LatticeAppImplContributor.class, this.getClass().getClassLoader()).stream().map(ServiceLoader.Provider::get).map(contrib -> contrib.fields(this.context)).flatMap(Collection::stream).toList()).addAnnotations(this.getTypeAnnotations()).addMethod(MethodSpec.overriding((ExecutableElement)Objects.requireNonNull(this.util.getMethod(LatticeApplication.class, "getDependencyInjectionBinder", 0))).returns(TypeName.get((TypeMirror)this.util.getTypeFromAnnotationMember(() -> ((LatticeApp)this.context.latticeApp()).dependencyInjectionBinder()))).addCode("$L", new Object[]{this.depInjectBinderGen.getBinderCreationCode(this.context)}).build());
            StringWriter writer = new StringWriter();
            try {
                JavaFile.builder((String)packageName, (TypeSpec)classBuilder.build()).build().writeTo((Appendable)writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.util.generateSourceFile(latticeAppImplClassName.canonicalName(), writer.toString(), latticeApp);
        }

        private List<AnnotationSpec> getTypeAnnotations() {
            return ServiceLoader.load(LatticeAppImplContributor.class, this.getClass().getClassLoader()).stream().map(ServiceLoader.Provider::get).map(c -> c.classAnnotations(this.context)).flatMap(Collection::stream).toList();
        }

        private MethodSpec getMainMethod(ClassName latticeAppImplClassName, TypeElement latticeApp, LatticeCodegenContext context) {
            ServiceLoader<LatticeAppImplContributor> contributors = ServiceLoader.load(LatticeAppImplContributor.class, this.getClass().getClassLoader());
            Map<Class, Optional> mainMethods = contributors.stream().map(ServiceLoader.Provider::get).collect(Collectors.toMap(latticeAppImplContributor -> latticeAppImplContributor.getClass(), c -> Optional.ofNullable(c.mainMethod(context))));
            List<MethodSpec> mainMethodsList = mainMethods.values().stream().filter(Optional::isPresent).map(Optional::get).toList();
            if (mainMethodsList.size() > 1) {
                this.util.error("More than main method providers found for Lattice App impl. Providers are : " + String.valueOf(mainMethods.keySet()), new Element[]{latticeApp});
                return mainMethodsList.get(0);
            }
            if (mainMethodsList.size() == 1) {
                return mainMethodsList.get(0);
            }
            return MethodSpec.methodBuilder((String)"main").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(TypeName.VOID).addParameter(ParameterSpec.builder(String[].class, (String)"_args", (Modifier[])new Modifier[0]).build()).addException(Exception.class).addNamedCode("$system:T.exit(new $implClass:T().init(_args));", Map.of("system", System.class, "implClass", latticeAppImplClassName)).build();
        }

        private boolean isApplicable() {
            if (!CodegenPhase.FINAL.equals((Object)this.context.codegenPhase())) {
                this.util.note((CharSequence)"Skipping Lattice App Impl codegen current phase is not FINAL");
                return false;
            }
            return true;
        }
    }
}

