/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenContext;
import com.flipkart.krystal.lattice.codegen.spi.di.Binding;
import com.flipkart.krystal.lattice.codegen.spi.di.BindingsContainer;
import com.flipkart.krystal.lattice.codegen.spi.di.BindingsProvider;
import com.flipkart.krystal.lattice.codegen.spi.di.ProviderMethod;
import com.flipkart.krystal.lattice.core.LatticeAppBootstrap;
import com.flipkart.krystal.lattice.core.LatticeAppConfig;
import com.flipkart.krystal.lattice.core.LatticeDopantSet;
import com.flipkart.krystal.lattice.core.di.Produces;
import com.flipkart.krystal.lattice.core.doping.AutoConfigure;
import com.flipkart.krystal.lattice.core.doping.DopantConfig;
import com.flipkart.krystal.lattice.core.doping.DopantSpec;
import com.flipkart.krystal.lattice.core.doping.DopantSpecBuilder;
import com.flipkart.krystal.lattice.core.doping.DopantType;
import com.flipkart.krystal.lattice.core.doping.DopeWith;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import jakarta.enterprise.context.NormalScope;
import jakarta.inject.Qualifier;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoService(value={BindingsProvider.class})
public class DopantBindingsProvider
implements BindingsProvider {
    @Override
    public ImmutableList<BindingsContainer> bindings(LatticeCodegenContext context) {
        ProcessingEnvironment processingEnv;
        List<ExecutableElement> dopingMethods = context.latticeAppTypeElement().getEnclosedElements().stream().filter(e -> e instanceof ExecutableElement).map(ExecutableElement.class::cast).filter(e -> e.getAnnotation(DopeWith.class) != null).toList();
        for (ExecutableElement executableElement : dopingMethods) {
            this.validateDopingMethod(executableElement, context);
        }
        LinkedHashMap<TypeElement, DopantTypesInfo> infosBySpecBuilder = new LinkedHashMap<TypeElement, DopantTypesInfo>();
        for (ExecutableElement dopingMethod : dopingMethods) {
            processingEnv = context.codeGenUtility().codegenUtil().processingEnv();
            TypeMirror dopantSpecBuilderType = dopingMethod.getReturnType();
            TypeElement dopantSpecBuilderElem = (TypeElement)processingEnv.getTypeUtils().asElement(dopantSpecBuilderType);
            ImmutableList typeParamTypes = context.codeGenUtility().codegenUtil().getTypeParamTypes(dopantSpecBuilderElem, processingEnv.getElementUtils().getTypeElement(Objects.requireNonNull(DopantSpecBuilder.class.getCanonicalName())));
            TypeMirror dopantAnnoType = (TypeMirror)typeParamTypes.get(0);
            TypeElement dopantAnnoElement = (TypeElement)processingEnv.getTypeUtils().asElement(dopantAnnoType);
            TypeMirror dopantConfigType = (TypeMirror)typeParamTypes.get(1);
            TypeElement dopantConfigElement = (TypeElement)processingEnv.getTypeUtils().asElement(dopantConfigType);
            TypeMirror dopantSpecType = (TypeMirror)typeParamTypes.get(2);
            TypeElement dopantSpecElement = (TypeElement)processingEnv.getTypeUtils().asElement(dopantSpecType);
            TypeMirror dopantTypeMirror = (TypeMirror)context.codeGenUtility().codegenUtil().getTypeParamTypes(dopantSpecElement, processingEnv.getElementUtils().getTypeElement(Objects.requireNonNull(DopantSpec.class.getCanonicalName()))).get(2);
            TypeElement dopantElement = (TypeElement)processingEnv.getTypeUtils().asElement(dopantTypeMirror);
            DopantType dopantType = dopantElement.getAnnotation(DopantType.class);
            if (dopantType == null) {
                context.codeGenUtility().codegenUtil().error("DopantType annotation is missing on " + String.valueOf(dopantElement.getQualifiedName()), new Element[]{dopantElement});
                return ImmutableList.of();
            }
            infosBySpecBuilder.put(dopantSpecBuilderElem, new DopantTypesInfo(dopantType.value(), dopantTypeMirror, dopantElement, dopantSpecBuilderType, dopantSpecBuilderElem, dopantSpecType, dopantSpecElement, dopantConfigType, dopantConfigElement, dopantAnnoType, dopantAnnoElement, dopingMethod, new ArrayList<ExecutableElement>()));
        }
        for (DopantTypesInfo dopantTypesInfo : infosBySpecBuilder.values()) {
            processingEnv = context.codeGenUtility().codegenUtil().processingEnv();
            TypeElement dopantSpecTypeElement = dopantTypesInfo.dopantSpecElement();
            dopantSpecTypeElement.getEnclosedElements().stream().filter(e -> e instanceof ExecutableElement).map(ExecutableElement.class::cast).forEach(method -> {
                List<VariableElement> autoConfigurables = method.getParameters().stream().filter(variable -> variable.getAnnotation(AutoConfigure.class) != null).toList();
                if (autoConfigurables.isEmpty()) {
                    return;
                }
                if (autoConfigurables.size() != 1) {
                    context.codeGenUtility().codegenUtil().error("Auto configure method must have exactly one @AutoConfigure parameter", new Element[]{method});
                }
                TypeMirror autoConfigurableType = autoConfigurables.get(0).asType();
                Element element = processingEnv.getTypeUtils().asElement(autoConfigurableType);
                if (!context.codeGenUtility().codegenUtil().isRawAssignable(autoConfigurableType, DopantSpecBuilder.class)) {
                    context.codeGenUtility().codegenUtil().error("@AutoConfigure parameter must be a DopantSpecBuilder", new Element[]{element});
                }
                if (!(element instanceof TypeElement)) {
                    context.codeGenUtility().codegenUtil().error("Auto configure parameter must be a type", new Element[]{element});
                    return;
                }
                TypeElement typeElement = (TypeElement)element;
                DopantTypesInfo configurableTypeInfo = (DopantTypesInfo)infosBySpecBuilder.get(typeElement);
                if (configurableTypeInfo == null) {
                    context.codeGenUtility().codegenUtil().error("Could not find dopant " + String.valueOf(typeElement.getQualifiedName()), new Element[]{typeElement});
                    return;
                }
                configurableTypeInfo.autoConfigurers().add((ExecutableElement)method);
            });
        }
        List<Binding> list = this.dopantSpecBindings(context, infosBySpecBuilder.values());
        List<Binding> dopantConfigBindings = this.dopantConfigBindings(context, infosBySpecBuilder.values());
        List<Binding> dopantAnnoBindings = this.dopantAnnoBindings(context, infosBySpecBuilder.values());
        Binding appBootstrapBinding = this.appBootstrapBinding(infosBySpecBuilder.values());
        Binding dopantSetBinding = this.dopantSetBinding(infosBySpecBuilder.values());
        List<Binding> dopantProducerBindings = this.dopantProducerBindings(context, infosBySpecBuilder.values());
        return ImmutableList.of((Object)new BindingsContainer("Dopants", (ImmutableList<Binding>)((ImmutableList)Stream.of(list.stream(), dopantConfigBindings.stream(), dopantAnnoBindings.stream(), Stream.of(appBootstrapBinding), Stream.of(dopantSetBinding)).flatMap(Function.identity()).collect(ImmutableList.toImmutableList()))), (Object)new BindingsContainer((ImmutableList<Binding>)ImmutableList.copyOf(dopantProducerBindings)));
    }

    private @NonNull List<Binding> dopantSpecBindings(LatticeCodegenContext context, Collection<DopantTypesInfo> dopantTypesInfos) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (DopantTypesInfo dopantTypesInfo : dopantTypesInfos) {
            ProcessingEnvironment processingEnv = context.codeGenUtility().codegenUtil().processingEnv();
            List<ExecutableElement> autoConfigureMethods = dopantTypesInfo.autoConfigurers();
            ArrayList<TypeMirror> dependencies = new ArrayList<TypeMirror>();
            List<? extends VariableElement> parameters = dopantTypesInfo.dopingMethod().getParameters();
            for (VariableElement variableElement : parameters) {
                dependencies.add(variableElement.asType());
            }
            autoConfigureMethods.stream().map(Element::getEnclosingElement).map(Element::asType).forEach(dependencies::add);
            autoConfigureMethods.forEach(autoConfigureMethod -> {
                for (VariableElement variableElement : autoConfigureMethod.getParameters()) {
                    if (variableElement.getAnnotation(AutoConfigure.class) != null) continue;
                    dependencies.add(variableElement.asType());
                }
            });
            bindings.add(new ProviderMethod(dopantTypesInfo.dopantSpecElement().getSimpleName().toString(), TypeName.get((TypeMirror)dopantTypesInfo.dopantSpecType()), dependencies.stream().map(typeMirror -> ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)typeMirror), (String)this.variableName((TypeMirror)typeMirror, processingEnv), (Modifier[])new Modifier[0]).build()).toList(), CodeBlock.builder().addNamed("    var _dopantSpecBuilder = $appType:T.$dopingMethod:L($dopingMethodParams:L);\n    log.info(\"Auto-configuring '$dopantSpecType:L' : Start\");\n    $autoConfiguration:L\n    log.info(\"Auto-configuring '$dopantSpecType:L' : End\");\n    return _dopantSpecBuilder._buildSpec();\n", Map.ofEntries(Map.entry("appType", context.latticeAppTypeElement().asType()), Map.entry("dopingMethod", dopantTypesInfo.dopingMethod().getSimpleName()), Map.entry("dopingMethodParams", (CodeBlock)parameters.stream().map(VariableElement::asType).map(typeMirror -> CodeBlock.of((String)"$L", (Object[])new Object[]{this.variableName((TypeMirror)typeMirror, processingEnv)})).collect(CodeBlock.joining((String)", "))), Map.entry("dopantSpecType", dopantTypesInfo.dopantSpecElement().getSimpleName()), Map.entry("autoConfiguration", (CodeBlock)autoConfigureMethods.stream().map(executableElement -> {
                Element configurer = executableElement.getEnclosingElement();
                return CodeBlock.builder().addStatement("log.info(\"Auto-configuring '$L' with '$L' : Start\")", new Object[]{dopantTypesInfo.dopantSpecElement().getSimpleName(), configurer.getSimpleName()}).addStatement("$L.$L($L)", new Object[]{this.variableName(configurer.asType(), processingEnv), executableElement.getSimpleName().toString(), executableElement.getParameters().stream().map(elem -> {
                    boolean isAutoConfig = elem.getAnnotation(AutoConfigure.class) != null;
                    return CodeBlock.of((String)"$L", (Object[])new Object[]{isAutoConfig ? "_dopantSpecBuilder" : this.variableName(elem.asType(), processingEnv)});
                }).collect(CodeBlock.joining((String)", "))}).addStatement("log.info(\"Auto-configuring '$L' with '$L' : End\")", new Object[]{dopantTypesInfo.dopantSpecElement().getSimpleName(), configurer.getSimpleName()}).build();
            }).collect(CodeBlock.joining((String)"\n"))))).build(), AnnotationSpec.builder(Singleton.class).build()));
        }
        return bindings;
    }

    private List<Binding> dopantConfigBindings(LatticeCodegenContext context, Collection<DopantTypesInfo> dopantTypesInfos) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (DopantTypesInfo dopantTypesInfo : dopantTypesInfos) {
            String latticeAppConfigVarName = CodeGenUtility.lowerCaseFirstChar((String)LatticeAppConfig.class.getSimpleName());
            TypeMirror dopantConfigType = dopantTypesInfo.dopantConfigType();
            if (context.codeGenUtility().codegenUtil().isRawAssignable(dopantConfigType, DopantConfig.NoConfiguration.class)) continue;
            bindings.add(new ProviderMethod(dopantTypesInfo.dopantConfigElement().getSimpleName().toString(), TypeName.get((TypeMirror)dopantConfigType).annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), List.of(ParameterSpec.builder(LatticeAppConfig.class, (String)latticeAppConfigVarName, (Modifier[])new Modifier[0]).build()), CodeBlock.of((String)"return ($T) $L.configsByDopantType().get($S);", (Object[])new Object[]{dopantConfigType, latticeAppConfigVarName, dopantTypesInfo.dopantTypeString()}), AnnotationSpec.builder(Singleton.class).build()));
        }
        return bindings;
    }

    private List<Binding> dopantAnnoBindings(LatticeCodegenContext context, Collection<DopantTypesInfo> dopantTypesInfos) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (DopantTypesInfo dopantTypesInfo : dopantTypesInfos) {
            TypeMirror dopantAnnoType = dopantTypesInfo.dopantAnnoType();
            if (context.codeGenUtility().codegenUtil().isRawAssignable(dopantAnnoType, DopantConfig.NoAnnotation.class)) continue;
            bindings.add(new ProviderMethod(dopantTypesInfo.dopantAnnoElement().getSimpleName().toString(), TypeName.get((TypeMirror)dopantAnnoType), List.of(), CodeBlock.of((String)"return $T.class.getAnnotation($T.class);", (Object[])new Object[]{context.latticeAppTypeElement().asType(), dopantAnnoType}), AnnotationSpec.builder(Singleton.class).build()));
        }
        return bindings;
    }

    private Binding appBootstrapBinding(Collection<DopantTypesInfo> dopantTypesInfos) {
        List<ParameterSpec> dependencies = dopantTypesInfos.stream().map(DopantTypesInfo::dopantSpecElement).map(element -> ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)element.asType()), (String)CodeGenUtility.lowerCaseFirstChar((String)element.getSimpleName().toString()), (Modifier[])new Modifier[0]).build()).toList();
        return new ProviderMethod(LatticeAppBootstrap.class.getSimpleName(), (TypeName)ClassName.get(LatticeAppBootstrap.class), dependencies, CodeBlock.of((String)"return new $T($L);", (Object[])new Object[]{LatticeAppBootstrap.class, dependencies.stream().map(p -> CodeBlock.of((String)"$L", (Object[])new Object[]{p.name})).collect(CodeBlock.joining((String)", "))}), AnnotationSpec.builder(Singleton.class).build());
    }

    private Binding dopantSetBinding(Collection<DopantTypesInfo> dopantTypesInfos) {
        List<ParameterSpec> dependencies = dopantTypesInfos.stream().map(DopantTypesInfo::dopantElem).map(element -> ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)element.asType()), (String)CodeGenUtility.lowerCaseFirstChar((String)element.getSimpleName().toString()), (Modifier[])new Modifier[0]).build()).toList();
        return new ProviderMethod(LatticeDopantSet.class.getSimpleName(), (TypeName)ClassName.get(LatticeDopantSet.class), dependencies, CodeBlock.of((String)"return new $T($L);", (Object[])new Object[]{LatticeDopantSet.class, dependencies.stream().map(p -> CodeBlock.of((String)"$L", (Object[])new Object[]{p.name})).collect(CodeBlock.joining((String)", "))}), AnnotationSpec.builder(Singleton.class).build());
    }

    private List<Binding> dopantProducerBindings(LatticeCodegenContext context, Collection<DopantTypesInfo> dopantTypesInfos) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (DopantTypesInfo dopantTypesInfo : dopantTypesInfos) {
            TypeElement dopantElem = dopantTypesInfo.dopantElem();
            dopantElem.getEnclosedElements().stream().filter(element -> element instanceof ExecutableElement).map(ExecutableElement.class::cast).filter(element -> element.getAnnotation(Produces.class) != null).filter(element -> element.getReturnType().getKind() != TypeKind.VOID).forEach(element -> {
                List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
                Produces producesAnno = element.getAnnotation(Produces.class);
                List qualifierAnnotations = annotationMirrors.stream().filter(annotationMirror -> annotationMirror.getAnnotationType().asElement().getAnnotation(Qualifier.class) != null).collect(Collectors.toList());
                String dopantVarName = CodeGenUtility.lowerCaseFirstChar((String)dopantElem.getSimpleName().toString());
                List<ParameterSpec> additionalParams = element.getParameters().stream().map(parameter -> ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)parameter.asType()), (String)CodeGenUtility.lowerCaseFirstChar((String)parameter.getSimpleName().toString()), (Modifier[])new Modifier[0]).build()).toList();
                List<ParameterSpec> bindingParams = Stream.concat(Stream.of(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)dopantElem.asType()), (String)dopantVarName, (Modifier[])new Modifier[0]).build()), additionalParams.stream()).toList();
                TypeMirror returnType = element.getReturnType();
                ArrayList<AnnotationSpec> annotationSpecs = new ArrayList<AnnotationSpec>(qualifierAnnotations.stream().map(AnnotationSpec::get).toList());
                TypeMirror scopedTypeMirror = context.codeGenUtility().codegenUtil().getTypeFromAnnotationMember(() -> ((Produces)producesAnno).inScope());
                TypeElement scopeElem = (TypeElement)context.codeGenUtility().processingEnv().getTypeUtils().asElement(scopedTypeMirror);
                if (!ClassName.get((TypeElement)scopeElem).equals((Object)ClassName.get(Produces.NoScope.class)) && scopeElem.getAnnotation(Scope.class) != null && scopeElem.getAnnotation(NormalScope.class) != null) {
                    context.codeGenUtility().codegenUtil().error("@Produces(scope=) class must have be scope (must have @jakarta.inject.Scope or @NormalScope annotation)", new Element[0]);
                }
                bindings.add(new ProviderMethod(this.variableName(returnType, context.codeGenUtility().processingEnv()), TypeName.get((TypeMirror)returnType), bindingParams, CodeBlock.of((String)"return $L.$L($L);", (Object[])new Object[]{dopantVarName, element.getSimpleName(), additionalParams.stream().map(p -> CodeBlock.of((String)"$L", (Object[])new Object[]{p.name})).collect(CodeBlock.joining((String)", "))}), annotationSpecs, AnnotationSpec.builder((ClassName)ClassName.get((TypeElement)scopeElem)).build()));
            });
        }
        return bindings;
    }

    private String variableName(TypeMirror typeMirror, ProcessingEnvironment processingEnv) {
        TypeElement element = (TypeElement)processingEnv.getTypeUtils().asElement(typeMirror);
        return CodeGenUtility.lowerCaseFirstChar((String)element.getSimpleName().toString());
    }

    private void validateDopingMethod(ExecutableElement dopingMethod, LatticeCodegenContext context) {
        Element returnTypeElement;
        if (!dopingMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            context.codeGenUtility().codegenUtil().error("Doping method must be static", new Element[]{dopingMethod});
        }
        if (dopingMethod.getModifiers().contains((Object)Modifier.PRIVATE)) {
            context.codeGenUtility().codegenUtil().error("Doping method must not be private", new Element[]{dopingMethod});
        }
        TypeMirror returnType = dopingMethod.getReturnType();
        if (!context.codeGenUtility().codegenUtil().isRawAssignable(returnType, DopantSpecBuilder.class)) {
            context.codeGenUtility().codegenUtil().error("Doping method must return an instance of DopantSpecBuilder", new Element[]{dopingMethod});
        }
        if (!((returnTypeElement = context.codeGenUtility().codegenUtil().processingEnv().getTypeUtils().asElement(returnType)) instanceof TypeElement)) {
            context.codeGenUtility().codegenUtil().error("Doping method must return an object instance", new Element[]{dopingMethod});
            return;
        }
        TypeElement typeElement = (TypeElement)returnTypeElement;
        if (!typeElement.getModifiers().contains((Object)Modifier.FINAL)) {
            context.codeGenUtility().codegenUtil().error("Return type of doping method must be a final class", new Element[]{dopingMethod});
        }
    }

    record DopantTypesInfo(String dopantTypeString, TypeMirror dopantType, TypeElement dopantElem, TypeMirror dopantSpecBuilderType, TypeElement dopantSpecBuilderElem, TypeMirror dopantSpecType, TypeElement dopantSpecElement, TypeMirror dopantConfigType, TypeElement dopantConfigElement, TypeMirror dopantAnnoType, TypeElement dopantAnnoElement, ExecutableElement dopingMethod, List<ExecutableElement> autoConfigurers) {
    }
}

