/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.codegen;

import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenContext;
import com.flipkart.krystal.lattice.codegen.spi.LatticeCodeGeneratorProvider;
import com.flipkart.krystal.lattice.core.LatticeApp;
import com.flipkart.krystal.vajram.codegen.common.models.VajramCodeGenUtility;
import com.google.auto.service.AutoService;
import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"com.flipkart.krystal.lattice.core.LatticeApp"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@SupportedOptions(value={"krystal.codegen.phase"})
@AutoService(value={Processor.class})
public class LatticeAnnotationProcessor
extends AbstractProcessor {
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        CodegenPhase codegenPhase;
        String phaseString = this.processingEnv.getOptions().get("krystal.codegen.phase");
        VajramCodeGenUtility util = new VajramCodeGenUtility(this.processingEnv, this.getClass(), phaseString);
        try {
            if (phaseString == null) {
                util.codegenUtil().note((CharSequence)"Skipping %s since codegen phase is null");
                return false;
            }
            codegenPhase = CodegenPhase.valueOf((String)phaseString);
        }
        catch (IllegalArgumentException e) {
            util.codegenUtil().error("%s could not parse phase string '%s'. Exactly one of %s must be passed as value to the java compiler via the annotation processor argument '-A%s='".formatted(this.getClass().getSimpleName(), String.valueOf(phaseString), Arrays.toString(CodegenPhase.values()), "krystal.codegen.phase"), new Element[0]);
            return false;
        }
        List<TypeElement> latticeApps = roundEnv.getElementsAnnotatedWith(LatticeApp.class).stream().filter(element -> element.getKind() == ElementKind.CLASS).map(executableElement -> (TypeElement)executableElement).toList();
        for (TypeElement latticeAppTypeElement : latticeApps) {
            String message = "Lattice detected by %s: %s".formatted(this.getClass().getSimpleName(), latticeAppTypeElement.getQualifiedName());
            util.codegenUtil().note((CharSequence)message);
            LatticeCodegenContext codegenContext = new LatticeCodegenContext(latticeAppTypeElement, Objects.requireNonNull(latticeAppTypeElement.getAnnotation(LatticeApp.class)), codegenPhase, util, roundEnv);
            for (LatticeCodeGeneratorProvider customCodeGeneratorProvider : ServiceLoader.load(LatticeCodeGeneratorProvider.class, this.getClass().getClassLoader())) {
                try {
                    customCodeGeneratorProvider.create(codegenContext).generate();
                }
                catch (Exception e) {
                    util.codegenUtil().error(Throwables.getStackTraceAsString((Throwable)e), new Element[]{latticeAppTypeElement});
                }
            }
        }
        return false;
    }
}

