/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.lattice.core.doping.Dopant;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class LatticeCodegenUtils {
    public static final String LATTICE_APP_IMPL_SUFFIX = "_Impl";
    public static final String APP_DOPANT_NAME_SEPARATOR = "_";
    public static final String DOPANT_IMPL_SUFFIX = "_Impl";
    private final CodeGenUtility util;

    public LatticeCodegenUtils(CodeGenUtility util) {
        this.util = util;
    }

    public ClassName getDopantImplName(TypeElement latticeAppElem, Class<? extends Dopant<?, ?>> dopantClass) {
        String packageName = this.util.processingEnv().getElementUtils().getPackageOf(latticeAppElem).getQualifiedName().toString();
        return ClassName.get((String)packageName, (String)(latticeAppElem.getSimpleName().toString() + APP_DOPANT_NAME_SEPARATOR + dopantClass.getSimpleName() + "_Impl"), (String[])new String[0]);
    }

    public MethodSpec.Builder dopantConstructorOverride(Class<? extends Dopant<?, ?>> dopantClass) {
        TypeElement dopantElement = Objects.requireNonNull(this.util.processingEnv().getElementUtils().getTypeElement(Objects.requireNonNull(dopantClass.getCanonicalName())));
        ArrayList<ExecutableElement> injectionCtors = new ArrayList<ExecutableElement>();
        ExecutableElement noArgCtor = null;
        for (Element element : dopantElement.getEnclosedElements()) {
            if (!LatticeCodegenUtils.isVisible(element) || element.getKind() != ElementKind.CONSTRUCTOR) continue;
            ExecutableElement c = (ExecutableElement)element;
            if (c.getAnnotation(Inject.class) != null) {
                injectionCtors.add(c);
            }
            if (!c.getParameters().isEmpty()) continue;
            noArgCtor = c;
        }
        if (injectionCtors.size() > 1 || injectionCtors.isEmpty() && noArgCtor == null) {
            throw this.util.errorAndThrow("A dopant must have exactly one public/protected constructor with the @Inject annotation OR a public/protected no arg constructor", new Element[]{dopantElement});
        }
        ExecutableElement parentCtor = !injectionCtors.isEmpty() ? (ExecutableElement)injectionCtors.get(0) : (ExecutableElement)Objects.requireNonNull(noArgCtor, "Cannot be null here because of the checks above");
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addAnnotation(Inject.class);
        ArrayList<CodeBlock> params = new ArrayList<CodeBlock>();
        for (VariableElement variableElement : parentCtor.getParameters()) {
            builder.addParameter(TypeName.get((TypeMirror)variableElement.asType()), variableElement.getSimpleName().toString(), new Modifier[0]);
            params.add(CodeBlock.of((String)"$L", (Object[])new Object[]{variableElement.getSimpleName().toString()}));
        }
        return builder.addStatement("super($L)", new Object[]{params.stream().collect(CodeBlock.joining((String)","))});
    }

    private static boolean isVisible(Element element) {
        return element.getModifiers().contains((Object)Modifier.PUBLIC) || element.getModifiers().contains((Object)Modifier.PROTECTED);
    }
}

