/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.codegen;

import com.flipkart.krystal.codegen.common.datatypes.CodeGenType;
import com.flipkart.krystal.codegen.common.spi.ModelProtocolConfigProvider;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenContext;
import com.flipkart.krystal.lattice.codegen.spi.BindingsProvider;
import com.flipkart.krystal.lattice.codegen.spi.DefaultSerdeProtocolProvider;
import com.flipkart.krystal.lattice.codegen.spi.LatticeAppCodeGenAttrsProvider;
import com.flipkart.krystal.lattice.core.headers.Header;
import com.flipkart.krystal.lattice.core.headers.StandardHeaderNames;
import com.flipkart.krystal.model.Model;
import com.flipkart.krystal.model.SupportedModelProtocols;
import com.flipkart.krystal.serial.SerdeProtocol;
import com.flipkart.krystal.vajram.codegen.common.models.VajramCodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfoLite;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoService(value={BindingsProvider.class})
public final class SerdeProtocolBindingsProvider
implements BindingsProvider {
    @Override
    public ImmutableList<BindingsProvider.Binding> bindings(LatticeCodegenContext context) {
        VajramCodeGenUtility util = context.codeGenUtility();
        ServiceLoader<LatticeAppCodeGenAttrsProvider> providers = ServiceLoader.load(LatticeAppCodeGenAttrsProvider.class, this.getClass().getClassLoader());
        LinkedHashSet<TypeElement> remotelyInvocableVajrams = new LinkedHashSet<TypeElement>();
        for (LatticeAppCodeGenAttrsProvider provider : providers) {
            remotelyInvocableVajrams.addAll((Collection<TypeElement>)provider.get(context).remotelyInvocableVajrams());
        }
        Map<String, ModelProtocolConfigProvider.ModelProtocolConfig> configs = ServiceLoader.load(ModelProtocolConfigProvider.class, this.getClass().getClassLoader()).stream().map(ServiceLoader.Provider::get).collect(Collectors.toMap(cp -> Objects.requireNonNull(cp.getConfig().serdeProtocol().getClass().getCanonicalName()), ModelProtocolConfigProvider::getConfig));
        LinkedHashMap<String, TypeElement> responseTypeElems = new LinkedHashMap<String, TypeElement>();
        LinkedHashMap<String, List> responseToVajramsMapping = new LinkedHashMap<String, List>();
        for (TypeElement vajram : remotelyInvocableVajrams) {
            VajramInfoLite vajramInfoLite = util.computeVajramInfoLite(vajram);
            CodeGenType responseType = vajramInfoLite.responseType();
            TypeMirror responseMirror = responseType.javaModelType(util.processingEnv());
            if (!util.codegenUtil().isRawAssignable(responseMirror, Model.class)) continue;
            TypeElement responseTypeElem = (TypeElement)Objects.requireNonNull(util.codegenUtil().processingEnv().getTypeUtils().asElement(responseMirror));
            String responseCanonicalName = responseTypeElem.getQualifiedName().toString();
            responseTypeElems.put(responseCanonicalName, responseTypeElem);
            responseToVajramsMapping.computeIfAbsent(responseCanonicalName, s -> new ArrayList()).add(vajramInfoLite.vajramId().id());
        }
        ArrayList<BindingsProvider.ProviderMethod> bindings = new ArrayList<BindingsProvider.ProviderMethod>();
        for (Map.Entry entry : responseTypeElems.entrySet()) {
            List<TypeElement> supportedModelProtocolElems;
            String responseCanonicalName = (String)entry.getKey();
            TypeElement responseElement = (TypeElement)entry.getValue();
            SupportedModelProtocols supportedModelProtocols = responseElement.getAnnotation(SupportedModelProtocols.class);
            if (supportedModelProtocols == null || (supportedModelProtocolElems = context.codeGenUtility().codegenUtil().getTypesFromAnnotationMember(() -> ((SupportedModelProtocols)supportedModelProtocols).value()).stream().filter(tm -> util.codegenUtil().isRawAssignable(tm, SerdeProtocol.class)).map(tm -> (TypeElement)Objects.requireNonNull(util.processingEnv().getTypeUtils().asElement((TypeMirror)tm))).toList()).isEmpty()) continue;
            ClassName immutClassName = util.codegenUtil().getImmutClassName(responseElement);
            ClassName immutBuilderClassName = ClassName.get((String)immutClassName.packageName(), (String)immutClassName.simpleName(), (String[])new String[]{"Builder"});
            TypeElement defaultSerializationProtocol = this.getDefaultSerializationProtocol(context);
            if (defaultSerializationProtocol == null) {
                throw util.codegenUtil().errorAndThrow("Could not determine default Serialization protocol of lattice app.", new Element[]{context.latticeAppTypeElement()});
            }
            ArrayList<CodeBlock> providingLogics = new ArrayList<CodeBlock>();
            if (!supportedModelProtocolElems.contains(defaultSerializationProtocol)) {
                throw util.codegenUtil().errorAndThrow("Response type " + String.valueOf(responseElement) + " of vajram(s): " + String.valueOf(responseToVajramsMapping.get(responseCanonicalName)) + " does not support the default serialization protocol " + String.valueOf(defaultSerializationProtocol), new Element[]{responseElement});
            }
            ModelProtocolConfigProvider.ModelProtocolConfig defaultConfig = configs.get(defaultSerializationProtocol.getQualifiedName().toString());
            if (defaultConfig == null) {
                throw util.codegenUtil().errorAndThrow("Unrecognized Serde protocol: %s. Please check if the relevant protocol specific libraries are added to the annotationProcessor classpath of the project.".formatted(defaultSerializationProtocol), new Element[]{context.latticeAppTypeElement()});
            }
            ClassName defaultModelBuilderName = ClassName.get((String)immutClassName.packageName(), (String)(immutClassName.simpleName() + defaultConfig.serdeProtocol().modelClassesSuffix()), (String[])new String[0]);
            providingLogics.add(CodeBlock.of((String)"if (null == acceptHeader){\n  return $T._builder();\n}\nvar acceptHeaderValues = new $T<>(acceptHeader.values());\nif (acceptHeaderValues.contains(\"*/*\")){\n  return $T._builder();\n}\n", (Object[])new Object[]{defaultModelBuilderName, LinkedHashSet.class, defaultModelBuilderName}));
            for (TypeElement modelProtocol : supportedModelProtocolElems) {
                ModelProtocolConfigProvider.ModelProtocolConfig config = configs.get(modelProtocol.getQualifiedName().toString());
                if (config == null) {
                    util.codegenUtil().note((CharSequence)"Skipping creation of binding for %s as protocol config for this protocol was not found in the annotation processor class path".formatted(modelProtocol.getQualifiedName()));
                    continue;
                }
                configs.put(Objects.requireNonNull(config.serdeProtocol().getClass().getCanonicalName()), config);
                providingLogics.add(CodeBlock.of((String)"if(acceptHeaderValues.contains($S)) {\n  return $T._builder();\n}", (Object[])new Object[]{config.serdeProtocol().defaultContentType(), ClassName.get((String)immutClassName.packageName(), (String)(immutClassName.simpleName() + config.serdeProtocol().modelClassesSuffix()), (String[])new String[0])}));
            }
            providingLogics.add(CodeBlock.of((String)"{\n  throw new $T($S + acceptHeader.values());\n}\n", (Object[])new Object[]{IllegalStateException.class, "Response type " + responseCanonicalName + " of vajrams: " + String.valueOf(responseToVajramsMapping.get(responseCanonicalName)) + " doesn't support any of the content types: "}));
            bindings.add(new BindingsProvider.ProviderMethod(immutClassName.simpleName() + "_Builder", (TypeName)immutBuilderClassName, List.of(ParameterSpec.builder((TypeName)ClassName.get(Header.class).annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}).annotated(new AnnotationSpec[]{AnnotationSpec.builder(Named.class).addMember("value", CodeBlock.of((String)"$T.$L", (Object[])new Object[]{StandardHeaderNames.class, "ACCEPT"})).build()}), (String)"acceptHeader", (Modifier[])new Modifier[0])), (CodeBlock)providingLogics.stream().collect(CodeBlock.joining((String)" else ")), BindingsProvider.BindingScope.REQUEST));
        }
        return ImmutableList.copyOf(bindings);
    }

    private @Nullable TypeElement getDefaultSerializationProtocol(LatticeCodegenContext context) {
        ArrayList<TypeElement> protocols = new ArrayList<TypeElement>();
        for (DefaultSerdeProtocolProvider defaultSerdeProtocolProvider : ServiceLoader.load(DefaultSerdeProtocolProvider.class, this.getClass().getClassLoader())) {
            TypeElement protocol = defaultSerdeProtocolProvider.getDefaultSerializationProtocol(context);
            if (protocol == null) continue;
            protocols.add(protocol);
        }
        if (protocols.isEmpty()) {
            return null;
        }
        if (protocols.size() > 1) {
            context.codeGenUtility().codegenUtil().error("Found more than one default serialization protocol: " + String.valueOf(protocols), new Element[]{context.latticeAppTypeElement()});
        }
        return (TypeElement)protocols.get(0);
    }
}

