/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.ext.cdi.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenContext;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenUtils;
import com.flipkart.krystal.lattice.codegen.spi.LatticeCodeGeneratorProvider;
import com.flipkart.krystal.lattice.codegen.spi.di.Binding;
import com.flipkart.krystal.lattice.codegen.spi.di.BindingsContainer;
import com.flipkart.krystal.lattice.codegen.spi.di.ImplTypeBinding;
import com.flipkart.krystal.lattice.codegen.spi.di.NullBinding;
import com.flipkart.krystal.lattice.codegen.spi.di.ProviderMethod;
import com.flipkart.krystal.lattice.ext.cdi.CdiProvider;
import com.flipkart.krystal.lattice.ext.cdi.codegen.BindingCodeTransformer;
import com.flipkart.krystal.lattice.ext.cdi.codegen.CdiBinderGen;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

@AutoService(value={LatticeCodeGeneratorProvider.class})
public class CdiModuleGenProvider
implements LatticeCodeGeneratorProvider {
    public CodeGenerator create(LatticeCodegenContext latticeCodegenContext) {
        return new CdiModuleGen(latticeCodegenContext);
    }

    private record CdiModuleGen(LatticeCodegenContext context) implements CodeGenerator
    {
        public void generate() {
            if (!this.isApplicable()) {
                return;
            }
            Map bindingContainers = BindingsContainer.getBindingContainers((LatticeCodegenContext)this.context);
            CodeGenUtility util = this.context.codeGenUtility().codegenUtil();
            TypeElement latticeAppTypeElement = this.context.latticeAppTypeElement();
            for (Map.Entry entry : bindingContainers.entrySet()) {
                String identifier = (String)entry.getKey();
                List<Binding> bindings = ((List)entry.getValue()).stream().map(BindingsContainer::bindings).flatMap(Collection::stream).toList();
                ClassName moduleClassName = LatticeCodegenUtils.getDiBindingContainerName((LatticeCodegenContext)this.context, (String)identifier);
                TypeSpec.Builder classBuilder = util.classBuilder(moduleClassName.simpleName(), latticeAppTypeElement.getQualifiedName().toString()).addAnnotation(ApplicationScoped.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethods(this.getProviderMethods(bindings));
                util.generateSourceFile(moduleClassName.canonicalName(), JavaFile.builder((String)moduleClassName.packageName(), (TypeSpec)classBuilder.build()).build(), latticeAppTypeElement);
            }
        }

        private boolean isApplicable() {
            return CodegenPhase.FINAL.equals((Object)this.context.codegenPhase()) && CdiBinderGen.getDependencyInjectionBinder(this.context).equals(this.context.codeGenUtility().processingEnv().getElementUtils().getTypeElement(CdiProvider.class.getCanonicalName()));
        }

        private List<MethodSpec> getProviderMethods(List<Binding> bindings) {
            ArrayList<MethodSpec> providers = new ArrayList<MethodSpec>();
            for (Binding binding : bindings) {
                ImplTypeBinding implTypeBinding;
                if (binding instanceof NullBinding || binding instanceof ImplTypeBinding && (implTypeBinding = (ImplTypeBinding)binding).isSoleImpl()) continue;
                MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)CodeGenUtility.lowerCaseFirstChar((String)binding.identifierName())).addAnnotation(Produces.class);
                if (binding instanceof ImplTypeBinding) {
                    ImplTypeBinding implTypeBinding2 = (ImplTypeBinding)binding;
                    methodBuilder.returns((TypeName)implTypeBinding2.parentType());
                    ClassName childType = implTypeBinding2.childType();
                    AnnotationSpec scopeAnnotation = implTypeBinding2.scope();
                    String varName = CodeGenUtility.lowerCaseFirstChar((String)childType.simpleName());
                    methodBuilder.addParameter((TypeName)childType, varName, new Modifier[0]);
                    if (scopeAnnotation != null) {
                        methodBuilder.addAnnotation(scopeAnnotation);
                    }
                    methodBuilder.addStatement("return $L", new Object[]{varName});
                } else if (binding instanceof ProviderMethod) {
                    ProviderMethod providerMethod = (ProviderMethod)binding;
                    AnnotationSpec scopeAnnotation = providerMethod.scope();
                    methodBuilder.returns(providerMethod.boundType()).addParameters((Iterable)providerMethod.dependencies()).addCode(providerMethod.providingLogic());
                    if (scopeAnnotation != null) {
                        methodBuilder.addAnnotation(scopeAnnotation);
                    }
                    methodBuilder.addAnnotations((Iterable)providerMethod.annotations());
                } else {
                    throw new UnsupportedOperationException("Unsupported binding type " + String.valueOf(binding));
                }
                for (BindingCodeTransformer bindingCodeTransformer : ServiceLoader.load(BindingCodeTransformer.class, this.getClass().getClassLoader())) {
                    bindingCodeTransformer.transform(methodBuilder);
                }
                providers.add(methodBuilder.build());
            }
            return providers;
        }
    }
}

