/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.ext.cdi.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenContext;
import com.flipkart.krystal.lattice.codegen.spi.di.DepInjectBinderGen;
import com.flipkart.krystal.lattice.core.LatticeApp;
import com.flipkart.krystal.lattice.core.LatticeApplication;
import com.flipkart.krystal.lattice.ext.cdi.CdiProvider;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.CodeBlock;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.checkerframework.checker.nullness.qual.NonNull;

@AutoService(value={DepInjectBinderGen.class})
public final class CdiBinderGen
implements DepInjectBinderGen {
    public CodeBlock getBinderCreationCode(LatticeCodegenContext context) {
        if (!this.isApplicable(context)) {
            throw new UnsupportedOperationException();
        }
        return CodeBlock.builder().addStatement("return new $T()", new Object[]{CdiBinderGen.getDependencyInjectionBinder(context)}).build();
    }

    static @NonNull TypeElement getDependencyInjectionBinder(LatticeCodegenContext context) {
        CodeGenUtility util = context.codeGenUtility().codegenUtil();
        TypeElement dependencyInjectionBinder = (TypeElement)Objects.requireNonNull(util.processingEnv().getTypeUtils().asElement(util.getTypeFromAnnotationMember(() -> ((LatticeApp)context.latticeApp()).dependencyInjectionBinder())));
        return dependencyInjectionBinder;
    }

    public boolean isApplicable(LatticeCodegenContext context) {
        boolean isCdiApp = CdiBinderGen.getDependencyInjectionBinder(context).equals(context.codeGenUtility().processingEnv().getElementUtils().getTypeElement(CdiProvider.class.getCanonicalName()));
        if (isCdiApp) {
            this.userDefinedDepInjectBinderMethod(context).ifPresent(userDefinedDepInjectBinderMethod -> context.codeGenUtility().codegenUtil().error("CDI doesn't support user defined dependency injection binder", new Element[]{userDefinedDepInjectBinderMethod}));
        }
        return isCdiApp;
    }

    private Optional<ExecutableElement> userDefinedDepInjectBinderMethod(LatticeCodegenContext context) {
        TypeElement typeElement = context.latticeAppTypeElement();
        CodeGenUtility util = context.codeGenUtility().codegenUtil();
        try {
            return util.getMethod(typeElement, LatticeApplication.class.getMethod("getDependencyInjectionBinder", new Class[0]).getName(), 0);
        }
        catch (Exception e) {
            throw util.errorAndThrow("LatticeApplication.class has no 'getDependencyInjectionBinder' method. This should not happen. Possibly there are incompatible versions in the classpath.", new Element[0]);
        }
    }
}

