/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.decoration.DecorationOrdering;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyDecorator;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyExecutionContext;
import com.flipkart.krystal.krystex.kryon.DependentChain;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonCommandResponse;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.VajramKryonDefinition;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.request.RequestIdGenerator;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractKryon<C extends KryonCommand, R extends KryonCommandResponse>
implements Kryon<C, R> {
    static final int INITIAL_CAPACITY = 64;
    protected final VajramKryonDefinition kryonDefinition;
    protected final VajramID vajramID;
    protected final KryonExecutor kryonExecutor;
    protected final Function<LogicExecutionContext, Map<String, OutputLogicDecorator>> outputLogicDecoratorSuppliers;
    private final Function<DependencyExecutionContext, ImmutableMap<String, DependencyDecorator>> depDecoratorSuppliers;
    private final Map<DependentChain, NavigableSet<OutputLogicDecorator>> requestScopedDecoratorsByDepChain = new HashMap<DependentChain, NavigableSet<OutputLogicDecorator>>(64);
    protected final DecorationOrdering decorationOrdering;
    protected final RequestIdGenerator requestIdGenerator;

    AbstractKryon(VajramKryonDefinition definition, KryonExecutor kryonExecutor, Function<LogicExecutionContext, Map<String, OutputLogicDecorator>> outputLogicDecoratorSuppliers, Function<DependencyExecutionContext, ImmutableMap<String, DependencyDecorator>> depDecoratorSuppliers, DecorationOrdering decorationOrdering, RequestIdGenerator requestIdGenerator) {
        this.kryonDefinition = definition;
        this.vajramID = definition.vajramID();
        this.kryonExecutor = kryonExecutor;
        this.outputLogicDecoratorSuppliers = outputLogicDecoratorSuppliers;
        this.depDecoratorSuppliers = depDecoratorSuppliers;
        this.decorationOrdering = decorationOrdering;
        this.requestIdGenerator = requestIdGenerator;
    }

    protected NavigableSet<OutputLogicDecorator> getSortedOutputLogicDecorators(DependentChain dependantChain) {
        return this.requestScopedDecoratorsByDepChain.computeIfAbsent(dependantChain, _d -> {
            TreeSet sortedDecorators = new TreeSet(this.decorationOrdering.encounterOrder().reversed());
            OutputLogicDefinition outputLogicDefinition = this.kryonDefinition.getOutputLogicDefinition();
            sortedDecorators.addAll(this.outputLogicDecoratorSuppliers.apply(new LogicExecutionContext(this.vajramID, outputLogicDefinition.tags(), dependantChain, this.kryonDefinition.kryonDefinitionRegistry())).values());
            return sortedDecorators;
        });
    }

    protected NavigableSet<DependencyDecorator> getSortedDependencyDecorators(VajramID depVajramId, DependentChain dependentChain) {
        TreeSet<DependencyDecorator> sortedDecorators = new TreeSet<DependencyDecorator>(this.decorationOrdering.encounterOrder().reversed());
        Dependency dependency = dependentChain.latestDependency();
        if (dependency == null) {
            return sortedDecorators;
        }
        sortedDecorators.addAll((Collection<DependencyDecorator>)this.depDecoratorSuppliers.apply(new DependencyExecutionContext(this.vajramID, dependency, depVajramId, dependentChain)).values());
        return sortedDecorators;
    }

    @Override
    public VajramKryonDefinition getKryonDefinition() {
        return this.kryonDefinition;
    }
}

