/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.logicdecorators.resilience4j;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.core.OutputLogicExecutionInput;
import com.flipkart.krystal.core.OutputLogicExecutionResults;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.logicdecorators.resilience4j.R4JUtils;
import com.flipkart.krystal.krystex.logicdecorators.resilience4j.Resilience4JBulkheadManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.decorators.Decorators;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Resilience4JBulkhead
implements OutputLogicDecorator {
    public static final String DECORATOR_TYPE = Resilience4JBulkhead.class.getName();
    private final String instanceId;
    private @Nullable BulkheadAdapter adaptedBulkhead;

    public Resilience4JBulkhead(String instanceId) {
        this.instanceId = instanceId;
    }

    public static Resilience4JBulkheadManager onePerIOVajram() {
        return Resilience4JBulkhead.onePerInstanceId(logicExecutionContext -> logicExecutionContext.vajramID().id());
    }

    public static Resilience4JBulkheadManager onePerInstanceId(Function<LogicExecutionContext, String> instanceIdGenerator) {
        return new Resilience4JBulkheadManager(instanceIdGenerator);
    }

    @Override
    public OutputLogic<Object> decorateLogic(OutputLogic<Object> logicToDecorate, OutputLogicDefinition<Object> originalLogicDefinition) {
        BulkheadAdapter bulkhead = this.adaptedBulkhead;
        if (bulkhead != null) {
            return input -> R4JUtils.extractResponseMap((ImmutableList<? extends FacetValues>)input.facetValues(), bulkhead.decorate(logicToDecorate, input));
        }
        return logicToDecorate;
    }

    public void onConfigUpdate(ConfigProvider configProvider) {
        this.updateBulkhead(configProvider);
    }

    private void updateBulkhead(ConfigProvider configProvider) {
        Optional<BulkheadAdapterConfig> newBulkheadConfig = this.getBulkheadConfig(configProvider);
        if (newBulkheadConfig.isPresent()) {
            BulkheadAdapter bulkhead = this.adaptedBulkhead;
            if (bulkhead == null) {
                this.adaptedBulkhead = new BulkheadAdapter(newBulkheadConfig.get());
            } else {
                bulkhead.changeConfig(newBulkheadConfig.get());
            }
        } else {
            this.adaptedBulkhead = null;
        }
    }

    private Optional<BulkheadAdapterConfig> getBulkheadConfig(ConfigProvider configProvider) {
        boolean bulkheadEnabled = configProvider.getConfig(this.instanceId + ".bulkhead.enabled").orElse(true);
        if (!bulkheadEnabled) {
            return Optional.empty();
        }
        BulkheadType bulkheadType = configProvider.getConfig(this.instanceId + ".bulkhead.type").map(BulkheadType::valueOf).orElse(BulkheadType.SEMAPHORE);
        Optional maxConcurrency = configProvider.getConfig(this.instanceId + ".bulkhead.max_concurrency");
        switch (bulkheadType) {
            case SEMAPHORE: {
                BulkheadConfig.Builder builder = BulkheadConfig.custom().writableStackTraceEnabled(false);
                maxConcurrency.ifPresent(arg_0 -> ((BulkheadConfig.Builder)builder).maxConcurrentCalls(arg_0));
                return Optional.of(new BulkheadAdapterConfig(builder.build()));
            }
            case THREADPOOL: {
                ThreadPoolBulkheadConfig.Builder builder = ThreadPoolBulkheadConfig.custom().writableStackTraceEnabled(false).queueCapacity(0);
                maxConcurrency.ifPresent(arg_0 -> ((ThreadPoolBulkheadConfig.Builder)builder).maxThreadPoolSize(arg_0));
                maxConcurrency.ifPresent(arg_0 -> ((ThreadPoolBulkheadConfig.Builder)builder).coreThreadPoolSize(arg_0));
                return Optional.of(new BulkheadAdapterConfig(builder.build()));
            }
        }
        return Optional.empty();
    }

    private String getBulkheadId() {
        return this.instanceId + ".bulkhead";
    }

    private final class BulkheadAdapter {
        private @Nullable Bulkhead bulkhead;
        private @Nullable ThreadPoolBulkhead threadPoolBulkhead;

        private BulkheadAdapter(BulkheadAdapterConfig config) {
            BulkheadConfig bulkheadConfig = config.bulkheadConfig();
            if (bulkheadConfig != null) {
                this.bulkhead = Bulkhead.of((String)Resilience4JBulkhead.this.getBulkheadId(), (BulkheadConfig)bulkheadConfig);
            } else {
                ThreadPoolBulkheadConfig threadPoolBulkheadConfig = config.threadPoolBulkheadConfig();
                if (threadPoolBulkheadConfig != null) {
                    this.threadPoolBulkhead = BulkheadAdapter.newThreadPoolBulkhead(threadPoolBulkheadConfig, Resilience4JBulkhead.this.getBulkheadId());
                } else {
                    throw new IllegalArgumentException("Either bulkheadConfig or threadPoolBulkheadConfig must be non-null");
                }
            }
        }

        private void changeConfig(BulkheadAdapterConfig config) {
            Bulkhead localBulkHead = this.bulkhead;
            if (config.bulkheadConfig() != null && localBulkHead != null && !config.bulkheadConfig().equals(localBulkHead.getBulkheadConfig())) {
                localBulkHead.changeConfig(config.bulkheadConfig());
            } else {
                ThreadPoolBulkhead localTPBulkhead = this.threadPoolBulkhead;
                if (config.threadPoolBulkheadConfig() != null && localTPBulkhead != null && !config.threadPoolBulkheadConfig().equals(localTPBulkhead.getBulkheadConfig())) {
                    this.threadPoolBulkhead = BulkheadAdapter.newThreadPoolBulkhead(config.threadPoolBulkheadConfig(), Resilience4JBulkhead.this.getBulkheadId());
                }
            }
        }

        CompletionStage<OutputLogicExecutionResults<Object>> decorate(OutputLogic<Object> logicToDecorate, OutputLogicExecutionInput input) {
            ThreadPoolBulkhead threadPoolBulkhead = this.threadPoolBulkhead;
            Bulkhead bulkhead = this.bulkhead;
            if (threadPoolBulkhead != null) {
                return threadPoolBulkhead.executeCallable(() -> logicToDecorate.execute(input));
            }
            if (bulkhead != null) {
                return Decorators.ofCompletionStage(() -> {
                    OutputLogicExecutionResults results = logicToDecorate.execute(input);
                    CompletionStage handle = CompletableFuture.allOf((CompletableFuture[])results.results().values().toArray(CompletableFuture[]::new)).handle((unused, throwable) -> results);
                    return handle;
                }).withBulkhead(bulkhead).get();
            }
            throw new IllegalStateException("Either bulkheadConfig or threadPoolBulkheadConfig must be non-null");
        }

        private static ThreadPoolBulkhead newThreadPoolBulkhead(ThreadPoolBulkheadConfig config, String bulkheadId) {
            return ThreadPoolBulkhead.of((String)bulkheadId, (ThreadPoolBulkheadConfig)config);
        }
    }

    private record BulkheadAdapterConfig(@Nullable BulkheadConfig bulkheadConfig, @Nullable ThreadPoolBulkheadConfig threadPoolBulkheadConfig) {
        BulkheadAdapterConfig(@Nullable BulkheadConfig bulkheadConfig, @Nullable ThreadPoolBulkheadConfig threadPoolBulkheadConfig) {
            Preconditions.checkArgument((bulkheadConfig == null || threadPoolBulkheadConfig == null ? 1 : 0) != 0);
            Preconditions.checkArgument((bulkheadConfig != null || threadPoolBulkheadConfig != null ? 1 : 0) != 0);
        }

        private BulkheadAdapterConfig(BulkheadConfig bulkheadConfig) {
            this(bulkheadConfig, null);
        }

        private BulkheadAdapterConfig(ThreadPoolBulkheadConfig threadPoolBulkheadConfig) {
            this(null, threadPoolBulkheadConfig);
        }
    }

    private static enum BulkheadType {
        THREADPOOL,
        SEMAPHORE;

    }
}

