/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.krystex.kryon.DependentChain;
import com.flipkart.krystal.traits.StaticDispatchPolicy;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public record KryonExecutionConfig(String executionId, ImmutableSet<DependentChain> disabledDependentChains, @Nullable Annotation staticDispatchQualifier) {
    private static final AtomicLong EXEC_COUNT = new AtomicLong();

    public KryonExecutionConfig(String executionId, ImmutableSet<DependentChain> disabledDependentChains, @Nullable Annotation staticDispatchQualifier) {
        if (executionId == null) {
            executionId = "KryonExecution-" + EXEC_COUNT.getAndIncrement();
        }
        if (disabledDependentChains == null) {
            disabledDependentChains = ImmutableSet.of();
        }
        if (staticDispatchQualifier != null) {
            StaticDispatchPolicy.isValidQualifier((Annotation)staticDispatchQualifier);
        }
    }

    @Generated
    public static @NonNull KryonExecutionConfigBuilder builder() {
        return new KryonExecutionConfigBuilder();
    }

    @Generated
    public @NonNull KryonExecutionConfigBuilder toBuilder() {
        return new KryonExecutionConfigBuilder().executionId(this.executionId).disabledDependentChains(this.disabledDependentChains).staticDispatchQualifier(this.staticDispatchQualifier);
    }

    @Generated
    public static class KryonExecutionConfigBuilder {
        @Generated
        private String executionId;
        @Generated
        private ImmutableSet<DependentChain> disabledDependentChains;
        @Generated
        private Annotation staticDispatchQualifier;

        @Generated
        KryonExecutionConfigBuilder() {
        }

        @Generated
        public @NonNull KryonExecutionConfigBuilder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        @Generated
        public @NonNull KryonExecutionConfigBuilder disabledDependentChains(ImmutableSet<DependentChain> disabledDependentChains) {
            this.disabledDependentChains = disabledDependentChains;
            return this;
        }

        @Generated
        public @NonNull KryonExecutionConfigBuilder staticDispatchQualifier(@Nullable Annotation staticDispatchQualifier) {
            this.staticDispatchQualifier = staticDispatchQualifier;
            return this;
        }

        @Generated
        public @NonNull KryonExecutionConfig build() {
            return new KryonExecutionConfig(this.executionId, this.disabledDependentChains, this.staticDispatchQualifier);
        }

        @Generated
        public @NonNull String toString() {
            return "KryonExecutionConfig.KryonExecutionConfigBuilder(executionId=" + this.executionId + ", disabledDependentChains=" + this.disabledDependentChains + ", staticDispatchQualifier=" + this.staticDispatchQualifier + ")";
        }
    }
}

