/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.facets.BasicFacetInfo;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.facets.Facet;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.facets.FacetUtils;
import com.flipkart.krystal.facets.resolution.ResolverDefinition;
import com.flipkart.krystal.krystex.resolution.Resolver;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

record KryonDefinitionView(ImmutableMap<Integer, Facet> facetsById, ImmutableMap<FacetType, ImmutableSet<Facet>> facetsByType, ImmutableSet<Facet> givenFacets, ImmutableMap<Optional<Facet>, ImmutableSet<Resolver>> resolverDefinitionsBySource, ImmutableMap<Dependency, ImmutableSet<Resolver>> resolverDefinitionsByDependencies, ImmutableSet<Dependency> dependenciesWithNoResolvers, ImmutableSet<Dependency> dependenciesWithNoFacetResolvers, ImmutableMap<Dependency, ImmutableSet<Facet>> dependencyToBoundFacetsMapping, ImmutableMap<Facet, ImmutableSet<Dependency>> dependenciesByBoundFacet) {
    static KryonDefinitionView createView(Set<? extends Facet> allFacets, ImmutableMap<ResolverDefinition, Resolver> resolversByDefinition, ImmutableMap<Dependency, VajramID> dependencyKryons) {
        ImmutableSet dependencyFacets = dependencyKryons.keySet();
        ImmutableMap resolverDefinitionsByDependencies = ImmutableMap.copyOf(resolversByDefinition.values().stream().collect(Collectors.groupingBy(d -> d.definition().target().dependency(), ImmutableSet.toImmutableSet())));
        ImmutableSet dependenciesWithNoResolvers = (ImmutableSet)dependencyFacets.stream().filter(depName -> ((ImmutableSet)resolverDefinitionsByDependencies.getOrDefault(depName, (Object)ImmutableSet.of())).isEmpty()).collect(ImmutableSet.toImmutableSet());
        LinkedHashMap<FacetType, Set> facetsByType = new LinkedHashMap<FacetType, Set>();
        for (Facet facet : allFacets) {
            facetsByType.computeIfAbsent(facet.facetType(), _t -> new LinkedHashSet()).add(facet);
        }
        ImmutableMap<Optional<Facet>, ImmutableSet<ResolverDefinition>> resolverDefinitionsByFacets = KryonDefinitionView.createResolverDefinitionsByFacets((ImmutableCollection<ResolverDefinition>)resolversByDefinition.keySet());
        return new KryonDefinitionView((ImmutableMap<Integer, Facet>)((ImmutableMap)allFacets.stream().collect(ImmutableMap.toImmutableMap(BasicFacetInfo::id, Function.identity()))), (ImmutableMap<FacetType, ImmutableSet<Facet>>)((ImmutableMap)facetsByType.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ImmutableSet.copyOf((Collection)((Collection)e.getValue()))))), (ImmutableSet<Facet>)((ImmutableSet)allFacets.stream().filter(FacetUtils::isGiven).collect(ImmutableSet.toImmutableSet())), KryonDefinitionView.createResolverDefinitionsBySource(resolversByDefinition), (ImmutableMap<Dependency, ImmutableSet<Resolver>>)resolverDefinitionsByDependencies, (ImmutableSet<Dependency>)dependenciesWithNoResolvers, (ImmutableSet<Dependency>)((ImmutableSet)((ImmutableSet)resolverDefinitionsByFacets.getOrDefault(Optional.empty(), (Object)ImmutableSet.of())).stream().map(rd -> rd.target().dependency()).collect(ImmutableSet.toImmutableSet())), KryonDefinitionView.getDependencyToBoundFacetsMapping((ImmutableMap<Dependency, ImmutableSet<Resolver>>)resolverDefinitionsByDependencies), KryonDefinitionView.getDependenciesByBoundFacet(resolverDefinitionsByFacets));
    }

    private static ImmutableMap<Optional<Facet>, ImmutableSet<Resolver>> createResolverDefinitionsBySource(ImmutableMap<ResolverDefinition, Resolver> resolversByDefinition) {
        LinkedHashMap resolverDefinitionsByInput = new LinkedHashMap();
        resolversByDefinition.values().forEach(resolver -> {
            ImmutableSet sources = resolver.definition().sources();
            if (!sources.isEmpty()) {
                sources.forEach(facet -> resolverDefinitionsByInput.computeIfAbsent(Optional.of(facet), s -> ImmutableSet.builder()).add(resolver));
            } else {
                resolverDefinitionsByInput.computeIfAbsent(Optional.empty(), s -> ImmutableSet.builder()).add(resolver);
            }
        });
        return (ImmutableMap)resolverDefinitionsByInput.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((ImmutableSet.Builder)e.getValue()).build()));
    }

    private static ImmutableMap<Optional<Facet>, ImmutableSet<ResolverDefinition>> createResolverDefinitionsByFacets(ImmutableCollection<ResolverDefinition> resolverDefinitions) {
        LinkedHashMap resolverDefinitionsBySource = new LinkedHashMap();
        resolverDefinitions.forEach(resolverDefinition -> {
            if (!resolverDefinition.sources().isEmpty()) {
                resolverDefinition.sources().forEach(input -> resolverDefinitionsBySource.computeIfAbsent(Optional.of(input), s -> ImmutableSet.builder()).add(resolverDefinition));
            } else {
                resolverDefinitionsBySource.computeIfAbsent(Optional.empty(), s -> ImmutableSet.builder()).add(resolverDefinition);
            }
        });
        return (ImmutableMap)resolverDefinitionsBySource.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((ImmutableSet.Builder)e.getValue()).build()));
    }

    private static ImmutableMap<Dependency, ImmutableSet<Facet>> getDependencyToBoundFacetsMapping(ImmutableMap<Dependency, ImmutableSet<Resolver>> resolverDefinitionsByDependencies) {
        LinkedHashMap<Dependency, ImmutableSet> dependencyToBoundFacetsMapping = new LinkedHashMap<Dependency, ImmutableSet>();
        for (Map.Entry e : resolverDefinitionsByDependencies.entrySet()) {
            Dependency depName = (Dependency)e.getKey();
            ImmutableSet resolvers = (ImmutableSet)e.getValue();
            LinkedHashSet boundFromInputs = new LinkedHashSet();
            for (Resolver resolver : resolvers) {
                boundFromInputs.addAll(resolver.definition().sources());
            }
            dependencyToBoundFacetsMapping.put(depName, ImmutableSet.copyOf(boundFromInputs));
        }
        return ImmutableMap.copyOf(dependencyToBoundFacetsMapping);
    }

    private static ImmutableMap<Facet, ImmutableSet<Dependency>> getDependenciesByBoundFacet(ImmutableMap<Optional<Facet>, ImmutableSet<ResolverDefinition>> resolverDefinitionsByFacets) {
        LinkedHashMap<Facet, ImmutableSet> dependenciesByBoundFacet = new LinkedHashMap<Facet, ImmutableSet>();
        for (Map.Entry e : resolverDefinitionsByFacets.entrySet()) {
            Optional facetNameOpt = (Optional)e.getKey();
            if (facetNameOpt.isEmpty()) continue;
            Facet facetName = (Facet)facetNameOpt.get();
            LinkedHashSet<Dependency> dependenciesForFacet = new LinkedHashSet<Dependency>();
            for (ResolverDefinition resolverDefinition : (ImmutableSet)e.getValue()) {
                dependenciesForFacet.add(resolverDefinition.target().dependency());
            }
            dependenciesByBoundFacet.put(facetName, ImmutableSet.copyOf(dependenciesForFacet));
        }
        return ImmutableMap.copyOf(dependenciesByBoundFacet);
    }
}

