/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.concurrent.Futures;
import com.flipkart.krystal.core.OutputLogicExecutionInput;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.DepResponse;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.FacetValuesBuilder;
import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.One2OneDepResponse;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.data.RequestResponse;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.facets.Facet;
import com.flipkart.krystal.facets.resolution.ResolverCommand;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.commands.CallbackCommand;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardReceive;
import com.flipkart.krystal.krystex.commands.ForwardSend;
import com.flipkart.krystal.krystex.commands.MultiRequestCommand;
import com.flipkart.krystal.krystex.decoration.DecorationOrdering;
import com.flipkart.krystal.krystex.decoration.FlushCommand;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyDecorator;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyExecutionContext;
import com.flipkart.krystal.krystex.dependencydecoration.VajramInvocation;
import com.flipkart.krystal.krystex.kryon.AbstractKryon;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.DependentChain;
import com.flipkart.krystal.krystex.kryon.DuplicateRequestException;
import com.flipkart.krystal.krystex.kryon.KryonCommandResponse;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.KryonUtils;
import com.flipkart.krystal.krystex.kryon.OutputLogicFacets;
import com.flipkart.krystal.krystex.kryon.VajramKryonDefinition;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.request.InvocationId;
import com.flipkart.krystal.krystex.request.RequestIdGenerator;
import com.flipkart.krystal.krystex.resolution.Resolver;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BatchKryon
extends AbstractKryon<MultiRequestCommand, BatchResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchKryon.class);
    private final Map<DependentChain, Map<InvocationId, FacetValuesBuilder>> facetsCollector = new HashMap<DependentChain, Map<InvocationId, FacetValuesBuilder>>(64);
    private final Map<DependentChain, ForwardReceive> inputsValueCollector = new HashMap<DependentChain, ForwardReceive>(64);
    private final Map<DependentChain, CompletableFuture<BatchResponse>> resultsByDepChain = new HashMap<DependentChain, CompletableFuture<BatchResponse>>(64);
    private final Map<DependentChain, Set<Facet>> executedDependencies = new HashMap<DependentChain, Set<Facet>>(64);
    private final Map<DependentChain, Set<InvocationId>> invocationsByDependentChain = new HashMap<DependentChain, Set<InvocationId>>(64);
    private final Map<DependentChain, Boolean> outputLogicExecuted = new HashMap<DependentChain, Boolean>(64);
    private final Map<DependentChain, Map<Dependency, Set<Facet>>> dependencyToPendingFacets = new HashMap<DependentChain, Map<Dependency, Set<Facet>>>(64);
    private final Map<DependentChain, Set<Facet>> outputLogicPendingFacets = new HashMap<DependentChain, Set<Facet>>(64);

    BatchKryon(VajramKryonDefinition kryonDefinition, KryonExecutor kryonExecutor, Function<LogicExecutionContext, Map<String, OutputLogicDecorator>> outputLogicDecoratorSuppliers, Function<DependencyExecutionContext, ImmutableMap<String, DependencyDecorator>> depDecoratorSuppliers, DecorationOrdering decorationOrdering, RequestIdGenerator requestIdGenerator) {
        super(kryonDefinition, kryonExecutor, outputLogicDecoratorSuppliers, depDecoratorSuppliers, decorationOrdering, requestIdGenerator);
    }

    @Override
    public void executeCommand(Flush flushCommand) {
    }

    @Override
    public CompletableFuture<BatchResponse> executeCommand(MultiRequestCommand kryonCommand) {
        DependentChain dependentChain = kryonCommand.dependentChain();
        CompletableFuture resultForDepChain = this.resultsByDepChain.computeIfAbsent(dependentChain, r -> new CompletableFuture());
        try {
            Set<Object> triggerableDependencies = new HashSet();
            if (kryonCommand instanceof ForwardReceive) {
                ForwardReceive forward = (ForwardReceive)kryonCommand;
                if (log.isDebugEnabled()) {
                    forward.executableInvocations().forEach((requestId, facets) -> log.debug("Exec Ids - {}: {} invoked with inputs {}, in call path {}", new Object[]{requestId, this.vajramID, facets, forward.dependentChain()}));
                }
                triggerableDependencies = this.collectInputValues(forward);
            } else if (kryonCommand instanceof CallbackCommand) {
                CallbackCommand callbackBatch = (CallbackCommand)kryonCommand;
                if (log.isDebugEnabled()) {
                    callbackBatch.resultsByRequest().forEach((requestId, results) -> log.debug("Exec Ids - {}: {} received response for dependency {} in call path {}. Response: {}", new Object[]{requestId, this.vajramID, callbackBatch.dependency(), callbackBatch.dependentChain(), results}));
                }
                triggerableDependencies = this.collectDependencyValues(callbackBatch);
            }
            this.triggerDependencies(dependentChain, Collections.unmodifiableSet(triggerableDependencies));
            this.executeOutputLogicIfPossible(dependentChain);
        }
        catch (Throwable e) {
            resultForDepChain.completeExceptionally(StackTracelessException.stackTracelessWrap((Throwable)e));
        }
        return resultForDepChain;
    }

    private void triggerDependencies(DependentChain dependentChain, Set<Dependency> triggerableDependencies) {
        ForwardReceive forwardBatch = this.getForwardCommand(dependentChain);
        if (log.isDebugEnabled()) {
            log.debug("Exec ids: {}. Computed triggerable dependencies: {} of {} in call path {}", new Object[]{forwardBatch.invocationIds(), triggerableDependencies, this.vajramID, forwardBatch.dependentChain()});
        }
        Map<InvocationId, String> skippedRequests = forwardBatch.invocationsToSkip();
        Set<InvocationId> executableRequests = forwardBatch.executableInvocations().keySet();
        LinkedHashMap<Dependency, Map> commandsByDependency = new LinkedHashMap<Dependency, Map>(this.kryonDefinition.dependencyKryons().size());
        LinkedHashMap requestIdsByDependency = new LinkedHashMap(this.kryonDefinition.dependencyKryons().size());
        if (!skippedRequests.isEmpty()) {
            ResolverCommand.SkipDependency skip = ResolverCommand.skip((String)String.join((CharSequence)", ", skippedRequests.values()));
            for (Dependency dependency : triggerableDependencies) {
                commandsByDependency.computeIfAbsent(dependency, _k -> new LinkedHashMap(64)).put(Collections.unmodifiableSet(skippedRequests.keySet()), skip);
                requestIdsByDependency.computeIfAbsent(dependency, _k -> new LinkedHashSet(64)).addAll(skippedRequests.keySet());
            }
        }
        Sets.SetView triggerablesWithNoResolvers = Sets.intersection(this.kryonDefinition.dependenciesWithNoResolvers(), triggerableDependencies);
        for (InvocationId invocationId : executableRequests) {
            triggerablesWithNoResolvers.forEach(depName -> {
                commandsByDependency.computeIfAbsent((Dependency)depName, _k -> new LinkedHashMap(64)).put(Set.of(invocationId), ResolverCommand.executeWithRequests((ImmutableList)ImmutableList.of(this.emptyRequest())));
                requestIdsByDependency.computeIfAbsent((Dependency)depName, _k -> new LinkedHashSet(64)).add(invocationId);
            });
            FacetValues facetValues = this.getFacetsFor(dependentChain, invocationId);
            triggerableDependencies.forEach(dep -> {
                ImmutableSet resolverDefs = (ImmutableSet)this.kryonDefinition.resolverDefinitionsByDependencies().getOrDefault(dep, (Object)ImmutableSet.of());
                VajramID depVajramId = (VajramID)this.kryonDefinition.dependencyKryons().get(dep);
                KryonDefinition depKryonDefinition = this.kryonDefinition.kryonDefinitionRegistry().get((VajramID)Preconditions.checkNotNull((Object)depVajramId));
                if (depKryonDefinition == null) {
                    commandsByDependency.computeIfAbsent((Dependency)dep, _k -> new LinkedHashMap(64)).put(Set.of(invocationId), ResolverCommand.skip((String)("Could not find dependency with vajram ID " + depVajramId)));
                    return;
                }
                Resolver fanoutResolver = null;
                ArrayList<Resolver> oneToOneResolvers = new ArrayList<Resolver>(resolverDefs.size());
                for (Resolver resolver : resolverDefs) {
                    if (resolver.definition().canFanout()) {
                        if (fanoutResolver != null) {
                            throw new IllegalStateException("Multiple fanout resolvers found for dependency %s of vajram %s. This is not supported.".formatted(dep, this.vajramID.id()));
                        }
                        fanoutResolver = resolver;
                        continue;
                    }
                    oneToOneResolvers.add(resolver);
                }
                Supplier<ImmutableRequest.Builder> newDepRequestBuilder = () -> depKryonDefinition.createNewRequest().logic().newRequestBuilder();
                ImmutableList depRequestBuilders = ImmutableList.of((Object)newDepRequestBuilder.get());
                ResolverCommand.ExecuteDependency resolverCommand = null;
                for (Resolver resolver : oneToOneResolvers) {
                    if (resolver == null || (resolverCommand = this.kryonDefinition.kryonDefinitionRegistry().logicDefinitionRegistry().getResolver(resolver.resolverKryonLogicId()).logic().resolve(depRequestBuilders, facetValues)) instanceof ResolverCommand.ExecuteDependency && resolverCommand.getRequests().isEmpty()) continue;
                    if (resolverCommand instanceof ResolverCommand.SkipDependency) break;
                    depRequestBuilders = resolverCommand.getRequests();
                }
                if (fanoutResolver != null && !(resolverCommand instanceof ResolverCommand.SkipDependency) && (resolverCommand = this.kryonDefinition.kryonDefinitionRegistry().logicDefinitionRegistry().getResolver(fanoutResolver.resolverKryonLogicId()).logic().resolve(depRequestBuilders, facetValues)) instanceof ResolverCommand.ExecuteDependency && resolverCommand.getRequests().isEmpty()) {
                    resolverCommand = ResolverCommand.executeWithRequests((ImmutableList)depRequestBuilders);
                }
                if (resolverCommand == null) {
                    resolverCommand = ResolverCommand.executeWithRequests((ImmutableList)depRequestBuilders);
                }
                commandsByDependency.computeIfAbsent((Dependency)dep, _k -> new LinkedHashMap(64)).put(Set.of(invocationId), resolverCommand);
                requestIdsByDependency.computeIfAbsent((Dependency)dep, _k -> new LinkedHashSet(64)).add(invocationId);
            });
        }
        for (Map.Entry entry : commandsByDependency.entrySet()) {
            Dependency dependency = (Dependency)entry.getKey();
            Map resolverCommandsForDep = (Map)entry.getValue();
            this.triggerDependency(dependency, dependentChain, resolverCommandsForDep, requestIdsByDependency.getOrDefault(dependency, Set.of()));
        }
    }

    private FacetValuesBuilder emptyFacets() {
        return this.kryonDefinition.facetsFromRequest().logic().facetsFromRequest((Request<?>)this.emptyRequest());
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableRequest.Builder<@Nullable Object> emptyRequest() {
        return this.kryonDefinition.createNewRequest().logic().newRequestBuilder();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableRequest.Builder<@Nullable Object> emptyRequestForVajram(VajramID depVajramID) {
        return this.kryonDefinition.kryonDefinitionRegistry().getOrThrow(depVajramID).createNewRequest().logic().newRequestBuilder();
    }

    private ForwardReceive getForwardCommand(DependentChain dependentChain) {
        ForwardReceive forwardBatch = this.inputsValueCollector.get(dependentChain);
        if (forwardBatch == null) {
            throw new IllegalArgumentException("Missing Forward command. This should not be possible.");
        }
        return forwardBatch;
    }

    private void triggerDependency(Dependency dependency, DependentChain dependentChain, Map<Set<InvocationId>, ResolverCommand> resolverCommandsByReq, Set<InvocationId> allInvocationIds) {
        if (this.executedDependencies.getOrDefault(dependentChain, Set.of()).contains(dependency)) {
            return;
        }
        VajramID depVajramID = (VajramID)this.kryonDefinition.dependencyKryons().get((Object)dependency);
        if (depVajramID == null) {
            throw new AssertionError((Object)"Could not find kryon mapped to dependency name %s in kryon %s.\nThis should not happen and is mostly a bug in the framework.\n".formatted(dependency, this.vajramID));
        }
        LinkedHashMap<InvocationId, Request<@Nullable Object>> depRequestsByDepInvocationId = new LinkedHashMap<InvocationId, Request<Object>>(64);
        LinkedHashMap<InvocationId, String> skipReasonsByReq = new LinkedHashMap<InvocationId, String>(64);
        LinkedHashMap<InvocationId, Set> depReqsByIncomingReq = new LinkedHashMap<InvocationId, Set>(64);
        for (Map.Entry<Set<InvocationId>, ResolverCommand> entry : resolverCommandsByReq.entrySet()) {
            Set<InvocationId> incomingReqIds = entry.getKey();
            ResolverCommand resolverCommand = entry.getValue();
            if (resolverCommand instanceof ResolverCommand.SkipDependency) {
                ResolverCommand.SkipDependency skipDependency = (ResolverCommand.SkipDependency)resolverCommand;
                InvocationId depReqId = this.requestIdGenerator.newSubRequest(incomingReqIds.iterator().next(), () -> "%s[skip]".formatted(dependency));
                skipReasonsByReq.put(depReqId, skipDependency.reason());
                continue;
            }
            int count = 0;
            for (InvocationId incomingReqId : incomingReqIds) {
                if (resolverCommand.getRequests().isEmpty()) {
                    InvocationId depReqId = this.requestIdGenerator.newSubRequest(incomingReqId, () -> "%s[skip]".formatted(dependency));
                    skipReasonsByReq.put(depReqId, "Resolvers for dependency %s resolved to empty list".formatted(dependency));
                    continue;
                }
                for (Request request : resolverCommand.getRequests()) {
                    int currentCount = count++;
                    InvocationId depReqId = this.requestIdGenerator.newSubRequest(incomingReqId, () -> "%s[%s]".formatted(dependency, currentCount));
                    depReqsByIncomingReq.computeIfAbsent(incomingReqId, _k -> new LinkedHashSet(64)).add(depReqId);
                    depRequestsByDepInvocationId.put(depReqId, (Request<Object>)request._build());
                }
            }
        }
        this.executedDependencies.computeIfAbsent(dependentChain, _k -> new LinkedHashSet(this.kryonDefinition.dependencyKryons().size())).add(dependency);
        if (log.isDebugEnabled()) {
            skipReasonsByReq.forEach((execId, reason) -> log.debug("Exec Ids: {}. Dependency {} of {} will be skipped due to reason {}", new Object[]{execId, Optional.ofNullable((VajramID)this.kryonDefinition.dependencyKryons().get((Object)dependency)), this.vajramID, reason}));
        }
        DependentChain extendedDependentChain = dependentChain.extend(this.vajramID, dependency);
        VajramInvocation<BatchResponse> kryonResponseVajramInvocation = this.decorateVajramInvocation(extendedDependentChain, depVajramID, this.kryonExecutor::executeCommand);
        CompletableFuture<BatchResponse> depResponse = kryonResponseVajramInvocation.invokeDependency(new ForwardSend(depVajramID, depRequestsByDepInvocationId, extendedDependentChain, skipReasonsByReq));
        depResponse.whenComplete((batchResponse, throwable) -> {
            LinkedHashMap<InvocationId, @Nullable @Nullable RequestResponse> results = new LinkedHashMap<InvocationId, RequestResponse>(64);
            for (InvocationId invocationId : allInvocationIds) {
                Object result;
                if (throwable != null) {
                    @Nullable @Nullable RequestResponse fail = new RequestResponse((Request)depRequestsByDepInvocationId.getOrDefault(invocationId, (Request<Object>)this.emptyRequestForVajram(depVajramID)._build()), Errable.withError((Throwable)throwable));
                    result = dependency.canFanout() ? new FanoutDepResponses((List)ImmutableList.of((Object)fail)) : fail;
                } else {
                    Set depReqIds = depReqsByIncomingReq.getOrDefault(invocationId, Set.of());
                    ArrayList<@Nullable @Nullable RequestResponse> collect = new ArrayList<RequestResponse>(depReqIds.size());
                    for (InvocationId depReqId : depReqIds) {
                        collect.add(new RequestResponse((Request)depRequestsByDepInvocationId.getOrDefault(depReqId, (Request<Object>)this.emptyRequestForVajram(depVajramID)._build()), batchResponse.responses().getOrDefault(depReqId, (Errable<Object>)Errable.nil())));
                    }
                    result = dependency.canFanout() ? new FanoutDepResponses(collect) : (collect.size() == 1 ? (DepResponse)collect.get(0) : One2OneDepResponse.noRequest());
                }
                results.put(invocationId, (RequestResponse)result);
            }
            KryonUtils.enqueueOrExecuteCommand(() -> new CallbackCommand(this.vajramID, dependency, results, dependentChain), this.kryonExecutor);
        });
        if (log.isDebugEnabled()) {
            this.logWaitingMessage(dependency, dependentChain, depResponse, depVajramID);
        }
    }

    private <R extends KryonCommandResponse> VajramInvocation<R> decorateVajramInvocation(DependentChain dependentChain, VajramID depVajramID, VajramInvocation<R> invocationToDecorate) {
        for (DependencyDecorator dependencyDecorator : this.getSortedDependencyDecorators(depVajramID, dependentChain)) {
            VajramInvocation<R> previousDecoratedInvocation = invocationToDecorate;
            invocationToDecorate = dependencyDecorator.decorateDependency(previousDecoratedInvocation);
        }
        return invocationToDecorate;
    }

    private void logWaitingMessage(Dependency dependency, DependentChain dependentChain, CompletableFuture<BatchResponse> depResponse, VajramID depVajramID) {
        for (int timeout : List.of(Integer.valueOf(5), Integer.valueOf(10), Integer.valueOf(15))) {
            depResponse.copy().orTimeout(timeout, TimeUnit.SECONDS).whenComplete((_r, throwable) -> {
                if (throwable instanceof TimeoutException) {
                    log.debug("KryonId: {}, Dependency: {} on: {} with depChain: {}. Status: Waiting since {} {}", new Object[]{this.vajramID, Optional.ofNullable((VajramID)this.kryonDefinition.dependencyKryons().get((Object)dependency)), depVajramID, dependentChain, timeout, TimeUnit.SECONDS});
                }
            });
        }
    }

    private void executeOutputLogicIfPossible(DependentChain dependentChain) {
        if (this.outputLogicExecuted.getOrDefault(dependentChain, false).booleanValue()) {
            return;
        }
        CompletableFuture<BatchResponse> outputLogicResult = null;
        ForwardReceive forwardCommand = this.getForwardCommand(dependentChain);
        if (forwardCommand.shouldSkip()) {
            outputLogicResult = CompletableFuture.completedFuture(BatchResponse.empty());
        } else if (this.outputLogicPendingFacets.getOrDefault(dependentChain, (Set<Facet>)ImmutableSet.of()).isEmpty()) {
            outputLogicResult = this.executeOutputLogic(Collections.unmodifiableSet(forwardCommand.executableInvocations().keySet()), dependentChain);
        }
        if (outputLogicResult != null) {
            this.outputLogicExecuted.put(dependentChain, true);
            this.flushDecorators(dependentChain);
            Futures.linkFutures(outputLogicResult, (CompletableFuture)this.resultsByDepChain.computeIfAbsent(dependentChain, r -> new CompletableFuture()));
        }
    }

    private CompletableFuture<BatchResponse> executeOutputLogic(Set<? extends InvocationId> invocationIds, DependentChain dependentChain) {
        OutputLogicDefinition<Object> outputLogicDefinition = this.kryonDefinition.getOutputLogicDefinition();
        LinkedHashMap<InvocationId, OutputLogicFacets> outputLogicInputs = new LinkedHashMap<InvocationId, OutputLogicFacets>(invocationIds.size());
        for (InvocationId invocationId : invocationIds) {
            outputLogicInputs.put(invocationId, this.getFacetsForOutputLogic(dependentChain, invocationId));
        }
        CompletableFuture<BatchResponse> resultForBatch = new CompletableFuture<BatchResponse>();
        Map<InvocationId, CompletableFuture<Errable<@Nullable Object>>> map = this.executeDecoratedOutputLogic(outputLogicDefinition, outputLogicInputs, dependentChain);
        CompletionStage ignored = CompletableFuture.allOf((CompletableFuture[])map.values().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> {
            LinkedHashMap<InvocationId, Errable<@Nullable Object>> responses = new LinkedHashMap<InvocationId, Errable<Object>>(outputLogicInputs.size());
            for (InvocationId invocationId : outputLogicInputs.keySet()) {
                responses.put(invocationId, (Errable<Object>)resultFutures.getOrDefault(invocationId, new CompletableFuture()).getNow(Errable.nil()));
            }
            resultForBatch.complete(new BatchResponse(responses));
        });
        return resultForBatch;
    }

    private Map<InvocationId, CompletableFuture<Errable<@Nullable Object>>> executeDecoratedOutputLogic(OutputLogicDefinition<Object> outputLogicDefinition, Map<InvocationId, OutputLogicFacets> inputs, DependentChain dependentChain) {
        NavigableSet<OutputLogicDecorator> sortedDecorators = this.getSortedOutputLogicDecorators(dependentChain);
        OutputLogic logic = ((OutputLogic)outputLogicDefinition.logic())::execute;
        for (OutputLogicDecorator outputLogicDecorator : sortedDecorators) {
            logic = outputLogicDecorator.decorateLogic(logic, outputLogicDefinition);
        }
        OutputLogic finalLogic = logic;
        LinkedHashMap<InvocationId, CompletableFuture<Errable<@Nullable Object>>> resultsByRequest = new LinkedHashMap<InvocationId, CompletableFuture<Errable<Object>>>(inputs.size());
        inputs.forEach((invocationId, outputLogicFacets) -> {
            CompletableFuture result;
            try {
                result = (CompletableFuture)finalLogic.execute(new OutputLogicExecutionInput(ImmutableList.of((Object)outputLogicFacets.allFacetValues()), (ExecutorService)this.kryonExecutor.commandQueue())).results().values().iterator().next();
            }
            catch (Throwable e) {
                result = CompletableFuture.failedFuture(e);
            }
            resultsByRequest.put((InvocationId)invocationId, (CompletableFuture<Errable<Object>>)result.handle(Errable::errableFrom));
        });
        return resultsByRequest;
    }

    private void flushDecorators(DependentChain dependentChain) {
        Iterable reverseSortedDecorators = this.getSortedOutputLogicDecorators(dependentChain)::descendingIterator;
        for (OutputLogicDecorator decorator : reverseSortedDecorators) {
            try {
                decorator.executeCommand(new FlushCommand(dependentChain));
            }
            catch (Throwable e) {
                log.error("Error while flushing decorator: {}. This is most probably a bug since decorator methods are not supposed to throw exceptions. This can cause unpredictable behaviour in the krystal graph execution. Please fix!", (Object)decorator, (Object)e);
            }
        }
    }

    private FacetValues getFacetsFor(DependentChain dependentChain, InvocationId invocationId) {
        return (FacetValues)this.facetsCollector.computeIfAbsent(dependentChain, _k -> new LinkedHashMap(64)).computeIfAbsent(invocationId, _k -> this.emptyFacets());
    }

    private OutputLogicFacets getFacetsForOutputLogic(DependentChain dependentChain, InvocationId invocationId) {
        return new OutputLogicFacets((FacetValues)this.facetsCollector.computeIfAbsent(dependentChain, _k -> new LinkedHashMap(64)).computeIfAbsent(invocationId, _k -> this.getForwardCommand(dependentChain).executableInvocations().getOrDefault(invocationId, (FacetValues)this.emptyFacets())._asBuilder()));
    }

    private Set<Dependency> collectInputValues(ForwardReceive forwardBatch) {
        DependentChain dependentChain = forwardBatch.dependentChain();
        if (this.invocationsByDependentChain.putIfAbsent(dependentChain, forwardBatch.invocationIds()) != null) {
            throw new DuplicateRequestException("Duplicate batch request received for dependant chain %s".formatted(dependentChain));
        }
        if (this.inputsValueCollector.putIfAbsent(dependentChain, forwardBatch) != null) {
            throw new DuplicateRequestException("Duplicate ForwardBatch %s received for kryon %s in dependant chain %s".formatted(this.inputsValueCollector.get(dependentChain), this.vajramID, dependentChain));
        }
        this.outputLogicPendingFacets.put(dependentChain, new HashSet<Facet>((Collection<Facet>)this.kryonDefinition.getOutputLogicDefinition().usedComputedFacets()));
        forwardBatch.executableInvocations().forEach((requestId, container) -> this.facetsCollector.computeIfAbsent(dependentChain, _d -> new LinkedHashMap(64)).put(requestId, container._asBuilder()));
        ImmutableSet dependencyNames = this.kryonDefinition.dependencyKryons().keySet();
        HashSet<Dependency> triggerableDependencies = new HashSet<Dependency>(dependencyNames.size());
        for (Dependency depName : dependencyNames) {
            ImmutableSet pendingFacets = (ImmutableSet)this.kryonDefinition.dependencyToBoundFacetsMapping().getOrDefault((Object)depName, (Object)ImmutableSet.of());
            if (pendingFacets.isEmpty()) {
                triggerableDependencies.add(depName);
                continue;
            }
            this.dependencyToPendingFacets.computeIfAbsent(dependentChain, _k -> new HashMap(this.kryonDefinition.dependencyKryons().size())).put(depName, new HashSet(pendingFacets));
        }
        for (Facet incomingFacet : this.kryonDefinition.givenFacets()) {
            triggerableDependencies.addAll(this.getTriggerableDependencies(dependentChain, incomingFacet));
        }
        return Collections.unmodifiableSet(triggerableDependencies);
    }

    private Set<Dependency> collectDependencyValues(CallbackCommand callbackBatch) {
        Dependency incomingFacet = callbackBatch.dependency();
        callbackBatch.resultsByRequest().forEach((requestId, depResponse) -> {
            FacetValuesBuilder facetsBuilder = (FacetValuesBuilder)this.facetsCollector.computeIfAbsent(callbackBatch.dependentChain(), _d -> new LinkedHashMap(64)).get(requestId);
            if (facetsBuilder == null) {
                return;
            }
            incomingFacet.setFacetValue(facetsBuilder, (FacetValue)depResponse);
        });
        this.outputLogicPendingFacets.computeIfAbsent(callbackBatch.dependentChain(), _k -> new HashSet(this.kryonDefinition.facets().size())).remove(incomingFacet);
        return this.getTriggerableDependencies(callbackBatch.dependentChain(), (Facet)incomingFacet);
    }

    private Set<Dependency> getTriggerableDependencies(DependentChain dependantChain, Facet incomingFacet) {
        ImmutableSet depsByBoundFacet = (ImmutableSet)this.kryonDefinition.dependenciesByBoundFacet().getOrDefault((Object)incomingFacet, (Object)ImmutableSet.of());
        HashSet<Dependency> triggerableDependencies = new HashSet<Dependency>(this.kryonDefinition.dependencyKryons().size());
        for (Dependency depName : depsByBoundFacet) {
            Set pendingFacets = (Set)this.dependencyToPendingFacets.computeIfAbsent(dependantChain, _k -> new HashMap(this.kryonDefinition.dependencyKryons().size())).get(depName);
            if (pendingFacets != null) {
                pendingFacets.remove(incomingFacet);
            }
            if (pendingFacets != null && !pendingFacets.isEmpty()) continue;
            triggerableDependencies.add(depName);
        }
        return Collections.unmodifiableSet(triggerableDependencies);
    }
}

