/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.logicdecorators.observability;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.flipkart.krystal.core.OutputLogicExecutionResults;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfigurator;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecoratorConfig;
import com.flipkart.krystal.krystex.logicdecorators.observability.GenerateHtml;
import com.flipkart.krystal.krystex.logicdecorators.observability.KryonExecutionReport;
import com.flipkart.krystal.krystex.logicdecorators.observability.LogicExecResponse;
import com.flipkart.krystal.krystex.logicdecorators.observability.LogicExecResults;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainLogicExecReporter
implements OutputLogicDecorator,
KryonExecutorConfigurator {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(MainLogicExecReporter.class);
    public static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String DECORATOR_TYPE = MainLogicExecReporter.class.getName();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecutionReport kryonExecutionReport;
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String FILE_PATH = File.separator + "tmp" + File.separator + "krystal_exec_graph_";
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ObjectMapper objectMapper;

    public MainLogicExecReporter(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecutionReport kryonExecutionReport) {
        this.kryonExecutionReport = kryonExecutionReport;
        this.objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(SerializationFeature.FAIL_ON_SELF_REFERENCES);
    }

    @Override
    public void addToConfig( @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecutorConfig.KryonExecutorConfigBuilder configBuilder) {
        configBuilder.logicDecoratorConfig(this.decoratorType(), new OutputLogicDecoratorConfig(this.decoratorType(), logicExecutionContext -> true, logicExecutionContext -> this.decoratorType(), decoratorContext -> this));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogic<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> decorateLogic(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogic<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogicDefinition<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> originalLogicDefinition) {
        return input -> {
            VajramID vajramID = originalLogicDefinition.kryonLogicId().vajramID();
            KryonLogicId kryonLogicId = originalLogicDefinition.kryonLogicId();
            ImmutableList facets = input.facetValues();
            this.kryonExecutionReport.reportMainLogicStart(vajramID, kryonLogicId, (ImmutableList<? extends FacetValues>)facets);
            OutputLogicExecutionResults executionResult = logicToDecorate.execute(input);
            ImmutableMap results = executionResult.results();
            CompletableFuture.allOf((CompletableFuture[])results.values().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> this.kryonExecutionReport.reportMainLogicEnd(vajramID, kryonLogicId, new LogicExecResults((ImmutableList<LogicExecResponse>)((ImmutableList)results.entrySet().stream().map(e -> new LogicExecResponse((FacetValues)e.getKey(), (Errable<Object>)((CompletableFuture)((CompletableFuture)e.getValue()).handle(Errable::errableFrom)).getNow(Errable.nil()))).collect(ImmutableList.toImmutableList())))));
            return executionResult;
        };
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String decoratorType() {
        return DECORATOR_TYPE;
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecutionReport getKryonExecutionReport() {
        return this.kryonExecutionReport;
    }

    @Override
    public void onComplete() {
        String htmlString = this.generateGraph();
        String fileName = LocalDateTime.now(ZoneId.of((String)Preconditions.checkNotNull((Object)ZoneId.SHORT_IDS.get("IST")))).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + ".html";
        MainLogicExecReporter.writeToFile(htmlString, FILE_PATH + fileName);
    }

    public static void writeToFile(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String content, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String filePath) {
        try {
            Path path = Paths.get(filePath, new String[0]);
            if (path.getParent() == null) {
                log.error("Parent path is null so not storing the html output of DefaultKryonExecutionReport");
                return;
            }
            if (!Files.exists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            FileWriter writer = new FileWriter(filePath, StandardCharsets.UTF_8);
            writer.write(content);
            writer.close();
        }
        catch (IOException e) {
            log.error("Error writing file: {} with path: {}" + e.getMessage(), (Object)filePath);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String generateGraph() {
        try {
            String jsonString = this.objectMapper.writeValueAsString((Object)this.kryonExecutionReport);
            return GenerateHtml.generateHtml(jsonString);
        }
        catch (JsonProcessingException e) {
            log.error("Error came while serializing kryonExecutionReport");
            return "";
        }
    }
}

