/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.logicdecorators.resilience4j;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.core.OutputLogicExecutionInput;
import com.flipkart.krystal.core.OutputLogicExecutionResults;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.logicdecorators.resilience4j.R4JUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.decorators.Decorators;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public final class Resilience4JBulkhead
implements OutputLogicDecorator {
    public static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String DECORATOR_TYPE = Resilience4JBulkhead.class.getName();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String instanceId;
    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Resilience4JBulkhead. @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BulkheadAdapter adaptedBulkhead;

    public Resilience4JBulkhead(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogic<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> decorateLogic(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogic<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogicDefinition<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> originalLogicDefinition) {
        BulkheadAdapter bulkhead = this.adaptedBulkhead;
        if (bulkhead != null) {
            return input -> R4JUtils.extractResponseMap((ImmutableList<? extends FacetValues>)input.facetValues(), bulkhead.decorate(logicToDecorate, input));
        }
        return logicToDecorate;
    }

    public void onConfigUpdate(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ConfigProvider configProvider) {
        this.updateBulkhead(configProvider);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String getId() {
        return this.instanceId;
    }

    private void updateBulkhead(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ConfigProvider configProvider) {
        Optional<BulkheadAdapterConfig> newBulkheadConfig = this.getBulkheadConfig(configProvider);
        if (newBulkheadConfig.isPresent()) {
            BulkheadAdapter bulkhead = this.adaptedBulkhead;
            if (bulkhead == null) {
                this.adaptedBulkhead = new BulkheadAdapter(newBulkheadConfig.get());
            } else {
                bulkhead.changeConfig(newBulkheadConfig.get());
            }
        } else {
            this.adaptedBulkhead = null;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BulkheadAdapterConfig> getBulkheadConfig(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ConfigProvider configProvider) {
        boolean bulkheadEnabled = configProvider.getConfig(this.instanceId + ".bulkhead.enabled").orElse(true);
        if (!bulkheadEnabled) {
            return Optional.empty();
        }
        BulkheadType bulkheadType = configProvider.getConfig(this.instanceId + ".bulkhead.type").map(BulkheadType::valueOf).orElse(BulkheadType.SEMAPHORE);
        Optional maxConcurrency = configProvider.getConfig(this.instanceId + ".bulkhead.max_concurrency");
        switch (bulkheadType) {
            case SEMAPHORE: {
                BulkheadConfig.Builder builder = BulkheadConfig.custom().writableStackTraceEnabled(false);
                maxConcurrency.ifPresent(arg_0 -> ((BulkheadConfig.Builder)builder).maxConcurrentCalls(arg_0));
                return Optional.of(new BulkheadAdapterConfig(builder.build()));
            }
            case THREADPOOL: {
                ThreadPoolBulkheadConfig.Builder builder = ThreadPoolBulkheadConfig.custom().writableStackTraceEnabled(false).queueCapacity(0);
                maxConcurrency.ifPresent(arg_0 -> ((ThreadPoolBulkheadConfig.Builder)builder).maxThreadPoolSize(arg_0));
                maxConcurrency.ifPresent(arg_0 -> ((ThreadPoolBulkheadConfig.Builder)builder).coreThreadPoolSize(arg_0));
                return Optional.of(new BulkheadAdapterConfig(builder.build()));
            }
        }
        return Optional.empty();
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String getBulkheadId() {
        return this.instanceId + ".bulkhead";
    }

    private final class BulkheadAdapter {
        private @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Bulkhead bulkhead;
        private @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ThreadPoolBulkhead threadPoolBulkhead;

        private BulkheadAdapter(BulkheadAdapterConfig config) {
            BulkheadConfig bulkheadConfig = config.bulkheadConfig();
            if (bulkheadConfig != null) {
                this.bulkhead = Bulkhead.of((String)Resilience4JBulkhead.this.getBulkheadId(), (BulkheadConfig)bulkheadConfig);
            } else {
                ThreadPoolBulkheadConfig threadPoolBulkheadConfig = config.threadPoolBulkheadConfig();
                if (threadPoolBulkheadConfig != null) {
                    this.threadPoolBulkhead = BulkheadAdapter.newThreadPoolBulkhead(threadPoolBulkheadConfig, Resilience4JBulkhead.this.getBulkheadId());
                } else {
                    throw new IllegalArgumentException("Either bulkheadConfig or threadPoolBulkheadConfig must be non-null");
                }
            }
        }

        private void changeConfig(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BulkheadAdapterConfig config) {
            Bulkhead localBulkHead = this.bulkhead;
            if (config.bulkheadConfig() != null && localBulkHead != null && !config.bulkheadConfig().equals(localBulkHead.getBulkheadConfig())) {
                localBulkHead.changeConfig(config.bulkheadConfig());
            } else {
                ThreadPoolBulkhead localTPBulkhead = this.threadPoolBulkhead;
                if (config.threadPoolBulkheadConfig() != null && localTPBulkhead != null && !config.threadPoolBulkheadConfig().equals(localTPBulkhead.getBulkheadConfig())) {
                    this.threadPoolBulkhead = BulkheadAdapter.newThreadPoolBulkhead(config.threadPoolBulkheadConfig(), Resilience4JBulkhead.this.getBulkheadId());
                }
            }
        }

        @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletionStage<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogicExecutionResults<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object>> decorate(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogic<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogicExecutionInput input) {
            ThreadPoolBulkhead threadPoolBulkhead = this.threadPoolBulkhead;
            Bulkhead bulkhead = this.bulkhead;
            if (threadPoolBulkhead != null) {
                return threadPoolBulkhead.executeCallable(() -> logicToDecorate.execute(input));
            }
            if (bulkhead != null) {
                return Decorators.ofCompletionStage(() -> {
                    OutputLogicExecutionResults results = logicToDecorate.execute(input);
                    CompletionStage handle = CompletableFuture.allOf((CompletableFuture[])results.results().values().toArray(CompletableFuture[]::new)).handle((unused, throwable) -> results);
                    return handle;
                }).withBulkhead(bulkhead).get();
            }
            throw new IllegalStateException("Either bulkheadConfig or threadPoolBulkheadConfig must be non-null");
        }

        private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ThreadPoolBulkhead newThreadPoolBulkhead(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ThreadPoolBulkheadConfig config, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String bulkheadId) {
            return ThreadPoolBulkhead.of((String)bulkheadId, (ThreadPoolBulkheadConfig)config);
        }
    }

    private record BulkheadAdapterConfig(@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BulkheadConfig bulkheadConfig, @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ThreadPoolBulkheadConfig threadPoolBulkheadConfig) {
        BulkheadAdapterConfig(@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BulkheadConfig bulkheadConfig, @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ThreadPoolBulkheadConfig threadPoolBulkheadConfig) {
            Preconditions.checkArgument((bulkheadConfig == null || threadPoolBulkheadConfig == null ? 1 : 0) != 0);
            Preconditions.checkArgument((bulkheadConfig != null || threadPoolBulkheadConfig != null ? 1 : 0) != 0);
        }

        private BulkheadAdapterConfig(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BulkheadConfig bulkheadConfig) {
            this(bulkheadConfig, null);
        }

        private BulkheadAdapterConfig(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ThreadPoolBulkheadConfig threadPoolBulkheadConfig) {
            this(null, threadPoolBulkheadConfig);
        }
    }

    private static enum BulkheadType {
        THREADPOOL,
        SEMAPHORE;

    }
}

