/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.annos.ExternalInvocation;
import com.flipkart.krystal.concurrent.Futures;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.krystex.KrystalExecutor;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardReceive;
import com.flipkart.krystal.krystex.commands.ForwardSend;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.BatchKryon;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.kryon.DisabledDependantChainException;
import com.flipkart.krystal.krystex.kryon.FlushResponse;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonDefinitionRegistry;
import com.flipkart.krystal.krystex.kryon.KryonExecutionConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutorMetrics;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonRegistry;
import com.flipkart.krystal.krystex.kryon.KryonResponse;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorationInput;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorator;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorConfig;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorContext;
import com.flipkart.krystal.krystex.kryondecoration.KryonExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.InitiateActiveDepChains;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecoratorConfig;
import com.flipkart.krystal.krystex.request.IntReqGenerator;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.krystex.request.RequestIdGenerator;
import com.flipkart.krystal.krystex.request.StringReqGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KryonExecutor
implements KrystalExecutor {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(KryonExecutor.class);
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonDefinitionRegistry kryonDefinitionRegistry;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecutorConfig executorConfig;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutorService commandQueue;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String instanceId;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogicDecoratorConfig>> requestScopedLogicDecoratorConfigs;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogicDecorator>> requestScopedOutputLogicDecorators = new LinkedHashMap<String, Map<String, OutputLogicDecorator>>();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonDecorator>> requestScopedKryonDecorators = new LinkedHashMap<String, Map<String, KryonDecorator>>();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonRegistry<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @MaybeLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?> kryonRegistry = new KryonRegistry();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecutorMetrics kryonMetrics;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RequestId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecution> allExecutions = new LinkedHashMap<RequestId, KryonExecution>();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Set<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RequestId> unFlushedExecutions = new LinkedHashSet<RequestId>();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Set<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependantChain>> dependantChainsPerKryon = new LinkedHashMap<KryonId, Set<DependantChain>>();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RequestIdGenerator preferredReqGenerator;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Set<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependantChain> depChainsDisabledInAllExecutions = new LinkedHashSet<DependantChain>();
    private volatile @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean closed;
    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean shutdownRequested;

    public KryonExecutor(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonDefinitionRegistry kryonDefinitionRegistry, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecutorConfig executorConfig, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String instanceId) {
        this.kryonDefinitionRegistry = kryonDefinitionRegistry;
        this.executorConfig = executorConfig;
        this.commandQueue = executorConfig.singleThreadExecutor();
        this.instanceId = instanceId;
        this.requestScopedLogicDecoratorConfigs = ImmutableMap.copyOf(executorConfig.requestScopedLogicDecoratorConfigs());
        this.kryonMetrics = new KryonExecutorMetrics();
        this.preferredReqGenerator = executorConfig.debug() ? new StringReqGenerator() : new IntReqGenerator();
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogicDecorator> getRequestScopedDecorators(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent LogicExecutionContext logicExecutionContext) {
        KryonId kryonId = logicExecutionContext.kryonId();
        KryonDefinition kryonDefinition = this.kryonDefinitionRegistry.get(kryonId);
        OutputLogicDefinition outputLogicDefinition = kryonDefinition.getOutputLogicDefinition();
        LinkedHashMap decorators = new LinkedHashMap();
        Stream.concat(outputLogicDefinition.requestScopedLogicDecoratorConfigs().entrySet().stream(), this.requestScopedLogicDecoratorConfigs.entrySet().stream()).forEach(entry -> {
            String decoratorType = (String)entry.getKey();
            if (decorators.containsKey(decoratorType)) {
                return;
            }
            ArrayList decoratorConfigList = new ArrayList((Collection)entry.getValue());
            for (OutputLogicDecoratorConfig decoratorConfig : decoratorConfigList) {
                String instanceId = decoratorConfig.instanceIdGenerator().apply(logicExecutionContext);
                if (!decoratorConfig.shouldDecorate().test(logicExecutionContext)) continue;
                OutputLogicDecorator outputLogicDecorator = this.requestScopedOutputLogicDecorators.computeIfAbsent(decoratorType, t -> new LinkedHashMap()).computeIfAbsent(instanceId, _i -> decoratorConfig.factory().apply(new OutputLogicDecoratorConfig.LogicDecoratorContext(instanceId, logicExecutionContext)));
                outputLogicDecorator.executeCommand(new InitiateActiveDepChains(kryonId, (ImmutableSet<DependantChain>)ImmutableSet.copyOf((Collection)this.dependantChainsPerKryon.getOrDefault(kryonId, (Set<DependantChain>)ImmutableSet.of()))));
                decorators.put(decoratorType, outputLogicDecorator);
                break;
            }
        });
        return ImmutableMap.copyOf(decorators);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@Nullable T> executeKryon(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonId kryonId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request facets, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecutionConfig executionConfig) {
        if (this.closed) {
            throw new RejectedExecutionException("KryonExecutor is already closed");
        }
        Preconditions.checkArgument((executionConfig != null ? 1 : 0) != 0, (Object)"executionConfig can not be null");
        if (!this.executorConfig._riskyOpenAllKryonsForExternalInvocation() && !this.kryonDefinitionRegistry.get(kryonId).tags().getAnnotationByType(ExternalInvocation.class).map(ExternalInvocation::allow).orElse(false).booleanValue()) {
            throw new RejectedExecutionException("External invocation is not allowed for kryonId: " + kryonId);
        }
        String executionId = executionConfig.executionId();
        Preconditions.checkArgument((executionId != null ? 1 : 0) != 0, (Object)"executionConfig.executionId can not be null");
        RequestId requestId = this.preferredReqGenerator.newRequest("%s:%s".formatted(this.instanceId, executionId));
        return this.enqueueCommand(() -> {
            this.createDependencyKryons(kryonId, this.kryonDefinitionRegistry.getDependantChainsStart(), executionConfig);
            CompletableFuture<@Nullable Object> future = new CompletableFuture<Object>();
            if (this.allExecutions.containsKey(requestId)) {
                future.completeExceptionally(new IllegalArgumentException("Received duplicate requests for same instanceId '%s' and execution Id '%s'".formatted(this.instanceId, executionId)));
            } else {
                this.allExecutions.put(requestId, new KryonExecution(kryonId, requestId, facets, executionConfig, future));
                this.unFlushedExecutions.add(requestId);
            }
            CompletableFuture<@Nullable Object> f = future;
            return f;
        }).thenCompose(Function.identity());
    }

    private void createDependencyKryons(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonId kryonId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecutionConfig executionConfig) {
        KryonDefinition kryonDefinition = this.kryonDefinitionRegistry.get(kryonId);
        if (!Sets.union(this.executorConfig.disabledDependantChains(), executionConfig.disabledDependantChains()).contains((Object)dependantChain)) {
            this.createKryonIfAbsent(kryonId, kryonDefinition);
            ImmutableMap<Dependency, KryonId> dependencyKryons = kryonDefinition.dependencyKryons();
            dependencyKryons.forEach((dependency, depKryonId) -> this.createDependencyKryons((KryonId)depKryonId, dependantChain.extend(kryonId, (Dependency)dependency), executionConfig));
            this.dependantChainsPerKryon.computeIfAbsent(kryonId, _n -> new LinkedHashSet()).add(dependantChain);
        }
    }

    private void createKryonIfAbsent(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonId kryonId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonDefinition kryonDefinition) {
        KryonRegistry<?> batchKryonRegistry = this.kryonRegistry;
        batchKryonRegistry.createIfAbsent(kryonId, _n -> new BatchKryon(kryonDefinition, this, this::getRequestScopedDecorators, this.executorConfig.logicDecorationOrdering(), this.preferredReqGenerator));
    }

    <R extends KryonResponse> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<R> enqueueKryonCommand(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Supplier<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommand> kryonCommand) {
        return this.enqueueCommand(() -> this._executeCommand((KryonCommand)kryonCommand.get())).thenCompose(Function.identity());
    }

    public <T extends KryonResponse> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<T> executeCommand(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommand kryonCommand) {
        if (GraphTraversalStrategy.BREADTH.equals((Object)this.executorConfig.graphTraversalStrategy())) {
            return this.enqueueKryonCommand(() -> kryonCommand);
        }
        this.kryonMetrics.commandQueueBypassed();
        return this._executeCommand(kryonCommand);
    }

    private <R extends KryonResponse> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<R> _executeCommand(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommand kryonCommand) {
        try {
            if (kryonCommand instanceof ForwardSend) {
                ForwardSend forwardSend = (ForwardSend)kryonCommand;
                KryonDefinition kryonDefinition = this.kryonDefinitionRegistry.get(kryonCommand.kryonId());
                return this._executeCommand(new ForwardReceive(forwardSend.kryonId(), (ImmutableMap<RequestId, ? extends FacetValues>)((ImmutableMap)forwardSend.executableRequests().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> kryonDefinition.facetsFromRequest().logic().facetsFromRequest((Request)e.getValue())))), forwardSend.dependantChain(), forwardSend.skippedRequests()));
            }
            try {
                this.validate(kryonCommand);
            }
            catch (Throwable e2) {
                return CompletableFuture.failedFuture(e2);
            }
            KryonId kryonId = kryonCommand.kryonId();
            Object kryon = this.kryonRegistry.get(kryonId);
            for (KryonDecorator kryonDecorator : this.getSortedKryonDecorators(kryonId, kryonCommand)) {
                Kryon<KryonCommand, KryonResponse> decoratedKryon = kryonDecorator.decorateKryon(new KryonDecorationInput((Kryon<KryonCommand, KryonResponse>)kryon, this));
                kryon = decoratedKryon;
            }
            if (kryonCommand instanceof Flush) {
                Flush flush = (Flush)kryonCommand;
                kryon.executeCommand(flush);
                CompletableFuture<FlushResponse> f = CompletableFuture.completedFuture(FlushResponse.getInstance());
                return f;
            }
            return kryon.executeCommand((KryonCommand)kryonCommand);
        }
        catch (Throwable e3) {
            return CompletableFuture.failedFuture(e3);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TreeSet<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonDecorator> getSortedKryonDecorators(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonId kryonId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommand kryonCommand) {
        Map<String, KryonDecoratorConfig> configs = this.executorConfig.requestScopedKryonDecoratorConfigs();
        KryonExecutionContext executionContext = new KryonExecutionContext(kryonId, kryonCommand.dependantChain());
        TreeSet<KryonDecorator> sortedDecorators = new TreeSet<KryonDecorator>(this.executorConfig.logicDecorationOrdering().encounterOrder().reversed());
        for (Map.Entry<String, KryonDecoratorConfig> configsByType : configs.entrySet()) {
            String decoratorType = configsByType.getKey();
            KryonDecoratorConfig decoratorConfig = configsByType.getValue();
            if (!decoratorConfig.shouldDecorate().test(executionContext)) continue;
            String instanceId = decoratorConfig.instanceIdGenerator().apply(executionContext);
            sortedDecorators.add(this.requestScopedKryonDecorators.computeIfAbsent(decoratorType, _t -> new LinkedHashMap()).computeIfAbsent(instanceId, _i -> decoratorConfig.factory().apply(new KryonDecoratorContext(instanceId, executionContext))));
        }
        return sortedDecorators;
    }

    private void validate(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommand kryonCommand) {
        if (this.shutdownRequested) {
            throw new RejectedExecutionException("Kryon Executor shutdown requested.");
        }
        DependantChain dependantChain = kryonCommand.dependantChain();
        if (this.depChainsDisabledInAllExecutions.contains(dependantChain)) {
            throw new DisabledDependantChainException(dependantChain);
        }
    }

    private void flush() {
        this.enqueueRunnable(() -> {
            this.computeDisabledDependantChains();
            this.submitBatch(this.unFlushedExecutions);
            this.unFlushedExecutions.stream().map(requestId -> this.getKryonExecution((RequestId)requestId).kryonId()).distinct().forEach(kryonId -> this.executeCommand(new Flush((KryonId)kryonId, this.kryonDefinitionRegistry.getDependantChainsStart())));
        });
    }

    private void computeDisabledDependantChains() {
        this.depChainsDisabledInAllExecutions.clear();
        List<ImmutableSet> disabledDependantChainsPerExecution = this.unFlushedExecutions.stream().map(this::getKryonExecution).map(KryonExecution::executionConfig).map(KryonExecutionConfig::disabledDependantChains).toList();
        disabledDependantChainsPerExecution.stream().filter(x -> !x.isEmpty()).findAny().ifPresent(this.depChainsDisabledInAllExecutions::addAll);
        for (Set set : disabledDependantChainsPerExecution) {
            if (this.depChainsDisabledInAllExecutions.isEmpty()) break;
            this.depChainsDisabledInAllExecutions.retainAll(set);
        }
        this.depChainsDisabledInAllExecutions.addAll((Collection<DependantChain>)this.executorConfig.disabledDependantChains());
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecution getKryonExecution(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RequestId requestId) {
        KryonExecution kryonExecution = this.allExecutions.get(requestId);
        if (kryonExecution == null) {
            throw new AssertionError((Object)("No kryon execution found for requestId " + requestId));
        }
        return kryonExecution;
    }

    private void submitBatch(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Set<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RequestId> unFlushedRequests) {
        Map<KryonId, List<KryonExecution>> executionsByKryon = unFlushedRequests.stream().map(this::getKryonExecution).collect(Collectors.groupingBy(KryonExecution::kryonId));
        executionsByKryon.forEach((kryonId, kryonExecutions) -> {
            CompletableFuture batchResponseFuture = this.executeCommand(new ForwardSend((KryonId)kryonId, (ImmutableMap<RequestId, ? extends Request>)((ImmutableMap)kryonExecutions.stream().collect(ImmutableMap.toImmutableMap(KryonExecution::instanceExecutionId, kryonExecution -> kryonExecution.request()))), this.kryonDefinitionRegistry.getDependantChainsStart(), (ImmutableMap<RequestId, String>)ImmutableMap.of()));
            ((CompletableFuture)batchResponseFuture.thenApply(BatchResponse::responses)).whenComplete((responses, throwable) -> {
                for (KryonExecution kryonExecution : kryonExecutions) {
                    if (throwable != null) {
                        kryonExecution.future().completeExceptionally((Throwable)throwable);
                        continue;
                    }
                    Errable result = (Errable)responses.getOrDefault((Object)kryonExecution.instanceExecutionId(), (Object)Errable.nil());
                    Futures.linkFutures((CompletableFuture)result.toFuture(), kryonExecution.future());
                }
            });
            Futures.propagateCancellation(CompletableFuture.allOf((CompletableFuture[])kryonExecutions.stream().map(KryonExecutor.getFuture()).toArray(CompletableFuture[]::new)), batchResponseFuture);
        });
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecutorMetrics getKryonMetrics() {
        return this.kryonMetrics;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this._close0();
        this.flush();
        this.enqueueCommand(() -> CompletableFuture.allOf((CompletableFuture[])this.allExecutions.values().stream().map(KryonExecutor.getFuture()).toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> {
            for (Map.Entry<String, Map<String, OutputLogicDecorator>> decoratorsDetails : this.requestScopedOutputLogicDecorators.entrySet()) {
                Map<String, OutputLogicDecorator> decoratorsDetailsValue = decoratorsDetails.getValue();
                for (Map.Entry<String, OutputLogicDecorator> decorator : decoratorsDetailsValue.entrySet()) {
                    decorator.getValue().onComplete();
                }
            }
        }));
    }

    @Override
    public void shutdownNow() {
        this._close0();
        this.shutdownRequested = true;
    }

    private void _close0() {
        this.closed = true;
    }

    private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Function<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecution, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object>> getFuture() {
        return KryonExecution::future;
    }

    private void enqueueRunnable(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Runnable command) {
        this.enqueueCommand(() -> {
            command.run();
            return new Object();
        });
    }

    private <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<T> enqueueCommand(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Supplier<T> command) {
        return CompletableFuture.supplyAsync(() -> {
            this.kryonMetrics.commandQueued();
            return command.get();
        }, this.commandQueue);
    }

    public static enum GraphTraversalStrategy {
        DEPTH,
        BREADTH;

    }

    private record KryonExecution(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonId kryonId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RequestId instanceExecutionId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request request, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecutionConfig executionConfig, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> future) {
    }

    public static enum KryonExecStrategy {
        BATCH;

    }
}

