/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.krystex.LogicDefinitionRegistry;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.kryon.DependantChainStart;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.resolution.ResolverDefinition;
import com.flipkart.krystal.tags.ElementTags;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public final class KryonDefinitionRegistry {
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) LogicDefinitionRegistry logicDefinitionRegistry;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonDefinition> kryonDefinitions = new LinkedHashMap<KryonId, KryonDefinition>();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DependantChainStart dependantChainStart = new DependantChainStart();

    public KryonDefinitionRegistry(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) LogicDefinitionRegistry logicDefinitionRegistry) {
        this.logicDefinitionRegistry = logicDefinitionRegistry;
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) LogicDefinitionRegistry logicDefinitionRegistry() {
        return this.logicDefinitionRegistry;
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonDefinition get(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonId kryonId) {
        KryonDefinition kryon = this.kryonDefinitions.get(kryonId);
        if (kryon == null) {
            throw new IllegalArgumentException("No Kryon with id %s found".formatted(kryonId));
        }
        return kryon;
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonDefinition newKryonDefinition(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String kryonId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Set<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String> inputs, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonLogicId outputLogicId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonId> dependencyKryons, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ResolverDefinition> resolverDefinitions, @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) KryonLogicId mulitResolverId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ElementTags tags) {
        if (!resolverDefinitions.isEmpty() && mulitResolverId == null) {
            throw new IllegalArgumentException("missing multi resolver logic");
        }
        KryonDefinition kryonDefinition = new KryonDefinition(new KryonId(kryonId), inputs, outputLogicId, dependencyKryons, resolverDefinitions, Optional.ofNullable(mulitResolverId), this, tags);
        this.kryonDefinitions.put(kryonDefinition.kryonId(), kryonDefinition);
        return kryonDefinition;
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DependantChain getDependantChainsStart() {
        return this.dependantChainStart;
    }
}

