/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.logicdecorators.observability;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.logicdecorators.observability.KryonExecutionReport;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultKryonExecutionReport
implements KryonExecutionReport {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Logger log = LoggerFactory.getLogger(DefaultKryonExecutionReport.class);
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Instant startTime;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean verbose;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Clock clock;
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String SHA_256 = "SHA-256";
    private static @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) MessageDigest digest = null;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonExecution, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) LogicExecInfo> mainLogicExecInfos = new LinkedHashMap<KryonExecution, LogicExecInfo>();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Object> dataMap = new HashMap<String, Object>();

    public DefaultKryonExecutionReport(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Clock clock) {
        this(clock, false);
    }

    public DefaultKryonExecutionReport(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Clock clock, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean verbose) {
        this.clock = clock;
        this.startTime = clock.instant();
        this.verbose = verbose;
    }

    @Override
    public void reportMainLogicStart(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonId kryonId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonLogicId kryonLogicId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Facets> inputs) {
        KryonExecution kryonExecution = new KryonExecution(kryonId, (ImmutableList<ImmutableMap<String, String>>)((ImmutableList)inputs.stream().map(this::extractAndConvertInputs).collect(ImmutableList.toImmutableList())));
        if (this.mainLogicExecInfos.containsKey(kryonExecution)) {
            log.error("Cannot start the same kryon execution multiple times: {}", (Object)kryonExecution);
            return;
        }
        this.mainLogicExecInfos.put(kryonExecution, new LogicExecInfo(this, kryonId, (ImmutableCollection<Facets>)inputs, this.startTime.until(this.clock.instant(), ChronoUnit.MILLIS)));
    }

    @Override
    public void reportMainLogicEnd(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonId kryonId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonLogicId kryonLogicId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Results<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Object> result) {
        KryonExecution kryonExecution = new KryonExecution(kryonId, (ImmutableList<ImmutableMap<String, String>>)((ImmutableList)result.values().keySet().stream().map(this::extractAndConvertInputs).collect(ImmutableList.toImmutableList())));
        LogicExecInfo logicExecInfo = this.mainLogicExecInfos.get(kryonExecution);
        if (logicExecInfo == null) {
            log.error("'reportMainLogicEnd' called without calling 'reportMainLogicStart' first for: {}", (Object)kryonExecution);
            return;
        }
        if (logicExecInfo.getResult() != null) {
            log.error("Cannot end the same kryon execution multiple times: {}", (Object)kryonExecution);
            return;
        }
        logicExecInfo.endTimeMs = this.startTime.until(this.clock.instant(), ChronoUnit.MILLIS);
        logicExecInfo.setResult(this.convertResult(result));
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String> extractAndConvertInputs(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Facets facets) {
        LinkedHashMap<String, String> inputMap = new LinkedHashMap<String, String>();
        for (Map.Entry e : facets.values().entrySet()) {
            String collect;
            FacetValue value = (FacetValue)e.getValue();
            if (!(value instanceof Errable) || (collect = this.convertErrable((Errable<Object>)((Errable)value))) == null) continue;
            inputMap.put((String)e.getKey(), collect);
        }
        return ImmutableMap.copyOf(inputMap);
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Object> extractAndConvertDependencyResults(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Facets facets) {
        LinkedHashMap<String, Map<ImmutableMap<String, String>, String>> inputMap = new LinkedHashMap<String, Map<ImmutableMap<String, String>, String>>();
        for (Map.Entry e : facets.values().entrySet()) {
            FacetValue value = (FacetValue)e.getValue();
            if (!(value instanceof Results)) continue;
            Map<ImmutableMap<String, String>, String> collect = this.convertResult((Results<Object>)((Results)value));
            inputMap.put((String)e.getKey(), collect);
        }
        return ImmutableMap.copyOf(inputMap);
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String convertErrable(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Errable<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Object> voe) {
        String sha256;
        if (voe.error().isPresent()) {
            Throwable throwable = (Throwable)voe.error().get();
            String stackTraceAsString = Throwables.getStackTraceAsString((Throwable)throwable);
            sha256 = this.verbose ? DefaultKryonExecutionReport.hashValues(stackTraceAsString) : DefaultKryonExecutionReport.hashValues(throwable.toString());
            this.dataMap.put(sha256, this.verbose ? stackTraceAsString : throwable.toString());
        } else {
            String value = voe.value().orElse("null");
            sha256 = DefaultKryonExecutionReport.hashValues(value);
            this.dataMap.put(sha256, value);
        }
        return sha256;
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String>, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String> convertResult(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Results<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Object> results) {
        return results.values().entrySet().stream().collect(Collectors.toMap(e -> this.extractAndConvertInputs((Facets)e.getKey()), e -> this.convertErrable((Errable<Object>)((Errable)e.getValue()))));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String hashValues(T input) {
        return DefaultKryonExecutionReport.hashString(input != null ? input.toString() : "");
    }

    private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String hashString(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String appendedInput) {
        String encodedString = "";
        if (digest != null) {
            byte[] encodedHash = digest.digest(appendedInput.getBytes(StandardCharsets.UTF_8));
            encodedString = Base64.getEncoder().encodeToString(encodedHash);
        }
        return encodedString;
    }

    @SideEffectFree
    @Generated
    public @NonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) String toString() {
        return "DefaultKryonExecutionReport(startTime=" + this.getStartTime() + ", verbose=" + this.verbose + ", clock=" + this.clock + ", mainLogicExecInfos=" + this.getMainLogicExecInfos() + ", dataMap=" + this.getDataMap() + ")";
    }

    @Generated
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Instant getStartTime() {
        return this.startTime;
    }

    @Generated
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonExecution, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) LogicExecInfo> getMainLogicExecInfos() {
        return this.mainLogicExecInfos;
    }

    @Generated
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Object> getDataMap() {
        return this.dataMap;
    }

    static {
        try {
            digest = MessageDigest.getInstance(SHA_256);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Error could not hash inputs because of exception ", (Throwable)e);
        }
    }

    private record KryonExecution(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonId kryonId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String>> inputs) {
        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String toString() {
            return "%s(%s)".formatted(this.kryonId.value(), this.inputs);
        }
    }

    static final class LogicExecInfo {
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String kryonId;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String>> inputsList;
        private final @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Object>> dependencyResults;
        private @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) Object result;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) long startTimeMs;
        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) long endTimeMs;

        LogicExecInfo(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) DefaultKryonExecutionReport kryonExecutionReport, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonId kryonId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableCollection<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Facets> inputList, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) long startTimeMs) {
            this.startTimeMs = startTimeMs;
            this.kryonId = kryonId.value();
            this.inputsList = (ImmutableList)inputList.stream().map(kryonExecutionReport::extractAndConvertInputs).collect(ImmutableList.toImmutableList());
            ImmutableList dependencyResults = (ImmutableList)inputList.stream().map(kryonExecutionReport::extractAndConvertDependencyResults).filter(map -> !map.isEmpty()).collect(ImmutableList.toImmutableList());
            this.dependencyResults = dependencyResults.isEmpty() ? null : dependencyResults;
        }

        public void setResult(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String>, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String> result) {
            this.result = this.inputsList.size() <= 1 && result.size() == 1 ? result.values().iterator().next() : result;
        }

        @SideEffectFree
        @Generated
        public @NonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) String toString() {
            return "DefaultKryonExecutionReport.LogicExecInfo(kryonId=" + this.getKryonId() + ", inputsList=" + this.getInputsList() + ", dependencyResults=" + this.getDependencyResults() + ", result=" + this.getResult() + ", startTimeMs=" + this.getStartTimeMs() + ", endTimeMs=" + this.getEndTimeMs() + ")";
        }

        @Generated
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String getKryonId() {
            return this.kryonId;
        }

        @Generated
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String>> getInputsList() {
            return this.inputsList;
        }

        @Generated
        public @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Object>> getDependencyResults() {
            return this.dependencyResults;
        }

        @Generated
        public @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) Object getResult() {
            return this.result;
        }

        @Generated
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) long getStartTimeMs() {
            return this.startTimeMs;
        }

        @Generated
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) long getEndTimeMs() {
            return this.endTimeMs;
        }
    }
}

