/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.logicdecorators.observability;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.logicdecorators.observability.GenerateHtml;
import com.flipkart.krystal.krystex.logicdecorators.observability.KryonExecutionReport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainLogicExecReporter
implements OutputLogicDecorator {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Logger log = LoggerFactory.getLogger(MainLogicExecReporter.class);
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonExecutionReport kryonExecutionReport;
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String DATE_TIME_PATTERN = "yyyy-MM-dd_HH:mm:ss";
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String FILE_PATH = File.separator + "tmp" + File.separator + "krystal_exec_graph_";
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) ObjectMapper objectMapper;

    public MainLogicExecReporter(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonExecutionReport kryonExecutionReport) {
        this.kryonExecutionReport = kryonExecutionReport;
        this.objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(SerializationFeature.FAIL_ON_SELF_REFERENCES);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) OutputLogic<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Object> decorateLogic(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) OutputLogic<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) OutputLogicDefinition<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Object> originalLogicDefinition) {
        return inputs -> {
            KryonId kryonId = originalLogicDefinition.kryonLogicId().kryonId();
            KryonLogicId kryonLogicId = originalLogicDefinition.kryonLogicId();
            this.kryonExecutionReport.reportMainLogicStart(kryonId, kryonLogicId, (ImmutableList<Facets>)inputs);
            ImmutableMap<Facets, CompletableFuture<@Nullable T>> results = logicToDecorate.execute((ImmutableList<Facets>)inputs);
            CompletableFuture.allOf((CompletableFuture[])results.values().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> this.kryonExecutionReport.reportMainLogicEnd(kryonId, kryonLogicId, (Results<Object>)new Results((ImmutableMap)results.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((CompletableFuture)((CompletableFuture)e.getValue()).handle(Errable::errableFrom)).getNow(Errable.empty()))))));
            return results;
        };
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String getId() {
        return MainLogicExecReporter.class.getName();
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KryonExecutionReport getKryonExecutionReport() {
        return this.kryonExecutionReport;
    }

    @Override
    public void onComplete() {
        String htmlString = this.generateGraph();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_TIME_PATTERN);
        String fileName = LocalDateTime.now().format(formatter) + ".html";
        MainLogicExecReporter.writeToFile(htmlString, FILE_PATH + fileName);
    }

    public static void writeToFile(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String content, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String filePath) {
        try {
            Path path = Paths.get(filePath, new String[0]);
            if (path.getParent() == null) {
                log.error("Parent path is null so not storing the html output of DefaultKryonExecutionReport");
                return;
            }
            if (!Files.exists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            FileWriter writer = new FileWriter(filePath, StandardCharsets.UTF_8);
            writer.write(content);
            writer.close();
        }
        catch (IOException e) {
            log.error("Error writing file: {} with path: {}" + e.getMessage(), (Object)filePath);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String generateGraph() {
        try {
            String jsonString = this.objectMapper.writeValueAsString((Object)this.kryonExecutionReport);
            return GenerateHtml.generateHtml(jsonString);
        }
        catch (JsonProcessingException e) {
            log.error("Error came while serializing kryonExecutionReport");
            return "";
        }
    }
}

