/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.krystex.LogicDefinition;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.commands.BatchCommand;
import com.flipkart.krystal.krystex.commands.CallbackBatch;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardBatch;
import com.flipkart.krystal.krystex.kryon.AbstractKryon;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.kryon.DuplicateRequestException;
import com.flipkart.krystal.krystex.kryon.FacetType;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.kryon.KryonUtils;
import com.flipkart.krystal.krystex.kryon.OutputLogicFacets;
import com.flipkart.krystal.krystex.logicdecoration.FlushCommand;
import com.flipkart.krystal.krystex.logicdecoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.krystex.request.RequestIdGenerator;
import com.flipkart.krystal.krystex.resolution.DependencyResolutionRequest;
import com.flipkart.krystal.krystex.resolution.MultiResolverDefinition;
import com.flipkart.krystal.krystex.resolution.ResolverCommand;
import com.flipkart.krystal.krystex.resolution.ResolverDefinition;
import com.flipkart.krystal.utils.Futures;
import com.flipkart.krystal.utils.SkippedExecutionException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BatchKryon
extends AbstractKryon<BatchCommand, BatchResponse> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(BatchKryon.class);
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized ForwardBatch> inputsValueCollector = new LinkedHashMap<DependantChain, ForwardBatch>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CallbackBatch>> dependencyValuesCollector = new LinkedHashMap<DependantChain, Map<String, CallbackBatch>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse>> resultsByDepChain = new LinkedHashMap<DependantChain, CompletableFuture<BatchResponse>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> executedDependencies = new LinkedHashMap<DependantChain, Set<String>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId>> requestsByDependantChain = new LinkedHashMap<DependantChain, Set<RequestId>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Boolean> outputLogicExecuted = new LinkedHashMap<DependantChain, Boolean>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>>> dependencyToPendingFacets = new LinkedHashMap<DependantChain, Map<String, Set<String>>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> outputLogicPendingFacets = new LinkedHashMap<DependantChain, Set<String>>();

    BatchKryon(@UnknownKeyFor @NonNull @Initialized KryonDefinition kryonDefinition, @UnknownKeyFor @NonNull @Initialized KryonExecutor kryonExecutor, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized LogicExecutionContext, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized OutputLogicDecorator>> requestScopedDecoratorsSupplier, @UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering, @UnknownKeyFor @NonNull @Initialized RequestIdGenerator requestIdGenerator) {
        super(kryonDefinition, kryonExecutor, requestScopedDecoratorsSupplier, logicDecorationOrdering, requestIdGenerator);
    }

    @Override
    public void executeCommand(@UnknownKeyFor @NonNull @Initialized Flush flushCommand) {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse> executeCommand(@UnknownKeyFor @NonNull @Initialized BatchCommand kryonCommand) {
        DependantChain dependantChain = kryonCommand.dependantChain();
        CompletableFuture resultForDepChain = this.resultsByDepChain.computeIfAbsent(dependantChain, r -> new CompletableFuture());
        try {
            Set<String> triggerableDependencies = new HashSet<String>();
            if (kryonCommand instanceof ForwardBatch) {
                ForwardBatch forwardBatch = (ForwardBatch)kryonCommand;
                if (log.isDebugEnabled()) {
                    forwardBatch.executableRequests().forEach((requestId, facets) -> log.debug("Exec Ids - {}: {} invoked with inputs {}, in call path {}", new Object[]{requestId, this.kryonId, facets, forwardBatch.dependantChain()}));
                }
                triggerableDependencies = this.collectInputValues(forwardBatch);
            } else if (kryonCommand instanceof CallbackBatch) {
                CallbackBatch callbackBatch = (CallbackBatch)kryonCommand;
                if (log.isDebugEnabled()) {
                    callbackBatch.resultsByRequest().forEach((requestId, results) -> log.debug("Exec Ids - {}: {} received response for dependency {} in call path {}. Response: {}", new Object[]{requestId, this.kryonId, callbackBatch.dependencyName(), callbackBatch.dependantChain(), results}));
                }
                triggerableDependencies = this.collectDependencyValues(callbackBatch);
            }
            this.triggerDependencies(dependantChain, triggerableDependencies);
            this.executeOutputLogicIfPossible(dependantChain);
        }
        catch (Throwable e) {
            resultForDepChain.completeExceptionally(StackTracelessException.stackTracelessWrap((Throwable)e));
        }
        return resultForDepChain;
    }

    private void triggerDependencies(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> triggerableDependencies) {
        ForwardBatch forwardBatch = this.getForwardCommand(dependantChain);
        if (log.isDebugEnabled()) {
            log.debug("Exec ids: {}. Computed triggerable dependencies: {} of {} in call path {}", new Object[]{forwardBatch.requestIds(), triggerableDependencies, this.kryonId, forwardBatch.dependantChain()});
        }
        Optional<MultiResolverDefinition> multiResolverOpt = this.kryonDefinition.multiResolverLogicId().map(kryonLogicId -> this.kryonDefinition.kryonDefinitionRegistry().logicDefinitionRegistry().getMultiResolver((KryonLogicId)kryonLogicId));
        Map<RequestId, String> skippedRequests = forwardBatch.skippedRequests();
        Set<RequestId> executableRequests = forwardBatch.executableRequests().keySet();
        LinkedHashMap<String, Map> commandsByDependency = new LinkedHashMap<String, Map>();
        LinkedHashMap requestIdsByDependency = new LinkedHashMap();
        if (!skippedRequests.isEmpty()) {
            ResolverCommand.SkipDependency skip = ResolverCommand.skip(String.join((CharSequence)", ", skippedRequests.values()));
            for (String depName2 : triggerableDependencies) {
                commandsByDependency.computeIfAbsent(depName2, _k -> new LinkedHashMap()).put(Collections.unmodifiableSet(skippedRequests.keySet()), skip);
                requestIdsByDependency.computeIfAbsent(depName2, _k -> new LinkedHashSet()).addAll(skippedRequests.keySet());
            }
        }
        ArrayList<DependencyResolutionRequest> resolutionRequests = new ArrayList<DependencyResolutionRequest>();
        for (String depName2 : triggerableDependencies) {
            ImmutableSet resolverDefinitions = (ImmutableSet)this.kryonDefinition.resolverDefinitionsByDependencies().getOrDefault((Object)depName2, (Object)ImmutableSet.of());
            if (resolverDefinitions.isEmpty()) continue;
            resolutionRequests.add(new DependencyResolutionRequest(depName2, (Set<ResolverDefinition>)resolverDefinitions));
        }
        LinkedHashSet<String> boundFromFacets = new LinkedHashSet<String>();
        triggerableDependencies.forEach(depName -> boundFromFacets.addAll((Collection)this.kryonDefinition.dependencyToBoundFacetsMapping().getOrDefault(depName, (Object)ImmutableSet.of())));
        Sets.SetView triggerablesWithNoResolvers = Sets.intersection(this.kryonDefinition.dependenciesWithNoResolvers(), triggerableDependencies);
        for (RequestId requestId : executableRequests) {
            triggerablesWithNoResolvers.forEach(depName -> {
                commandsByDependency.computeIfAbsent((String)depName, _k -> new LinkedHashMap()).put(Set.of(requestId), ResolverCommand.multiExecuteWith((ImmutableList<Facets>)ImmutableList.of((Object)Facets.empty())));
                requestIdsByDependency.computeIfAbsent((String)depName, _k -> new LinkedHashSet()).add(requestId);
            });
            Facets facets = this.getInputsFor(dependantChain, requestId, boundFromFacets);
            multiResolverOpt.map(LogicDefinition::logic).map(logic -> logic.resolve(resolutionRequests, facets)).orElse(ImmutableMap.of()).forEach((depName, resolverCommand) -> {
                commandsByDependency.computeIfAbsent((String)depName, _k -> new LinkedHashMap()).put(Set.of(requestId), resolverCommand);
                requestIdsByDependency.computeIfAbsent((String)depName, _k -> new LinkedHashSet()).add(requestId);
            });
        }
        for (Map.Entry entry : commandsByDependency.entrySet()) {
            String depName3 = (String)entry.getKey();
            Map resolverCommandsForDep = (Map)entry.getValue();
            this.triggerDependency(depName3, dependantChain, resolverCommandsForDep, requestIdsByDependency.getOrDefault(depName3, Set.of()));
        }
    }

    private @UnknownKeyFor @NonNull @Initialized ForwardBatch getForwardCommand(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        ForwardBatch forwardBatch = this.inputsValueCollector.get(dependantChain);
        if (forwardBatch == null) {
            throw new IllegalArgumentException("Missing Forward command. This should not be possible.");
        }
        return forwardBatch;
    }

    private void triggerDependency(@UnknownKeyFor @NonNull @Initialized String depName, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId>, @UnknownKeyFor @NonNull @Initialized ResolverCommand> resolverCommandsByReq, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId> allRequestIds) {
        if (this.executedDependencies.getOrDefault(dependantChain, Set.of()).contains(depName)) {
            return;
        }
        KryonId depKryonId = (KryonId)this.kryonDefinition.dependencyKryons().get((Object)depName);
        if (depKryonId == null) {
            throw new AssertionError((Object)"Could not find kryon mapped to dependency name %s in kryon %s.\nThis should not happen and is mostly a bug in the framework.\n".formatted(depName, this.kryonId));
        }
        LinkedHashMap<RequestId, Facets> inputsByDepReq = new LinkedHashMap<RequestId, Facets>();
        LinkedHashMap<RequestId, String> skipReasonsByReq = new LinkedHashMap<RequestId, String>();
        LinkedHashMap<RequestId, Set> depReqsByIncomingReq = new LinkedHashMap<RequestId, Set>();
        for (Map.Entry<Set<RequestId>, ResolverCommand> entry : resolverCommandsByReq.entrySet()) {
            Set<RequestId> incomingReqIds = entry.getKey();
            ResolverCommand resolverCommand = entry.getValue();
            if (resolverCommand instanceof ResolverCommand.SkipDependency) {
                ResolverCommand.SkipDependency skipDependency = (ResolverCommand.SkipDependency)resolverCommand;
                RequestId depReqId = this.requestIdGenerator.newSubRequest(incomingReqIds.iterator().next(), () -> "%s[skip]".formatted(depName));
                incomingReqIds.forEach(incomingReqId -> depReqsByIncomingReq.computeIfAbsent((RequestId)incomingReqId, _k -> new LinkedHashSet()).add(depReqId));
                skipReasonsByReq.put(depReqId, skipDependency.reason());
                continue;
            }
            int count = 0;
            for (RequestId incomingReqId2 : incomingReqIds) {
                if (resolverCommand.getInputs().isEmpty()) {
                    RequestId depReqId = this.requestIdGenerator.newSubRequest(incomingReqId2, () -> "%s[skip]".formatted(depName));
                    skipReasonsByReq.put(depReqId, "Resolvers for dependency %s resolved to empty list".formatted(depName));
                    continue;
                }
                for (Facets facets : resolverCommand.getInputs()) {
                    int currentCount = count++;
                    RequestId depReqId = this.requestIdGenerator.newSubRequest(incomingReqId2, () -> "%s[%s]".formatted(depName, currentCount));
                    depReqsByIncomingReq.computeIfAbsent(incomingReqId2, _k -> new LinkedHashSet()).add(depReqId);
                    inputsByDepReq.put(depReqId, facets);
                }
            }
        }
        this.executedDependencies.computeIfAbsent(dependantChain, _k -> new LinkedHashSet()).add(depName);
        if (log.isDebugEnabled()) {
            skipReasonsByReq.forEach((execId, reason) -> log.debug("Exec Ids: {}. Dependency {} of {} will be skipped due to reason {}", new Object[]{execId, depName, this.kryonId, reason}));
        }
        CompletableFuture depResponse = this.kryonExecutor.executeCommand(new ForwardBatch(depKryonId, Collections.unmodifiableMap(inputsByDepReq), dependantChain.extend(this.kryonId, depName), Collections.unmodifiableMap(skipReasonsByReq)));
        depResponse.whenComplete((batchResponse, throwable) -> {
            LinkedHashMap<RequestId, Results> results = new LinkedHashMap<RequestId, Results>();
            for (RequestId requestId : allRequestIds) {
                if (throwable != null) {
                    results.put(requestId, new Results((Map)ImmutableMap.of((Object)Facets.empty(), (Object)Errable.withError((Throwable)throwable))));
                    continue;
                }
                Set depReqIds = depReqsByIncomingReq.getOrDefault(requestId, Set.of());
                LinkedHashMap<Facets, Errable<Object>> resultsByFacets = new LinkedHashMap<Facets, Errable<Object>>();
                for (RequestId depReqId : depReqIds) {
                    resultsByFacets.put(inputsByDepReq.getOrDefault(depReqId, Facets.empty()), batchResponse.responses().getOrDefault(depReqId, (Errable<Object>)Errable.empty()));
                }
                results.put(requestId, new Results(Collections.unmodifiableMap(resultsByFacets)));
            }
            KryonUtils.enqueueOrExecuteCommand(() -> new CallbackBatch(this.kryonId, depName, Collections.unmodifiableMap(results), dependantChain), depKryonId, this.kryonDefinition, this.kryonExecutor);
        });
        if (log.isDebugEnabled()) {
            for (int timeout : List.of(Integer.valueOf(5), Integer.valueOf(10), Integer.valueOf(15))) {
                depResponse.copy().orTimeout(timeout, TimeUnit.SECONDS).whenComplete((_r, throwable) -> {
                    if (throwable instanceof TimeoutException) {
                        log.debug("KryonId: {}, Dependency: {} on: {} with depChain: {}. Status: Waiting since {} {}", new Object[]{this.kryonId, depName, depKryonId, dependantChain, timeout, TimeUnit.SECONDS});
                    }
                });
            }
        }
    }

    private void executeOutputLogicIfPossible(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        if (this.outputLogicExecuted.getOrDefault(dependantChain, false).booleanValue()) {
            return;
        }
        CompletableFuture<Object> outputLogicResult = null;
        ForwardBatch forwardCommand = this.getForwardCommand(dependantChain);
        if (forwardCommand.shouldSkip()) {
            outputLogicResult = CompletableFuture.failedFuture((Throwable)SkippedExecutionException.SKIPPED_EXECUTION_EXCEPTION);
        } else if (this.outputLogicPendingFacets.getOrDefault(dependantChain, (Set<String>)ImmutableSet.of()).isEmpty()) {
            outputLogicResult = this.executeOutputLogic(Collections.unmodifiableSet(forwardCommand.executableRequests().keySet()), dependantChain);
        }
        if (outputLogicResult != null) {
            this.outputLogicExecuted.put(dependantChain, true);
            this.flushDecoratorsIfNeeded(dependantChain);
            Futures.linkFutures(outputLogicResult, (CompletableFuture)this.resultsByDepChain.computeIfAbsent(dependantChain, r -> new CompletableFuture()));
        }
    }

    private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse> executeOutputLogic(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId> requestIds, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        OutputLogicDefinition<Object> outputLogicDefinition = this.kryonDefinition.getOutputLogicDefinition();
        LinkedHashMap<RequestId, OutputLogicFacets> outputLogicInputs = new LinkedHashMap<RequestId, OutputLogicFacets>();
        for (RequestId requestId : requestIds) {
            outputLogicInputs.put(requestId, this.getFacetsForOutputLogic(dependantChain, requestId));
        }
        CompletableFuture<BatchResponse> resultForBatch = new CompletableFuture<BatchResponse>();
        Map<RequestId, CompletableFuture<Errable<Object>>> resultFutures = this.executeDecoratedOutputLogic(outputLogicDefinition, outputLogicInputs, dependantChain);
        CompletableFuture.allOf((CompletableFuture[])resultFutures.values().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> {
            LinkedHashMap<RequestId, Errable> responses = new LinkedHashMap<RequestId, Errable>();
            for (RequestId requestId : outputLogicInputs.keySet()) {
                CompletableFuture<Errable> resultFuture = resultFutures.getOrDefault(requestId, new CompletableFuture());
                responses.put(requestId, resultFuture.getNow(Errable.empty()));
            }
            resultForBatch.complete(new BatchResponse(Collections.unmodifiableMap(responses)));
        });
        return resultForBatch;
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized Errable<@UnknownKeyFor @NonNull @Initialized Object>>> executeDecoratedOutputLogic(@UnknownKeyFor @NonNull @Initialized OutputLogicDefinition<@UnknownKeyFor @NonNull @Initialized Object> outputLogicDefinition, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized OutputLogicFacets> inputs, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        NavigableSet<OutputLogicDecorator> sortedDecorators = this.getSortedDecorators(dependantChain);
        OutputLogic logic = outputLogicDefinition::execute;
        for (OutputLogicDecorator outputLogicDecorator : sortedDecorators) {
            logic = outputLogicDecorator.decorateLogic(logic, outputLogicDefinition);
        }
        OutputLogic finalLogic = logic;
        LinkedHashMap<RequestId, CompletableFuture<Errable<Object>>> resultsByRequest = new LinkedHashMap<RequestId, CompletableFuture<Errable<Object>>>();
        inputs.forEach((requestId, outputLogicFacets) -> {
            CompletableFuture result;
            try {
                result = (CompletableFuture)finalLogic.execute((ImmutableList<Facets>)ImmutableList.of((Object)outputLogicFacets.allFacets())).values().iterator().next();
            }
            catch (Throwable e) {
                result = CompletableFuture.failedFuture(e);
            }
            resultsByRequest.put((RequestId)requestId, (CompletableFuture<Errable<Object>>)result.handle(Errable::errableFrom));
        });
        return resultsByRequest;
    }

    private void flushDecoratorsIfNeeded(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        block6: {
            block5: {
                if (!this.kryonDefinition.getOutputLogicDefinition().doDecoratorsNeedFlushing()) {
                    return;
                }
                if (this.outputLogicExecuted.getOrDefault(dependantChain, false).booleanValue()) break block5;
                if (!this.getForwardCommand(dependantChain).shouldSkip()) break block6;
            }
            Iterable reverseSortedDecorators = this.getSortedDecorators(dependantChain)::descendingIterator;
            for (OutputLogicDecorator decorator : reverseSortedDecorators) {
                decorator.executeCommand(new FlushCommand(dependantChain));
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Facets getInputsFor(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> boundFrom) {
        Facets resolvableInputs = Optional.ofNullable(this.inputsValueCollector.get(dependantChain)).map(ForwardBatch::executableRequests).map(inputsByRequest -> (Facets)inputsByRequest.get(requestId)).orElse(Facets.empty());
        Map depValues = this.dependencyValuesCollector.getOrDefault(dependantChain, Map.of());
        LinkedHashMap<String, FacetValue> inputValues = new LinkedHashMap<String, FacetValue>();
        for (String boundFromInput : boundFrom) {
            FacetValue voe = (FacetValue)resolvableInputs.values().get((Object)boundFromInput);
            if (voe == null) {
                CallbackBatch callbackBatch = (CallbackBatch)depValues.get(boundFromInput);
                if (callbackBatch == null) continue;
                inputValues.put(boundFromInput, (FacetValue)callbackBatch.resultsByRequest().getOrDefault(requestId, (Results<Object>)Results.empty()));
                continue;
            }
            inputValues.put(boundFromInput, voe);
        }
        return new Facets(inputValues);
    }

    private @UnknownKeyFor @NonNull @Initialized OutputLogicFacets getFacetsForOutputLogic(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized RequestId requestId) {
        ForwardBatch forwardBatch = this.inputsValueCollector.get(dependantChain);
        if (forwardBatch == null) {
            throw new AssertionError((Object)"Could not find forwardBatch. This is a bug.");
        }
        ImmutableMap depValues = (ImmutableMap)this.dependencyValuesCollector.getOrDefault(dependantChain, (Map<String, CallbackBatch>)ImmutableMap.of()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((CallbackBatch)e.getValue()).resultsByRequest().getOrDefault(requestId, (Results<Object>)Results.empty())));
        Facets inputValues = forwardBatch.executableRequests().getOrDefault(requestId, Facets.empty());
        Facets allFacets = Facets.union((Map)depValues, (Map)inputValues.values());
        return new OutputLogicFacets(inputValues, allFacets);
    }

    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> collectInputValues(@UnknownKeyFor @NonNull @Initialized ForwardBatch forwardBatch) {
        if (this.requestsByDependantChain.putIfAbsent(forwardBatch.dependantChain(), forwardBatch.requestIds()) != null) {
            throw new DuplicateRequestException("Duplicate batch request received for dependant chain %s".formatted(forwardBatch.dependantChain()));
        }
        ImmutableSet<String> givenFacets = this.kryonDefinition.givenFacets();
        if (this.inputsValueCollector.putIfAbsent(forwardBatch.dependantChain(), forwardBatch) != null) {
            throw new DuplicateRequestException("Duplicate data for inputs %s of kryon %s in dependant chain %s".formatted(givenFacets, this.kryonId, forwardBatch.dependantChain()));
        }
        this.outputLogicPendingFacets.put(forwardBatch.dependantChain(), new HashSet<String>((Collection<String>)this.kryonDefinition.facetsByType(FacetType.DEPENDENCY)));
        HashSet<String> triggerableDependencies = new HashSet<String>();
        for (String depName : this.kryonDefinition.dependencyKryons().keySet()) {
            HashSet pendingFacets = new HashSet((Collection)this.kryonDefinition.dependencyToBoundFacetsMapping().getOrDefault((Object)depName, (Object)ImmutableSet.of()));
            if (pendingFacets.isEmpty()) {
                triggerableDependencies.add(depName);
                continue;
            }
            this.dependencyToPendingFacets.computeIfAbsent(forwardBatch.dependantChain(), _k -> new HashMap()).put(depName, pendingFacets);
        }
        for (String incomingFacet : this.kryonDefinition.givenFacets()) {
            triggerableDependencies.addAll(this.getTriggerableDependencies(forwardBatch.dependantChain(), incomingFacet));
        }
        return Collections.unmodifiableSet(triggerableDependencies);
    }

    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> collectDependencyValues(@UnknownKeyFor @NonNull @Initialized CallbackBatch callbackBatch) {
        String incomingFacet = callbackBatch.dependencyName();
        if (this.dependencyValuesCollector.computeIfAbsent(callbackBatch.dependantChain(), k -> new LinkedHashMap()).putIfAbsent(incomingFacet, callbackBatch) != null) {
            throw new DuplicateRequestException("Duplicate data for dependency %s of kryon %s in dependant chain %s".formatted(incomingFacet, this.kryonId, callbackBatch.dependantChain()));
        }
        this.outputLogicPendingFacets.computeIfAbsent(callbackBatch.dependantChain(), _k -> new HashSet()).remove(incomingFacet);
        return this.getTriggerableDependencies(callbackBatch.dependantChain(), incomingFacet);
    }

    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTriggerableDependencies(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized String incomingFacet) {
        ImmutableSet depsByBoundFacet = (ImmutableSet)this.kryonDefinition.dependenciesByBoundFacet().getOrDefault((Object)incomingFacet, (Object)ImmutableSet.of());
        HashSet<String> triggerableDependencies = new HashSet<String>();
        for (String depName : depsByBoundFacet) {
            Set pendingFacets = (Set)this.dependencyToPendingFacets.computeIfAbsent(dependantChain, _k -> new HashMap()).get(depName);
            if (pendingFacets != null) {
                pendingFacets.remove(incomingFacet);
            }
            if (pendingFacets != null && !pendingFacets.isEmpty()) continue;
            triggerableDependencies.add(depName);
        }
        return Collections.unmodifiableSet(triggerableDependencies);
    }
}

