/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.krystex.LogicDefinition;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecoratorConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class OutputLogicDefinition<@UnknownKeyFor T>
extends LogicDefinition<OutputLogic<T>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(OutputLogicDefinition.class);
    private @MonotonicNonNull @UnknownKeyFor @Initialized Boolean decoratorsNeedFlushing;
    private @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OutputLogicDecoratorConfig>> requestScopedLogicDecoratorConfigs = ImmutableMap.of();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized OutputLogicDecoratorConfig> sessionScopedLogicDecoratorConfigs = new HashMap<String, OutputLogicDecoratorConfig>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized OutputLogicDecorator>> sessionScopedDecorators = new LinkedHashMap<String, Map<String, OutputLogicDecorator>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KryonId, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized OutputLogicDecorator>> sessionScopedDecoratorsByKryon = new HashMap<KryonId, ImmutableMap<String, OutputLogicDecorator>>();

    protected OutputLogicDefinition(@UnknownKeyFor @NonNull @Initialized KryonLogicId kryonLogicId, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> inputs, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Tag> logicTags, @UnknownKeyFor @NonNull @Initialized OutputLogic<T> outputLogic) {
        super(kryonLogicId, inputs, logicTags, outputLogic);
    }

    public final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Facets, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable T>> execute(@UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized Facets> inputs) {
        return ((OutputLogic)this.logic()).execute(inputs);
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized OutputLogicDecorator> getSessionScopedLogicDecorators(@UnknownKeyFor @NonNull @Initialized KryonDefinition kryonDefinition, @UnknownKeyFor @NonNull @Initialized DependantChain dependants) {
        return this.sessionScopedDecoratorsByKryon.computeIfAbsent(kryonDefinition.kryonId(), _k -> {
            LinkedHashMap decorators = new LinkedHashMap();
            this.sessionScopedLogicDecoratorConfigs.forEach((s, decoratorConfig) -> {
                try {
                    LogicExecutionContext logicExecutionContext = new LogicExecutionContext(kryonDefinition.kryonId(), this.logicTags(), dependants, kryonDefinition.kryonDefinitionRegistry());
                    String instanceId = decoratorConfig.instanceIdGenerator().apply(logicExecutionContext);
                    if (decoratorConfig.shouldDecorate().test(logicExecutionContext)) {
                        decorators.put(s, this.sessionScopedDecorators.computeIfAbsent((String)s, k -> new LinkedHashMap()).computeIfAbsent(instanceId, k -> decoratorConfig.factory().apply(new OutputLogicDecoratorConfig.LogicDecoratorContext(instanceId, logicExecutionContext))));
                    }
                }
                catch (Exception e) {
                    log.error("Error in getSessionScopedLogicDecorators for decorator : {} and config : {}", new Object[]{s, decoratorConfig, e});
                }
            });
            return ImmutableMap.copyOf(decorators);
        });
    }

    public @UnknownKeyFor @NonNull @Initialized boolean doDecoratorsNeedFlushing() {
        if (this.decoratorsNeedFlushing == null) {
            block0: for (List list : this.requestScopedLogicDecoratorConfigs.values()) {
                for (OutputLogicDecoratorConfig outputLogicDecoratorConfig : list) {
                    if (!outputLogicDecoratorConfig.enableFlushing()) continue;
                    this.decoratorsNeedFlushing = true;
                    continue block0;
                }
            }
            if (this.decoratorsNeedFlushing == null) {
                for (OutputLogicDecoratorConfig outputLogicDecoratorConfig : this.sessionScopedLogicDecoratorConfigs.values()) {
                    if (!outputLogicDecoratorConfig.enableFlushing()) continue;
                    this.decoratorsNeedFlushing = true;
                    break;
                }
            }
            if (this.decoratorsNeedFlushing == null) {
                this.decoratorsNeedFlushing = false;
            }
        }
        return this.decoratorsNeedFlushing;
    }

    public void registerRequestScopedDecorator(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized OutputLogicDecoratorConfig> decoratorConfigs) {
        this.requestScopedLogicDecoratorConfigs = ImmutableMap.builderWithExpectedSize((int)(this.requestScopedLogicDecoratorConfigs.size() + decoratorConfigs.size())).putAll(this.requestScopedLogicDecoratorConfigs).putAll(this.getDecoratorConfigMap(decoratorConfigs)).build();
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OutputLogicDecoratorConfig>> getDecoratorConfigMap(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized OutputLogicDecoratorConfig> decoratorConfigs) {
        HashMap<String, List<OutputLogicDecoratorConfig>> decoratorConfigMap = new HashMap<String, List<OutputLogicDecoratorConfig>>();
        for (OutputLogicDecoratorConfig outputLogicDecoratorConfig : decoratorConfigs) {
            decoratorConfigMap.putIfAbsent(outputLogicDecoratorConfig.decoratorType(), new ArrayList());
            ((List)decoratorConfigMap.get(outputLogicDecoratorConfig.decoratorType())).add(outputLogicDecoratorConfig);
        }
        return decoratorConfigMap;
    }

    public void registerSessionScopedLogicDecorator(@UnknownKeyFor @NonNull @Initialized OutputLogicDecoratorConfig decoratorConfig) {
        this.sessionScopedLogicDecoratorConfigs.put(decoratorConfig.decoratorType(), decoratorConfig);
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OutputLogicDecoratorConfig>> getRequestScopedLogicDecoratorConfigs() {
        return this.requestScopedLogicDecoratorConfigs;
    }
}

