/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.commands.CallbackGranule;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardGranule;
import com.flipkart.krystal.krystex.commands.GranularCommand;
import com.flipkart.krystal.krystex.commands.SkipGranule;
import com.flipkart.krystal.krystex.kryon.AbstractKryon;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.kryon.DuplicateRequestException;
import com.flipkart.krystal.krystex.kryon.GranuleResponse;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.kryon.KryonUtils;
import com.flipkart.krystal.krystex.kryon.OutputLogicFacets;
import com.flipkart.krystal.krystex.logicdecoration.FlushCommand;
import com.flipkart.krystal.krystex.logicdecoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.krystex.request.StringReqGenerator;
import com.flipkart.krystal.krystex.resolution.DependencyResolutionRequest;
import com.flipkart.krystal.krystex.resolution.MultiResolver;
import com.flipkart.krystal.krystex.resolution.MultiResolverDefinition;
import com.flipkart.krystal.krystex.resolution.ResolverCommand;
import com.flipkart.krystal.krystex.resolution.ResolverDefinition;
import com.flipkart.krystal.utils.SkippedExecutionException;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class GranularKryon
extends AbstractKryon<GranularCommand, GranuleResponse> {
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DependencyKryonExecutions>> dependencyExecutions = new LinkedHashMap<RequestId, Map<String, DependencyKryonExecutions>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FacetValue<@UnknownKeyFor @NonNull @Initialized Object>>> inputsValueCollector = new LinkedHashMap<RequestId, Map<String, FacetValue<Object>>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Results<@UnknownKeyFor @NonNull @Initialized Object>>> dependencyValuesCollector = new LinkedHashMap<RequestId, Map<String, Results<Object>>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized GranuleResponse>> resultsByRequest = new LinkedHashMap<RequestId, CompletableFuture<GranuleResponse>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Facets, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable @UnknownKeyFor @Initialized Object>> resultsCache = new LinkedHashMap<Facets, CompletableFuture<Object>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized Boolean> outputLogicExecuted = new LinkedHashMap<RequestId, Boolean>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized SkipGranule>> skipLogicRequested = new LinkedHashMap<RequestId, Optional<SkipGranule>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ResolverDefinition, @UnknownKeyFor @NonNull @Initialized ResolverCommand>> resolverResults = new LinkedHashMap<RequestId, Map<ResolverDefinition, ResolverCommand>>();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DependantChain> flushedDependantChain = new LinkedHashSet<DependantChain>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId>> requestsByDependantChain = new LinkedHashMap<DependantChain, Set<RequestId>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized DependantChain> dependantChainByRequest = new LinkedHashMap<RequestId, DependantChain>();

    GranularKryon(@UnknownKeyFor @NonNull @Initialized KryonDefinition kryonDefinition, @UnknownKeyFor @NonNull @Initialized KryonExecutor kryonExecutor, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized LogicExecutionContext, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized OutputLogicDecorator>> requestScopedDecoratorsSupplier, @UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering) {
        super(kryonDefinition, kryonExecutor, requestScopedDecoratorsSupplier, logicDecorationOrdering, new StringReqGenerator());
    }

    private static @UnknownKeyFor @NonNull @Initialized SkippedExecutionException skipKryonException(@UnknownKeyFor @NonNull @Initialized SkipGranule skip) {
        return new SkippedExecutionException(skip.skipDependencyCommand().reason());
    }

    @Override
    public void executeCommand(@UnknownKeyFor @NonNull @Initialized Flush flushCommand) {
        this.flushedDependantChain.add(flushCommand.dependantChain());
        this.flushAllDependenciesIfNeeded(flushCommand.dependantChain());
        this.flushDecoratorsIfNeeded(flushCommand.dependantChain());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized GranuleResponse> executeCommand(@UnknownKeyFor @NonNull @Initialized GranularCommand kryonCommand) {
        RequestId requestId = kryonCommand.requestId();
        CompletableFuture resultForRequest = this.resultsByRequest.computeIfAbsent(requestId, r -> new CompletableFuture());
        if (resultForRequest.isDone()) {
            return resultForRequest;
        }
        try {
            if (kryonCommand instanceof SkipGranule) {
                SkipGranule skipGranule = (SkipGranule)kryonCommand;
                this.requestsByDependantChain.computeIfAbsent(skipGranule.dependantChain(), k -> new LinkedHashSet()).add(requestId);
                this.dependantChainByRequest.put(requestId, skipGranule.dependantChain());
                this.skipLogicRequested.put(requestId, Optional.of(skipGranule));
                return this.handleSkipDependency(requestId, skipGranule, resultForRequest);
            }
            if (kryonCommand instanceof CallbackGranule) {
                CallbackGranule callbackGranule = (CallbackGranule)kryonCommand;
                this.executeWithDependency(requestId, callbackGranule);
            } else if (kryonCommand instanceof ForwardGranule) {
                ForwardGranule forwardGranule = (ForwardGranule)kryonCommand;
                this.requestsByDependantChain.computeIfAbsent(forwardGranule.dependantChain(), k -> new LinkedHashSet()).add(requestId);
                this.dependantChainByRequest.computeIfAbsent(requestId, r -> forwardGranule.dependantChain());
                this.executeWithInputs(requestId, forwardGranule);
            } else {
                throw new UnsupportedOperationException("Unknown type of kryonCommand: %s".formatted(kryonCommand));
            }
            this.executeOutputLogicIfPossible(requestId, resultForRequest);
        }
        catch (Throwable e) {
            resultForRequest.completeExceptionally(e);
        }
        return resultForRequest;
    }

    private void executeOutputLogicIfPossible(@UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized GranuleResponse> resultForRequest) {
        OutputLogicDefinition outputLogicDefinition = this.kryonDefinition.getOutputLogicDefinition();
        ImmutableSet<String> inputNames = outputLogicDefinition.inputNames();
        LinkedHashSet<String> collect = new LinkedHashSet<String>(this.inputsValueCollector.getOrDefault(requestId, (Map<String, FacetValue<Object>>)ImmutableMap.of()).keySet());
        collect.addAll(this.dependencyValuesCollector.getOrDefault(requestId, (Map<String, Results<Object>>)ImmutableMap.of()).keySet());
        if (collect.containsAll((Collection<?>)inputNames)) {
            this.executeOutputLogic(resultForRequest, requestId);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized GranuleResponse> handleSkipDependency(@UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized SkipGranule skipGranule, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized GranuleResponse> resultForRequest) {
        Set<ResolverDefinition> pendingResolvers = this.resolverDefinitionsByInput.values().stream().flatMap(Collection::stream).filter(resolverDefinition -> !this.resolverResults.computeIfAbsent(requestId, r -> new LinkedHashMap()).containsKey(resolverDefinition)).collect(Collectors.toSet());
        this.executeResolvers(requestId, pendingResolvers);
        resultForRequest.completeExceptionally((Throwable)GranularKryon.skipKryonException(skipGranule));
        return resultForRequest;
    }

    private void flushDecoratorsIfNeeded(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        if (!this.flushedDependantChain.contains(dependantChain)) {
            return;
        }
        Set<RequestId> requestIds = this.requestsByDependantChain.getOrDefault(dependantChain, (Set<RequestId>)ImmutableSet.of());
        int requestIdExecuted = 0;
        for (RequestId requestId : requestIds) {
            if (!this.outputLogicExecuted.getOrDefault(requestId, false).booleanValue() && !this.skipLogicRequested.getOrDefault(requestId, Optional.empty()).isPresent()) continue;
            ++requestIdExecuted;
        }
        if (requestIdExecuted == requestIds.size()) {
            Iterable reverseSortedDecorators = this.getSortedDecorators(dependantChain)::descendingIterator;
            for (OutputLogicDecorator decorator : reverseSortedDecorators) {
                decorator.executeCommand(new FlushCommand(dependantChain));
            }
        }
    }

    private void executeWithInputs(@UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized ForwardGranule forwardGranule) {
        this.collectInputValues(requestId, (Set<String>)forwardGranule.inputNames(), forwardGranule.values());
        this.execute(requestId, forwardGranule.inputNames());
    }

    private void executeWithDependency(@UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized CallbackGranule executeWithInput) {
        String dependencyName = executeWithInput.dependencyName();
        ImmutableSet inputNames = ImmutableSet.of((Object)dependencyName);
        if (this.dependencyValuesCollector.computeIfAbsent(requestId, k -> new LinkedHashMap()).putIfAbsent(dependencyName, executeWithInput.results()) != null) {
            throw new DuplicateRequestException("Duplicate data for dependency %s of kryon %s in request %s".formatted(dependencyName, this.kryonId, requestId));
        }
        this.execute(requestId, (ImmutableSet<String>)inputNames);
    }

    private void execute(@UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> newInputNames) {
        OutputLogicDefinition outputLogicDefinition = this.kryonDefinition.getOutputLogicDefinition();
        Map allInputs = this.inputsValueCollector.computeIfAbsent(requestId, r -> new LinkedHashMap());
        Map allDependencies = this.dependencyValuesCollector.computeIfAbsent(requestId, k -> new LinkedHashMap());
        ImmutableSet<String> allInputNames = outputLogicDefinition.inputNames();
        Sets.SetView availableInputs = Sets.union(allInputs.keySet(), allDependencies.keySet());
        if (availableInputs.isEmpty()) {
            if (!allInputNames.isEmpty() && this.kryonDefinition.resolverDefinitions().isEmpty() && !this.kryonDefinition.dependencyKryons().isEmpty()) {
                this.executeDependenciesWhenNoResolvers(requestId);
            }
            return;
        }
        this.executeResolvers(requestId, this.getPendingResolvers(requestId, newInputNames, (Set<String>)availableInputs));
    }

    private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> getPendingResolvers(@UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> newInputNames, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> availableInputs) {
        Map resolverResults = this.resolverResults.computeIfAbsent(requestId, r -> new LinkedHashMap());
        Set pendingUnboundResolvers = ((ImmutableSet)this.resolverDefinitionsByInput.getOrDefault(Optional.empty(), (Object)ImmutableSet.of())).stream().filter(resolverDefinition -> availableInputs.containsAll((Collection<?>)resolverDefinition.boundFrom())).filter(resolverDefinition -> !resolverResults.containsKey(resolverDefinition)).collect(Collectors.toSet());
        Set<ResolverDefinition> pendingResolvers = newInputNames.stream().flatMap(input -> ((ImmutableSet)this.resolverDefinitionsByInput.getOrDefault(Optional.ofNullable(input), (Object)ImmutableSet.of())).stream().filter(resolverDefinition -> availableInputs.containsAll((Collection<?>)resolverDefinition.boundFrom())).filter(resolverDefinition -> !resolverResults.containsKey(resolverDefinition))).collect(Collectors.toSet());
        pendingResolvers.addAll(pendingUnboundResolvers);
        return pendingResolvers;
    }

    private void executeResolvers(@UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> pendingResolvers) {
        Map<String, ResolverCommand> resolverCommands;
        if (pendingResolvers.isEmpty()) {
            return;
        }
        Optional<MultiResolverDefinition> multiResolverOpt = this.kryonDefinition.multiResolverLogicId().map(kryonLogicId -> this.kryonDefinition.kryonDefinitionRegistry().logicDefinitionRegistry().getMultiResolver((KryonLogicId)kryonLogicId));
        if (multiResolverOpt.isEmpty()) {
            return;
        }
        MultiResolverDefinition multiResolver = multiResolverOpt.get();
        Map resolversByDependency = pendingResolvers.stream().collect(Collectors.groupingBy(ResolverDefinition::dependencyName, Collectors.toSet()));
        Optional skipRequested = this.skipLogicRequested.getOrDefault(requestId, Optional.empty());
        if (skipRequested.isPresent()) {
            ResolverCommand.SkipDependency skip = ResolverCommand.skip(((SkipGranule)skipRequested.get()).skipDependencyCommand().reason());
            resolverCommands = resolversByDependency.keySet().stream().collect(Collectors.toMap(Functions.identity(), _k -> skip));
        } else {
            Facets facets = this.getInputsFor(requestId, pendingResolvers.stream().map(ResolverDefinition::boundFrom).flatMap(Collection::stream).collect(Collectors.toSet()));
            resolverCommands = ((MultiResolver)multiResolver.logic()).resolve(resolversByDependency.entrySet().stream().map(e -> new DependencyResolutionRequest((String)e.getKey(), (Set)e.getValue())).toList(), facets);
        }
        resolverCommands.forEach((depName, resolverCommand) -> this.handleResolverCommand(requestId, (String)depName, (Set)resolversByDependency.getOrDefault(depName, ImmutableSet.of()), (ResolverCommand)resolverCommand));
    }

    private void handleResolverCommand(@UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized String dependencyName, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> resolverDefinitions, @UnknownKeyFor @NonNull @Initialized ResolverCommand resolverCommand) {
        ImmutableSet resolverDefinitionsForDependency;
        KryonId depKryonId = this.getDepKryonId(dependencyName);
        Map resolverResults = this.resolverResults.computeIfAbsent(requestId, r -> new LinkedHashMap());
        resolverDefinitions.forEach(resolverDefinition -> resolverResults.put(resolverDefinition, resolverCommand));
        DependencyKryonExecutions dependencyKryonExecutions = this.dependencyExecutions.computeIfAbsent(requestId, k -> new LinkedHashMap()).computeIfAbsent(dependencyName, k -> new DependencyKryonExecutions());
        dependencyKryonExecutions.executedResolvers().addAll(resolverDefinitions);
        if (resolverCommand instanceof ResolverCommand.SkipDependency) {
            if (this.dependencyValuesCollector.getOrDefault(requestId, (Map<String, Results<Object>>)ImmutableMap.of()).get(dependencyName) == null) {
                HashSet<RequestId> requestIdSet = new HashSet<RequestId>(dependencyKryonExecutions.individualCallResponses().keySet());
                RequestId dependencyRequestId = this.requestIdGenerator.newSubRequest(requestId, () -> "%s[%s]".formatted(dependencyName, 0));
                requestIdSet.add(dependencyRequestId);
                for (RequestId depRequestId : requestIdSet) {
                    SkipGranule skipGranule = new SkipGranule(depKryonId, depRequestId, this.dependantChainByRequest.getOrDefault(requestId, this.kryonDefinition.kryonDefinitionRegistry().getDependantChainsStart()).extend(this.kryonId, dependencyName), (ResolverCommand.SkipDependency)resolverCommand);
                    dependencyKryonExecutions.individualCallResponses().putIfAbsent(depRequestId, this.kryonExecutor.executeCommand(skipGranule));
                }
            }
        } else {
            ImmutableList<Facets> inputList = resolverCommand.getInputs();
            long executionsInProgress = dependencyKryonExecutions.executionCounter().longValue();
            LinkedHashMap<RequestId, Facets> oldInputs = new LinkedHashMap<RequestId, Facets>();
            int i = 0;
            while ((long)i < executionsInProgress) {
                int iFinal = i++;
                RequestId rid = this.requestIdGenerator.newSubRequest(requestId, () -> "%s[%s]".formatted(dependencyName, iFinal));
                oldInputs.put(rid, new Facets((Map)dependencyKryonExecutions.individualCallInputs().getOrDefault(rid, Facets.empty()).values()));
            }
            long batchSize = Math.max(executionsInProgress, 1L);
            long requestCounter = 0L;
            for (int j = 0; j < inputList.size(); ++j) {
                int jFinal = j;
                Facets facets = (Facets)inputList.get(j);
                int i2 = 0;
                while ((long)i2 < batchSize) {
                    int iFinal = i2;
                    RequestId dependencyRequestId = this.requestIdGenerator.newSubRequest(requestId, () -> "%s[%s]".formatted(dependencyName, (long)jFinal * batchSize + (long)iFinal));
                    RequestId inProgressRequestId = executionsInProgress > 0L ? this.requestIdGenerator.newSubRequest(requestId, () -> "%s[%s]".formatted(dependencyName, iFinal)) : dependencyRequestId;
                    Facets oldInput = oldInputs.getOrDefault(inProgressRequestId, Facets.empty());
                    if (requestCounter >= executionsInProgress) {
                        dependencyKryonExecutions.executionCounter().increment();
                    }
                    Facets newFacets = j == 0 ? facets : Facets.union((Map)oldInput.values(), (Map)facets.values());
                    dependencyKryonExecutions.individualCallInputs().put(dependencyRequestId, newFacets);
                    dependencyKryonExecutions.individualCallResponses().putIfAbsent(dependencyRequestId, this.kryonExecutor.executeCommand(new ForwardGranule(depKryonId, (ImmutableSet<String>)newFacets.values().keySet(), newFacets, this.dependantChainByRequest.getOrDefault(requestId, this.kryonDefinition.kryonDefinitionRegistry().getDependantChainsStart()).extend(this.kryonId, dependencyName), dependencyRequestId)));
                    ++i2;
                }
                requestCounter += batchSize;
            }
        }
        if ((resolverDefinitionsForDependency = (ImmutableSet)this.resolverDefinitionsByDependencies.getOrDefault((Object)dependencyName, (Object)ImmutableSet.of())).equals(dependencyKryonExecutions.executedResolvers())) {
            CompletableFuture.allOf((CompletableFuture[])dependencyKryonExecutions.individualCallResponses().values().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> KryonUtils.enqueueOrExecuteCommand(() -> {
                Results results = throwable != null ? new Results(ImmutableMap.of((Object)Facets.empty(), (Object)Errable.withError((Throwable)throwable))) : new Results((ImmutableMap)dependencyKryonExecutions.individualCallResponses().values().stream().map(cf -> cf.getNow(new GranuleResponse())).collect(ImmutableMap.toImmutableMap(GranuleResponse::facets, GranuleResponse::response)));
                return new CallbackGranule(this.kryonId, dependencyName, (Results<Object>)results, requestId, this.getDepChainFor(requestId));
            }, depKryonId, this.kryonDefinition, this.kryonExecutor));
            this.flushDependencyIfNeeded(dependencyName, this.dependantChainByRequest.getOrDefault(requestId, this.kryonDefinition.kryonDefinitionRegistry().getDependantChainsStart()));
        }
    }

    private void flushAllDependenciesIfNeeded(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        this.kryonDefinition.dependencyKryons().keySet().forEach(dependencyName -> this.flushDependencyIfNeeded((String)dependencyName, dependantChain));
    }

    private void flushDependencyIfNeeded(@UnknownKeyFor @NonNull @Initialized String dependencyName, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        if (!this.flushedDependantChain.contains(dependantChain)) {
            return;
        }
        Set<RequestId> requestsForDependantChain = this.requestsByDependantChain.getOrDefault(dependantChain, (Set<RequestId>)ImmutableSet.of());
        KryonId depKryonId = this.getDepKryonId(dependencyName);
        ImmutableSet resolverDefinitionsForDependency = (ImmutableSet)this.resolverDefinitionsByDependencies.getOrDefault((Object)dependencyName, (Object)ImmutableSet.of());
        if (!requestsForDependantChain.isEmpty() && requestsForDependantChain.stream().allMatch(requestId -> resolverDefinitionsForDependency.equals(this.dependencyExecutions.computeIfAbsent((RequestId)requestId, k -> new LinkedHashMap()).computeIfAbsent(dependencyName, k -> new DependencyKryonExecutions()).executedResolvers()))) {
            this.kryonExecutor.executeCommand(new Flush(depKryonId, dependantChain.extend(this.kryonId, dependencyName)));
        }
    }

    private @UnknownKeyFor @NonNull @Initialized KryonId getDepKryonId(@UnknownKeyFor @NonNull @Initialized String dependencyName) {
        KryonId depKryonId = (KryonId)this.kryonDefinition.dependencyKryons().get((Object)dependencyName);
        if (depKryonId == null) {
            throw new AssertionError((Object)"This is a bug");
        }
        return depKryonId;
    }

    private @UnknownKeyFor @NonNull @Initialized Facets getInputsFor(@UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> boundFrom) {
        Map allInputs = this.inputsValueCollector.computeIfAbsent(requestId, r -> new LinkedHashMap());
        LinkedHashMap<String, FacetValue> inputValues = new LinkedHashMap<String, FacetValue>();
        for (String boundFromInput : boundFrom) {
            FacetValue voe = (FacetValue)allInputs.get(boundFromInput);
            if (voe == null) {
                inputValues.put(boundFromInput, (FacetValue)this.dependencyValuesCollector.computeIfAbsent(requestId, k -> new LinkedHashMap()).getOrDefault(boundFromInput, Results.empty()));
                continue;
            }
            inputValues.put(boundFromInput, voe);
        }
        return new Facets(inputValues);
    }

    private void executeDependenciesWhenNoResolvers(@UnknownKeyFor @NonNull @Initialized RequestId requestId) {
        this.kryonDefinition.dependencyKryons().forEach((depName, depKryonId) -> {
            if (!this.dependencyValuesCollector.getOrDefault(requestId, (Map<String, Results<Object>>)ImmutableMap.of()).containsKey(depName)) {
                RequestId dependencyRequestId = this.requestIdGenerator.newSubRequest(requestId, () -> "%s".formatted(depName));
                CompletableFuture kryonResponse = this.kryonExecutor.executeCommand(new ForwardGranule((KryonId)depKryonId, (ImmutableSet<String>)ImmutableSet.of(), Facets.empty(), this.getDepChainFor(requestId).extend(this.kryonId, (String)depName), dependencyRequestId));
                ((CompletableFuture)kryonResponse.thenApply(GranuleResponse::response)).whenComplete((response, throwable) -> KryonUtils.enqueueOrExecuteCommand(() -> {
                    Errable errable = response;
                    if (throwable != null) {
                        errable = Errable.withError((Throwable)throwable);
                    }
                    return new CallbackGranule(this.kryonId, (String)depName, (Results<Object>)new Results(ImmutableMap.of((Object)Facets.empty(), (Object)errable)), requestId, this.getDepChainFor(requestId));
                }, depKryonId, this.kryonDefinition, this.kryonExecutor));
            }
        });
    }

    private void executeOutputLogic(@UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized GranuleResponse> resultForRequest, @UnknownKeyFor @NonNull @Initialized RequestId requestId) {
        OutputLogicDefinition<Object> outputLogicDefinition = this.kryonDefinition.getOutputLogicDefinition();
        OutputLogicFacets outputLogicFacets = this.getInputsForOutputLogic(requestId);
        CompletableFuture<@Nullable Object> resultFuture = this.resultsCache.get(outputLogicFacets.providedFacets());
        if (resultFuture == null) {
            resultFuture = this.executeDecoratedOutputLogic(outputLogicFacets.allFacets(), outputLogicDefinition, requestId);
            this.resultsCache.put(outputLogicFacets.providedFacets(), resultFuture);
        }
        ((CompletableFuture)resultFuture.handle(Errable::valueOrError)).thenAccept(value -> resultForRequest.complete(new GranuleResponse(outputLogicFacets.providedFacets(), (Errable<Object>)value)));
        this.outputLogicExecuted.put(requestId, true);
        this.flushDecoratorsIfNeeded(this.getDepChainFor(requestId));
    }

    private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable @UnknownKeyFor @Initialized Object> executeDecoratedOutputLogic(@UnknownKeyFor @NonNull @Initialized Facets facets, @UnknownKeyFor @NonNull @Initialized OutputLogicDefinition<@UnknownKeyFor @NonNull @Initialized Object> outputLogicDefinition, @UnknownKeyFor @NonNull @Initialized RequestId requestId) {
        NavigableSet<OutputLogicDecorator> sortedDecorators = this.getSortedDecorators(this.getDepChainFor(requestId));
        OutputLogic logic = outputLogicDefinition::execute;
        for (OutputLogicDecorator outputLogicDecorator : sortedDecorators) {
            logic = outputLogicDecorator.decorateLogic(logic, outputLogicDefinition);
        }
        return Optional.ofNullable((CompletableFuture)logic.execute((ImmutableList<Facets>)ImmutableList.of((Object)facets)).get((Object)facets)).orElseThrow(() -> new IllegalStateException("Output logic " + outputLogicDefinition.kryonLogicId() + " did not return a future for inputs " + facets));
    }

    private @UnknownKeyFor @NonNull @Initialized DependantChain getDepChainFor(@UnknownKeyFor @NonNull @Initialized RequestId requestId) {
        return Optional.ofNullable(this.dependantChainByRequest.get(requestId)).orElseThrow(() -> new AssertionError((Object)"This is a bug"));
    }

    private @UnknownKeyFor @NonNull @Initialized OutputLogicFacets getInputsForOutputLogic(@UnknownKeyFor @NonNull @Initialized RequestId requestId) {
        Facets inputValues = new Facets(this.inputsValueCollector.getOrDefault(requestId, (Map<String, FacetValue<Object>>)ImmutableMap.of()));
        Map<String, Results<Object>> dependencyValues = this.dependencyValuesCollector.getOrDefault(requestId, (Map<String, Results<Object>>)ImmutableMap.of());
        Facets allFacets = Facets.union(dependencyValues, (Map)inputValues.values());
        return new OutputLogicFacets(inputValues, allFacets);
    }

    private void collectInputValues(@UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> inputNames, @UnknownKeyFor @NonNull @Initialized Facets facets) {
        for (String inputName : inputNames) {
            if (this.inputsValueCollector.computeIfAbsent(requestId, r -> new LinkedHashMap()).putIfAbsent(inputName, facets.getInputValue(inputName)) == null) continue;
            throw new DuplicateRequestException("Duplicate data for inputs %s of kryon %s in request %s".formatted(inputNames, this.kryonId, requestId));
        }
    }

    private record DependencyKryonExecutions(@UnknownKeyFor @NonNull @Initialized LongAdder executionCounter, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> executedResolvers, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized Facets> individualCallInputs, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized GranuleResponse>> individualCallResponses) {
        private DependencyKryonExecutions() {
            this(new LongAdder(), new LinkedHashSet<ResolverDefinition>(), new LinkedHashMap<RequestId, Facets>(), new LinkedHashMap<RequestId, CompletableFuture<GranuleResponse>>());
        }
    }
}

