/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.LogicDefinition;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.commands.BatchCommand;
import com.flipkart.krystal.krystex.commands.CallbackBatch;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardBatch;
import com.flipkart.krystal.krystex.kryon.AbstractKryon;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.kryon.DuplicateRequestException;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.kryon.KryonUtils;
import com.flipkart.krystal.krystex.kryon.OutputLogicInputs;
import com.flipkart.krystal.krystex.logicdecoration.FlushCommand;
import com.flipkart.krystal.krystex.logicdecoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.krystex.request.RequestIdGenerator;
import com.flipkart.krystal.krystex.resolution.DependencyResolutionRequest;
import com.flipkart.krystal.krystex.resolution.MultiResolverDefinition;
import com.flipkart.krystal.krystex.resolution.ResolverCommand;
import com.flipkart.krystal.krystex.resolution.ResolverDefinition;
import com.flipkart.krystal.utils.Futures;
import com.flipkart.krystal.utils.SkippedExecutionException;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class BatchKryon
extends AbstractKryon<BatchCommand, BatchResponse> {
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> availableInputsByDepChain = new LinkedHashMap<DependantChain, Set<String>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized ForwardBatch> inputsValueCollector = new LinkedHashMap<DependantChain, ForwardBatch>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CallbackBatch>> dependencyValuesCollector = new LinkedHashMap<DependantChain, Map<String, CallbackBatch>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse>> resultsByDepChain = new LinkedHashMap<DependantChain, CompletableFuture<BatchResponse>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Inputs, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable @UnknownKeyFor @Initialized Object>> resultsCache = new LinkedHashMap<Inputs, CompletableFuture<Object>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> executedDependencies = new LinkedHashMap<DependantChain, Set<String>>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId>> requestsByDependantChain = new LinkedHashMap<DependantChain, Set<RequestId>>();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DependantChain> flushedDependantChain = new LinkedHashSet<DependantChain>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized DependantChain, @UnknownKeyFor @NonNull @Initialized Boolean> outputLogicExecuted = new LinkedHashMap<DependantChain, Boolean>();

    BatchKryon(@UnknownKeyFor @NonNull @Initialized KryonDefinition kryonDefinition, @UnknownKeyFor @NonNull @Initialized KryonExecutor kryonExecutor, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized LogicExecutionContext, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized OutputLogicDecorator>> requestScopedDecoratorsSupplier, @UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering, @UnknownKeyFor @NonNull @Initialized RequestIdGenerator requestIdGenerator) {
        super(kryonDefinition, kryonExecutor, requestScopedDecoratorsSupplier, logicDecorationOrdering, requestIdGenerator);
    }

    @Override
    public void executeCommand(@UnknownKeyFor @NonNull @Initialized Flush flushCommand) {
        this.flushedDependantChain.add(flushCommand.dependantChain());
        this.flushAllDependenciesIfNeeded(flushCommand.dependantChain());
        this.flushDecoratorsIfNeeded(flushCommand.dependantChain());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse> executeCommand(@UnknownKeyFor @NonNull @Initialized BatchCommand kryonCommand) {
        DependantChain dependantChain = kryonCommand.dependantChain();
        CompletableFuture resultForDepChain = this.resultsByDepChain.computeIfAbsent(dependantChain, r -> new CompletableFuture());
        try {
            if (kryonCommand instanceof ForwardBatch) {
                ForwardBatch forwardBatch = (ForwardBatch)kryonCommand;
                this.collectInputValues(forwardBatch);
            } else if (kryonCommand instanceof CallbackBatch) {
                CallbackBatch callbackBatch = (CallbackBatch)kryonCommand;
                this.collectDependencyValues(callbackBatch);
            }
            this.triggerDependencies(dependantChain, this.getTriggerableDependencies(dependantChain, kryonCommand.inputNames()));
            Optional<CompletableFuture<BatchResponse>> outputLogicFuture = this.executeOutputLogicIfPossible(dependantChain);
            outputLogicFuture.ifPresent(f -> Futures.linkFutures((CompletableFuture)f, (CompletableFuture)resultForDepChain));
        }
        catch (Throwable e) {
            resultForDepChain.completeExceptionally(e);
        }
        return resultForDepChain;
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> getTriggerableDependencies(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> newInputNames) {
        Set availableInputs = this.availableInputsByDepChain.getOrDefault(dependantChain, Set.of());
        Set executedDeps = this.executedDependencies.getOrDefault(dependantChain, Set.of());
        return Stream.concat(Stream.concat(Stream.of(Optional.empty()), newInputNames.stream().map(Optional::of)).map(key -> (ImmutableSet)this.resolverDefinitionsByInput.getOrDefault(key, (Object)ImmutableSet.of())).flatMap(Collection::stream).map(ResolverDefinition::dependencyName), this.dependenciesWithNoResolvers.stream()).distinct().filter(depName -> !executedDeps.contains(depName)).filter(depName -> ((ImmutableSet)this.resolverDefinitionsByDependencies.getOrDefault(depName, (Object)ImmutableSet.of())).stream().map(ResolverDefinition::boundFrom).flatMap(Collection::stream).allMatch(availableInputs::contains)).collect(Collectors.toMap(Functions.identity(), depName -> (Set)this.resolverDefinitionsByDependencies.getOrDefault(depName, (Object)ImmutableSet.of())));
    }

    private void triggerDependencies(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> triggerableDependencies) {
        ForwardBatch forwardBatch = this.getForwardCommand(dependantChain);
        Optional<MultiResolverDefinition> multiResolverOpt = this.kryonDefinition.multiResolverLogicId().map(kryonLogicId -> this.kryonDefinition.kryonDefinitionRegistry().logicDefinitionRegistry().getMultiResolver((KryonLogicId)kryonLogicId));
        ImmutableMap<RequestId, String> skippedRequests = forwardBatch.skippedRequests();
        ImmutableSet executableRequests = forwardBatch.executableRequests().keySet();
        LinkedHashMap<String, Map> commandsByDependency = new LinkedHashMap<String, Map>();
        if (!skippedRequests.isEmpty()) {
            ResolverCommand.SkipDependency skip = ResolverCommand.skip(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)skippedRequests.values()));
            for (String string : triggerableDependencies.keySet()) {
                commandsByDependency.computeIfAbsent(string, _k -> new LinkedHashMap()).put(skippedRequests.keySet(), skip);
            }
        }
        Set<String> dependenciesWithNoResolvers = triggerableDependencies.entrySet().stream().filter(e -> ((Set)e.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
        for (RequestId requestId : executableRequests) {
            dependenciesWithNoResolvers.forEach(depName -> commandsByDependency.computeIfAbsent((String)depName, _k -> new LinkedHashMap()).put(Set.of(requestId), ResolverCommand.multiExecuteWith((ImmutableList<Inputs>)ImmutableList.of((Object)Inputs.empty()))));
            Inputs inputs = this.getInputsFor(dependantChain, requestId, triggerableDependencies.values().stream().flatMap(Collection::stream).map(ResolverDefinition::boundFrom).flatMap(Collection::stream).collect(Collectors.toSet()));
            multiResolverOpt.map(LogicDefinition::logic).map(logic -> logic.resolve(triggerableDependencies.entrySet().stream().filter(e -> !((Set)e.getValue()).isEmpty()).map(e -> new DependencyResolutionRequest((String)e.getKey(), (Set)e.getValue())).toList(), inputs)).orElse(ImmutableMap.of()).forEach((depName, resolverCommand) -> commandsByDependency.computeIfAbsent((String)depName, _k -> new LinkedHashMap()).put(Set.of(requestId), resolverCommand));
        }
        for (Map.Entry entry : commandsByDependency.entrySet()) {
            String depName3 = (String)entry.getKey();
            Map resolverCommandsForDep = (Map)entry.getValue();
            this.triggerDependency(depName3, dependantChain, resolverCommandsForDep, triggerableDependencies.getOrDefault(depName3, (Set<ResolverDefinition>)ImmutableSet.of()));
        }
    }

    private @UnknownKeyFor @NonNull @Initialized ForwardBatch getForwardCommand(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        ForwardBatch forwardBatch = this.inputsValueCollector.get(dependantChain);
        if (forwardBatch == null) {
            throw new IllegalArgumentException("Missing Forward command. This should not be possible.");
        }
        return forwardBatch;
    }

    private void triggerDependency(@UnknownKeyFor @NonNull @Initialized String depName, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId>, @UnknownKeyFor @NonNull @Initialized ResolverCommand> resolverCommandsByReq, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> resolverDefinitions) {
        KryonId depKryonId = (KryonId)this.kryonDefinition.dependencyKryons().get((Object)depName);
        if (depKryonId == null) {
            throw new AssertionError((Object)"This is a bug.");
        }
        LinkedHashMap<RequestId, Inputs> inputsByDepReq = new LinkedHashMap<RequestId, Inputs>();
        LinkedHashMap<RequestId, String> skipReasonsByReq = new LinkedHashMap<RequestId, String>();
        LinkedHashMap<RequestId, Set> depReqsByIncomingReq = new LinkedHashMap<RequestId, Set>();
        for (Map.Entry<Set<RequestId>, ResolverCommand> entry : resolverCommandsByReq.entrySet()) {
            Set<RequestId> incomingReqIds = entry.getKey();
            ResolverCommand resolverCommand = entry.getValue();
            if (resolverCommand instanceof ResolverCommand.SkipDependency) {
                ResolverCommand.SkipDependency skipDependency = (ResolverCommand.SkipDependency)resolverCommand;
                RequestId depReqId = this.requestIdGenerator.newSubRequest(incomingReqIds.iterator().next(), () -> "%s[skip]".formatted(depName));
                incomingReqIds.forEach(incomingReqId -> depReqsByIncomingReq.computeIfAbsent((RequestId)incomingReqId, _k -> new LinkedHashSet()).add(depReqId));
                skipReasonsByReq.put(depReqId, skipDependency.reason());
                continue;
            }
            int count = 0;
            for (RequestId incomingReqId2 : incomingReqIds) {
                if (resolverCommand.getInputs().isEmpty()) {
                    RequestId depReqId = this.requestIdGenerator.newSubRequest(incomingReqId2, () -> "%s[skip]".formatted(depName));
                    skipReasonsByReq.put(depReqId, "Resolvers for dependency %s resolved to empty list".formatted(depName));
                    continue;
                }
                for (Inputs inputs : resolverCommand.getInputs()) {
                    int currentCount = count++;
                    RequestId depReqId = this.requestIdGenerator.newSubRequest(incomingReqId2, () -> "%s[%s]".formatted(depName, currentCount));
                    depReqsByIncomingReq.computeIfAbsent(incomingReqId2, _k -> new LinkedHashSet()).add(depReqId);
                    inputsByDepReq.put(depReqId, inputs);
                }
            }
        }
        this.executedDependencies.computeIfAbsent(dependantChain, _k -> new LinkedHashSet()).add(depName);
        CompletableFuture depResponse = this.kryonExecutor.executeCommand(new ForwardBatch(depKryonId, (ImmutableSet<String>)((ImmutableSet)resolverDefinitions.stream().map(ResolverDefinition::resolvedInputNames).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet())), (ImmutableMap<RequestId, Inputs>)ImmutableMap.copyOf(inputsByDepReq), dependantChain.extend(this.kryonId, depName), (ImmutableMap<RequestId, String>)ImmutableMap.copyOf(skipReasonsByReq)));
        depResponse.whenComplete((batchResponse, throwable) -> {
            Set requestIds = resolverCommandsByReq.keySet().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            ImmutableMap results = (ImmutableMap)requestIds.stream().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), requestId -> {
                if (throwable != null) {
                    return new Results(ImmutableMap.of((Object)Inputs.empty(), (Object)ValueOrError.withError((Throwable)throwable)));
                }
                Set depReqIds = depReqsByIncomingReq.getOrDefault(requestId, Set.of());
                return new Results((ImmutableMap)depReqIds.stream().collect(ImmutableMap.toImmutableMap(depReqId -> inputsByDepReq.getOrDefault(depReqId, Inputs.empty()), depReqId -> (ValueOrError)batchResponse.responses().getOrDefault(depReqId, (Object)ValueOrError.empty()))));
            }));
            KryonUtils.enqueueOrExecuteCommand(() -> new CallbackBatch(this.kryonId, depName, (ImmutableMap<RequestId, Results<Object>>)results, dependantChain), depKryonId, this.kryonDefinition, this.kryonExecutor);
        });
        this.flushDependencyIfNeeded(depName, dependantChain);
    }

    private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse>> executeOutputLogicIfPossible(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        ForwardBatch forwardCommand = this.getForwardCommand(dependantChain);
        ImmutableSet<String> inputNames = this.kryonDefinition.getOutputLogicDefinition().inputNames();
        if (this.availableInputsByDepChain.getOrDefault(dependantChain, (Set<String>)ImmutableSet.of()).containsAll((Collection<?>)inputNames)) {
            if (forwardCommand.shouldSkip()) {
                return Optional.of(CompletableFuture.failedFuture((Throwable)new SkippedExecutionException(BatchKryon.getSkipMessage(forwardCommand))));
            }
            return Optional.of(this.executeOutputLogic((Set<RequestId>)forwardCommand.executableRequests().keySet(), dependantChain));
        }
        return Optional.empty();
    }

    private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized BatchResponse> executeOutputLogic(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId> requestIds, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        OutputLogicDefinition<Object> outputLogicDefinition = this.kryonDefinition.getOutputLogicDefinition();
        LinkedHashMap<RequestId, OutputLogicInputs> outputLogicInputs = new LinkedHashMap<RequestId, OutputLogicInputs>();
        for (RequestId requestId : requestIds) {
            outputLogicInputs.put(requestId, this.getInputsForOutputLogic(dependantChain, requestId));
        }
        CompletableFuture<BatchResponse> resultForBatch = new CompletableFuture<BatchResponse>();
        Map<RequestId, CompletableFuture<ValueOrError<Object>>> results = this.executeDecoratedOutputLogic(outputLogicDefinition, outputLogicInputs, dependantChain);
        CompletableFuture.allOf((CompletableFuture[])results.values().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> resultForBatch.complete(new BatchResponse((ImmutableMap<RequestId, ValueOrError<Object>>)((ImmutableMap)outputLogicInputs.keySet().stream().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), requestId -> results.getOrDefault(requestId, new CompletableFuture()).getNow(ValueOrError.empty())))))));
        this.outputLogicExecuted.put(dependantChain, true);
        this.flushDecoratorsIfNeeded(dependantChain);
        return resultForBatch;
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized ValueOrError<@UnknownKeyFor @NonNull @Initialized Object>>> executeDecoratedOutputLogic(@UnknownKeyFor @NonNull @Initialized OutputLogicDefinition<@UnknownKeyFor @NonNull @Initialized Object> outputLogicDefinition, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized OutputLogicInputs> inputs, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        NavigableSet<OutputLogicDecorator> sortedDecorators = this.getSortedDecorators(dependantChain);
        OutputLogic logic = outputLogicDefinition::execute;
        for (OutputLogicDecorator outputLogicDecorator : sortedDecorators) {
            logic = outputLogicDecorator.decorateLogic(logic, outputLogicDefinition);
        }
        OutputLogic finalLogic = logic;
        LinkedHashMap<RequestId, CompletableFuture<ValueOrError<Object>>> resultsByRequest = new LinkedHashMap<RequestId, CompletableFuture<ValueOrError<Object>>>();
        inputs.forEach((requestId, outputLogicInputs) -> {
            CompletableFuture<@Nullable Object> cachedResult = this.resultsCache.get(outputLogicInputs.providedInputs());
            if (cachedResult == null) {
                try {
                    cachedResult = (CompletableFuture<Object>)finalLogic.execute((ImmutableList<Inputs>)ImmutableList.of((Object)outputLogicInputs.allInputsAndDependencies())).values().iterator().next();
                }
                catch (Exception e) {
                    cachedResult = CompletableFuture.failedFuture(e);
                }
                this.resultsCache.put(outputLogicInputs.providedInputs(), cachedResult);
            }
            resultsByRequest.put((RequestId)requestId, (CompletableFuture<ValueOrError<Object>>)cachedResult.handle(ValueOrError::valueOrError));
        });
        return resultsByRequest;
    }

    private void flushAllDependenciesIfNeeded(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        this.kryonDefinition.dependencyKryons().keySet().forEach(dependencyName -> this.flushDependencyIfNeeded((String)dependencyName, dependantChain));
    }

    private void flushDependencyIfNeeded(@UnknownKeyFor @NonNull @Initialized String dependencyName, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        if (!this.flushedDependantChain.contains(dependantChain)) {
            return;
        }
        if (this.executedDependencies.getOrDefault(dependantChain, Set.of()).contains(dependencyName)) {
            this.kryonExecutor.executeCommand(new Flush(Optional.ofNullable((KryonId)this.kryonDefinition.dependencyKryons().get((Object)dependencyName)).orElseThrow(() -> new AssertionError((Object)("Could not find KryonId for dependency " + dependencyName + ". This is a bug"))), dependantChain.extend(this.kryonId, dependencyName)));
        }
    }

    private void flushDecoratorsIfNeeded(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        block6: {
            block5: {
                if (!this.flushedDependantChain.contains(dependantChain)) {
                    return;
                }
                if (this.outputLogicExecuted.getOrDefault(dependantChain, false).booleanValue()) break block5;
                if (!this.getForwardCommand(dependantChain).shouldSkip()) break block6;
            }
            Iterable reverseSortedDecorators = this.getSortedDecorators(dependantChain)::descendingIterator;
            for (OutputLogicDecorator decorator : reverseSortedDecorators) {
                decorator.executeCommand(new FlushCommand(dependantChain));
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Inputs getInputsFor(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> boundFrom) {
        Inputs resolvableInputs = Optional.ofNullable(this.inputsValueCollector.get(dependantChain)).map(ForwardBatch::executableRequests).map(inputsByRequest -> (Inputs)inputsByRequest.get((Object)requestId)).orElse(Inputs.empty());
        Map depValues = this.dependencyValuesCollector.getOrDefault(dependantChain, Map.of());
        LinkedHashMap<String, InputValue> inputValues = new LinkedHashMap<String, InputValue>();
        for (String boundFromInput : boundFrom) {
            InputValue voe = (InputValue)resolvableInputs.values().get((Object)boundFromInput);
            if (voe == null) {
                CallbackBatch callbackBatch = (CallbackBatch)depValues.get(boundFromInput);
                if (callbackBatch == null) continue;
                inputValues.put(boundFromInput, (InputValue)callbackBatch.resultsByRequest().getOrDefault((Object)requestId, (Object)Results.empty()));
                continue;
            }
            inputValues.put(boundFromInput, voe);
        }
        return new Inputs(inputValues);
    }

    private @UnknownKeyFor @NonNull @Initialized OutputLogicInputs getInputsForOutputLogic(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized RequestId requestId) {
        ForwardBatch forwardBatch = this.inputsValueCollector.get(dependantChain);
        if (forwardBatch == null) {
            throw new AssertionError((Object)"Could not find forwardBatch. This is a bug.");
        }
        ImmutableMap depValues = (ImmutableMap)this.dependencyValuesCollector.getOrDefault(dependantChain, (Map<String, CallbackBatch>)ImmutableMap.of()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> (Results)((CallbackBatch)e.getValue()).resultsByRequest().getOrDefault((Object)requestId, (Object)Results.empty())));
        Inputs inputValues = (Inputs)forwardBatch.executableRequests().getOrDefault((Object)requestId, (Object)Inputs.empty());
        Inputs allInputsAndDependencies = Inputs.union((Map)depValues, (Map)inputValues.values());
        return new OutputLogicInputs(inputValues, allInputsAndDependencies);
    }

    private void collectInputValues(@UnknownKeyFor @NonNull @Initialized ForwardBatch forwardBatch) {
        if (this.requestsByDependantChain.putIfAbsent(forwardBatch.dependantChain(), forwardBatch.requestIds()) != null) {
            throw new DuplicateRequestException("Duplicate batch request received for dependant chain %s".formatted(forwardBatch.dependantChain()));
        }
        ImmutableSet<String> inputNames = forwardBatch.inputNames();
        if (this.inputsValueCollector.putIfAbsent(forwardBatch.dependantChain(), forwardBatch) != null) {
            throw new DuplicateRequestException("Duplicate data for inputs %s of kryon %s in dependant chain %s".formatted(inputNames, this.kryonId, forwardBatch.dependantChain()));
        }
        Sets.SetView resolvableInputNames = Sets.difference(this.kryonDefinition.getOutputLogicDefinition().inputNames(), (Set)this.kryonDefinition.dependencyKryons().keySet());
        if (!inputNames.containsAll((Collection)resolvableInputNames)) {
            throw new IllegalArgumentException("Did not receive inputs " + Sets.difference((Set)resolvableInputNames, inputNames));
        }
        this.availableInputsByDepChain.computeIfAbsent(forwardBatch.dependantChain(), _k -> new LinkedHashSet()).addAll(inputNames);
    }

    private static @UnknownKeyFor @NonNull @Initialized String getSkipMessage(@UnknownKeyFor @NonNull @Initialized ForwardBatch forwardBatch) {
        return String.join((CharSequence)", ", (Iterable<? extends CharSequence>)forwardBatch.skippedRequests().values());
    }

    private void collectDependencyValues(@UnknownKeyFor @NonNull @Initialized CallbackBatch callbackBatch) {
        String dependencyName = callbackBatch.dependencyName();
        this.availableInputsByDepChain.computeIfAbsent(callbackBatch.dependantChain(), _k -> new LinkedHashSet()).add(dependencyName);
        if (this.dependencyValuesCollector.computeIfAbsent(callbackBatch.dependantChain(), k -> new LinkedHashMap()).putIfAbsent(dependencyName, callbackBatch) != null) {
            throw new DuplicateRequestException("Duplicate data for dependency %s of kryon %s in dependant chain %s".formatted(dependencyName, this.kryonId, callbackBatch.dependantChain()));
        }
    }
}

