/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.KrystalExecutor;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardBatch;
import com.flipkart.krystal.krystex.commands.ForwardGranule;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.decoration.InitiateActiveDepChains;
import com.flipkart.krystal.krystex.decoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.decoration.MainLogicDecoratorConfig;
import com.flipkart.krystal.krystex.kryon.BatchKryon;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.kryon.DisabledDependantChainException;
import com.flipkart.krystal.krystex.kryon.FlushResponse;
import com.flipkart.krystal.krystex.kryon.GranularKryon;
import com.flipkart.krystal.krystex.kryon.GranuleResponse;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonDefinitionRegistry;
import com.flipkart.krystal.krystex.kryon.KryonExecutionConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutorMetrics;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonRegistry;
import com.flipkart.krystal.krystex.kryon.KryonResponse;
import com.flipkart.krystal.krystex.request.IntReqGenerator;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.krystex.request.RequestIdGenerator;
import com.flipkart.krystal.krystex.request.StringReqGenerator;
import com.flipkart.krystal.utils.Futures;
import com.flipkart.krystal.utils.MultiLeasePool;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KryonExecutor
implements KrystalExecutor {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(KryonExecutor.class);
    private final @UnknownKeyFor @NonNull @Initialized KryonDefinitionRegistry kryonDefinitionRegistry;
    private final @UnknownKeyFor @NonNull @Initialized KryonExecutorConfig executorConfig;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized MultiLeasePool.Lease<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ExecutorService> commandQueueLease;
    private final @UnknownKeyFor @NonNull @Initialized String instanceId;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MainLogicDecoratorConfig>> requestScopedLogicDecoratorConfigs;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MainLogicDecorator>> requestScopedMainDecorators = new LinkedHashMap<String, Map<String, MainLogicDecorator>>();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized KryonRegistry<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> kryonRegistry = new KryonRegistry();
    private final @UnknownKeyFor @NonNull @Initialized KryonExecutorMetrics kryonMetrics;
    private volatile @UnknownKeyFor @NonNull @Initialized boolean closed;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized RequestId, @UnknownKeyFor @NonNull @Initialized KryonExecution> allExecutions = new LinkedHashMap<RequestId, KryonExecution>();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId> unFlushedExecutions = new LinkedHashSet<RequestId>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KryonId, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DependantChain>> dependantChainsPerKryon = new LinkedHashMap<KryonId, Set<DependantChain>>();
    private final @UnknownKeyFor @NonNull @Initialized RequestIdGenerator preferredReqGenerator;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DependantChain> depChainsDisabledInAllExecutions = new LinkedHashSet<DependantChain>();

    public KryonExecutor(@UnknownKeyFor @NonNull @Initialized KryonDefinitionRegistry kryonDefinitionRegistry, @UnknownKeyFor @NonNull @Initialized MultiLeasePool<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ExecutorService> commandQueuePool, @UnknownKeyFor @NonNull @Initialized KryonExecutorConfig executorConfig, @UnknownKeyFor @NonNull @Initialized String instanceId) {
        this.kryonDefinitionRegistry = kryonDefinitionRegistry;
        this.executorConfig = executorConfig;
        this.commandQueueLease = commandQueuePool.lease();
        this.instanceId = instanceId;
        this.requestScopedLogicDecoratorConfigs = ImmutableMap.copyOf(executorConfig.requestScopedLogicDecoratorConfigs());
        this.kryonMetrics = new KryonExecutorMetrics();
        this.preferredReqGenerator = executorConfig.debug() ? new StringReqGenerator() : new IntReqGenerator();
    }

    private @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MainLogicDecorator> getRequestScopedDecorators(@UnknownKeyFor @NonNull @Initialized LogicExecutionContext logicExecutionContext) {
        KryonId kryonId = logicExecutionContext.kryonId();
        KryonDefinition kryonDefinition = this.kryonDefinitionRegistry.get(kryonId);
        MainLogicDefinition mainLogicDefinition = kryonDefinition.getMainLogicDefinition();
        LinkedHashMap decorators = new LinkedHashMap();
        Stream.concat(mainLogicDefinition.getRequestScopedLogicDecoratorConfigs().entrySet().stream(), this.requestScopedLogicDecoratorConfigs.entrySet().stream()).forEach(entry -> {
            String decoratorType = (String)entry.getKey();
            ArrayList decoratorConfigList = new ArrayList((Collection)entry.getValue());
            decoratorConfigList.forEach(decoratorConfig -> {
                String instanceId = decoratorConfig.instanceIdGenerator().apply(logicExecutionContext);
                if (decoratorConfig.shouldDecorate().test(logicExecutionContext)) {
                    MainLogicDecorator mainLogicDecorator = this.requestScopedMainDecorators.computeIfAbsent(decoratorType, t -> new LinkedHashMap()).computeIfAbsent(instanceId, _i -> decoratorConfig.factory().apply(new MainLogicDecoratorConfig.DecoratorContext(instanceId, logicExecutionContext)));
                    mainLogicDecorator.executeCommand(new InitiateActiveDepChains(kryonId, (ImmutableSet<DependantChain>)ImmutableSet.copyOf((Collection)this.dependantChainsPerKryon.getOrDefault(kryonId, (Set<DependantChain>)ImmutableSet.of()))));
                    decorators.putIfAbsent(decoratorType, mainLogicDecorator);
                }
            });
        });
        return ImmutableMap.copyOf(decorators);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable T> executeKryon(@UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized Inputs inputs, @UnknownKeyFor @NonNull @Initialized KryonExecutionConfig executionConfig) {
        if (this.closed) {
            throw new RejectedExecutionException("KryonExecutor is already closed");
        }
        Preconditions.checkArgument((executionConfig != null ? 1 : 0) != 0, (Object)"executionConfig can not be null");
        String executionId = executionConfig.executionId();
        Preconditions.checkArgument((executionId != null ? 1 : 0) != 0, (Object)"executionConfig.executionId can not be null");
        RequestId requestId = this.preferredReqGenerator.newRequest("%s:%s".formatted(this.instanceId, executionId));
        return this.enqueueCommand(() -> {
            this.createDependencyKryons(kryonId, this.kryonDefinitionRegistry.getDependantChainsStart(), executionConfig);
            CompletableFuture<@Nullable Object> future = new CompletableFuture<Object>();
            if (this.allExecutions.containsKey(requestId)) {
                future.completeExceptionally(new IllegalArgumentException("Received duplicate requests for same instanceId '%s' and execution Id '%s'".formatted(this.instanceId, executionId)));
            } else {
                this.allExecutions.put(requestId, new KryonExecution(kryonId, requestId, inputs, executionConfig, future));
                this.unFlushedExecutions.add(requestId);
            }
            return future;
        }).thenCompose(Function.identity());
    }

    private void createDependencyKryons(@UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized DependantChain dependantChain, @UnknownKeyFor @NonNull @Initialized KryonExecutionConfig executionConfig) {
        KryonDefinition kryonDefinition = this.kryonDefinitionRegistry.get(kryonId);
        if (!Sets.union(this.executorConfig.disabledDependantChains(), executionConfig.disabledDependantChains()).contains((Object)dependantChain)) {
            this.createKryonIfAbsent(kryonId, kryonDefinition);
            ImmutableMap<String, KryonId> dependencyKryons = kryonDefinition.dependencyKryons();
            dependencyKryons.forEach((dependencyName, depKryonId) -> this.createDependencyKryons((KryonId)depKryonId, dependantChain.extend(kryonId, (String)dependencyName), executionConfig));
            this.dependantChainsPerKryon.computeIfAbsent(kryonId, _n -> new LinkedHashSet()).add(dependantChain);
        }
    }

    private void createKryonIfAbsent(@UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized KryonDefinition kryonDefinition) {
        if (this.isGranular()) {
            this.kryonRegistry.createIfAbsent(kryonId, _n -> new GranularKryon(kryonDefinition, this, this::getRequestScopedDecorators, this.executorConfig.logicDecorationOrdering()));
        } else {
            KryonRegistry<?> batchKryonRegistry = this.kryonRegistry;
            batchKryonRegistry.createIfAbsent(kryonId, _n -> new BatchKryon(kryonDefinition, this, this::getRequestScopedDecorators, this.executorConfig.logicDecorationOrdering(), this.preferredReqGenerator));
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isGranular() {
        return KryonExecStrategy.GRANULAR.equals((Object)this.executorConfig.kryonExecStrategy());
    }

    <R extends KryonResponse> @UnknownKeyFor @NonNull @Initialized CompletableFuture<R> enqueueKryonCommand(@UnknownKeyFor @NonNull @Initialized Supplier<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized KryonCommand> kryonCommand) {
        return this.enqueueCommand(() -> this._executeCommand((KryonCommand)kryonCommand.get())).thenCompose(Function.identity());
    }

    <T extends KryonResponse> @UnknownKeyFor @NonNull @Initialized CompletableFuture<T> executeCommand(@UnknownKeyFor @NonNull @Initialized KryonCommand kryonCommand) {
        if (GraphTraversalStrategy.BREADTH.equals((Object)this.executorConfig.graphTraversalStrategy())) {
            return this.enqueueKryonCommand(() -> kryonCommand);
        }
        this.kryonMetrics.commandQueueBypassed();
        return this._executeCommand(kryonCommand);
    }

    private <R extends KryonResponse> @UnknownKeyFor @NonNull @Initialized CompletableFuture<R> _executeCommand(@UnknownKeyFor @NonNull @Initialized KryonCommand kryonCommand) {
        try {
            this.validate(kryonCommand);
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
        if (kryonCommand instanceof Flush) {
            Flush flush = (Flush)kryonCommand;
            this.kryonRegistry.get(flush.kryonId()).executeCommand(flush);
            return CompletableFuture.completedFuture(FlushResponse.getInstance());
        }
        Object kryon = this.kryonRegistry.get(kryonCommand.kryonId());
        return kryon.executeCommand((KryonCommand)kryonCommand);
    }

    private void validate(@UnknownKeyFor @NonNull @Initialized KryonCommand kryonCommand) {
        DependantChain dependantChain = kryonCommand.dependantChain();
        if (this.depChainsDisabledInAllExecutions.contains(dependantChain)) {
            throw new DisabledDependantChainException(dependantChain);
        }
    }

    @Override
    public void flush() {
        this.enqueueRunnable(() -> {
            this.computeDisabledDependantChains();
            if (this.isGranular()) {
                this.unFlushedExecutions.forEach(requestId -> {
                    KryonExecution kryonExecution = this.getKryonExecution((RequestId)requestId);
                    KryonId kryonId = kryonExecution.kryonId();
                    if (kryonExecution.future().isDone()) {
                        return;
                    }
                    KryonDefinition kryonDefinition = this.kryonDefinitionRegistry.get(kryonId);
                    this.submitGranular((RequestId)requestId, kryonExecution, kryonId, kryonDefinition);
                });
            } else {
                this.submitBatch(this.unFlushedExecutions);
            }
            this.unFlushedExecutions.stream().map(requestId -> this.getKryonExecution((RequestId)requestId).kryonId()).distinct().forEach(kryonId -> this.executeCommand(new Flush((KryonId)kryonId, this.kryonDefinitionRegistry.getDependantChainsStart())));
        });
    }

    private void computeDisabledDependantChains() {
        this.depChainsDisabledInAllExecutions.clear();
        List<ImmutableSet> disabledDependantChainsPerExecution = this.unFlushedExecutions.stream().map(this::getKryonExecution).map(KryonExecution::executionConfig).map(KryonExecutionConfig::disabledDependantChains).toList();
        disabledDependantChainsPerExecution.stream().filter(x -> !x.isEmpty()).findAny().ifPresent(this.depChainsDisabledInAllExecutions::addAll);
        for (Set set : disabledDependantChainsPerExecution) {
            if (this.depChainsDisabledInAllExecutions.isEmpty()) break;
            this.depChainsDisabledInAllExecutions.retainAll(set);
        }
        this.depChainsDisabledInAllExecutions.addAll((Collection<DependantChain>)this.executorConfig.disabledDependantChains());
    }

    private @UnknownKeyFor @NonNull @Initialized KryonExecution getKryonExecution(@UnknownKeyFor @NonNull @Initialized RequestId requestId) {
        KryonExecution kryonExecution = this.allExecutions.get(requestId);
        if (kryonExecution == null) {
            throw new AssertionError((Object)("No kryon execution found for requestId " + requestId));
        }
        return kryonExecution;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void submitGranular(@UnknownKeyFor @NonNull @Initialized RequestId requestId, @UnknownKeyFor @NonNull @Initialized KryonExecution kryonExecution, @UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized KryonDefinition kryonDefinition) {
        @Nullable CompletionStage submissionResult = ((CompletableFuture)((CompletableFuture)this.executeCommand(new ForwardGranule(kryonId, (ImmutableSet<String>)((ImmutableSet)kryonDefinition.getMainLogicDefinition().inputNames().stream().filter(s -> !kryonDefinition.dependencyKryons().containsKey(s)).collect(ImmutableSet.toImmutableSet())), kryonExecution.inputs(), this.kryonDefinitionRegistry.getDependantChainsStart(), requestId)).thenApply(GranuleResponse::response)).thenApply(ValueOrError::toFuture)).thenCompose(Function.identity());
        Futures.linkFutures((CompletableFuture)submissionResult, kryonExecution.future());
    }

    private void submitBatch(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RequestId> unFlushedRequests) {
        unFlushedRequests.stream().map(this::getKryonExecution).collect(Collectors.groupingBy(KryonExecution::kryonId)).forEach((kryonId, kryonResults) -> {
            KryonDefinition kryonDefinition = this.kryonDefinitionRegistry.get((KryonId)kryonId);
            CompletableFuture batchResponseFuture = this.executeCommand(new ForwardBatch((KryonId)kryonId, (ImmutableSet<String>)((ImmutableSet)kryonDefinition.getMainLogicDefinition().inputNames().stream().filter(s -> !kryonDefinition.dependencyKryons().containsKey(s)).collect(ImmutableSet.toImmutableSet())), (ImmutableMap<RequestId, Inputs>)((ImmutableMap)kryonResults.stream().collect(ImmutableMap.toImmutableMap(KryonExecution::instanceExecutionId, KryonExecution::inputs))), this.kryonDefinitionRegistry.getDependantChainsStart(), (ImmutableMap<RequestId, String>)ImmutableMap.of()));
            ((CompletableFuture)batchResponseFuture.thenApply(BatchResponse::responses)).whenComplete((responses, throwable) -> {
                for (KryonExecution kryonExecution : kryonResults) {
                    if (throwable != null) {
                        kryonExecution.future().completeExceptionally((Throwable)throwable);
                        continue;
                    }
                    ValueOrError result = (ValueOrError)responses.getOrDefault((Object)kryonExecution.instanceExecutionId(), (Object)ValueOrError.empty());
                    Futures.linkFutures((CompletableFuture)result.toFuture(), kryonExecution.future());
                }
            });
            Futures.propagateCancellation(CompletableFuture.allOf((CompletableFuture[])kryonResults.stream().map(KryonExecutor.getFuture()).toArray(CompletableFuture[]::new)), batchResponseFuture);
        });
    }

    public @UnknownKeyFor @NonNull @Initialized KryonExecutorMetrics getKryonMetrics() {
        return this.kryonMetrics;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.flush();
        this.enqueueCommand(() -> CompletableFuture.allOf((CompletableFuture[])this.allExecutions.values().stream().map(KryonExecutor.getFuture()).toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> this.commandQueueLease.close()));
    }

    private static @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized KryonExecution, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable @UnknownKeyFor @Initialized Object>> getFuture() {
        return KryonExecution::future;
    }

    private void enqueueRunnable(@UnknownKeyFor @NonNull @Initialized Runnable command) {
        this.enqueueCommand(() -> {
            command.run();
            return new Object();
        });
    }

    private <T> @UnknownKeyFor @NonNull @Initialized CompletableFuture<T> enqueueCommand(@UnknownKeyFor @NonNull @Initialized Supplier<T> command) {
        return CompletableFuture.supplyAsync(() -> {
            this.kryonMetrics.commandQueued();
            return command.get();
        }, (Executor)this.commandQueueLease.get());
    }

    public static enum KryonExecStrategy {
        GRANULAR,
        BATCH;

    }

    public static enum GraphTraversalStrategy {
        DEPTH,
        BREADTH;

    }

    private record KryonExecution(@UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized RequestId instanceExecutionId, @UnknownKeyFor @NonNull @Initialized Inputs inputs, @UnknownKeyFor @NonNull @Initialized KryonExecutionConfig executionConfig, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable @UnknownKeyFor @Initialized Object> future) {
    }
}

