/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.decoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.decoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonResponse;
import com.flipkart.krystal.krystex.request.RequestIdGenerator;
import com.flipkart.krystal.krystex.resolution.ResolverDefinition;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractKryon<@UnknownKeyFor C extends @UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor R extends @UnknownKeyFor @NonNull @Initialized KryonResponse>
implements Kryon<C, R> {
    protected final @UnknownKeyFor @NonNull @Initialized KryonDefinition kryonDefinition;
    protected final @UnknownKeyFor @NonNull @Initialized KryonId kryonId;
    protected final @UnknownKeyFor @NonNull @Initialized KryonExecutor kryonExecutor;
    protected final @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized LogicExecutionContext, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MainLogicDecorator>> requestScopedDecoratorsSupplier;
    protected final @UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering;
    protected final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String>, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> resolverDefinitionsByInput;
    protected final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> resolverDefinitionsByDependencies;
    protected final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized String> dependenciesWithNoResolvers;
    protected final @UnknownKeyFor @NonNull @Initialized RequestIdGenerator requestIdGenerator;

    AbstractKryon(@UnknownKeyFor @NonNull @Initialized KryonDefinition kryonDefinition, @UnknownKeyFor @NonNull @Initialized KryonExecutor kryonExecutor, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized LogicExecutionContext, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MainLogicDecorator>> requestScopedDecoratorsSupplier, @UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering, @UnknownKeyFor @NonNull @Initialized RequestIdGenerator requestIdGenerator) {
        this.kryonDefinition = kryonDefinition;
        this.kryonId = kryonDefinition.kryonId();
        this.kryonExecutor = kryonExecutor;
        this.requestScopedDecoratorsSupplier = requestScopedDecoratorsSupplier;
        this.logicDecorationOrdering = logicDecorationOrdering;
        KryonDefinition.KryonDefinitionView kryonDefinitionView = kryonDefinition.kryonDefinitionView();
        this.resolverDefinitionsByInput = kryonDefinitionView.resolverDefinitionsByInput();
        this.resolverDefinitionsByDependencies = kryonDefinitionView.resolverDefinitionsByDependencies();
        this.dependenciesWithNoResolvers = kryonDefinitionView.dependenciesWithNoResolvers();
        this.requestIdGenerator = requestIdGenerator;
    }

    protected @UnknownKeyFor @NonNull @Initialized NavigableSet<@UnknownKeyFor @NonNull @Initialized MainLogicDecorator> getSortedDecorators(@UnknownKeyFor @NonNull @Initialized DependantChain dependantChain) {
        MainLogicDefinition mainLogicDefinition = this.kryonDefinition.getMainLogicDefinition();
        LinkedHashMap<String, MainLogicDecorator> decorators = new LinkedHashMap<String, MainLogicDecorator>((Map<String, MainLogicDecorator>)mainLogicDefinition.getSessionScopedLogicDecorators(this.kryonDefinition, dependantChain));
        decorators.putAll((Map)this.requestScopedDecoratorsSupplier.apply(new LogicExecutionContext(this.kryonId, mainLogicDefinition.logicTags(), dependantChain, this.kryonDefinition.kryonDefinitionRegistry())));
        TreeSet sortedDecorators = new TreeSet(this.logicDecorationOrdering.decorationOrder());
        sortedDecorators.addAll(decorators.values());
        return sortedDecorators;
    }
}

