/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.decorators.resilience4j;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.decorators.resilience4j.R4JUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.decorators.Decorators;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class Resilience4JBulkhead
implements MainLogicDecorator {
    public static final String DECORATOR_TYPE = Resilience4JBulkhead.class.getName();
    private final String instanceId;
    private BulkheadAdapter bulkhead;

    public Resilience4JBulkhead(String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public MainLogic<Object> decorateLogic(MainLogic<Object> logicToDecorate, MainLogicDefinition<Object> originalLogicDefinition) {
        BulkheadAdapter bulkhead = this.bulkhead;
        if (bulkhead != null) {
            return inputsList -> R4JUtils.extractResponseMap((ImmutableList<Inputs>)inputsList, bulkhead.decorate(logicToDecorate, (ImmutableList<Inputs>)inputsList));
        }
        return logicToDecorate;
    }

    public void onConfigUpdate(ConfigProvider configProvider) {
        this.updateBulkhead(configProvider);
    }

    @Override
    public String getId() {
        return this.instanceId;
    }

    private void updateBulkhead(ConfigProvider configProvider) {
        BulkheadAdapter bulkhead = this.bulkhead;
        Optional<BulkheadAdapterConfig> newBulkheadConfig = this.getBulkheadConfig(configProvider);
        if (newBulkheadConfig.isPresent()) {
            if (bulkhead == null) {
                this.bulkhead = new BulkheadAdapter(newBulkheadConfig.get());
            } else {
                bulkhead.changeConfig(newBulkheadConfig.get());
            }
        }
    }

    private Optional<BulkheadAdapterConfig> getBulkheadConfig(ConfigProvider configProvider) {
        boolean bulkheadEnabled = configProvider.getConfig(this.instanceId + ".bulkhead.enabled").orElse(true);
        if (!bulkheadEnabled) {
            return Optional.empty();
        }
        BulkheadType bulkheadType = configProvider.getConfig(this.instanceId + ".bulkhead.type").map(BulkheadType::valueOf).orElse(BulkheadType.SEMAPHORE);
        Optional maxConcurrency = configProvider.getConfig(this.instanceId + ".bulkhead.max_concurrency");
        switch (bulkheadType) {
            case SEMAPHORE: {
                BulkheadConfig.Builder builder = BulkheadConfig.custom().writableStackTraceEnabled(false);
                maxConcurrency.ifPresent(arg_0 -> ((BulkheadConfig.Builder)builder).maxConcurrentCalls(arg_0));
                return Optional.of(new BulkheadAdapterConfig(builder.build()));
            }
            case THREADPOOL: {
                ThreadPoolBulkheadConfig.Builder builder = ThreadPoolBulkheadConfig.custom().writableStackTraceEnabled(false).queueCapacity(0);
                maxConcurrency.ifPresent(arg_0 -> ((ThreadPoolBulkheadConfig.Builder)builder).maxThreadPoolSize(arg_0));
                maxConcurrency.ifPresent(arg_0 -> ((ThreadPoolBulkheadConfig.Builder)builder).coreThreadPoolSize(arg_0));
                return Optional.of(new BulkheadAdapterConfig(builder.build()));
            }
        }
        return Optional.empty();
    }

    private final class BulkheadAdapter {
        private Bulkhead bulkhead;
        private ThreadPoolBulkhead threadPoolBulkhead;

        private BulkheadAdapter(BulkheadAdapterConfig config) {
            if (config.bulkheadConfig() != null) {
                this.bulkhead = Bulkhead.of((String)this.getBulkheadId(), (BulkheadConfig)config.bulkheadConfig());
            } else if (config.threadPoolBulkheadConfig() != null) {
                this.threadPoolBulkhead = this.newThreadPoolBulkhead(config.threadPoolBulkheadConfig());
            }
        }

        private void changeConfig(BulkheadAdapterConfig config) {
            if (config.bulkheadConfig() != null && this.bulkhead != null && !config.bulkheadConfig().equals(this.bulkhead.getBulkheadConfig())) {
                this.bulkhead.changeConfig(config.bulkheadConfig());
            } else if (config.threadPoolBulkheadConfig() != null && this.threadPoolBulkhead != null && !config.threadPoolBulkheadConfig().equals(this.threadPoolBulkhead.getBulkheadConfig())) {
                this.threadPoolBulkhead = this.newThreadPoolBulkhead(config.threadPoolBulkheadConfig());
            } else {
                throw new IllegalStateException();
            }
        }

        CompletionStage<ImmutableMap<Inputs, CompletableFuture<Object>>> decorate(MainLogic<Object> logicToDecorate, ImmutableList<Inputs> inputsList) {
            if (this.bulkhead != null) {
                return Decorators.ofCompletionStage(() -> {
                    ImmutableMap result = logicToDecorate.execute(inputsList);
                    return CompletableFuture.allOf((CompletableFuture[])result.values().toArray(CompletableFuture[]::new)).handle((unused, throwable) -> result);
                }).withBulkhead(this.bulkhead).get();
            }
            if (this.threadPoolBulkhead != null) {
                return this.threadPoolBulkhead.executeCallable(() -> logicToDecorate.execute(inputsList));
            }
            return null;
        }

        private ThreadPoolBulkhead newThreadPoolBulkhead(ThreadPoolBulkheadConfig config) {
            return ThreadPoolBulkhead.of((String)this.getBulkheadId(), (ThreadPoolBulkheadConfig)config);
        }

        private String getBulkheadId() {
            return Resilience4JBulkhead.this.instanceId + ".bulkhead";
        }
    }

    private record BulkheadAdapterConfig(BulkheadConfig bulkheadConfig, ThreadPoolBulkheadConfig threadPoolBulkheadConfig) {
        BulkheadAdapterConfig {
            assert (bulkheadConfig == null || threadPoolBulkheadConfig == null);
            assert (bulkheadConfig != null || threadPoolBulkheadConfig != null);
        }

        private BulkheadAdapterConfig(BulkheadConfig bulkheadConfig) {
            this(bulkheadConfig, null);
        }

        private BulkheadAdapterConfig(ThreadPoolBulkheadConfig threadPoolBulkheadConfig) {
            this(null, threadPoolBulkheadConfig);
        }
    }

    private static enum BulkheadType {
        THREADPOOL,
        SEMAPHORE;

    }
}

