/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.node;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.ComputeLogicDefinition;
import com.flipkart.krystal.krystex.IOLogicDefinition;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.ResolverCommand;
import com.flipkart.krystal.krystex.ResolverDefinition;
import com.flipkart.krystal.krystex.commands.ExecuteWithDependency;
import com.flipkart.krystal.krystex.commands.ExecuteWithInputs;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.NodeRequestCommand;
import com.flipkart.krystal.krystex.commands.SkipNode;
import com.flipkart.krystal.krystex.decoration.FlushCommand;
import com.flipkart.krystal.krystex.decoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.decoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.node.DependantChain;
import com.flipkart.krystal.krystex.node.DependantChainStart;
import com.flipkart.krystal.krystex.node.DuplicateRequestException;
import com.flipkart.krystal.krystex.node.KrystalNodeExecutor;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.flipkart.krystal.krystex.node.NodeResponse;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.utils.ImmutableMapView;
import com.flipkart.krystal.utils.SkippedExecutionException;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

class Node {
    private final NodeId nodeId;
    private final NodeDefinition nodeDefinition;
    private final KrystalNodeExecutor krystalNodeExecutor;
    private final Function<LogicExecutionContext, ImmutableMap<String, MainLogicDecorator>> requestScopedDecoratorsSupplier;
    private final ImmutableMapView<Optional<String>, List<ResolverDefinition>> resolverDefinitionsByInput;
    private final ImmutableMapView<String, ImmutableSet<ResolverDefinition>> resolverDefinitionsByDependencies;
    private final LogicDecorationOrdering logicDecorationOrdering;
    private final Map<RequestId, Map<String, DependencyNodeExecutions>> dependencyExecutions = new LinkedHashMap<RequestId, Map<String, DependencyNodeExecutions>>();
    private final Map<RequestId, Map<String, InputValue<Object>>> inputsValueCollector = new LinkedHashMap<RequestId, Map<String, InputValue<Object>>>();
    private final Map<RequestId, Map<String, Results<Object>>> dependencyValuesCollector = new LinkedHashMap<RequestId, Map<String, Results<Object>>>();
    private final Map<RequestId, CompletableFuture<NodeResponse>> resultsByRequest = new LinkedHashMap<RequestId, CompletableFuture<NodeResponse>>();
    private final Map<Inputs, CompletableFuture<Object>> resultsCache = new LinkedHashMap<Inputs, CompletableFuture<Object>>();
    private final Map<RequestId, Boolean> mainLogicExecuted = new LinkedHashMap<RequestId, Boolean>();
    private final Map<RequestId, Optional<SkipNode>> skipLogicRequested = new LinkedHashMap<RequestId, Optional<SkipNode>>();
    private final Map<RequestId, Map<NodeLogicId, ResolverCommand>> resolverResults = new LinkedHashMap<RequestId, Map<NodeLogicId, ResolverCommand>>();
    private final Map<DependantChain, Boolean> flushedDependantChain = new LinkedHashMap<DependantChain, Boolean>();
    private final Map<DependantChain, Set<RequestId>> requestsByDependantChain = new LinkedHashMap<DependantChain, Set<RequestId>>();
    private final Map<RequestId, DependantChain> dependantChainByRequest = new LinkedHashMap<RequestId, DependantChain>();

    Node(NodeDefinition nodeDefinition, KrystalNodeExecutor krystalNodeExecutor, Function<LogicExecutionContext, ImmutableMap<String, MainLogicDecorator>> requestScopedDecoratorsSupplier, LogicDecorationOrdering logicDecorationOrdering) {
        this.nodeId = nodeDefinition.nodeId();
        this.nodeDefinition = nodeDefinition;
        this.krystalNodeExecutor = krystalNodeExecutor;
        this.requestScopedDecoratorsSupplier = requestScopedDecoratorsSupplier;
        this.logicDecorationOrdering = logicDecorationOrdering;
        this.resolverDefinitionsByInput = Node.createResolverDefinitionsByInputs(nodeDefinition.resolverDefinitions());
        this.resolverDefinitionsByDependencies = ImmutableMapView.viewOf(nodeDefinition.resolverDefinitions().stream().collect(Collectors.groupingBy(ResolverDefinition::dependencyName, ImmutableSet.toImmutableSet())));
    }

    void executeCommand(Flush nodeCommand) {
        this.flushedDependantChain.put(nodeCommand.nodeDependants(), true);
        this.flushAllDependenciesIfNeeded(nodeCommand.nodeDependants());
        this.flushDecoratorsIfNeeded(nodeCommand.nodeDependants());
    }

    CompletableFuture<NodeResponse> executeRequestCommand(NodeRequestCommand nodeCommand) {
        RequestId requestId = nodeCommand.requestId();
        CompletableFuture resultForRequest = this.resultsByRequest.computeIfAbsent(requestId, r -> new CompletableFuture());
        if (resultForRequest.isDone()) {
            return resultForRequest;
        }
        try {
            if (nodeCommand instanceof SkipNode) {
                SkipNode skipNode = (SkipNode)nodeCommand;
                this.requestsByDependantChain.computeIfAbsent(skipNode.dependantChain(), k -> new LinkedHashSet()).add(requestId);
                this.dependantChainByRequest.put(requestId, skipNode.dependantChain());
                this.skipLogicRequested.put(requestId, Optional.of(skipNode));
                return this.handleSkipDependency(requestId, skipNode, resultForRequest);
            }
            if (nodeCommand instanceof ExecuteWithDependency) {
                ExecuteWithDependency executeWithDependency = (ExecuteWithDependency)nodeCommand;
                this.executeWithDependency(requestId, executeWithDependency);
            } else if (nodeCommand instanceof ExecuteWithInputs) {
                ExecuteWithInputs executeWithInputs = (ExecuteWithInputs)nodeCommand;
                this.requestsByDependantChain.computeIfAbsent(executeWithInputs.dependantChain(), k -> new LinkedHashSet()).add(requestId);
                this.dependantChainByRequest.computeIfAbsent(requestId, r -> executeWithInputs.dependantChain());
                this.executeWithInputs(requestId, executeWithInputs);
            } else {
                throw new UnsupportedOperationException("Unknown type of nodeCommand: %s".formatted(nodeCommand));
            }
            this.executeMainLogicIfPossible(requestId, resultForRequest);
        }
        catch (Throwable e) {
            resultForRequest.completeExceptionally(e);
        }
        return resultForRequest;
    }

    private void executeMainLogicIfPossible(RequestId requestId, CompletableFuture<NodeResponse> resultForRequest) {
        MainLogicDefinition mainLogicDefinition = this.nodeDefinition.getMainLogicDefinition();
        ImmutableSet<String> inputNames = mainLogicDefinition.inputNames();
        LinkedHashSet<String> collect = new LinkedHashSet<String>(this.inputsValueCollector.getOrDefault(requestId, (Map<String, InputValue<Object>>)ImmutableMap.of()).keySet());
        collect.addAll(this.dependencyValuesCollector.getOrDefault(requestId, (Map<String, Results<Object>>)ImmutableMap.of()).keySet());
        if (collect.containsAll((Collection<?>)inputNames)) {
            this.executeMainLogic(resultForRequest, requestId);
        }
    }

    private CompletableFuture<NodeResponse> handleSkipDependency(RequestId requestId, SkipNode skipNode, CompletableFuture<NodeResponse> resultForRequest) {
        Set pendingResolvers = this.resolverDefinitionsByInput.values().stream().flatMap(Collection::stream).filter(resolverDefinition -> !this.resolverResults.computeIfAbsent(requestId, r -> new LinkedHashMap()).containsKey(resolverDefinition.resolverNodeLogicId())).collect(Collectors.toSet());
        for (ResolverDefinition resolverDefinition2 : pendingResolvers) {
            this.executeResolver(requestId, resolverDefinition2);
        }
        resultForRequest.completeExceptionally((Throwable)Node.skipNodeException(skipNode));
        return resultForRequest;
    }

    private static SkippedExecutionException skipNodeException(SkipNode skipNode) {
        return new SkippedExecutionException(skipNode.skipDependencyCommand().reason());
    }

    private void flushDecoratorsIfNeeded(DependantChain dependantChain) {
        if (!this.flushedDependantChain.getOrDefault(dependantChain, false).booleanValue()) {
            return;
        }
        Set<RequestId> requestIds = this.requestsByDependantChain.get(dependantChain);
        int requestIdExecuted = 0;
        for (RequestId requestId : requestIds) {
            if (!this.mainLogicExecuted.getOrDefault(requestId, false).booleanValue() && !this.skipLogicRequested.getOrDefault(requestId, Optional.empty()).isPresent()) continue;
            ++requestIdExecuted;
        }
        if (requestIdExecuted == requestIds.size()) {
            Iterable reverseSortedDecorators = this.getSortedDecorators(dependantChain)::descendingIterator;
            for (MainLogicDecorator decorator : reverseSortedDecorators) {
                decorator.executeCommand(new FlushCommand(dependantChain));
            }
        }
    }

    private void executeWithInputs(RequestId requestId, ExecuteWithInputs executeWithInputs) {
        this.collectInputValues(requestId, (Set<String>)executeWithInputs.inputNames(), executeWithInputs.values());
        this.execute(requestId, executeWithInputs.inputNames());
    }

    private void executeWithDependency(RequestId requestId, ExecuteWithDependency executeWithInput) {
        String dependencyName = executeWithInput.dependencyName();
        ImmutableSet inputNames = ImmutableSet.of((Object)dependencyName);
        if (this.dependencyValuesCollector.computeIfAbsent(requestId, k -> new LinkedHashMap()).putIfAbsent(dependencyName, executeWithInput.results()) != null) {
            throw new DuplicateRequestException("Duplicate data for dependency %s of node %s in request %s".formatted(dependencyName, this.nodeId, requestId));
        }
        this.execute(requestId, (ImmutableSet<String>)inputNames);
    }

    private void execute(RequestId requestId, ImmutableSet<String> newInputNames) {
        MainLogicDefinition mainLogicDefinition = this.nodeDefinition.getMainLogicDefinition();
        Map allInputs = this.inputsValueCollector.computeIfAbsent(requestId, r -> new LinkedHashMap());
        Map allDependencies = this.dependencyValuesCollector.computeIfAbsent(requestId, k -> new LinkedHashMap());
        ImmutableSet<String> allInputNames = mainLogicDefinition.inputNames();
        Sets.SetView availableInputs = Sets.union(allInputs.keySet(), allDependencies.keySet());
        if (availableInputs.isEmpty()) {
            if (!allInputNames.isEmpty() && this.nodeDefinition.resolverDefinitions().isEmpty() && !this.nodeDefinition.dependencyNodes().isEmpty()) {
                this.executeDependenciesWhenNoResolvers(requestId);
            }
            return;
        }
        Map<NodeLogicId, ResolverDefinition> pendingResolvers = this.getPendingResolvers(requestId, newInputNames, (Set<String>)availableInputs);
        for (ResolverDefinition pendingResolver : pendingResolvers.values()) {
            this.executeResolver(requestId, pendingResolver);
        }
    }

    private Map<NodeLogicId, ResolverDefinition> getPendingResolvers(RequestId requestId, ImmutableSet<String> newInputNames, Set<String> availableInputs) {
        Map nodeResults = this.resolverResults.computeIfAbsent(requestId, r -> new LinkedHashMap());
        Collector resolverCollector = Collectors.toMap(ResolverDefinition::resolverNodeLogicId, Functions.identity(), (o1, o2) -> o1);
        Map pendingUnboundResolvers = ((List)this.resolverDefinitionsByInput.getOrDefault(Optional.empty(), Collections.emptyList())).stream().filter(resolverDefinition -> availableInputs.containsAll((Collection<?>)resolverDefinition.boundFrom())).filter(resolverDefinition -> !nodeResults.containsKey(resolverDefinition.resolverNodeLogicId())).collect(resolverCollector);
        Map<NodeLogicId, ResolverDefinition> pendingResolvers = newInputNames.stream().flatMap(input -> ((List)this.resolverDefinitionsByInput.getOrDefault(Optional.ofNullable(input), (Object)ImmutableList.of())).stream().filter(resolverDefinition -> availableInputs.containsAll((Collection<?>)resolverDefinition.boundFrom())).filter(resolverDefinition -> !nodeResults.containsKey(resolverDefinition.resolverNodeLogicId()))).collect(resolverCollector);
        pendingResolvers.putAll(pendingUnboundResolvers);
        return pendingResolvers;
    }

    private void executeResolver(RequestId requestId, ResolverDefinition resolverDefinition) {
        ImmutableSet resolverDefinitionsForDependency;
        ResolverCommand resolverCommand;
        Map nodeResults = this.resolverResults.computeIfAbsent(requestId, r -> new LinkedHashMap());
        String dependencyName = resolverDefinition.dependencyName();
        NodeId depNodeId = (NodeId)this.nodeDefinition.dependencyNodes().get((Object)dependencyName);
        NodeLogicId nodeLogicId = resolverDefinition.resolverNodeLogicId();
        Optional skipRequested = this.skipLogicRequested.getOrDefault(requestId, Optional.empty());
        if (skipRequested.isPresent()) {
            resolverCommand = ResolverCommand.skip(((SkipNode)skipRequested.get()).skipDependencyCommand().reason());
        } else {
            Inputs inputsForResolver = this.getInputsForResolver(resolverDefinition, requestId);
            resolverCommand = this.nodeDefinition.nodeDefinitionRegistry().logicDefinitionRegistry().getResolver(nodeLogicId).resolve(inputsForResolver);
        }
        nodeResults.put(nodeLogicId, resolverCommand);
        DependencyNodeExecutions dependencyNodeExecutions = this.dependencyExecutions.computeIfAbsent(requestId, k -> new LinkedHashMap()).computeIfAbsent(dependencyName, k -> new DependencyNodeExecutions());
        dependencyNodeExecutions.executedResolvers().add(resolverDefinition);
        if (resolverCommand instanceof ResolverCommand.SkipDependency) {
            if (this.dependencyValuesCollector.getOrDefault(requestId, (Map<String, Results<Object>>)ImmutableMap.of()).get(dependencyName) == null) {
                HashSet<RequestId> requestIdSet = new HashSet<RequestId>(dependencyNodeExecutions.individualCallResponses().keySet());
                RequestId dependencyRequestId = requestId.createNewRequest("%s[%s]".formatted(dependencyName, 0));
                requestIdSet.add(dependencyRequestId);
                for (RequestId depRequestId : requestIdSet) {
                    SkipNode skipNode = new SkipNode(depNodeId, depRequestId, DependantChain.extend(this.dependantChainByRequest.getOrDefault(requestId, DependantChainStart.instance()), this.nodeId, dependencyName), (ResolverCommand.SkipDependency)resolverCommand);
                    dependencyNodeExecutions.individualCallResponses().putIfAbsent(depRequestId, this.krystalNodeExecutor.executeCommand(skipNode));
                }
            }
        } else {
            ImmutableList<Inputs> inputList = resolverCommand.getInputs();
            long executionsInProgress = dependencyNodeExecutions.executionCounter().longValue();
            LinkedHashMap<RequestId, Inputs> oldInputs = new LinkedHashMap<RequestId, Inputs>();
            int i = 0;
            while ((long)i < executionsInProgress) {
                RequestId rid = requestId.createNewRequest("%s[%s]".formatted(dependencyName, i));
                oldInputs.put(rid, new Inputs(dependencyNodeExecutions.individualCallInputs().getOrDefault(rid, Inputs.empty()).values()));
                ++i;
            }
            long batchSize = Math.max(executionsInProgress, 1L);
            int requestCounter = 0;
            for (int j = 0; j < inputList.size(); ++j) {
                Inputs inputs = (Inputs)inputList.get(j);
                int i2 = 0;
                while ((long)i2 < batchSize) {
                    RequestId dependencyRequestId = requestId.createNewRequest("%s[%s]".formatted(dependencyName, (long)j * batchSize + (long)i2));
                    RequestId inProgressRequestId = executionsInProgress > 0L ? requestId.createNewRequest("%s[%s]".formatted(dependencyName, i2)) : dependencyRequestId;
                    Inputs oldInput = oldInputs.getOrDefault(inProgressRequestId, Inputs.empty());
                    if ((long)requestCounter >= executionsInProgress) {
                        dependencyNodeExecutions.executionCounter().increment();
                    }
                    Inputs newInputs = j == 0 ? inputs : Inputs.union((Map)oldInput.values(), (Map)inputs.values());
                    dependencyNodeExecutions.individualCallInputs().put(dependencyRequestId, newInputs);
                    dependencyNodeExecutions.individualCallResponses().putIfAbsent(dependencyRequestId, this.krystalNodeExecutor.executeCommand(new ExecuteWithInputs(depNodeId, (ImmutableSet<String>)newInputs.values().keySet(), newInputs, DependantChain.extend(this.dependantChainByRequest.getOrDefault(requestId, DependantChainStart.instance()), this.nodeId, dependencyName), dependencyRequestId)));
                    ++i2;
                }
                requestCounter = (int)((long)requestCounter + batchSize);
            }
        }
        if ((resolverDefinitionsForDependency = (ImmutableSet)this.resolverDefinitionsByDependencies.get((Object)dependencyName)).equals(dependencyNodeExecutions.executedResolvers())) {
            CompletableFuture.allOf((CompletableFuture[])dependencyNodeExecutions.individualCallResponses().values().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> this.enqueueOrExecuteCommand(() -> {
                Results results = throwable != null ? new Results(ImmutableMap.of((Object)Inputs.empty(), (Object)ValueOrError.withError((Throwable)throwable))) : new Results((ImmutableMap)dependencyNodeExecutions.individualCallResponses().values().stream().map(cf -> cf.getNow(new NodeResponse())).collect(ImmutableMap.toImmutableMap(NodeResponse::inputs, NodeResponse::response)));
                return new ExecuteWithDependency(this.nodeId, dependencyName, (Results<Object>)results, requestId);
            }, depNodeId));
            this.flushDependencyIfNeeded(dependencyName, this.dependantChainByRequest.getOrDefault(requestId, DependantChainStart.instance()));
        }
    }

    private void enqueueOrExecuteCommand(Supplier<NodeRequestCommand> commandGenerator, NodeId depNodeId) {
        MainLogicDefinition depMainLogic = this.nodeDefinition.nodeDefinitionRegistry().get(depNodeId).getMainLogicDefinition();
        if (depMainLogic instanceof IOLogicDefinition) {
            this.krystalNodeExecutor.enqueueNodeCommand(commandGenerator);
        } else if (depMainLogic instanceof ComputeLogicDefinition) {
            this.krystalNodeExecutor.executeCommand(commandGenerator.get());
        } else {
            throw new UnsupportedOperationException("Unknown logicDefinition type %s".formatted(depMainLogic.getClass()));
        }
    }

    private void flushAllDependenciesIfNeeded(DependantChain dependantChain) {
        this.nodeDefinition.dependencyNodes().keySet().forEach(dependencyName -> this.flushDependencyIfNeeded((String)dependencyName, dependantChain));
    }

    private void flushDependencyIfNeeded(String dependencyName, DependantChain dependantChain) {
        if (!this.flushedDependantChain.getOrDefault(dependantChain, false).booleanValue()) {
            return;
        }
        Set<RequestId> requestsForDependantChain = this.requestsByDependantChain.getOrDefault(dependantChain, (Set<RequestId>)ImmutableSet.of());
        NodeId depNodeId = (NodeId)this.nodeDefinition.dependencyNodes().get((Object)dependencyName);
        ImmutableSet resolverDefinitionsForDependency = (ImmutableSet)this.resolverDefinitionsByDependencies.get((Object)dependencyName);
        if (!requestsForDependantChain.isEmpty() && requestsForDependantChain.stream().allMatch(requestId -> resolverDefinitionsForDependency.equals(this.dependencyExecutions.computeIfAbsent((RequestId)requestId, k -> new LinkedHashMap()).computeIfAbsent(dependencyName, k -> new DependencyNodeExecutions()).executedResolvers()))) {
            this.krystalNodeExecutor.executeCommand(new Flush(depNodeId, DependantChain.extend(dependantChain, this.nodeId, dependencyName)));
        }
    }

    private Inputs getInputsForResolver(ResolverDefinition resolverDefinition, RequestId requestId) {
        Map allInputs = this.inputsValueCollector.computeIfAbsent(requestId, r -> new LinkedHashMap());
        ImmutableSet<String> boundFrom = resolverDefinition.boundFrom();
        LinkedHashMap<String, InputValue> inputValues = new LinkedHashMap<String, InputValue>();
        for (String boundFromInput : boundFrom) {
            InputValue voe = (InputValue)allInputs.get(boundFromInput);
            if (voe == null) {
                inputValues.put(boundFromInput, (InputValue)this.dependencyValuesCollector.computeIfAbsent(requestId, k -> new LinkedHashMap()).get(boundFromInput));
                continue;
            }
            inputValues.put(boundFromInput, voe);
        }
        return new Inputs(inputValues);
    }

    private void executeDependenciesWhenNoResolvers(RequestId requestId) {
        this.nodeDefinition.dependencyNodes().forEach((depName, depNodeId) -> {
            if (!this.dependencyValuesCollector.getOrDefault(requestId, (Map<String, Results<Object>>)ImmutableMap.of()).containsKey(depName)) {
                RequestId dependencyRequestId = requestId.createNewRequest("%s".formatted(depName));
                CompletableFuture<NodeResponse> nodeResponse = this.krystalNodeExecutor.executeCommand(new ExecuteWithInputs((NodeId)depNodeId, (ImmutableSet<String>)ImmutableSet.of(), Inputs.empty(), DependantChain.extend(this.dependantChainByRequest.get(requestId), this.nodeId, depName), dependencyRequestId));
                ((CompletableFuture)nodeResponse.thenApply(NodeResponse::response)).whenComplete((response, throwable) -> this.enqueueOrExecuteCommand(() -> {
                    ValueOrError valueOrError = response;
                    if (throwable != null) {
                        valueOrError = ValueOrError.withError((Throwable)throwable);
                    }
                    return new ExecuteWithDependency(this.nodeId, (String)depName, (Results<Object>)new Results(ImmutableMap.of((Object)Inputs.empty(), (Object)valueOrError)), requestId);
                }, (NodeId)depNodeId));
            }
        });
    }

    private void executeMainLogic(CompletableFuture<NodeResponse> resultForRequest, RequestId requestId) {
        MainLogicDefinition<Object> mainLogicDefinition = this.nodeDefinition.getMainLogicDefinition();
        MainLogicInputs mainLogicInputs = this.getInputsForMainLogic(requestId);
        CompletableFuture<Object> resultFuture = this.resultsCache.get(mainLogicInputs.nonDependencyInputs());
        if (resultFuture == null) {
            resultFuture = this.executeDecoratedMainLogic(mainLogicInputs.allInputsAndDependencies(), mainLogicDefinition, requestId);
            this.resultsCache.put(mainLogicInputs.nonDependencyInputs(), resultFuture);
        }
        ((CompletableFuture)resultFuture.handle(ValueOrError::valueOrError)).thenAccept(value -> resultForRequest.complete(new NodeResponse(mainLogicInputs.nonDependencyInputs(), (ValueOrError<Object>)value)));
        this.mainLogicExecuted.put(requestId, true);
        this.flushDecoratorsIfNeeded(this.dependantChainByRequest.get(requestId));
    }

    private CompletableFuture<Object> executeDecoratedMainLogic(Inputs inputs, MainLogicDefinition<Object> mainLogicDefinition, RequestId requestId) {
        NavigableSet<MainLogicDecorator> sortedDecorators = this.getSortedDecorators(this.dependantChainByRequest.get(requestId));
        MainLogic logic = mainLogicDefinition::execute;
        for (MainLogicDecorator mainLogicDecorator : sortedDecorators) {
            logic = mainLogicDecorator.decorateLogic(logic, mainLogicDefinition);
        }
        return (CompletableFuture)logic.execute((ImmutableList<Inputs>)ImmutableList.of((Object)inputs)).get((Object)inputs);
    }

    private MainLogicInputs getInputsForMainLogic(RequestId requestId) {
        Inputs inputValues = new Inputs(this.inputsValueCollector.getOrDefault(requestId, (Map<String, InputValue<Object>>)ImmutableMap.of()));
        Map<String, Results<Object>> dependencyValues = this.dependencyValuesCollector.getOrDefault(requestId, (Map<String, Results<Object>>)ImmutableMap.of());
        Inputs allInputsAndDependencies = Inputs.union(dependencyValues, (Map)inputValues.values());
        return new MainLogicInputs(inputValues, allInputsAndDependencies);
    }

    private void collectInputValues(RequestId requestId, Set<String> inputNames, Inputs inputs) {
        for (String inputName : inputNames) {
            if (this.inputsValueCollector.computeIfAbsent(requestId, r -> new LinkedHashMap()).putIfAbsent(inputName, inputs.getInputValue(inputName)) == null) continue;
            throw new DuplicateRequestException("Duplicate data for inputs %s of node %s in request %s".formatted(inputNames, this.nodeId, requestId));
        }
    }

    private NavigableSet<MainLogicDecorator> getSortedDecorators(DependantChain dependantChain) {
        MainLogicDefinition mainLogicDefinition = this.nodeDefinition.getMainLogicDefinition();
        LinkedHashMap<String, MainLogicDecorator> decorators = new LinkedHashMap<String, MainLogicDecorator>((Map<String, MainLogicDecorator>)mainLogicDefinition.getSessionScopedLogicDecorators(this.nodeDefinition, dependantChain));
        decorators.putAll((Map)this.requestScopedDecoratorsSupplier.apply(new LogicExecutionContext(this.nodeId, mainLogicDefinition.logicTags(), dependantChain, this.nodeDefinition.nodeDefinitionRegistry())));
        TreeSet sortedDecorators = new TreeSet(this.logicDecorationOrdering.decorationOrder());
        sortedDecorators.addAll(decorators.values());
        return sortedDecorators;
    }

    private static ImmutableMapView<Optional<String>, List<ResolverDefinition>> createResolverDefinitionsByInputs(ImmutableList<ResolverDefinition> resolverDefinitions) {
        LinkedHashMap resolverDefinitionsByInput = new LinkedHashMap();
        resolverDefinitions.forEach(resolverDefinition -> {
            if (!resolverDefinition.boundFrom().isEmpty()) {
                resolverDefinition.boundFrom().forEach(input -> resolverDefinitionsByInput.computeIfAbsent(Optional.of(input), s -> new ArrayList()).add(resolverDefinition));
            } else {
                resolverDefinitionsByInput.computeIfAbsent(Optional.empty(), s -> new ArrayList()).add(resolverDefinition);
            }
        });
        return ImmutableMapView.viewOf(resolverDefinitionsByInput);
    }

    private record DependencyNodeExecutions(LongAdder executionCounter, Set<ResolverDefinition> executedResolvers, Map<RequestId, Inputs> individualCallInputs, Map<RequestId, CompletableFuture<NodeResponse>> individualCallResponses) {
        private DependencyNodeExecutions() {
            this(new LongAdder(), new LinkedHashSet<ResolverDefinition>(), new LinkedHashMap<RequestId, Inputs>(), new LinkedHashMap<RequestId, CompletableFuture<NodeResponse>>());
        }
    }

    private record MainLogicInputs(Inputs nonDependencyInputs, Inputs allInputsAndDependencies) {
    }
}

