/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.node;

import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.commands.NodeCommand;
import com.flipkart.krystal.krystex.decoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.decoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.node.DependantChain;
import com.flipkart.krystal.krystex.node.KrystalNodeExecutor;
import com.flipkart.krystal.krystex.node.Node;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeResponse;
import com.flipkart.krystal.krystex.node.NodeUtils;
import com.flipkart.krystal.krystex.request.RequestIdGenerator;
import com.flipkart.krystal.krystex.resolution.ResolverDefinition;
import com.flipkart.krystal.utils.ImmutableMapView;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractNode<C extends NodeCommand, R extends NodeResponse>
implements Node<C, R> {
    protected final NodeDefinition nodeDefinition;
    protected final NodeId nodeId;
    protected final KrystalNodeExecutor krystalNodeExecutor;
    protected final Function<LogicExecutionContext, ImmutableMap<String, MainLogicDecorator>> requestScopedDecoratorsSupplier;
    protected final LogicDecorationOrdering logicDecorationOrdering;
    protected final KrystalNodeExecutor.ResolverExecStrategy resolverExecStrategy;
    protected final ImmutableMapView<Optional<String>, List<ResolverDefinition>> resolverDefinitionsByInput;
    protected final ImmutableMapView<String, ImmutableSet<ResolverDefinition>> resolverDefinitionsByDependencies;
    protected final ImmutableSet<String> dependenciesWithNoResolvers;
    protected final RequestIdGenerator requestIdGenerator;

    AbstractNode(NodeDefinition nodeDefinition, KrystalNodeExecutor krystalNodeExecutor, Function<LogicExecutionContext, ImmutableMap<String, MainLogicDecorator>> requestScopedDecoratorsSupplier, LogicDecorationOrdering logicDecorationOrdering, KrystalNodeExecutor.ResolverExecStrategy resolverExecStrategy, RequestIdGenerator requestIdGenerator) {
        this.nodeDefinition = nodeDefinition;
        this.nodeId = nodeDefinition.nodeId();
        this.krystalNodeExecutor = krystalNodeExecutor;
        this.requestScopedDecoratorsSupplier = requestScopedDecoratorsSupplier;
        this.logicDecorationOrdering = logicDecorationOrdering;
        this.resolverExecStrategy = resolverExecStrategy;
        this.resolverDefinitionsByInput = NodeUtils.createResolverDefinitionsByInputs(nodeDefinition.resolverDefinitions());
        this.resolverDefinitionsByDependencies = ImmutableMapView.viewOf(nodeDefinition.resolverDefinitions().stream().collect(Collectors.groupingBy(ResolverDefinition::dependencyName, ImmutableSet.toImmutableSet())));
        this.dependenciesWithNoResolvers = (ImmutableSet)nodeDefinition.dependencyNodes().keySet().stream().filter(depName -> ((ImmutableSet)this.resolverDefinitionsByDependencies.getOrDefault(depName, (Object)ImmutableSet.of())).isEmpty()).collect(ImmutableSet.toImmutableSet());
        this.requestIdGenerator = requestIdGenerator;
    }

    protected NavigableSet<MainLogicDecorator> getSortedDecorators(DependantChain dependantChain) {
        MainLogicDefinition mainLogicDefinition = this.nodeDefinition.getMainLogicDefinition();
        LinkedHashMap<String, MainLogicDecorator> decorators = new LinkedHashMap<String, MainLogicDecorator>((Map<String, MainLogicDecorator>)mainLogicDefinition.getSessionScopedLogicDecorators(this.nodeDefinition, dependantChain));
        decorators.putAll((Map)this.requestScopedDecoratorsSupplier.apply(new LogicExecutionContext(this.nodeId, mainLogicDefinition.logicTags(), dependantChain, this.nodeDefinition.nodeDefinitionRegistry())));
        TreeSet sortedDecorators = new TreeSet(this.logicDecorationOrdering.decorationOrder());
        sortedDecorators.addAll(decorators.values());
        return sortedDecorators;
    }
}

