/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.decorators.observability;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.decorators.observability.NodeExecutionReport;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultNodeExecutionReport
implements NodeExecutionReport {
    private static final Logger log = LoggerFactory.getLogger(DefaultNodeExecutionReport.class);
    private final Instant startTime;
    private final boolean verbose;
    private final Clock clock;
    private final Map<NodeExecution, LogicExecInfo> mainLogicExecInfos = new LinkedHashMap<NodeExecution, LogicExecInfo>();

    public DefaultNodeExecutionReport(Clock clock) {
        this(clock, false);
    }

    public DefaultNodeExecutionReport(Clock clock, boolean verbose) {
        this.clock = clock;
        this.startTime = clock.instant();
        this.verbose = verbose;
    }

    @Override
    public void reportMainLogicStart(NodeId nodeId, NodeLogicId nodeLogicId, ImmutableList<Inputs> inputs) {
        NodeExecution nodeExecution = new NodeExecution(nodeId, (ImmutableList<ImmutableMap<String, Object>>)((ImmutableList)inputs.stream().map(this::extractAndConvertInputs).collect(ImmutableList.toImmutableList())));
        if (this.mainLogicExecInfos.containsKey(nodeExecution)) {
            log.error("Cannot start the same node execution multiple times: {}", (Object)nodeExecution);
            return;
        }
        this.mainLogicExecInfos.put(nodeExecution, new LogicExecInfo(this, nodeId, (ImmutableCollection<Inputs>)inputs, this.startTime.until(this.clock.instant(), ChronoUnit.MILLIS)));
    }

    @Override
    public void reportMainLogicEnd(NodeId nodeId, NodeLogicId nodeLogicId, Results<Object> result) {
        NodeExecution nodeExecution = new NodeExecution(nodeId, (ImmutableList<ImmutableMap<String, Object>>)((ImmutableList)result.values().keySet().stream().map(this::extractAndConvertInputs).collect(ImmutableList.toImmutableList())));
        LogicExecInfo logicExecInfo = this.mainLogicExecInfos.get(nodeExecution);
        if (logicExecInfo == null) {
            log.error("'reportMainLogicEnd' called without calling 'reportMainLogicStart' first for: {}", (Object)nodeExecution);
            return;
        }
        if (logicExecInfo.getResult() != null) {
            log.error("Cannot end the same node execution multiple times: {}", (Object)nodeExecution);
            return;
        }
        logicExecInfo.endTimeMs = this.startTime.until(this.clock.instant(), ChronoUnit.MILLIS);
        logicExecInfo.setResult(this.convertResult(result));
    }

    private ImmutableMap<String, Object> extractAndConvertInputs(Inputs inputs) {
        LinkedHashMap<String, Object> inputMap = new LinkedHashMap<String, Object>();
        for (Map.Entry e : inputs.values().entrySet()) {
            Object collect;
            InputValue value = (InputValue)e.getValue();
            if (!(value instanceof ValueOrError) || (collect = this.convertValueOrError((ValueOrError<Object>)((ValueOrError)value))) == null) continue;
            inputMap.put((String)e.getKey(), collect);
        }
        return ImmutableMap.copyOf(inputMap);
    }

    private ImmutableMap<String, Object> extractAndConvertDependencyResults(Inputs inputs) {
        LinkedHashMap<String, Map<ImmutableMap<String, Object>, Object>> inputMap = new LinkedHashMap<String, Map<ImmutableMap<String, Object>, Object>>();
        for (Map.Entry e : inputs.values().entrySet()) {
            InputValue value = (InputValue)e.getValue();
            if (!(value instanceof Results)) continue;
            Map<ImmutableMap<String, Object>, Object> collect = this.convertResult((Results<Object>)((Results)value));
            inputMap.put((String)e.getKey(), collect);
        }
        return ImmutableMap.copyOf(inputMap);
    }

    private Object convertValueOrError(ValueOrError<Object> voe) {
        if (voe.error().isPresent()) {
            Throwable throwable = (Throwable)voe.error().get();
            return this.verbose ? Throwables.getStackTraceAsString((Throwable)throwable) : throwable.toString();
        }
        return voe.value().orElse("null");
    }

    private Map<ImmutableMap<String, Object>, Object> convertResult(Results<Object> results) {
        return results.values().entrySet().stream().collect(Collectors.toMap(e -> this.extractAndConvertInputs((Inputs)e.getKey()), e -> this.convertValueOrError((ValueOrError<Object>)((ValueOrError)e.getValue()))));
    }

    public String toString() {
        return "DefaultNodeExecutionReport(startTime=" + this.getStartTime() + ", verbose=" + this.verbose + ", clock=" + this.clock + ", mainLogicExecInfos=" + this.getMainLogicExecInfos() + ")";
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Map<NodeExecution, LogicExecInfo> getMainLogicExecInfos() {
        return this.mainLogicExecInfos;
    }

    private record NodeExecution(NodeId nodeId, ImmutableList<ImmutableMap<String, Object>> inputs) {
        @Override
        public String toString() {
            return "%s(%s)".formatted(this.nodeId.value(), this.inputs);
        }
    }

    static final class LogicExecInfo {
        private final String nodeId;
        private final ImmutableList<ImmutableMap<String, Object>> inputsList;
        private final @Nullable ImmutableList<ImmutableMap<String, Object>> dependencyResults;
        private Object result;
        private final long startTimeMs;
        private long endTimeMs;

        LogicExecInfo(DefaultNodeExecutionReport nodeExecutionReport, NodeId nodeId, ImmutableCollection<Inputs> inputList, long startTimeMs) {
            this.startTimeMs = startTimeMs;
            this.nodeId = nodeId.value();
            this.inputsList = (ImmutableList)inputList.stream().map(nodeExecutionReport::extractAndConvertInputs).collect(ImmutableList.toImmutableList());
            ImmutableList dependencyResults = (ImmutableList)inputList.stream().map(nodeExecutionReport::extractAndConvertDependencyResults).filter(map -> !map.isEmpty()).collect(ImmutableList.toImmutableList());
            this.dependencyResults = dependencyResults.isEmpty() ? null : dependencyResults;
        }

        public void setResult(Map<ImmutableMap<String, Object>, Object> result) {
            this.result = this.inputsList.size() <= 1 && result.size() == 1 ? result.values().iterator().next() : result;
        }

        public String toString() {
            return "DefaultNodeExecutionReport.LogicExecInfo(nodeId=" + this.getNodeId() + ", inputsList=" + this.getInputsList() + ", dependencyResults=" + this.getDependencyResults() + ", result=" + this.getResult() + ", startTimeMs=" + this.getStartTimeMs() + ", endTimeMs=" + this.getEndTimeMs() + ")";
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public ImmutableList<ImmutableMap<String, Object>> getInputsList() {
            return this.inputsList;
        }

        public @Nullable ImmutableList<ImmutableMap<String, Object>> getDependencyResults() {
            return this.dependencyResults;
        }

        public Object getResult() {
            return this.result;
        }

        public long getStartTimeMs() {
            return this.startTimeMs;
        }

        public long getEndTimeMs() {
            return this.endTimeMs;
        }
    }
}

