/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.node;

import com.flipkart.krystal.krystex.node.Node;
import com.flipkart.krystal.krystex.node.NodeId;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public final class NodeRegistry {
    private final Map<NodeId, Node> nodes = new LinkedHashMap<NodeId, Node>();

    public Node get(NodeId nodeId) {
        return this.tryGet(nodeId).orElseThrow(() -> new IllegalArgumentException("No Node with id %s found".formatted(nodeId)));
    }

    public Optional<Node> tryGet(NodeId nodeId) {
        return Optional.ofNullable(this.nodes.get(nodeId));
    }

    public Node createIfAbsent(NodeId nodeId, Function<NodeId, Node> supplier) {
        return this.nodes.computeIfAbsent(nodeId, supplier);
    }
}

