/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.krystex.LogicDefinition;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.decoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.decoration.MainLogicDecoratorConfig;
import com.flipkart.krystal.krystex.node.DependantChain;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MainLogicDefinition<T>
extends LogicDefinition<MainLogic<T>> {
    private ImmutableMap<String, List<MainLogicDecoratorConfig>> requestScopedLogicDecoratorConfigs = ImmutableMap.of();
    private final Map<String, MainLogicDecoratorConfig> sessionScopedLogicDecoratorConfigs = new HashMap<String, MainLogicDecoratorConfig>();
    private final Map<String, Map<String, MainLogicDecorator>> sessionScopedDecorators = new LinkedHashMap<String, Map<String, MainLogicDecorator>>();

    protected MainLogicDefinition(NodeLogicId nodeLogicId, Set<String> inputs, ImmutableMap<String, Tag> logicTags, MainLogic<T> mainLogic) {
        super(nodeLogicId, inputs, logicTags, mainLogic);
    }

    public final ImmutableMap<Inputs, CompletableFuture<T>> execute(ImmutableList<Inputs> inputs) {
        return ((MainLogic)this.logic()).execute(inputs);
    }

    public ImmutableMap<String, List<MainLogicDecoratorConfig>> getRequestScopedLogicDecoratorConfigs() {
        return this.requestScopedLogicDecoratorConfigs;
    }

    public ImmutableMap<String, MainLogicDecorator> getSessionScopedLogicDecorators(NodeDefinition nodeDefinition, @Nullable DependantChain dependants) {
        LinkedHashMap decorators = new LinkedHashMap();
        this.sessionScopedLogicDecoratorConfigs.forEach((s, decoratorConfig) -> {
            LogicExecutionContext logicExecutionContext = new LogicExecutionContext(nodeDefinition.nodeId(), this.logicTags(), dependants, nodeDefinition.nodeDefinitionRegistry());
            String instanceId = decoratorConfig.instanceIdGenerator().apply(logicExecutionContext);
            if (decoratorConfig.shouldDecorate().test(logicExecutionContext)) {
                decorators.put(s, this.sessionScopedDecorators.computeIfAbsent((String)s, k -> new LinkedHashMap()).computeIfAbsent(instanceId, k -> decoratorConfig.factory().apply(new MainLogicDecoratorConfig.DecoratorContext(instanceId, logicExecutionContext))));
            }
        });
        return ImmutableMap.copyOf(decorators);
    }

    public void registerRequestScopedDecorator(Collection<MainLogicDecoratorConfig> decoratorConfigs) {
        this.requestScopedLogicDecoratorConfigs = ImmutableMap.builderWithExpectedSize((int)(this.requestScopedLogicDecoratorConfigs.size() + decoratorConfigs.size())).putAll(this.requestScopedLogicDecoratorConfigs).putAll(this.getDecoratorConfigMap(decoratorConfigs)).build();
    }

    private Map<String, List<MainLogicDecoratorConfig>> getDecoratorConfigMap(Collection<MainLogicDecoratorConfig> decoratorConfigs) {
        HashMap<String, List<MainLogicDecoratorConfig>> decoratorConfigMap = new HashMap<String, List<MainLogicDecoratorConfig>>();
        for (MainLogicDecoratorConfig mainLogicDecoratorConfig : decoratorConfigs) {
            decoratorConfigMap.putIfAbsent(mainLogicDecoratorConfig.decoratorType(), new ArrayList());
            ((List)decoratorConfigMap.get(mainLogicDecoratorConfig.decoratorType())).add(mainLogicDecoratorConfig);
        }
        return decoratorConfigMap;
    }

    public void registerSessionScopedLogicDecorator(MainLogicDecoratorConfig decoratorConfig) {
        this.sessionScopedLogicDecoratorConfigs.put(decoratorConfig.decoratorType(), decoratorConfig);
    }
}

