/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.testfixtures;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.ErrableFacetValue;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.facets.InputMirror;
import com.flipkart.krystal.krystex.testfixtures.SimpleRequest;
import com.flipkart.krystal.krystex.testfixtures.SimpleRequestBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SimpleImmutRequest<T>
implements SimpleRequest<T>,
ImmutableRequest<T> {
    private final Map<Integer, ErrableFacetValue<Object>> _data;
    private final VajramID _vajramID;

    public static <T> SimpleImmutRequest<T> empty(VajramID vajramID) {
        return new SimpleImmutRequest<T>((Map<Integer, ErrableFacetValue<Object>>)ImmutableMap.of(), vajramID);
    }

    SimpleImmutRequest(Map<Integer, ErrableFacetValue<Object>> data, VajramID vajramID) {
        this._data = ImmutableMap.copyOf(data);
        this._vajramID = vajramID;
    }

    public ErrableFacetValue<Object> _get(int facetId) {
        return this._data.getOrDefault(facetId, (ErrableFacetValue<Object>)ErrableFacetValue.nil());
    }

    public SimpleImmutRequest<T> _build() {
        return this;
    }

    public ImmutableRequest<T> _newCopy() {
        return this;
    }

    @Override
    public Map<Integer, ErrableFacetValue<Object>> _asMap() {
        return this._data;
    }

    public ImmutableSet<InputMirror> _facets() {
        return ImmutableSet.of();
    }

    public boolean _hasValue(int facetId) {
        return this._data.containsKey(facetId);
    }

    @Override
    public SimpleRequestBuilder<T> _asBuilder() {
        return new SimpleRequestBuilder((Set<InputMirror>)this._facets(), (Map<Integer, Errable<Object>>)new LinkedHashMap<Integer, Errable<Object>>(this._data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ErrableFacetValue)e.getValue()).asErrable()))), this._vajramID);
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleImmutRequest)) {
            return false;
        }
        SimpleImmutRequest other = (SimpleImmutRequest)o;
        return Objects.equals(this._asMap(), other._asMap()) && Objects.equals(this._vajramID(), other._vajramID());
    }

    public int hashCode() {
        return Objects.hash(this._data, this._vajramID);
    }

    public Map<Integer, ErrableFacetValue<Object>> _data() {
        return this._data;
    }

    public VajramID _vajramID() {
        return this._vajramID;
    }
}

