/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.caching;

import com.flipkart.krystal.concurrent.Futures;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.ExecutionItem;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.FacetValuesBuilder;
import com.flipkart.krystal.data.ImmutableFacetValuesContainer;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.krystex.caching.CacheKey;
import com.flipkart.krystal.krystex.commands.DirectForwardReceive;
import com.flipkart.krystal.krystex.commands.ForwardReceiveBatch;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonCommandResponse;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfigurator;
import com.flipkart.krystal.krystex.kryon.VajramKryonDefinition;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorationInput;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorator;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorConfig;
import com.flipkart.krystal.krystex.request.InvocationId;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class RequestLevelCache
implements KryonDecorator,
KryonExecutorConfigurator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestLevelCache.class);
    public static final String DECORATOR_TYPE = RequestLevelCache.class.getName();
    private static final Errable<Object> UNKNOWN_ERROR = Errable.withError((Throwable)new StackTracelessException("Unknown error in request cache"));
    private final Map<CacheKey, CompletableFuture<@Nullable Object>> cache = new LinkedHashMap<CacheKey, CompletableFuture<Object>>();

    @Override
    public void addToConfig(KryonExecutorConfig.KryonExecutorConfigBuilder configBuilder) {
        configBuilder.kryonDecoratorConfig(DECORATOR_TYPE, new KryonDecoratorConfig(DECORATOR_TYPE, _c -> true, _c -> DECORATOR_TYPE, _c -> this));
    }

    @Override
    public Kryon<KryonCommand<?>, KryonCommandResponse> decorateKryon(KryonDecorationInput decorationInput) {
        return new CachingDecoratedKryon(decorationInput.kryon());
    }

    @Nullable CompletableFuture<@Nullable Object> getCachedValue(CacheKey cacheKey) {
        return this.cache.get(cacheKey);
    }

    void primeCache(FacetValues request, CompletableFuture<@Nullable Object> data) {
        this.cache.put(new CacheKey((ImmutableFacetValuesContainer)request._build()), data);
    }

    private class CachingDecoratedKryon
    implements Kryon<KryonCommand<?>, KryonCommandResponse> {
        private final Kryon<KryonCommand<?>, KryonCommandResponse> kryon;

        private CachingDecoratedKryon(Kryon<KryonCommand<?>, KryonCommandResponse> kryon) {
            this.kryon = kryon;
        }

        @Override
        public VajramKryonDefinition getKryonDefinition() {
            return this.kryon.getKryonDefinition();
        }

        @Override
        public CompletableFuture<KryonCommandResponse> executeCommand(KryonCommand<?> kryonCommand) {
            if (kryonCommand instanceof ForwardReceiveBatch) {
                ForwardReceiveBatch forwardBatch = (ForwardReceiveBatch)kryonCommand;
                return this.readFromCache(this.kryon, forwardBatch);
            }
            if (kryonCommand instanceof DirectForwardReceive) {
                DirectForwardReceive directForwardReceive = (DirectForwardReceive)kryonCommand;
                return this.readFromCache(this.kryon, directForwardReceive);
            }
            return this.kryon.executeCommand(kryonCommand);
        }

        private CompletableFuture<KryonCommandResponse> readFromCache(Kryon<KryonCommand<?>, KryonCommandResponse> kryon, DirectForwardReceive command) {
            ArrayList<ExecutionItem> cacheMisses = new ArrayList<ExecutionItem>();
            for (ExecutionItem executionItem : command.executionItems()) {
                FacetValuesBuilder facetValues = executionItem.facetValues();
                CacheKey cacheKey = new CacheKey((ImmutableFacetValuesContainer)facetValues._build());
                CompletableFuture<Object> cachedFuture = RequestLevelCache.this.getCachedValue(cacheKey);
                if (cachedFuture != null) {
                    Futures.propagateCompletion(cachedFuture, (CompletableFuture)executionItem.response());
                    continue;
                }
                RequestLevelCache.this.cache.put(cacheKey, executionItem.response());
                cacheMisses.add(executionItem);
            }
            return kryon.executeCommand(new DirectForwardReceive(command.vajramID(), cacheMisses, command.dependentChain()));
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private CompletableFuture<KryonCommandResponse> readFromCache(Kryon<KryonCommand<?>, KryonCommandResponse> kryon, ForwardReceiveBatch forwardBatch) {
            Map<InvocationId, FacetValues> executableRequests = forwardBatch.executableInvocations();
            LinkedHashMap<InvocationId, FacetValues> cacheMisses = new LinkedHashMap<InvocationId, FacetValues>();
            LinkedHashMap<InvocationId, @Nullable CompletableFuture> cacheHits = new LinkedHashMap<InvocationId, CompletableFuture>();
            LinkedHashMap<K, @Nullable V> newCacheEntries = new LinkedHashMap();
            executableRequests.forEach((requestId, facets) -> {
                CacheKey cacheKey = new CacheKey((ImmutableFacetValuesContainer)facets._build());
                CompletableFuture<Object> cachedFuture = RequestLevelCache.this.getCachedValue(cacheKey);
                if (cachedFuture == null) {
                    CompletableFuture placeHolderFuture = new CompletableFuture();
                    newCacheEntries.put(requestId, placeHolderFuture);
                    RequestLevelCache.this.cache.put(cacheKey, placeHolderFuture);
                    cacheMisses.put((InvocationId)requestId, (FacetValues)facets._build());
                } else {
                    cacheHits.put((InvocationId)requestId, cachedFuture);
                }
            });
            LinkedHashMap<InvocationId, String> skippedRequests = new LinkedHashMap<InvocationId, String>(forwardBatch.invocationsToSkip());
            cacheHits.forEach((requestId, _f) -> skippedRequests.put((InvocationId)requestId, "Skipping due to cache hit!"));
            CompletableFuture<KryonCommandResponse> cacheMissesResponse = kryon.executeCommand(new ForwardReceiveBatch(forwardBatch.vajramID(), cacheMisses, forwardBatch.dependentChain(), skippedRequests));
            cacheMissesResponse.whenComplete((kryonResponse, throwable) -> {
                if (kryonResponse instanceof BatchResponse) {
                    BatchResponse batchResponse = (BatchResponse)kryonResponse;
                    Map<InvocationId, Errable<Object>> responses = batchResponse.responses();
                    responses.forEach((requestId, response) -> {
                        @Nullable CompletableFuture future = response.toFuture();
                        @Nullable CompletableFuture destinationFuture = newCacheEntries.computeIfAbsent(requestId, _r -> new CompletableFuture());
                        Futures.linkFutures((CompletableFuture)future, (CompletableFuture)destinationFuture);
                    });
                } else if (throwable != null) {
                    cacheMisses.forEach((requestId, response) -> newCacheEntries.computeIfAbsent(requestId, _r -> new CompletableFuture()).completeExceptionally(StackTracelessException.stackTracelessWrap((Throwable)throwable)));
                } else {
                    @Nullable RuntimeException e = new RuntimeException("Expecting BatchResponse. Found " + String.valueOf(kryonResponse));
                    log.error("", (Throwable)e);
                    throw e;
                }
            });
            CompletableFuture<KryonCommandResponse> finalResponse = new CompletableFuture<KryonCommandResponse>();
            @Nullable Iterable allFutures = Iterables.concat(cacheHits.entrySet(), newCacheEntries.entrySet());
            CompletableFuture[] allFuturesArray = new CompletableFuture[cacheHits.size() + newCacheEntries.size()];
            int i = 0;
            for (Map.Entry e : allFutures) {
                allFuturesArray[i++] = (CompletableFuture)e.getValue();
            }
            CompletableFuture.allOf(allFuturesArray).whenComplete((unused, throwable) -> {
                LinkedHashMap<InvocationId, Errable<Object>> responses = new LinkedHashMap<InvocationId, Errable<Object>>();
                for (Map.Entry e : allFutures) {
                    responses.put((InvocationId)e.getKey(), ((CompletableFuture)((CompletableFuture)e.getValue()).handle(Errable::errableFrom)).getNow(UNKNOWN_ERROR));
                }
                finalResponse.complete(new BatchResponse(responses));
            });
            return finalResponse;
        }
    }
}

