/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex;

import com.flipkart.krystal.krystex.LogicDefinition;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.resolution.MultiResolver;
import com.flipkart.krystal.krystex.resolution.ResolverLogic;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

public final class LogicDefinitionRegistry {
    private final Map<KryonLogicId, OutputLogicDefinition<?>> outputLogicDefinitions = new ConcurrentHashMap();
    private final Map<KryonLogicId, LogicDefinition<ResolverLogic>> resolverLogicDefinitions = new ConcurrentHashMap<KryonLogicId, LogicDefinition<ResolverLogic>>();
    private final Map<KryonLogicId, LogicDefinition<MultiResolver>> multiResolverDefinitions = new ConcurrentHashMap<KryonLogicId, LogicDefinition<MultiResolver>>();

    public <T> OutputLogicDefinition<T> getOutputLogic(KryonLogicId kryonLogicId) {
        OutputLogicDefinition<?> outputLogicDefinition = this.outputLogicDefinitions.get(kryonLogicId);
        if (outputLogicDefinition == null) {
            throw new NoSuchElementException("Could not find outputLogicDefinition for " + String.valueOf(kryonLogicId));
        }
        return outputLogicDefinition;
    }

    public LogicDefinition<MultiResolver> getMultiResolver(KryonLogicId kryonLogicId) {
        LogicDefinition<MultiResolver> multiResolverDefinition = this.multiResolverDefinitions.get(kryonLogicId);
        if (multiResolverDefinition == null) {
            throw new NoSuchElementException("Could not find multiResolverDefinition for " + String.valueOf(kryonLogicId));
        }
        return multiResolverDefinition;
    }

    public LogicDefinition<ResolverLogic> getResolver(KryonLogicId resolverLogicId) {
        LogicDefinition<ResolverLogic> resolverLogicDefinition = this.resolverLogicDefinitions.get(resolverLogicId);
        if (resolverLogicDefinition == null) {
            throw new NoSuchElementException("Could not find resolverLogicDefinition for " + String.valueOf(resolverLogicId));
        }
        return resolverLogicDefinition;
    }

    public void addOutputLogic(OutputLogicDefinition<?> outputLogicDefinition) {
        if (this.outputLogicDefinitions.containsKey(outputLogicDefinition.kryonLogicId())) {
            return;
        }
        this.outputLogicDefinitions.put(outputLogicDefinition.kryonLogicId(), outputLogicDefinition);
    }

    public void addResolver(LogicDefinition<ResolverLogic> def) {
        if (this.resolverLogicDefinitions.containsKey(def.kryonLogicId())) {
            return;
        }
        this.resolverLogicDefinitions.put(def.kryonLogicId(), def);
    }

    public void addMultiResolver(LogicDefinition<MultiResolver> def) {
        if (this.multiResolverDefinitions.containsKey(def.kryonLogicId())) {
            return;
        }
        this.multiResolverDefinitions.put(def.kryonLogicId(), def);
    }

    public void validate() {
    }
}

