/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.logicdecorators.observability;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.Failure;
import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.Facet;
import com.flipkart.krystal.facets.InputMirror;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.logicdecorators.observability.KryonExecutionReport;
import com.flipkart.krystal.krystex.logicdecorators.observability.LogicExecResponse;
import com.flipkart.krystal.krystex.logicdecorators.observability.LogicExecResults;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultKryonExecutionReport
implements KryonExecutionReport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultKryonExecutionReport.class);
    @JsonProperty
    private final Instant startTime;
    private final boolean verbose;
    private final Clock clock;
    private static final String SHA_256 = "SHA-256";
    private static final @NonNull MessageDigest digest = DefaultKryonExecutionReport.initMessageDigest();
    @JsonProperty
    private final Map<KryonExecution, LogicExecInfo> mainLogicExecInfos = new LinkedHashMap<KryonExecution, LogicExecInfo>();
    @JsonProperty
    private final Map<String, Object> dataMap = new HashMap<String, Object>();

    static MessageDigest initMessageDigest() {
        try {
            return MessageDigest.getInstance(SHA_256);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Error could not hash inputs because of exception ", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public DefaultKryonExecutionReport(Clock clock) {
        this(clock, false);
    }

    public DefaultKryonExecutionReport(Clock clock, boolean verbose) {
        this.clock = clock;
        this.startTime = clock.instant();
        this.verbose = verbose;
    }

    @Override
    public void reportMainLogicStart(VajramID vajramID, KryonLogicId kryonLogicId, ImmutableList<? extends FacetValues> inputs) {
        KryonExecution kryonExecution = new KryonExecution(vajramID, (ImmutableList<ImmutableMap<Facet, String>>)((ImmutableList)inputs.stream().map(facets -> this.extractAndConvertFacets((FacetValues)facets)).collect(ImmutableList.toImmutableList())));
        if (this.mainLogicExecInfos.containsKey(kryonExecution)) {
            log.error("Cannot start the same kryon execution multiple times: {}", (Object)kryonExecution);
            return;
        }
        this.mainLogicExecInfos.put(kryonExecution, new LogicExecInfo(this, vajramID, (ImmutableCollection<? extends FacetValues>)inputs, this.startTime.until(this.clock.instant(), ChronoUnit.MILLIS)));
    }

    @Override
    public void reportMainLogicEnd(VajramID vajramID, KryonLogicId kryonLogicId, LogicExecResults logicExecResults) {
        KryonExecution kryonExecution = new KryonExecution(vajramID, (ImmutableList<ImmutableMap<Facet, String>>)((ImmutableList)logicExecResults.responses().stream().map(LogicExecResponse::facetValues).map(facets -> this.extractAndConvertFacets((FacetValues)facets)).collect(ImmutableList.toImmutableList())));
        LogicExecInfo logicExecInfo = this.mainLogicExecInfos.get(kryonExecution);
        if (logicExecInfo == null) {
            log.error("'reportMainLogicEnd' called without calling 'reportMainLogicStart' first for: {}", (Object)kryonExecution);
            return;
        }
        if (logicExecInfo.result() != null) {
            log.error("Cannot end the same kryon execution multiple times: {}", (Object)kryonExecution);
            return;
        }
        logicExecInfo.endTimeMs = this.startTime.until(this.clock.instant(), ChronoUnit.MILLIS);
        logicExecInfo.setResult(this.convertResult(logicExecResults));
    }

    private ImmutableMap<InputMirror, String> extractAndConvertFacets(Request<?> request) {
        LinkedHashMap inputMap = new LinkedHashMap();
        request._facets().stream().forEach(inputDef -> inputMap.put(inputDef, this.convertValue(inputDef.getFromRequest(request))));
        return ImmutableMap.copyOf(inputMap);
    }

    private ImmutableMap<Facet, String> extractAndConvertFacets(FacetValues facetValues) {
        LinkedHashMap inputMap = new LinkedHashMap();
        facetValues._facets().stream().forEach(facetDef -> {
            FacetValue value = facetDef.getFacetValue(facetValues);
            if (!(value instanceof Errable)) {
                return;
            }
            String collect = this.convertErrable((Errable)value);
            if (collect != null) {
                inputMap.put(facetDef, collect);
            }
        });
        return ImmutableMap.copyOf(inputMap);
    }

    private ImmutableMap<Facet, Object> extractAndConvertDependencyResults(FacetValues facetValues, ImmutableSet<? extends Facet> facetDefs) {
        LinkedHashMap inputMap = new LinkedHashMap();
        facetDefs.stream().forEach(facetDef -> {
            FacetValue value = facetDef.getFacetValue(facetValues);
            if (!(value instanceof FanoutDepResponses)) {
                return;
            }
            FanoutDepResponses depResponses = (FanoutDepResponses)value;
            inputMap.put(facetDef, this.convertResult(depResponses));
        });
        return ImmutableMap.copyOf(inputMap);
    }

    private String convertErrable(Errable<?> voe) {
        String sha256;
        if (voe instanceof Failure) {
            Failure f = (Failure)voe;
            Throwable throwable = f.error();
            String stackTraceAsString = Throwables.getStackTraceAsString((Throwable)throwable);
            sha256 = this.verbose ? DefaultKryonExecutionReport.hashValues(stackTraceAsString) : DefaultKryonExecutionReport.hashValues(throwable.toString());
            this.dataMap.put(sha256, this.verbose ? stackTraceAsString : throwable.toString());
        } else {
            sha256 = this.convertValue(voe.valueOpt().orElse(null));
        }
        return sha256;
    }

    private String convertValue(@Nullable Object value) {
        if (value == null) {
            value = "null";
        }
        String sha256 = DefaultKryonExecutionReport.hashValues(value);
        this.dataMap.put(sha256, value);
        return sha256;
    }

    private Map<ImmutableMap<InputMirror, String>, Object> convertResult(FanoutDepResponses<?, ?> depResponses) {
        return depResponses.requestResponsePairs().stream().collect(Collectors.toMap(e -> this.extractAndConvertFacets(e.request()), e -> this.convertErrable(e.response())));
    }

    private Map<ImmutableMap<Facet, String>, String> convertResult(LogicExecResults logicExecResults) {
        return logicExecResults.responses().stream().collect(Collectors.toMap(e -> this.extractAndConvertFacets(e.facetValues()), e -> this.convertErrable(e.response()), (o1, o2) -> o1));
    }

    public static <T> String hashValues(@Nullable T input) {
        return DefaultKryonExecutionReport.hashString(String.valueOf(input));
    }

    private static String hashString(String appendedInput) {
        byte[] encodedHash = digest.digest(appendedInput.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encodedHash);
    }

    @Generated
    public @NonNull String toString() {
        return "DefaultKryonExecutionReport(startTime=" + this.startTime() + ", verbose=" + this.verbose + ", clock=" + this.clock + ", mainLogicExecInfos=" + this.mainLogicExecInfos() + ", dataMap=" + this.dataMap() + ")";
    }

    @Generated
    public Instant startTime() {
        return this.startTime;
    }

    @Generated
    public Map<KryonExecution, LogicExecInfo> mainLogicExecInfos() {
        return this.mainLogicExecInfos;
    }

    @Generated
    public Map<String, Object> dataMap() {
        return this.dataMap;
    }

    private record KryonExecution(VajramID vajramID, ImmutableList<ImmutableMap<Facet, String>> inputs) {
        @Override
        public String toString() {
            return "%s(%s)".formatted(this.vajramID.id(), this.inputs);
        }
    }

    static final class LogicExecInfo {
        @JsonProperty
        private final String kryonId;
        @JsonProperty
        private final ImmutableList<ImmutableMap<Facet, String>> inputsList;
        @JsonProperty
        private final @Nullable ImmutableList<ImmutableMap<Facet, Object>> dependencyResults;
        @JsonProperty
        private @Nullable Object result;
        @JsonProperty
        private final long startTimeMs;
        @JsonProperty
        private long endTimeMs;

        LogicExecInfo(DefaultKryonExecutionReport kryonExecutionReport, VajramID vajramID, ImmutableCollection<? extends FacetValues> inputList, long startTimeMs) {
            this.startTimeMs = startTimeMs;
            this.kryonId = vajramID.id();
            this.inputsList = (ImmutableList)inputList.stream().map(facets -> kryonExecutionReport.extractAndConvertFacets((FacetValues)facets)).collect(ImmutableList.toImmutableList());
            ImmutableList dependencyResults = (ImmutableList)inputList.stream().map(facets -> kryonExecutionReport.extractAndConvertDependencyResults((FacetValues)facets, (ImmutableSet<? extends Facet>)facets._facets())).filter(map -> !map.isEmpty()).collect(ImmutableList.toImmutableList());
            this.dependencyResults = dependencyResults.isEmpty() ? null : dependencyResults;
        }

        public void setResult(Map<ImmutableMap<Facet, String>, String> result) {
            this.result = this.inputsList.size() <= 1 && result.size() == 1 ? result.values().iterator().next() : result;
        }

        @Generated
        public @NonNull String toString() {
            return "DefaultKryonExecutionReport.LogicExecInfo(kryonId=" + this.kryonId() + ", inputsList=" + this.inputsList() + ", dependencyResults=" + this.dependencyResults() + ", result=" + this.result() + ", startTimeMs=" + this.startTimeMs() + ", endTimeMs=" + this.endTimeMs() + ")";
        }

        @Generated
        public String kryonId() {
            return this.kryonId;
        }

        @Generated
        public ImmutableList<ImmutableMap<Facet, String>> inputsList() {
            return this.inputsList;
        }

        @Generated
        public @Nullable ImmutableList<ImmutableMap<Facet, Object>> dependencyResults() {
            return this.dependencyResults;
        }

        @Generated
        public @Nullable Object result() {
            return this.result;
        }

        @Generated
        public long startTimeMs() {
            return this.startTimeMs;
        }

        @Generated
        public long endTimeMs() {
            return this.endTimeMs;
        }
    }
}

