/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.annos.InvocableOutsideGraph;
import com.flipkart.krystal.annos.TraitDependency;
import com.flipkart.krystal.concurrent.Futures;
import com.flipkart.krystal.concurrent.SingleThreadExecutor;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.krystex.KrystalExecutor;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardReceive;
import com.flipkart.krystal.krystex.commands.ForwardSend;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.commands.VoidResponse;
import com.flipkart.krystal.krystex.decoration.InitiateActiveDepChains;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyDecorator;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyDecoratorConfig;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyExecutionContext;
import com.flipkart.krystal.krystex.dependencydecorators.TraitDispatchDecorator;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.DependentChain;
import com.flipkart.krystal.krystex.kryon.DisabledDependentChainException;
import com.flipkart.krystal.krystex.kryon.FlushableKryon;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonCommandResponse;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonDefinitionRegistry;
import com.flipkart.krystal.krystex.kryon.KryonExecutionConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutorMetrics;
import com.flipkart.krystal.krystex.kryon.KryonRegistry;
import com.flipkart.krystal.krystex.kryon.KryonUtils;
import com.flipkart.krystal.krystex.kryon.TraitKryonDefinition;
import com.flipkart.krystal.krystex.kryon.VajramKryonDefinition;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorationInput;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorator;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorConfig;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorContext;
import com.flipkart.krystal.krystex.kryondecoration.KryonExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecoratorConfig;
import com.flipkart.krystal.krystex.request.IntReqGenerator;
import com.flipkart.krystal.krystex.request.InvocationId;
import com.flipkart.krystal.krystex.request.RequestIdGenerator;
import com.flipkart.krystal.krystex.request.StringReqGenerator;
import com.flipkart.krystal.traits.PredicateDynamicDispatchPolicy;
import com.flipkart.krystal.traits.StaticDispatchPolicy;
import com.flipkart.krystal.traits.TraitDispatchPolicy;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KryonExecutor
implements KrystalExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KryonExecutor.class);
    private final KryonDefinitionRegistry kryonDefinitionRegistry;
    private final KryonExecutorConfig executorConfig;
    private final SingleThreadExecutor commandQueue;
    private final String executorId;
    private final ImmutableMap<String, OutputLogicDecoratorConfig> outputLogicDecoratorConfigs;
    private final ImmutableMap<String, DependencyDecoratorConfig> dependencyDecoratorConfigs;
    private final ImmutableMap<String, KryonDecoratorConfig> kryonDecoratorConfigs;
    private final Map<String, Map<String, OutputLogicDecorator>> outputLogicDecorators = new LinkedHashMap<String, Map<String, OutputLogicDecorator>>();
    private final Map<String, Map<String, KryonDecorator>> kryonDecorators = new LinkedHashMap<String, Map<String, KryonDecorator>>();
    private final Map<String, Map<String, DependencyDecorator>> dependencyDecorators = new LinkedHashMap<String, Map<String, DependencyDecorator>>();
    private final KryonRegistry<?> kryonRegistry = new KryonRegistry();
    private final Map<VajramID, Kryon<?, ?>> decoratedKryons = new HashMap();
    private final KryonExecutorMetrics kryonMetrics;
    private final Map<InvocationId, KryonExecution> allExecutions = new LinkedHashMap<InvocationId, KryonExecution>();
    private final Set<InvocationId> unFlushedExecutions = new LinkedHashSet<InvocationId>();
    private final Map<VajramID, Set<DependentChain>> dependentChainsPerKryon = new LinkedHashMap<VajramID, Set<DependentChain>>();
    private final RequestIdGenerator preferredReqGenerator;
    private final Set<DependentChain> depChainsDisabledInAllExecutions = new LinkedHashSet<DependentChain>();
    private volatile boolean closed;
    private boolean shutdownRequested;

    public KryonExecutor(KryonDefinitionRegistry kryonDefinitionRegistry, KryonExecutorConfig executorConfig) {
        this.kryonDefinitionRegistry = kryonDefinitionRegistry;
        this.executorConfig = executorConfig;
        this.commandQueue = executorConfig.executorService();
        this.executorId = executorConfig.executorId();
        this.outputLogicDecoratorConfigs = executorConfig.outputLogicDecoratorConfigs();
        this.dependencyDecoratorConfigs = KryonExecutor.makeDependencyDecorConfigs(executorConfig);
        this.kryonDecoratorConfigs = executorConfig.kryonDecoratorConfigs();
        this.kryonMetrics = new KryonExecutorMetrics();
        this.preferredReqGenerator = executorConfig.debug() ? new StringReqGenerator() : new IntReqGenerator();
    }

    private static ImmutableMap<String, DependencyDecoratorConfig> makeDependencyDecorConfigs(KryonExecutorConfig executorConfig) {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(executorConfig.dependencyDecoratorConfigs());
        TraitDispatchDecorator traitDispatchDecorator = executorConfig.traitDispatchDecorator();
        if (traitDispatchDecorator != null) {
            String decoratorType = traitDispatchDecorator.decoratorType();
            builder.put((Object)decoratorType, (Object)new DependencyDecoratorConfig(decoratorType, dependencyExecutionContext -> dependencyExecutionContext.dependency().tags().getAnnotationByType(TraitDependency.class).isPresent(), d -> decoratorType, c -> traitDispatchDecorator));
        }
        return builder.build();
    }

    private NavigableSet<OutputLogicDecorator> getOutputLogicDecorators(LogicExecutionContext logicExecutionContext) {
        VajramID vajramID = logicExecutionContext.vajramID();
        TreeSet<OutputLogicDecorator> decorators = new TreeSet<OutputLogicDecorator>(this.executorConfig.decorationOrdering().encounterOrder().reversed());
        this.outputLogicDecoratorConfigs.forEach((decoratorType, decoratorConfig) -> {
            if (decoratorConfig.shouldDecorate().test(logicExecutionContext)) {
                String instanceId = decoratorConfig.instanceIdGenerator().apply(logicExecutionContext);
                OutputLogicDecorator outputLogicDecorator = this.outputLogicDecorators.computeIfAbsent((String)decoratorType, t -> new LinkedHashMap()).computeIfAbsent(instanceId, _i -> {
                    OutputLogicDecorator logicDecorator = decoratorConfig.factory().apply(new OutputLogicDecoratorConfig.OutputLogicDecoratorContext(instanceId, logicExecutionContext));
                    logicDecorator.executeCommand(new InitiateActiveDepChains(vajramID, Collections.unmodifiableSet(this.dependentChainsPerKryon.getOrDefault(vajramID, (Set<DependentChain>)ImmutableSet.of()))));
                    return logicDecorator;
                });
                decorators.add(outputLogicDecorator);
            }
        });
        return decorators;
    }

    private ImmutableMap<String, DependencyDecorator> getDependencyDecorators(DependencyExecutionContext dependencyExecutionContext) {
        LinkedHashMap<String, DependencyDecorator> decorators = new LinkedHashMap<String, DependencyDecorator>();
        for (Map.Entry entry : this.dependencyDecoratorConfigs.entrySet()) {
            String decoratorType = (String)entry.getKey();
            DependencyDecoratorConfig decoratorConfig = (DependencyDecoratorConfig)entry.getValue();
            if (!decoratorConfig.shouldDecorate().test(dependencyExecutionContext)) continue;
            String instanceId = decoratorConfig.instanceIdGenerator().apply(dependencyExecutionContext);
            DependencyDecorator dependencyDecorator = this.dependencyDecorators.computeIfAbsent(decoratorType, s -> new LinkedHashMap()).computeIfAbsent(instanceId, s -> decoratorConfig.factory().apply(dependencyExecutionContext));
            decorators.put(decoratorType, dependencyDecorator);
        }
        return ImmutableMap.copyOf(decorators);
    }

    @Override
    public <T> CompletableFuture<@Nullable T> executeKryon(ImmutableRequest request, KryonExecutionConfig executionConfig) {
        if (this.closed) {
            throw new RejectedExecutionException("KryonExecutor is already closed");
        }
        Preconditions.checkArgument((executionConfig != null ? 1 : 0) != 0, (Object)"executionConfig can not be null");
        VajramID vajramID = request._vajramID();
        boolean openAllKryonsForExternalInvocation = this.executorConfig._riskyOpenAllKryonsForExternalInvocation();
        if (!openAllKryonsForExternalInvocation && this.kryonDefinitionRegistry.getOrThrow(vajramID).tags().getAnnotationByType(InvocableOutsideGraph.class).isEmpty()) {
            throw new RejectedExecutionException("External invocation is not allowed for vajramId: " + vajramID);
        }
        String executionId = executionConfig.executionId();
        Preconditions.checkArgument((executionId != null ? 1 : 0) != 0, (Object)"executionConfig.executionId can not be null");
        InvocationId invocationId = this.preferredReqGenerator.newRequest("%s:%s".formatted(this.executorId, executionId));
        return this.enqueueCommand(() -> {
            this.createDependencyKryons(vajramID, this.kryonDefinitionRegistry.getDependentChainsStart(), executionConfig);
            CompletableFuture<@Nullable Object> future = new CompletableFuture<Object>();
            if (this.allExecutions.containsKey(invocationId)) {
                future.completeExceptionally(StackTracelessException.stackTracelessWrap((Throwable)new IllegalArgumentException("Received duplicate requests for same instanceId '%s' and execution Id '%s'".formatted(this.executorId, executionId))));
            } else {
                this.allExecutions.put(invocationId, new KryonExecution(vajramID, invocationId, (ImmutableRequest<Object>)request, executionConfig, future));
                this.unFlushedExecutions.add(invocationId);
            }
            CompletableFuture<@Nullable Object> f = future;
            return f;
        }).thenCompose(Function.identity());
    }

    private void createDependencyKryons(VajramID vajramID, DependentChain dependentChain, KryonExecutionConfig executionConfig) {
        if (Sets.union(this.executorConfig.disabledDependentChains(), executionConfig.disabledDependentChains()).contains((Object)dependentChain)) {
            return;
        }
        KryonDefinition kryonDefinition = this.kryonDefinitionRegistry.get(vajramID);
        ArrayList<VajramID> concreteVajramIds = new ArrayList<VajramID>();
        if (kryonDefinition instanceof TraitKryonDefinition) {
            @Nullable TraitDispatchPolicy traitDispatchPolicy = (TraitDispatchPolicy)this.executorConfig.traitDispatchDecorator().traitDispatchPolicies().get((Object)vajramID);
            if (traitDispatchPolicy == null) {
                throw new IllegalArgumentException("Trait " + vajramID + " found but no TraitDispatchPolicy provided in the executorConfig");
            }
            if (traitDispatchPolicy instanceof StaticDispatchPolicy) {
                VajramID boundVajram;
                StaticDispatchPolicy staticDispatchPolicy = (StaticDispatchPolicy)traitDispatchPolicy;
                Dependency latestDependency = dependentChain.latestDependency();
                try {
                    boundVajram = latestDependency != null ? staticDispatchPolicy.get(latestDependency) : staticDispatchPolicy.get(executionConfig.staticDispatchQualifier());
                }
                catch (Throwable throwable) {
                    throw new IllegalArgumentException("Error while getting bound vajram for trait with ID: " + vajramID);
                }
                concreteVajramIds.add(boundVajram);
            } else if (traitDispatchPolicy instanceof PredicateDynamicDispatchPolicy) {
                PredicateDynamicDispatchPolicy dynamicDispatcher = (PredicateDynamicDispatchPolicy)traitDispatchPolicy;
                concreteVajramIds.addAll((Collection<VajramID>)dynamicDispatcher.dispatchTargets());
            }
        } else {
            concreteVajramIds.add(vajramID);
        }
        for (VajramID finalVajramId : concreteVajramIds) {
            ImmutableMap<Dependency, VajramID> dependencyKryons = ImmutableMap.of();
            kryonDefinition = this.kryonDefinitionRegistry.getOrThrow(finalVajramId);
            if (kryonDefinition instanceof VajramKryonDefinition) {
                VajramKryonDefinition vajramKryonDefinition = (VajramKryonDefinition)kryonDefinition;
                this.createKryonIfAbsent(finalVajramId, vajramKryonDefinition);
                dependencyKryons = vajramKryonDefinition.dependencyKryons();
            }
            dependencyKryons.forEach((dependency, depKryonId) -> this.createDependencyKryons((VajramID)depKryonId, dependentChain.extend(finalVajramId, (Dependency)dependency), executionConfig));
            this.dependentChainsPerKryon.computeIfAbsent(finalVajramId, _n -> new LinkedHashSet()).add(dependentChain);
        }
    }

    private Kryon<? extends KryonCommand, ? extends KryonCommandResponse> createKryonIfAbsent(VajramID vajramID, VajramKryonDefinition kryonDefinition) {
        KryonRegistry<?> batchKryonRegistry = this.kryonRegistry;
        return batchKryonRegistry.createIfAbsent(vajramID, _n -> new FlushableKryon(kryonDefinition, this, this::getOutputLogicDecorators, this::getDependencyDecorators, this.executorConfig.decorationOrdering(), this.preferredReqGenerator));
    }

    <R extends KryonCommandResponse> CompletableFuture<R> enqueueKryonCommand(Supplier<? extends KryonCommand> kryonCommand) {
        return this.enqueueCommand(() -> this._executeCommand((KryonCommand)kryonCommand.get())).thenCompose(Function.identity());
    }

    public <R extends KryonCommandResponse> CompletableFuture<R> executeCommand(KryonCommand<R> kryonCommand) {
        if (GraphTraversalStrategy.BREADTH.equals((Object)this.executorConfig.graphTraversalStrategy())) {
            return this.enqueueKryonCommand(() -> kryonCommand);
        }
        this.kryonMetrics.commandQueueBypassed();
        return this._executeCommand(kryonCommand);
    }

    private <R extends KryonCommandResponse> CompletableFuture<R> _executeCommand(KryonCommand kryonCommand) {
        try {
            if (kryonCommand instanceof ForwardSend) {
                ForwardSend forwardSend = (ForwardSend)kryonCommand;
                VajramKryonDefinition vajramKryonDefinition = KryonUtils.validateAsVajram(this.kryonDefinitionRegistry.getOrThrow(kryonCommand.vajramID()));
                return this._executeCommand(new ForwardReceive(forwardSend.vajramID(), (Map)forwardSend.executableRequests().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> vajramKryonDefinition.facetsFromRequest().logic().facetsFromRequest((Request)e.getValue()))), forwardSend.dependentChain(), forwardSend.skippedInvocations()));
            }
            try {
                this.validate(kryonCommand);
            }
            catch (Throwable e2) {
                return CompletableFuture.failedFuture(e2);
            }
            VajramID vajramID = kryonCommand.vajramID();
            VajramKryonDefinition kryonDefinition = KryonUtils.validateAsVajram(this.kryonDefinitionRegistry.getOrThrow(vajramID));
            Kryon<KryonCommand, R> kryon = this.getDecoratedKryon(kryonCommand, vajramID);
            if (kryonCommand instanceof Flush) {
                Flush flush = (Flush)kryonCommand;
                kryon.executeCommand(flush);
                CompletableFuture<VoidResponse> f = CompletableFuture.completedFuture(VoidResponse.getInstance());
                return f;
            }
            return kryon.executeCommand(kryonCommand);
        }
        catch (Throwable e3) {
            return CompletableFuture.failedFuture(e3);
        }
    }

    private <R extends KryonCommandResponse> Kryon<KryonCommand, R> getDecoratedKryon(KryonCommand kryonCommand, VajramID kryonId) {
        return this.decoratedKryons.computeIfAbsent(kryonId, _n -> {
            Object kryon = this.kryonRegistry.get(kryonId);
            for (KryonDecorator kryonDecorator : this.getSortedKryonDecorators(kryonId, kryonCommand)) {
                kryon = kryonDecorator.decorateKryon(new KryonDecorationInput((Kryon<KryonCommand, KryonCommandResponse>)kryon, this));
            }
            return kryon;
        });
    }

    private Set<KryonDecorator> getSortedKryonDecorators(VajramID vajramID, KryonCommand kryonCommand) {
        KryonExecutionContext executionContext = new KryonExecutionContext(vajramID, kryonCommand.dependentChain());
        TreeSet<KryonDecorator> sortedDecorators = new TreeSet<KryonDecorator>(this.executorConfig.decorationOrdering().encounterOrder().reversed());
        for (Map.Entry configsByType : this.kryonDecoratorConfigs.entrySet()) {
            String decoratorType = (String)configsByType.getKey();
            KryonDecoratorConfig decoratorConfig = (KryonDecoratorConfig)configsByType.getValue();
            if (!decoratorConfig.shouldDecorate().test(executionContext)) continue;
            String instanceId = decoratorConfig.instanceIdGenerator().apply(executionContext);
            sortedDecorators.add(this.kryonDecorators.computeIfAbsent(decoratorType, _t -> new LinkedHashMap()).computeIfAbsent(instanceId, _i -> decoratorConfig.factory().apply(new KryonDecoratorContext(instanceId, executionContext))));
        }
        return sortedDecorators;
    }

    private void validate(KryonCommand kryonCommand) {
        if (this.shutdownRequested) {
            throw new RejectedExecutionException("Kryon Executor shutdown requested.");
        }
        DependentChain dependentChain = kryonCommand.dependentChain();
        if (this.depChainsDisabledInAllExecutions.contains(dependentChain)) {
            throw new DisabledDependentChainException(dependentChain);
        }
    }

    private void flush() {
        this.enqueueRunnable(() -> {
            this.computeDisabledDependentChains();
            this.submitBatch(this.unFlushedExecutions);
            this.unFlushedExecutions.stream().map(requestId -> this.getKryonExecution((InvocationId)requestId).vajramID()).distinct().forEach(kryonId -> this.executorConfig.traitDispatchDecorator().decorateDependency(this::executeCommand).invokeDependency(new Flush((VajramID)kryonId, this.kryonDefinitionRegistry.getDependentChainsStart())));
        });
    }

    private void computeDisabledDependentChains() {
        this.depChainsDisabledInAllExecutions.clear();
        List<ImmutableSet> disabledDependantChainsPerExecution = this.unFlushedExecutions.stream().map(this::getKryonExecution).map(KryonExecution::executionConfig).map(KryonExecutionConfig::disabledDependentChains).toList();
        disabledDependantChainsPerExecution.stream().filter(x -> !x.isEmpty()).findAny().ifPresent(this.depChainsDisabledInAllExecutions::addAll);
        for (Set set : disabledDependantChainsPerExecution) {
            if (this.depChainsDisabledInAllExecutions.isEmpty()) break;
            this.depChainsDisabledInAllExecutions.retainAll(set);
        }
        this.depChainsDisabledInAllExecutions.addAll((Collection<DependentChain>)this.executorConfig.disabledDependentChains());
    }

    private KryonExecution getKryonExecution(InvocationId invocationId) {
        KryonExecution kryonExecution = this.allExecutions.get(invocationId);
        if (kryonExecution == null) {
            throw new AssertionError((Object)("No kryon execution found for requestId " + invocationId));
        }
        return kryonExecution;
    }

    private void submitBatch(Set<InvocationId> unFlushedRequests) {
        Map<VajramID, List<KryonExecution>> executionsByKryon = unFlushedRequests.stream().map(this::getKryonExecution).collect(Collectors.groupingBy(KryonExecution::vajramID));
        executionsByKryon.forEach((kryonId, kryonExecutions) -> {
            CompletableFuture<BatchResponse> batchResponseFuture;
            try {
                LinkedHashMap<InvocationId, Request<@Nullable Object>> requests = new LinkedHashMap<InvocationId, Request<Object>>(kryonExecutions.size());
                for (KryonExecution kryonExecution : kryonExecutions) {
                    requests.put(kryonExecution.instanceExecutionId(), (Request<Object>)kryonExecution.request());
                }
                batchResponseFuture = this.executorConfig.traitDispatchDecorator().decorateDependency(this::executeCommand).invokeDependency(new ForwardSend((VajramID)kryonId, (Map<InvocationId, Request<Object>>)requests, this.kryonDefinitionRegistry.getDependentChainsStart(), (Map<InvocationId, String>)ImmutableMap.of()));
            }
            catch (Throwable throwable2) {
                batchResponseFuture = CompletableFuture.completedFuture(new BatchResponse((Map)kryonExecutions.stream().collect(ImmutableMap.toImmutableMap(KryonExecution::instanceExecutionId, _k -> Errable.withError((Throwable)throwable2)))));
            }
            ((CompletableFuture)batchResponseFuture.thenApply(BatchResponse::responses)).whenComplete((responses, throwable) -> {
                for (KryonExecution kryonExecution : kryonExecutions) {
                    if (throwable != null) {
                        kryonExecution.future().completeExceptionally(StackTracelessException.stackTracelessWrap((Throwable)throwable));
                        continue;
                    }
                    Futures.linkFutures((CompletableFuture)responses.getOrDefault(kryonExecution.instanceExecutionId(), Errable.nil()).toFuture(), kryonExecution.future());
                }
            });
            Futures.propagateCancellation(CompletableFuture.allOf((CompletableFuture[])kryonExecutions.stream().map(KryonExecutor.getFuture()).toArray(CompletableFuture[]::new)), batchResponseFuture);
        });
    }

    public KryonExecutorMetrics getKryonMetrics() {
        return this.kryonMetrics;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this._close0();
        this.flush();
        this.enqueueCommand(() -> CompletableFuture.allOf((CompletableFuture[])this.allExecutions.values().stream().map(KryonExecutor.getFuture()).toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> {
            for (Map.Entry<String, Map<String, OutputLogicDecorator>> decoratorsDetails : this.outputLogicDecorators.entrySet()) {
                Map<String, OutputLogicDecorator> decoratorsDetailsValue = decoratorsDetails.getValue();
                for (Map.Entry<String, OutputLogicDecorator> decorator : decoratorsDetailsValue.entrySet()) {
                    decorator.getValue().onComplete();
                }
            }
        }));
    }

    @Override
    public void shutdownNow() {
        this._close0();
        this.shutdownRequested = true;
    }

    private void _close0() {
        this.closed = true;
    }

    private static Function<KryonExecution, CompletableFuture<@Nullable Object>> getFuture() {
        return KryonExecution::future;
    }

    private void enqueueRunnable(Runnable command) {
        this.enqueueCommand(() -> {
            command.run();
            return new Object();
        });
    }

    private <T> CompletableFuture<T> enqueueCommand(Supplier<T> command) {
        return CompletableFuture.supplyAsync(() -> {
            this.kryonMetrics.commandQueued();
            return command.get();
        }, (Executor)this.commandQueue);
    }

    @Generated
    SingleThreadExecutor commandQueue() {
        return this.commandQueue;
    }

    public static enum GraphTraversalStrategy {
        DEPTH,
        BREADTH;

    }

    private record KryonExecution(VajramID vajramID, InvocationId instanceExecutionId, ImmutableRequest<@Nullable Object> request, KryonExecutionConfig executionConfig, CompletableFuture<@Nullable Object> future) {
    }

    public static enum KryonExecStrategy {
        BATCH;

    }
}

