/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.caching;

import com.flipkart.krystal.concurrent.Futures;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.ImmutableFacetValuesContainer;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.krystex.caching.CacheKey;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardReceive;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonCommandResponse;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfigurator;
import com.flipkart.krystal.krystex.kryon.VajramKryonDefinition;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorationInput;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorator;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorConfig;
import com.flipkart.krystal.krystex.request.InvocationId;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class RequestLevelCache
implements KryonDecorator,
KryonExecutorConfigurator {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(RequestLevelCache.class);
    public static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String DECORATOR_TYPE = RequestLevelCache.class.getName();
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> UNKNOWN_ERROR = Errable.withError((Throwable)new StackTracelessException("Unknown error in request cache"));
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CacheKey, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object>> cache = new LinkedHashMap<CacheKey, CompletableFuture<Object>>();

    @Override
    public void addToConfig(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonExecutorConfig.KryonExecutorConfigBuilder configBuilder) {
        configBuilder.kryonDecoratorConfig(DECORATOR_TYPE, new KryonDecoratorConfig(DECORATOR_TYPE, _c -> true, _c -> DECORATOR_TYPE, _c -> this));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Kryon<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommand, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommandResponse> decorateKryon(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonDecorationInput decorationInput) {
        return new CachingDecoratedKryon(decorationInput.kryon());
    }

    @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> getCachedValue(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CacheKey cacheKey) {
        return this.cache.get(cacheKey);
    }

    void primeCache(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetValues request, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> data) {
        this.cache.put(new CacheKey((ImmutableFacetValuesContainer)request._build()), data);
    }

    private class CachingDecoratedKryon
    implements Kryon<KryonCommand, KryonCommandResponse> {
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Kryon<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommand, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommandResponse> kryon;

        private CachingDecoratedKryon(Kryon<KryonCommand, KryonCommandResponse> kryon) {
            this.kryon = kryon;
        }

        @Override
        public void executeCommand(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Flush flushCommand) {
            this.kryon.executeCommand(flushCommand);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramKryonDefinition getKryonDefinition() {
            return this.kryon.getKryonDefinition();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommandResponse> executeCommand(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommand kryonCommand) {
            if (kryonCommand instanceof ForwardReceive) {
                ForwardReceive forwardBatch = (ForwardReceive)kryonCommand;
                return this.readFromCache(this.kryon, forwardBatch);
            }
            return this.kryon.executeCommand(kryonCommand);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommandResponse> readFromCache(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Kryon<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommand, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KryonCommandResponse> kryon, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ForwardReceive forwardBatch) {
            Map<InvocationId, FacetValues> executableRequests = forwardBatch.executableInvocations();
            LinkedHashMap<InvocationId, FacetValues> cacheMisses = new LinkedHashMap<InvocationId, FacetValues>();
            LinkedHashMap<InvocationId, @Nullable CompletableFuture> cacheHits = new LinkedHashMap<InvocationId, CompletableFuture>();
            LinkedHashMap<K, @Nullable V> newCacheEntries = new LinkedHashMap();
            executableRequests.forEach((requestId, facets) -> {
                CacheKey cacheKey = new CacheKey((ImmutableFacetValuesContainer)facets._build());
                CompletableFuture<Object> cachedFuture = RequestLevelCache.this.getCachedValue(cacheKey);
                if (cachedFuture == null) {
                    CompletableFuture placeHolderFuture = new CompletableFuture();
                    newCacheEntries.put(requestId, placeHolderFuture);
                    RequestLevelCache.this.cache.put(cacheKey, placeHolderFuture);
                    cacheMisses.put((InvocationId)requestId, (FacetValues)facets._build());
                } else {
                    cacheHits.put((InvocationId)requestId, cachedFuture);
                }
            });
            LinkedHashMap<InvocationId, String> skippedRequests = new LinkedHashMap<InvocationId, String>(forwardBatch.invocationsToSkip());
            cacheHits.forEach((requestId, _f) -> skippedRequests.put((InvocationId)requestId, "Skipping due to cache hit!"));
            CompletableFuture<KryonCommandResponse> cacheMissesResponse = kryon.executeCommand(new ForwardReceive(forwardBatch.vajramID(), cacheMisses, forwardBatch.dependentChain(), skippedRequests));
            cacheMissesResponse.whenComplete((kryonResponse, throwable) -> {
                if (kryonResponse instanceof BatchResponse) {
                    BatchResponse batchResponse = (BatchResponse)kryonResponse;
                    Map<InvocationId, Errable<@Nullable Object>> responses = batchResponse.responses();
                    responses.forEach((requestId, response) -> {
                        @Nullable CompletableFuture future = response.toFuture();
                        @Nullable CompletableFuture destinationFuture = newCacheEntries.computeIfAbsent(requestId, _r -> new CompletableFuture());
                        Futures.linkFutures((CompletableFuture)future, (CompletableFuture)destinationFuture);
                    });
                } else if (throwable != null) {
                    cacheMisses.forEach((requestId, response) -> newCacheEntries.computeIfAbsent(requestId, _r -> new CompletableFuture()).completeExceptionally(StackTracelessException.stackTracelessWrap((Throwable)throwable)));
                } else {
                    @Nullable RuntimeException e = new RuntimeException("Expecting BatchResponse. Found " + kryonResponse);
                    log.error("", (Throwable)e);
                    throw e;
                }
            });
            CompletableFuture<KryonCommandResponse> finalResponse = new CompletableFuture<KryonCommandResponse>();
            @Nullable Iterable allFutures = Iterables.concat(cacheHits.entrySet(), newCacheEntries.entrySet());
            CompletableFuture[] allFuturesArray = new CompletableFuture[cacheHits.size() + newCacheEntries.size()];
            int i = 0;
            for (Map.Entry e : allFutures) {
                allFuturesArray[i++] = (CompletableFuture)e.getValue();
            }
            CompletableFuture.allOf(allFuturesArray).whenComplete((unused, throwable) -> {
                LinkedHashMap<InvocationId, Errable<@Nullable Object>> responses = new LinkedHashMap<InvocationId, Errable<Object>>();
                for (Map.Entry e : allFutures) {
                    responses.put((InvocationId)e.getKey(), ((CompletableFuture)((CompletableFuture)e.getValue()).handle(Errable::errableFrom)).getNow(UNKNOWN_ERROR));
                }
                finalResponse.complete(new BatchResponse(responses));
            });
            return finalResponse;
        }
    }
}

