/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.VajramKryonDefinition;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public final class KryonUtils {
    static CompletableFuture<?> enqueueOrExecuteCommand(Supplier<KryonCommand<?>> commandGenerator, KryonExecutor kryonExecutor) {
        if (kryonExecutor.singleThreadExecutor().isCurrentThreadTheSingleThread()) {
            return kryonExecutor.executeCommand(commandGenerator.get());
        }
        return kryonExecutor.enqueueKryonCommand(commandGenerator);
    }

    static VajramKryonDefinition validateAsVajram(KryonDefinition kryonDefinition) {
        if (!(kryonDefinition instanceof VajramKryonDefinition)) {
            throw new IllegalStateException("Kryon command execution is supported only for vajrams. Please check that a trait dispatch policy dispatches requests to the trait appropriately. Found: " + String.valueOf(kryonDefinition.getClass()) + " VajramId: " + String.valueOf(kryonDefinition.vajramID()));
        }
        VajramKryonDefinition vajramKryonDefinition = (VajramKryonDefinition)kryonDefinition;
        return vajramKryonDefinition;
    }

    private KryonUtils() {
    }
}

