/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.core.CommunicationFacade;
import com.flipkart.krystal.core.GraphExecutionData;
import com.flipkart.krystal.core.OutputLogicExecutionInput;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.ExecutionItem;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.data.RequestResponseFuture;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.commands.DirectForwardReceive;
import com.flipkart.krystal.krystex.commands.DirectForwardSend;
import com.flipkart.krystal.krystex.commands.MultiRequestDirectCommand;
import com.flipkart.krystal.krystex.decoration.DecorationOrdering;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyDecorator;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyExecutionContext;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyInvocation;
import com.flipkart.krystal.krystex.kryon.AbstractKryon;
import com.flipkart.krystal.krystex.kryon.DependentChain;
import com.flipkart.krystal.krystex.kryon.DirectResponse;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.VajramKryonDefinition;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.request.RequestIdGenerator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class DirectKryon
extends AbstractKryon<MultiRequestDirectCommand<DirectResponse>, DirectResponse> {
    DirectKryon(VajramKryonDefinition definition, KryonExecutor kryonExecutor, Function<LogicExecutionContext, NavigableSet<OutputLogicDecorator>> sortedOutputLogicDecoratorsSupplier, Function<DependencyExecutionContext, ImmutableMap<String, DependencyDecorator>> depDecoratorSuppliers, DecorationOrdering decorationOrdering, RequestIdGenerator requestIdGenerator) {
        super(definition, kryonExecutor, sortedOutputLogicDecoratorsSupplier, depDecoratorSuppliers, decorationOrdering);
    }

    @Override
    public CompletableFuture<DirectResponse> executeCommand(MultiRequestDirectCommand<DirectResponse> kryonCommand) {
        final DependentChain dependentChain = kryonCommand.dependentChain();
        final VajramID vajramID = this.kryonDefinition.vajramID();
        if (kryonCommand instanceof DirectForwardReceive) {
            DirectForwardReceive directForwardReceive = (DirectForwardReceive)kryonCommand;
            final List<ExecutionItem> executionItems = directForwardReceive.executionItems();
            try {
                CommunicationFacade communicationFacade = new CommunicationFacade(){

                    public void triggerDependency(Dependency dependency, List<? extends RequestResponseFuture<? extends Request<?>, ?>> requestResponseFutureList) {
                        DependentChain extendedDependentChain = dependentChain.extend(vajramID, dependency);
                        DependencyInvocation<DirectResponse> kryonResponseDependencyInvocation = DirectKryon.this.decorateVajramInvocation(extendedDependentChain, dependency.onVajramID(), DirectKryon.this.kryonExecutor::executeCommand);
                        kryonResponseDependencyInvocation.invokeDependency(new DirectForwardSend(dependency.onVajramID(), requestResponseFutureList, extendedDependentChain));
                    }

                    public void executeOutputLogic() {
                        for (ExecutionItem executionItem : executionItems) {
                            DirectKryon.this.executeDecoratedOutputLogic(DirectKryon.this.kryonDefinition.getOutputLogicDefinition(), executionItem, dependentChain);
                        }
                        DirectKryon.this.flushDecorators(dependentChain);
                    }
                };
                if (executionItems.isEmpty()) {
                    this.kryonDefinition.dependencies().forEach(dependency -> this.kryonExecutor.executeCommand(new DirectForwardSend(dependency.onVajramID(), (List<? extends RequestResponseFuture<? extends Request<?>, ?>>)ImmutableList.of(), dependentChain.extend(vajramID, (Dependency)dependency))));
                    this.flushDecorators(dependentChain);
                }
                this.kryonDefinition.executeGraph(new GraphExecutionData(executionItems, communicationFacade, this.kryonExecutor.commandQueue()));
            }
            catch (Throwable e) {
                for (ExecutionItem executionItem : executionItems) {
                    if (executionItem.response().isDone()) continue;
                    executionItem.response().completeExceptionally(StackTracelessException.stackTracelessWrap((Throwable)e));
                }
            }
        }
        return CompletableFuture.completedFuture(DirectResponse.INSTANCE);
    }

    private void executeDecoratedOutputLogic(OutputLogicDefinition<Object> outputLogicDefinition, ExecutionItem executionItem, DependentChain dependentChain) {
        OutputLogic logic = (OutputLogic)outputLogicDefinition.logic();
        for (OutputLogicDecorator outputLogicDecorator : this.getSortedOutputLogicDecorators(dependentChain)) {
            logic = outputLogicDecorator.decorateLogic(logic, outputLogicDefinition);
        }
        OutputLogic finalLogic = logic;
        try {
            finalLogic.execute(new OutputLogicExecutionInput((List)ImmutableList.of((Object)executionItem), this.kryonExecutor.commandQueue()));
        }
        catch (Throwable e) {
            executionItem.response().completeExceptionally(StackTracelessException.stackTracelessWrap((Throwable)e));
        }
    }
}

