/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.annos.InvocableOutsideGraph;
import com.flipkart.krystal.annos.TraitDependency;
import com.flipkart.krystal.concurrent.Futures;
import com.flipkart.krystal.concurrent.SingleThreadExecutor;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.ExecutionItem;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.data.RequestResponseFuture;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.krystex.KrystalExecutor;
import com.flipkart.krystal.krystex.commands.DirectForwardReceive;
import com.flipkart.krystal.krystex.commands.DirectForwardSend;
import com.flipkart.krystal.krystex.commands.ForwardReceiveBatch;
import com.flipkart.krystal.krystex.commands.ForwardSendBatch;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.decoration.InitiateActiveDepChains;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyDecorator;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyDecoratorConfig;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyExecutionContext;
import com.flipkart.krystal.krystex.dependencydecorators.TraitDispatchDecorator;
import com.flipkart.krystal.krystex.internal.KrystalExecutorExecService;
import com.flipkart.krystal.krystex.kryon.BatchKryon;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.DependentChain;
import com.flipkart.krystal.krystex.kryon.DirectKryon;
import com.flipkart.krystal.krystex.kryon.DirectResponse;
import com.flipkart.krystal.krystex.kryon.DisabledDependentChainException;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonCommandResponse;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonDefinitionRegistry;
import com.flipkart.krystal.krystex.kryon.KryonExecutionConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutorMetrics;
import com.flipkart.krystal.krystex.kryon.KryonRegistry;
import com.flipkart.krystal.krystex.kryon.KryonUtils;
import com.flipkart.krystal.krystex.kryon.TraitKryonDefinition;
import com.flipkart.krystal.krystex.kryon.VajramKryonDefinition;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorationInput;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorator;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorConfig;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorContext;
import com.flipkart.krystal.krystex.kryondecoration.KryonExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecoratorConfig;
import com.flipkart.krystal.krystex.request.IntReqGenerator;
import com.flipkart.krystal.krystex.request.InvocationId;
import com.flipkart.krystal.krystex.request.RequestIdGenerator;
import com.flipkart.krystal.krystex.request.StringReqGenerator;
import com.flipkart.krystal.traits.DynamicDispatchPolicy;
import com.flipkart.krystal.traits.StaticDispatchPolicy;
import com.flipkart.krystal.traits.TraitDispatchPolicy;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KryonExecutor
implements KrystalExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KryonExecutor.class);
    private final KryonDefinitionRegistry kryonDefinitionRegistry;
    private final KryonExecutorConfig executorConfig;
    private @MonotonicNonNull ExecutorService commandQueue;
    private final SingleThreadExecutor singleThreadExecutor;
    private final String executorId;
    private final ImmutableMap<String, OutputLogicDecoratorConfig> outputLogicDecoratorConfigs;
    private final ImmutableMap<String, DependencyDecoratorConfig> dependencyDecoratorConfigs;
    private final ImmutableMap<String, KryonDecoratorConfig> kryonDecoratorConfigs;
    private final Map<String, Map<String, OutputLogicDecorator>> outputLogicDecorators = new LinkedHashMap<String, Map<String, OutputLogicDecorator>>();
    private final Map<String, Map<String, KryonDecorator>> kryonDecorators = new LinkedHashMap<String, Map<String, KryonDecorator>>();
    private final Map<String, Map<String, DependencyDecorator>> dependencyDecorators = new LinkedHashMap<String, Map<String, DependencyDecorator>>();
    private final KryonRegistry<Kryon<?, ?>> kryonRegistry = new KryonRegistry();
    private final Map<VajramID, Kryon<?, ?>> decoratedKryons = new HashMap();
    private final KryonExecutorMetrics kryonMetrics;
    private final Map<InvocationId, KryonExecution<?>> allExecutions = new LinkedHashMap();
    private final Set<InvocationId> unFlushedExecutions = new LinkedHashSet<InvocationId>();
    private final Map<VajramID, Set<DependentChain>> dependentChainsPerKryon = new LinkedHashMap<VajramID, Set<DependentChain>>();
    private final RequestIdGenerator preferredReqGenerator;
    private final Set<DependentChain> depChainsDisabledInAllExecutions = new LinkedHashSet<DependentChain>();
    private volatile boolean closed;
    private boolean shutdownRequested;

    public KryonExecutor(KryonDefinitionRegistry kryonDefinitionRegistry, KryonExecutorConfig executorConfig) {
        this.kryonDefinitionRegistry = kryonDefinitionRegistry;
        this.executorConfig = executorConfig;
        this.singleThreadExecutor = executorConfig.executorService();
        this.executorId = executorConfig.executorId();
        this.outputLogicDecoratorConfigs = executorConfig.outputLogicDecoratorConfigs();
        this.dependencyDecoratorConfigs = KryonExecutor.makeDependencyDecorConfigs(executorConfig);
        this.kryonDecoratorConfigs = executorConfig.kryonDecoratorConfigs();
        this.kryonMetrics = new KryonExecutorMetrics();
        this.preferredReqGenerator = executorConfig.debug() ? new StringReqGenerator() : new IntReqGenerator();
    }

    private static ImmutableMap<String, DependencyDecoratorConfig> makeDependencyDecorConfigs(KryonExecutorConfig executorConfig) {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(executorConfig.dependencyDecoratorConfigs());
        TraitDispatchDecorator traitDispatchDecorator = executorConfig.traitDispatchDecorator();
        if (traitDispatchDecorator != null) {
            String decoratorType = traitDispatchDecorator.decoratorType();
            builder.put((Object)decoratorType, (Object)new DependencyDecoratorConfig(decoratorType, dependencyExecutionContext -> dependencyExecutionContext.dependency().tags().getAnnotationByType(TraitDependency.class).isPresent(), d -> decoratorType, c -> traitDispatchDecorator));
        }
        return builder.build();
    }

    private NavigableSet<OutputLogicDecorator> getOutputLogicDecorators(LogicExecutionContext logicExecutionContext) {
        VajramID vajramID = logicExecutionContext.vajramID();
        TreeSet<OutputLogicDecorator> decorators = new TreeSet<OutputLogicDecorator>(this.executorConfig.decorationOrdering().encounterOrder().reversed());
        this.outputLogicDecoratorConfigs.forEach((decoratorType, decoratorConfig) -> {
            if (decoratorConfig.shouldDecorate().test(logicExecutionContext)) {
                String instanceId = decoratorConfig.instanceIdGenerator().apply(logicExecutionContext);
                OutputLogicDecorator outputLogicDecorator = this.outputLogicDecorators.computeIfAbsent((String)decoratorType, t -> new LinkedHashMap()).computeIfAbsent(instanceId, _i -> {
                    OutputLogicDecorator logicDecorator = decoratorConfig.factory().apply(new OutputLogicDecoratorConfig.OutputLogicDecoratorContext(instanceId, logicExecutionContext));
                    logicDecorator.executeCommand(new InitiateActiveDepChains(vajramID, Collections.unmodifiableSet(this.dependentChainsPerKryon.getOrDefault(vajramID, (Set<DependentChain>)ImmutableSet.of()))));
                    return logicDecorator;
                });
                decorators.add(outputLogicDecorator);
            }
        });
        return decorators;
    }

    private ImmutableMap<String, DependencyDecorator> getDependencyDecorators(DependencyExecutionContext dependencyExecutionContext) {
        LinkedHashMap<String, DependencyDecorator> decorators = new LinkedHashMap<String, DependencyDecorator>();
        for (Map.Entry entry : this.dependencyDecoratorConfigs.entrySet()) {
            String decoratorType = (String)entry.getKey();
            DependencyDecoratorConfig decoratorConfig = (DependencyDecoratorConfig)entry.getValue();
            if (!decoratorConfig.shouldDecorate().test(dependencyExecutionContext)) continue;
            String instanceId = decoratorConfig.instanceIdGenerator().apply(dependencyExecutionContext);
            DependencyDecorator dependencyDecorator = this.dependencyDecorators.computeIfAbsent(decoratorType, s -> new LinkedHashMap()).computeIfAbsent(instanceId, s -> decoratorConfig.factory().apply(dependencyExecutionContext));
            decorators.put(decoratorType, dependencyDecorator);
        }
        return ImmutableMap.copyOf(decorators);
    }

    @Override
    public <T> CompletableFuture<@Nullable T> executeKryon(ImmutableRequest<T> request, KryonExecutionConfig executionConfig) {
        RequestResponseFuture requestResponseFuture = RequestResponseFuture.forRequest(request);
        this.executeKryon(requestResponseFuture, executionConfig);
        return requestResponseFuture.response();
    }

    @Override
    public <T> void executeKryon(RequestResponseFuture<? extends Request<T>, T> requestResponseFuture, KryonExecutionConfig executionConfig) {
        ImmutableRequest castRequest = requestResponseFuture.request()._build();
        if (this.closed) {
            throw new RejectedExecutionException("KryonExecutor is already closed");
        }
        Preconditions.checkArgument((executionConfig != null ? 1 : 0) != 0, (Object)"executionConfig can not be null");
        VajramID vajramID = castRequest._vajramID();
        boolean openAllKryonsForExternalInvocation = Boolean.parseBoolean(System.getProperties().getProperty("krystal.krystex.risky.openAllVajramsToExternalInvocation", "false"));
        if (!openAllKryonsForExternalInvocation && this.kryonDefinitionRegistry.getOrThrow(vajramID).tags().getAnnotationByType(InvocableOutsideGraph.class).isEmpty()) {
            throw new RejectedExecutionException("External invocation is not enabled for vajramId: " + String.valueOf(vajramID));
        }
        String executionId = executionConfig.executionId();
        Preconditions.checkArgument((executionId != null ? 1 : 0) != 0, (Object)"executionConfig.executionId can not be null");
        this.enqueueRunnable(() -> {
            InvocationId invocationId = this.preferredReqGenerator.newRequest(() -> "%s:%s".formatted(this.executorId, executionId));
            this.createDependencyKryons(vajramID, this.kryonDefinitionRegistry.getDependentChainsStart(), executionConfig);
            if (this.allExecutions.containsKey(invocationId)) {
                requestResponseFuture.response().completeExceptionally(StackTracelessException.stackTracelessWrap((Throwable)new IllegalArgumentException("Received duplicate requests for same instanceId '%s' and execution Id '%s'".formatted(this.executorId, executionId))));
            } else {
                this.allExecutions.put(invocationId, new KryonExecution(vajramID, invocationId, requestResponseFuture, executionConfig));
                this.unFlushedExecutions.add(invocationId);
            }
        });
    }

    private void createDependencyKryons(VajramID vajramID, DependentChain dependentChain, KryonExecutionConfig executionConfig) {
        if (Sets.union(this.executorConfig.disabledDependentChains(), executionConfig.disabledDependentChains()).contains((Object)dependentChain)) {
            return;
        }
        KryonDefinition kryonDefinition = this.kryonDefinitionRegistry.get(vajramID);
        ArrayList<VajramID> concreteVajramIds = new ArrayList<VajramID>();
        if (kryonDefinition instanceof TraitKryonDefinition) {
            @Nullable TraitDispatchPolicy traitDispatchPolicy = (TraitDispatchPolicy)this.executorConfig.traitDispatchDecorator().traitDispatchPolicies().get((Object)vajramID);
            if (traitDispatchPolicy == null) {
                throw new IllegalArgumentException("Trait " + String.valueOf(vajramID) + " found but no TraitDispatchPolicy provided in the executorConfig");
            }
            if (traitDispatchPolicy instanceof StaticDispatchPolicy) {
                VajramID boundVajram;
                StaticDispatchPolicy staticDispatchPolicy = (StaticDispatchPolicy)traitDispatchPolicy;
                Dependency latestDependency = dependentChain.latestDependency();
                try {
                    boundVajram = latestDependency != null ? staticDispatchPolicy.getDispatchTargetID(latestDependency) : staticDispatchPolicy.getDispatchTargetID(executionConfig.staticDispatchQualifier());
                }
                catch (Throwable throwable) {
                    throw new IllegalArgumentException("Error while getting bound vajram for trait with ID: " + String.valueOf(vajramID));
                }
                concreteVajramIds.add(boundVajram);
            } else if (traitDispatchPolicy instanceof DynamicDispatchPolicy) {
                DynamicDispatchPolicy dynamicDispatcher = (DynamicDispatchPolicy)traitDispatchPolicy;
                concreteVajramIds.addAll((Collection<VajramID>)dynamicDispatcher.dispatchTargetIDs());
            }
        } else {
            concreteVajramIds.add(vajramID);
        }
        for (VajramID finalVajramId : concreteVajramIds) {
            ImmutableSet<Dependency> dependencyKryons = ImmutableSet.of();
            kryonDefinition = this.kryonDefinitionRegistry.getOrThrow(finalVajramId);
            if (kryonDefinition instanceof VajramKryonDefinition) {
                VajramKryonDefinition vajramKryonDefinition = (VajramKryonDefinition)kryonDefinition;
                this.createKryonIfAbsent(finalVajramId, vajramKryonDefinition);
                dependencyKryons = vajramKryonDefinition.dependencies();
            }
            dependencyKryons.forEach(dependency -> this.createDependencyKryons(dependency.onVajramID(), dependentChain.extend(finalVajramId, (Dependency)dependency), executionConfig));
            this.dependentChainsPerKryon.computeIfAbsent(finalVajramId, _n -> new LinkedHashSet()).add(dependentChain);
        }
    }

    @CanIgnoreReturnValue
    private Kryon<? extends KryonCommand<?>, ? extends KryonCommandResponse> createKryonIfAbsent(VajramID vajramID, VajramKryonDefinition kryonDefinition) {
        return this.kryonRegistry.createIfAbsent(vajramID, _n -> switch (this.executorConfig.kryonExecStrategy()) {
            default -> throw new IncompatibleClassChangeError();
            case KryonExecStrategy.BATCH -> new BatchKryon(kryonDefinition, this, this::getOutputLogicDecorators, this::getDependencyDecorators, this.executorConfig.decorationOrdering(), this.preferredReqGenerator);
            case KryonExecStrategy.DIRECT -> new DirectKryon(kryonDefinition, this, this::getOutputLogicDecorators, this::getDependencyDecorators, this.executorConfig.decorationOrdering(), this.preferredReqGenerator);
        });
    }

    <R extends KryonCommandResponse> CompletableFuture<R> enqueueKryonCommand(Supplier<? extends KryonCommand<?>> kryonCommand) {
        return this.enqueueCommand(() -> this._executeCommand((KryonCommand)kryonCommand.get())).thenCompose(Function.identity());
    }

    <R extends KryonCommandResponse> CompletableFuture<R> executeCommand(KryonCommand<R> kryonCommand) {
        if (GraphTraversalStrategy.BREADTH.equals((Object)this.executorConfig.graphTraversalStrategy())) {
            return this.enqueueKryonCommand(() -> kryonCommand);
        }
        this.kryonMetrics.commandQueueBypassed();
        return this._executeCommand(kryonCommand);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private <R extends KryonCommandResponse> CompletableFuture<R> _executeCommand(KryonCommand<?> kryonCommand) {
        try {
            VajramKryonDefinition vajramKryonDefinition = KryonUtils.validateAsVajram(this.kryonDefinitionRegistry.getOrThrow(kryonCommand.vajramID()));
            if (kryonCommand instanceof DirectForwardSend) {
                DirectForwardSend forwardSend = (DirectForwardSend)kryonCommand;
                ArrayList<ExecutionItem> list = new ArrayList<ExecutionItem>();
                for (RequestResponseFuture<? extends Request<?>, ?> requestResponseFuture : forwardSend.executableRequests()) {
                    @Nullable CompletableFuture response = requestResponseFuture.response();
                    list.add(new ExecutionItem(vajramKryonDefinition.facetsFromRequest().logic().facetsFromRequest(requestResponseFuture.request()), response));
                }
                return this._executeCommand(new DirectForwardReceive(forwardSend.vajramID(), list, forwardSend.dependentChain()));
            }
            if (kryonCommand instanceof ForwardSendBatch) {
                ForwardSendBatch forwardSend = (ForwardSendBatch)kryonCommand;
                return this._executeCommand(new ForwardReceiveBatch(forwardSend.vajramID(), (Map)forwardSend.executableRequests().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> vajramKryonDefinition.facetsFromRequest().logic().facetsFromRequest((Request)e.getValue()))), forwardSend.dependentChain(), forwardSend.skippedInvocations()));
            }
            try {
                this.validate(kryonCommand);
            }
            catch (Throwable e2) {
                return CompletableFuture.failedFuture(e2);
            }
            VajramID vajramID = kryonCommand.vajramID();
            Kryon<KryonCommand<?>, R> kryon = this.getDecoratedKryon(kryonCommand, vajramID);
            return kryon.executeCommand(kryonCommand);
        }
        catch (Throwable e3) {
            kryonCommand.error(e3);
            return CompletableFuture.failedFuture(e3);
        }
    }

    private <R extends KryonCommandResponse> Kryon<KryonCommand<?>, R> getDecoratedKryon(KryonCommand<?> kryonCommand, VajramID kryonId) {
        return this.decoratedKryons.computeIfAbsent(kryonId, _n -> {
            Kryon<KryonCommand<?>, KryonCommandResponse> kryon = this.kryonRegistry.get(kryonId);
            for (KryonDecorator kryonDecorator : this.getSortedKryonDecorators(kryonId, kryonCommand)) {
                kryon = kryonDecorator.decorateKryon(new KryonDecorationInput(kryon, this));
            }
            return kryon;
        });
    }

    private Set<KryonDecorator> getSortedKryonDecorators(VajramID vajramID, KryonCommand<?> kryonCommand) {
        KryonExecutionContext executionContext = new KryonExecutionContext(vajramID, kryonCommand.dependentChain());
        TreeSet<KryonDecorator> sortedDecorators = new TreeSet<KryonDecorator>(this.executorConfig.decorationOrdering().encounterOrder().reversed());
        for (Map.Entry configsByType : this.kryonDecoratorConfigs.entrySet()) {
            String decoratorType = (String)configsByType.getKey();
            KryonDecoratorConfig decoratorConfig = (KryonDecoratorConfig)configsByType.getValue();
            if (!decoratorConfig.shouldDecorate().test(executionContext)) continue;
            String instanceId = decoratorConfig.instanceIdGenerator().apply(executionContext);
            sortedDecorators.add(this.kryonDecorators.computeIfAbsent(decoratorType, _t -> new LinkedHashMap()).computeIfAbsent(instanceId, _i -> decoratorConfig.factory().apply(new KryonDecoratorContext(instanceId, executionContext))));
        }
        return sortedDecorators;
    }

    private void validate(KryonCommand<?> kryonCommand) {
        if (this.shutdownRequested) {
            throw new RejectedExecutionException("Kryon Executor shutdown requested.");
        }
        DependentChain dependentChain = kryonCommand.dependentChain();
        if (this.depChainsDisabledInAllExecutions.contains(dependentChain)) {
            throw new DisabledDependentChainException(dependentChain);
        }
    }

    private void flush() {
        this.enqueueRunnable(() -> {
            this.computeDisabledDependentChains();
            switch (this.executorConfig.kryonExecStrategy()) {
                case BATCH: {
                    this.submitBatch(this.unFlushedExecutions);
                    break;
                }
                case DIRECT: {
                    this.submitDirect(this.unFlushedExecutions);
                }
            }
        });
    }

    private void computeDisabledDependentChains() {
        this.depChainsDisabledInAllExecutions.clear();
        ArrayList<ImmutableSet<DependentChain>> disabledDependantChainsPerExecution = new ArrayList<ImmutableSet<DependentChain>>();
        for (InvocationId invocationId : this.unFlushedExecutions) {
            KryonExecution<?> kryonExecution = this.getKryonExecution(invocationId);
            KryonExecutionConfig executionConfig = kryonExecution.executionConfig();
            ImmutableSet<DependentChain> disabledDependentChains = executionConfig.disabledDependentChains();
            disabledDependantChainsPerExecution.add(disabledDependentChains);
        }
        for (ImmutableSet immutableSet : disabledDependantChainsPerExecution) {
            if (immutableSet.isEmpty()) continue;
            this.depChainsDisabledInAllExecutions.addAll((Collection<DependentChain>)immutableSet);
            break;
        }
        for (Set set : disabledDependantChainsPerExecution) {
            if (this.depChainsDisabledInAllExecutions.isEmpty()) break;
            this.depChainsDisabledInAllExecutions.retainAll(set);
        }
        this.depChainsDisabledInAllExecutions.addAll((Collection<DependentChain>)this.executorConfig.disabledDependentChains());
    }

    private KryonExecution<?> getKryonExecution(InvocationId invocationId) {
        KryonExecution<?> kryonExecution = this.allExecutions.get(invocationId);
        if (kryonExecution == null) {
            throw new AssertionError((Object)("No kryon execution found for requestId " + String.valueOf(invocationId)));
        }
        return kryonExecution;
    }

    private void submitDirect(Set<InvocationId> unFlushedRequests) {
        HashMap<VajramID, List> executionsByKryon = new HashMap<VajramID, List>();
        for (InvocationId unFlushedRequest : unFlushedRequests) {
            executionsByKryon.computeIfAbsent(this.getKryonExecution(unFlushedRequest).vajramID(), k -> new ArrayList()).add(this.getKryonExecution(unFlushedRequest));
        }
        executionsByKryon.forEach((vajramID, kryonExecutions) -> {
            try {
                CompletableFuture<DirectResponse> submissionResponse = this.executorConfig.traitDispatchDecorator().decorateDependency(this::executeCommand).invokeDependency(new DirectForwardSend((VajramID)vajramID, (List<? extends RequestResponseFuture<? extends Request<?>, ?>>)this.asRequestResponseFutures((List<KryonExecution<?>>)kryonExecutions), this.kryonDefinitionRegistry.getDependentChainsStart()));
                submissionResponse.whenComplete((response, throwable) -> {
                    if (throwable != null) {
                        for (KryonExecution kryonExecution : kryonExecutions) {
                            kryonExecution.response().completeExceptionally(StackTracelessException.stackTracelessWrap((Throwable)throwable));
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                for (KryonExecution ke : kryonExecutions) {
                    ke.response().completeExceptionally(StackTracelessException.stackTracelessWrap((Throwable)throwable2));
                }
            }
        });
    }

    private void submitBatch(Set<InvocationId> unFlushedRequests) {
        Map<VajramID, List<KryonExecution>> executionsByKryon = unFlushedRequests.stream().map(this::getKryonExecution).collect(Collectors.groupingBy(KryonExecution::vajramID));
        executionsByKryon.forEach((vajramID, kryonExecutions) -> {
            CompletableFuture<BatchResponse> batchResponseFuture;
            try {
                LinkedHashMap<InvocationId, Request<Object>> requests = new LinkedHashMap<InvocationId, Request<Object>>(kryonExecutions.size());
                for (KryonExecution kryonExecution : kryonExecutions) {
                    requests.put(kryonExecution.instanceExecutionId(), kryonExecution.request());
                }
                batchResponseFuture = this.executorConfig.traitDispatchDecorator().decorateDependency(this::executeCommand).invokeDependency(new ForwardSendBatch((VajramID)vajramID, (Map<InvocationId, Request<Object>>)requests, this.kryonDefinitionRegistry.getDependentChainsStart(), (Map<InvocationId, String>)ImmutableMap.of()));
            }
            catch (Throwable throwable2) {
                batchResponseFuture = CompletableFuture.completedFuture(new BatchResponse((Map)kryonExecutions.stream().collect(ImmutableMap.toImmutableMap(KryonExecution::instanceExecutionId, _k -> Errable.withError((Throwable)throwable2)))));
            }
            ((CompletableFuture)batchResponseFuture.thenApply(BatchResponse::responses)).whenComplete((responses, throwable) -> {
                for (KryonExecution kryonExecution : kryonExecutions) {
                    if (throwable != null) {
                        kryonExecution.requestResponseFuture().response().completeExceptionally(StackTracelessException.stackTracelessWrap((Throwable)throwable));
                        continue;
                    }
                    Futures.linkFutures((CompletableFuture)responses.getOrDefault(kryonExecution.instanceExecutionId(), Errable.nil()).toFuture(), kryonExecution.response());
                }
            });
            Futures.propagateCancellation(CompletableFuture.allOf((CompletableFuture[])kryonExecutions.stream().map(KryonExecution::response).toArray(CompletableFuture[]::new)), batchResponseFuture);
        });
    }

    private List<RequestResponseFuture<? extends Request<?>, ?>> asRequestResponseFutures(List<KryonExecution<?>> kryonExecutions) {
        ArrayList list = new ArrayList(kryonExecutions.size());
        kryonExecutions.forEach(ke -> list.add(ke.requestResponseFuture()));
        return list;
    }

    public KryonExecutorMetrics getKryonMetrics() {
        return this.kryonMetrics;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this._close0();
        this.flush();
        this.enqueueCommand(() -> CompletableFuture.allOf((CompletableFuture[])this.allExecutions.values().stream().map(KryonExecution::response).toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> {
            for (Map.Entry<String, Map<String, OutputLogicDecorator>> decoratorsDetails : this.outputLogicDecorators.entrySet()) {
                Map<String, OutputLogicDecorator> decoratorsDetailsValue = decoratorsDetails.getValue();
                for (Map.Entry<String, OutputLogicDecorator> decorator : decoratorsDetailsValue.entrySet()) {
                    decorator.getValue().onComplete();
                }
            }
        }));
    }

    @Override
    public void shutdownNow() {
        this._close0();
        this.shutdownRequested = true;
    }

    ExecutorService commandQueue() {
        if (this.commandQueue == null) {
            this.commandQueue = new KrystalExecutorExecService(this, (ExecutorService)this.executorConfig.executorService());
        }
        return this.commandQueue;
    }

    private void _close0() {
        this.closed = true;
    }

    private void enqueueRunnable(Runnable command) {
        this.enqueueCommand(() -> {
            command.run();
            return new Object();
        });
    }

    private <T> CompletableFuture<T> enqueueCommand(Supplier<T> command) {
        return CompletableFuture.supplyAsync(() -> {
            this.kryonMetrics.commandQueued();
            return command.get();
        }, this.commandQueue());
    }

    @Generated
    SingleThreadExecutor singleThreadExecutor() {
        return this.singleThreadExecutor;
    }

    public static enum GraphTraversalStrategy {
        DEPTH,
        BREADTH;

    }

    private record KryonExecution<T>(VajramID vajramID, InvocationId instanceExecutionId, RequestResponseFuture<? extends Request<T>, T> requestResponseFuture, KryonExecutionConfig executionConfig) {
        public CompletableFuture<@Nullable Object> response() {
            return this.requestResponseFuture().response();
        }

        public Request<Object> request() {
            return this.requestResponseFuture().request();
        }
    }

    public static enum KryonExecStrategy {
        BATCH,
        DIRECT;

    }
}

