/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.testfixtures;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.ErrableFacetValue;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.data.ImmutableFacetValues;
import com.flipkart.krystal.data.One2OneDepResponse;
import com.flipkart.krystal.facets.Facet;
import com.flipkart.krystal.krystex.testfixtures.FacetValuesMap;
import com.flipkart.krystal.krystex.testfixtures.FacetValuesMapBuilder;
import com.flipkart.krystal.krystex.testfixtures.SimpleImmutRequest;
import com.flipkart.krystal.krystex.testfixtures.SimpleRequestBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ImmutableFacetValuesMap
implements FacetValuesMap,
ImmutableFacetValues {
    private final ImmutableSet<? extends Facet> _facets;
    private final VajramID _vajramID;
    private final SimpleImmutRequest<Object> _request;
    private final ImmutableMap<Integer, FacetValue> otherFacetValues;

    public ImmutableFacetValuesMap(SimpleRequestBuilder<Object> _request, Set<? extends Facet> _facets, VajramID vajramID) {
        this(_request, _facets, (ImmutableMap<Integer, FacetValue>)ImmutableMap.of(), vajramID);
    }

    public ImmutableFacetValuesMap(SimpleRequestBuilder<Object> _request, Set<? extends Facet> _facets, ImmutableMap<Integer, FacetValue> otherFacetValues, VajramID vajramID) {
        this._request = _request._build();
        this._facets = ImmutableSet.copyOf(_facets);
        this.otherFacetValues = otherFacetValues;
        this._vajramID = vajramID;
    }

    public FacetValue _get(int facetId) {
        if (this._request._hasValue(facetId)) {
            ErrableFacetValue<Object> v = this._request._get(facetId);
            if (v != null) {
                return v;
            }
            throw new AssertionError((Object)"This should not be possible since _hasValue is true");
        }
        return (FacetValue)this.otherFacetValues.getOrDefault((Object)facetId, (Object)ErrableFacetValue.nil());
    }

    @Override
    public Errable<?> _getOne2OneResponse(int facetId) {
        if (this._request._hasValue(facetId)) {
            return this._request._get(facetId).asErrable();
        }
        FacetValue datum = (FacetValue)this.otherFacetValues.getOrDefault((Object)facetId, (Object)ErrableFacetValue.nil());
        if (datum instanceof One2OneDepResponse) {
            One2OneDepResponse one2OneDepResponse = (One2OneDepResponse)datum;
            return one2OneDepResponse.response();
        }
        throw new IllegalArgumentException("%s is not of type RequestResponse. It is of type %s".formatted(facetId, datum.getClass()));
    }

    public FanoutDepResponses _getDepResponses(int facetId) {
        FacetValue datum = (FacetValue)this.otherFacetValues.getOrDefault((Object)facetId, (Object)ErrableFacetValue.nil());
        if (datum instanceof FanoutDepResponses) {
            FanoutDepResponses errable = (FanoutDepResponses)datum;
            return errable;
        }
        throw new IllegalArgumentException("%s is not of type FanoutDepResponses.".formatted(facetId));
    }

    @Override
    public ImmutableMap<Integer, FacetValue> _asMap() {
        return ImmutableMap.builder().putAll(this._request._asMap()).putAll(this.otherFacetValues).build();
    }

    public boolean _hasValue(int facetId) {
        return this._request._hasValue(facetId) || this.otherFacetValues.containsKey((Object)facetId);
    }

    public FacetValuesMapBuilder _asBuilder() {
        return new FacetValuesMapBuilder((SimpleRequestBuilder<Object>)this._request._asBuilder(), (Set<? extends Facet>)this._facets, (Map<Integer, ? extends FacetValue>)this.otherFacetValues, this._vajramID);
    }

    public ImmutableFacetValuesMap _build() {
        return this;
    }

    public ImmutableFacetValuesMap _newCopy() {
        return this;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutableFacetValuesMap)) {
            return false;
        }
        ImmutableFacetValuesMap other = (ImmutableFacetValuesMap)o;
        return Objects.equals(this._asMap(), other._asMap()) && Objects.equals(this._vajramID(), other._vajramID());
    }

    public int hashCode() {
        return Objects.hash(this._asMap(), this._vajramID());
    }

    public SimpleImmutRequest<Object> _request() {
        return this._request;
    }

    public ImmutableSet<? extends Facet> _facets() {
        return this._facets;
    }

    public VajramID _vajramID() {
        return this._vajramID;
    }
}

