/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.testfixtures;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.ErrableFacetValue;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.FacetValuesBuilder;
import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.One2OneDepResponse;
import com.flipkart.krystal.except.IllegalModificationException;
import com.flipkart.krystal.facets.Facet;
import com.flipkart.krystal.krystex.testfixtures.FacetValuesMap;
import com.flipkart.krystal.krystex.testfixtures.ImmutableFacetValuesMap;
import com.flipkart.krystal.krystex.testfixtures.SimpleRequestBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class FacetValuesMapBuilder
implements FacetValuesMap,
FacetValuesBuilder {
    private final SimpleRequestBuilder<Object> _request;
    private final ImmutableSet<? extends Facet> _facets;
    private final Map<Integer, FacetValue> otherFacetValues;
    private final VajramID _vajramID;

    public FacetValuesMapBuilder(SimpleRequestBuilder<Object> _request, Set<? extends Facet> _facets, VajramID vajramID) {
        this(_request, _facets, (Map<Integer, ? extends FacetValue>)ImmutableMap.of(), vajramID);
    }

    FacetValuesMapBuilder(SimpleRequestBuilder<Object> _request, Set<? extends Facet> _facets, Map<Integer, ? extends FacetValue> otherFacetValues, VajramID vajramID) {
        this._request = _request._asBuilder();
        this._facets = ImmutableSet.copyOf(_facets);
        this.otherFacetValues = new LinkedHashMap<Integer, FacetValue>(otherFacetValues);
        this._vajramID = vajramID;
    }

    public FacetValue _get(int facetId) {
        if (this._request._hasValue(facetId)) {
            ErrableFacetValue<Object> v = this._request._get(facetId);
            if (v != null) {
                return v;
            }
            throw new AssertionError((Object)"This should not be possible sinve _hasValue is true");
        }
        return this.otherFacetValues.getOrDefault(facetId, (FacetValue)ErrableFacetValue.nil());
    }

    @Override
    public Errable<?> _getOne2OneResponse(int facetId) {
        if (this._request._hasValue(facetId)) {
            return this._request._get(facetId).asErrable();
        }
        FacetValue datum = this.otherFacetValues.getOrDefault(facetId, (FacetValue)ErrableFacetValue.nil());
        if (datum instanceof One2OneDepResponse) {
            One2OneDepResponse one2OneDepResponse = (One2OneDepResponse)datum;
            return one2OneDepResponse.response();
        }
        throw new IllegalArgumentException("%s is not of type One2OneDepResponse. It is of the type: %s".formatted(facetId, datum));
    }

    public FanoutDepResponses _getDepResponses(int facetId) {
        FacetValue datum = this.otherFacetValues.getOrDefault(facetId, (FacetValue)ErrableFacetValue.nil());
        if (datum instanceof FanoutDepResponses) {
            FanoutDepResponses fanoutDepResponses = (FanoutDepResponses)datum;
            return fanoutDepResponses;
        }
        throw new IllegalArgumentException("%s is not of type Responses".formatted(facetId));
    }

    @Override
    public ImmutableMap<Integer, FacetValue> _asMap() {
        return ImmutableMap.builder().putAll(this._request._asMap()).putAll(this.otherFacetValues).build();
    }

    public boolean _hasValue(int facetId) {
        return this._request._hasValue(facetId) || this.otherFacetValues.containsKey(facetId);
    }

    public ImmutableFacetValuesMap _build() {
        return new ImmutableFacetValuesMap(this._request, (Set<? extends Facet>)this._facets, (ImmutableMap<Integer, FacetValue>)ImmutableMap.copyOf(this.otherFacetValues), this._vajramID);
    }

    public FacetValuesMapBuilder _newCopy() {
        return new FacetValuesMapBuilder(this._request, (Set<? extends Facet>)this._facets, (Map<Integer, ? extends FacetValue>)new LinkedHashMap<Integer, FacetValue>(this.otherFacetValues), this._vajramID);
    }

    public FacetValuesMapBuilder _set(int facetId, FacetValue value) {
        if (this._hasValue(facetId)) {
            throw new IllegalModificationException();
        }
        this.otherFacetValues.put(facetId, value);
        return this;
    }

    public ImmutableRequest.Builder<?> _request() {
        return this._request;
    }

    public ImmutableSet<? extends Facet> _facets() {
        return this._facets;
    }

    public VajramID _vajramID() {
        return this._vajramID;
    }
}

