/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.concurrent.SingleThreadExecutor;
import com.flipkart.krystal.krystex.decoration.DecorationOrdering;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyDecorator;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyDecoratorConfig;
import com.flipkart.krystal.krystex.dependencydecorators.TraitDispatchDecorator;
import com.flipkart.krystal.krystex.kryon.DependentChain;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfigurator;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorConfig;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecoratorConfig;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import lombok.NonNull;
import org.checkerframework.common.returnsreceiver.qual.This;

public record KryonExecutorConfig(String executorId, DecorationOrdering decorationOrdering, ImmutableSet<DependentChain> disabledDependentChains, KryonExecutor.KryonExecStrategy kryonExecStrategy, KryonExecutor.GraphTraversalStrategy graphTraversalStrategy, ImmutableMap<String, OutputLogicDecoratorConfig> outputLogicDecoratorConfigs, ImmutableMap<String, KryonDecoratorConfig> kryonDecoratorConfigs, ImmutableMap<String, DependencyDecoratorConfig> dependencyDecoratorConfigs, @NonNull SingleThreadExecutor executorService, TraitDispatchDecorator traitDispatchDecorator, boolean debug) {
    private static final AtomicLong EXEC_COUNT = new AtomicLong();

    public KryonExecutorConfig(String executorId, DecorationOrdering decorationOrdering, ImmutableSet<DependentChain> disabledDependentChains, KryonExecutor.KryonExecStrategy kryonExecStrategy, KryonExecutor.GraphTraversalStrategy graphTraversalStrategy, ImmutableMap<String, OutputLogicDecoratorConfig> outputLogicDecoratorConfigs, ImmutableMap<String, KryonDecoratorConfig> kryonDecoratorConfigs, ImmutableMap<String, DependencyDecoratorConfig> dependencyDecoratorConfigs, @NonNull SingleThreadExecutor executorService, TraitDispatchDecorator traitDispatchDecorator, boolean debug) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        if (executorId == null) {
            executorId = "KrystalExecutor-" + EXEC_COUNT.getAndIncrement();
        }
        if (kryonExecStrategy == null) {
            kryonExecStrategy = KryonExecutor.KryonExecStrategy.DIRECT;
        }
        if (graphTraversalStrategy == null) {
            graphTraversalStrategy = KryonExecutor.GraphTraversalStrategy.DEPTH;
        }
        if (kryonExecStrategy == KryonExecutor.KryonExecStrategy.DIRECT && graphTraversalStrategy == KryonExecutor.GraphTraversalStrategy.BREADTH) {
            throw new UnsupportedOperationException("DIRECT kryon execution only supports DEPTH traversal strategy.");
        }
        if (kryonDecoratorConfigs == null) {
            kryonDecoratorConfigs = ImmutableMap.of();
        }
        if (dependencyDecoratorConfigs == null) {
            dependencyDecoratorConfigs = ImmutableMap.of();
        }
        if (disabledDependentChains == null) {
            disabledDependentChains = ImmutableSet.of();
        }
        if (decorationOrdering == null) {
            decorationOrdering = DecorationOrdering.none();
        }
        if (outputLogicDecoratorConfigs == null) {
            outputLogicDecoratorConfigs = ImmutableMap.of();
        }
        if (traitDispatchDecorator == null) {
            traitDispatchDecorator = DependencyDecorator.NO_OP::decorateDependency;
        }
    }

    @Generated
    public static @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder builder() {
        return new KryonExecutorConfigBuilder();
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder toBuilder() {
        KryonExecutorConfigBuilder builder = new KryonExecutorConfigBuilder().executorId(this.executorId).decorationOrdering(this.decorationOrdering).disabledDependentChains(this.disabledDependentChains).kryonExecStrategy(this.kryonExecStrategy).graphTraversalStrategy(this.graphTraversalStrategy).executorService(this.executorService).traitDispatchDecorator(this.traitDispatchDecorator).debug(this.debug);
        if (this.outputLogicDecoratorConfigs != null) {
            builder.outputLogicDecoratorConfigs((Map<? extends String, ? extends OutputLogicDecoratorConfig>)this.outputLogicDecoratorConfigs);
        }
        if (this.kryonDecoratorConfigs != null) {
            builder.kryonDecoratorConfigs((Map<? extends String, ? extends KryonDecoratorConfig>)this.kryonDecoratorConfigs);
        }
        if (this.dependencyDecoratorConfigs != null) {
            builder.dependencyDecoratorConfigs((Map<? extends String, ? extends DependencyDecoratorConfig>)this.dependencyDecoratorConfigs);
        }
        return builder;
    }

    public static class KryonExecutorConfigBuilder {
        @Generated
        private String executorId;
        @Generated
        private DecorationOrdering decorationOrdering;
        @Generated
        private ImmutableSet<DependentChain> disabledDependentChains;
        @Generated
        private KryonExecutor.KryonExecStrategy kryonExecStrategy;
        @Generated
        private KryonExecutor.GraphTraversalStrategy graphTraversalStrategy;
        @Generated
        private ImmutableMap.Builder<String, OutputLogicDecoratorConfig> outputLogicDecoratorConfigs;
        @Generated
        private ImmutableMap.Builder<String, KryonDecoratorConfig> kryonDecoratorConfigs;
        @Generated
        private ImmutableMap.Builder<String, DependencyDecoratorConfig> dependencyDecoratorConfigs;
        @Generated
        private SingleThreadExecutor executorService;
        @Generated
        private TraitDispatchDecorator traitDispatchDecorator;
        @Generated
        private boolean debug;

        public @This KryonExecutorConfigBuilder configureWith(KryonExecutorConfigurator applier) {
            applier.addToConfig(this);
            return this;
        }

        @Generated
        KryonExecutorConfigBuilder() {
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder executorId(String executorId) {
            this.executorId = executorId;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder decorationOrdering(DecorationOrdering decorationOrdering) {
            this.decorationOrdering = decorationOrdering;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder disabledDependentChains(ImmutableSet<DependentChain> disabledDependentChains) {
            this.disabledDependentChains = disabledDependentChains;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder kryonExecStrategy(KryonExecutor.KryonExecStrategy kryonExecStrategy) {
            this.kryonExecStrategy = kryonExecStrategy;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder graphTraversalStrategy(KryonExecutor.GraphTraversalStrategy graphTraversalStrategy) {
            this.graphTraversalStrategy = graphTraversalStrategy;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder outputLogicDecoratorConfig(String key, OutputLogicDecoratorConfig value) {
            if (this.outputLogicDecoratorConfigs == null) {
                this.outputLogicDecoratorConfigs = ImmutableMap.builder();
            }
            this.outputLogicDecoratorConfigs.put((Object)key, (Object)value);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder outputLogicDecoratorConfigs(@org.checkerframework.checker.nullness.qual.NonNull Map<? extends String, ? extends OutputLogicDecoratorConfig> outputLogicDecoratorConfigs) {
            if (outputLogicDecoratorConfigs == null) {
                throw new NullPointerException("outputLogicDecoratorConfigs cannot be null");
            }
            if (this.outputLogicDecoratorConfigs == null) {
                this.outputLogicDecoratorConfigs = ImmutableMap.builder();
            }
            this.outputLogicDecoratorConfigs.putAll(outputLogicDecoratorConfigs);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder clearOutputLogicDecoratorConfigs() {
            this.outputLogicDecoratorConfigs = null;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder kryonDecoratorConfig(String key, KryonDecoratorConfig value) {
            if (this.kryonDecoratorConfigs == null) {
                this.kryonDecoratorConfigs = ImmutableMap.builder();
            }
            this.kryonDecoratorConfigs.put((Object)key, (Object)value);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder kryonDecoratorConfigs(@org.checkerframework.checker.nullness.qual.NonNull Map<? extends String, ? extends KryonDecoratorConfig> kryonDecoratorConfigs) {
            if (kryonDecoratorConfigs == null) {
                throw new NullPointerException("kryonDecoratorConfigs cannot be null");
            }
            if (this.kryonDecoratorConfigs == null) {
                this.kryonDecoratorConfigs = ImmutableMap.builder();
            }
            this.kryonDecoratorConfigs.putAll(kryonDecoratorConfigs);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder clearKryonDecoratorConfigs() {
            this.kryonDecoratorConfigs = null;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder dependencyDecoratorConfig(String key, DependencyDecoratorConfig value) {
            if (this.dependencyDecoratorConfigs == null) {
                this.dependencyDecoratorConfigs = ImmutableMap.builder();
            }
            this.dependencyDecoratorConfigs.put((Object)key, (Object)value);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder dependencyDecoratorConfigs(@org.checkerframework.checker.nullness.qual.NonNull Map<? extends String, ? extends DependencyDecoratorConfig> dependencyDecoratorConfigs) {
            if (dependencyDecoratorConfigs == null) {
                throw new NullPointerException("dependencyDecoratorConfigs cannot be null");
            }
            if (this.dependencyDecoratorConfigs == null) {
                this.dependencyDecoratorConfigs = ImmutableMap.builder();
            }
            this.dependencyDecoratorConfigs.putAll(dependencyDecoratorConfigs);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder clearDependencyDecoratorConfigs() {
            this.dependencyDecoratorConfigs = null;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder executorService(@NonNull SingleThreadExecutor executorService) {
            if (executorService == null) {
                throw new NullPointerException("executorService is marked non-null but is null");
            }
            this.executorService = executorService;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder traitDispatchDecorator(TraitDispatchDecorator traitDispatchDecorator) {
            this.traitDispatchDecorator = traitDispatchDecorator;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfigBuilder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull KryonExecutorConfig build() {
            ImmutableMap outputLogicDecoratorConfigs = this.outputLogicDecoratorConfigs == null ? ImmutableMap.of() : this.outputLogicDecoratorConfigs.build();
            ImmutableMap kryonDecoratorConfigs = this.kryonDecoratorConfigs == null ? ImmutableMap.of() : this.kryonDecoratorConfigs.build();
            ImmutableMap dependencyDecoratorConfigs = this.dependencyDecoratorConfigs == null ? ImmutableMap.of() : this.dependencyDecoratorConfigs.build();
            return new KryonExecutorConfig(this.executorId, this.decorationOrdering, this.disabledDependentChains, this.kryonExecStrategy, this.graphTraversalStrategy, (ImmutableMap<String, OutputLogicDecoratorConfig>)outputLogicDecoratorConfigs, (ImmutableMap<String, KryonDecoratorConfig>)kryonDecoratorConfigs, (ImmutableMap<String, DependencyDecoratorConfig>)dependencyDecoratorConfigs, this.executorService, this.traitDispatchDecorator, this.debug);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "KryonExecutorConfig.KryonExecutorConfigBuilder(executorId=" + this.executorId + ", decorationOrdering=" + String.valueOf(this.decorationOrdering) + ", disabledDependentChains=" + String.valueOf(this.disabledDependentChains) + ", kryonExecStrategy=" + String.valueOf((Object)this.kryonExecStrategy) + ", graphTraversalStrategy=" + String.valueOf((Object)this.graphTraversalStrategy) + ", outputLogicDecoratorConfigs=" + String.valueOf(this.outputLogicDecoratorConfigs) + ", kryonDecoratorConfigs=" + String.valueOf(this.kryonDecoratorConfigs) + ", dependencyDecoratorConfigs=" + String.valueOf(this.dependencyDecoratorConfigs) + ", executorService=" + String.valueOf(this.executorService) + ", traitDispatchDecorator=" + String.valueOf(this.traitDispatchDecorator) + ", debug=" + this.debug + ")";
        }
    }
}

