/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.decoration.DecorationOrdering;
import com.flipkart.krystal.krystex.decoration.FlushCommand;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyDecorator;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyExecutionContext;
import com.flipkart.krystal.krystex.dependencydecoration.VajramInvocation;
import com.flipkart.krystal.krystex.kryon.DependentChain;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonCommandResponse;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.VajramKryonDefinition;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractKryon<C extends KryonCommand<?>, R extends KryonCommandResponse>
implements Kryon<C, R> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractKryon.class);
    static final int INITIAL_CAPACITY = 64;
    protected final VajramKryonDefinition kryonDefinition;
    protected final VajramID vajramID;
    protected final KryonExecutor kryonExecutor;
    protected final Function<LogicExecutionContext, NavigableSet<OutputLogicDecorator>> sortedOutputLogicDecoratorsSupplier;
    private final Function<DependencyExecutionContext, ImmutableMap<String, DependencyDecorator>> depDecoratorSuppliers;
    private final Map<DependentChain, NavigableSet<OutputLogicDecorator>> requestScopedDecoratorsByDepChain = new HashMap<DependentChain, NavigableSet<OutputLogicDecorator>>(64);
    protected final DecorationOrdering decorationOrdering;
    private final Map<VajramID, NavigableSet<DependencyDecorator>> decoratorsByDependency = new HashMap<VajramID, NavigableSet<DependencyDecorator>>();

    AbstractKryon(VajramKryonDefinition definition, KryonExecutor kryonExecutor, Function<LogicExecutionContext, NavigableSet<OutputLogicDecorator>> sortedOutputLogicDecoratorsSupplier, Function<DependencyExecutionContext, ImmutableMap<String, DependencyDecorator>> depDecoratorSuppliers, DecorationOrdering decorationOrdering) {
        this.kryonDefinition = definition;
        this.vajramID = definition.vajramID();
        this.kryonExecutor = kryonExecutor;
        this.sortedOutputLogicDecoratorsSupplier = sortedOutputLogicDecoratorsSupplier;
        this.depDecoratorSuppliers = depDecoratorSuppliers;
        this.decorationOrdering = decorationOrdering;
    }

    protected NavigableSet<OutputLogicDecorator> getSortedOutputLogicDecorators(DependentChain dependentChain) {
        OutputLogicDefinition outputLogicDefinition = this.kryonDefinition.getOutputLogicDefinition();
        return this.requestScopedDecoratorsByDepChain.computeIfAbsent(dependentChain, _d -> this.sortedOutputLogicDecoratorsSupplier.apply(new LogicExecutionContext(this.vajramID, outputLogicDefinition.tags(), dependentChain, this.kryonDefinition.kryonDefinitionRegistry())));
    }

    protected NavigableSet<DependencyDecorator> getSortedDependencyDecorators(VajramID depVajramId, DependentChain dependentChain) {
        return this.decoratorsByDependency.computeIfAbsent(depVajramId, _k -> {
            TreeSet sortedDecorators = new TreeSet(this.decorationOrdering.encounterOrder().reversed());
            Dependency dependency = dependentChain.latestDependency();
            if (dependency == null) {
                return sortedDecorators;
            }
            sortedDecorators.addAll(this.depDecoratorSuppliers.apply(new DependencyExecutionContext(dependency, dependentChain)).values());
            return sortedDecorators;
        });
    }

    @Override
    public VajramKryonDefinition getKryonDefinition() {
        return this.kryonDefinition;
    }

    protected void flushDecorators(DependentChain dependentChain) {
        Iterable reverseSortedDecorators = this.getSortedOutputLogicDecorators(dependentChain)::descendingIterator;
        for (OutputLogicDecorator decorator : reverseSortedDecorators) {
            try {
                decorator.executeCommand(new FlushCommand(dependentChain));
            }
            catch (Throwable e) {
                log.error("Error while flushing decorator: {}. This is most probably a bug since decorator methods are not supposed to throw exceptions. This can cause unpredictable behaviour in the krystal graph execution. Please fix!", (Object)decorator, (Object)e);
            }
        }
    }

    protected <R2 extends KryonCommandResponse> VajramInvocation<R2> decorateVajramInvocation(DependentChain dependentChain, VajramID depVajramID, VajramInvocation<R2> invocationToDecorate) {
        for (DependencyDecorator dependencyDecorator : this.getSortedDependencyDecorators(depVajramID, dependentChain)) {
            VajramInvocation<R2> previousDecoratedInvocation = invocationToDecorate;
            invocationToDecorate = dependencyDecorator.decorateDependency(previousDecoratedInvocation);
        }
        return invocationToDecorate;
    }
}

