/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.internal;

import com.flipkart.krystal.krystex.KrystalExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class KrystalExecutorExecService
implements ExecutorService {
    public static ThreadLocal<@Nullable KrystalExecutor> THREAD_LOCAL = new ThreadLocal();
    private final ExecutorService delegate;
    private final KrystalExecutor kryonExecutor;

    public KrystalExecutorExecService(KrystalExecutor kryonExecutor, ExecutorService delegate) {
        this.kryonExecutor = kryonExecutor;
        this.delegate = delegate;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.wrap(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.wrap(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.wrap(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList mappedCollection = new ArrayList(tasks.size());
        tasks.forEach(tCallable -> mappedCollection.add(this.wrap((Callable)tCallable)));
        return this.delegate.invokeAll(mappedCollection);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList mappedCollection = new ArrayList(tasks.size());
        tasks.forEach(tCallable -> mappedCollection.add(this.wrap((Callable)tCallable)));
        return this.delegate.invokeAll(mappedCollection, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        ArrayList mappedCollection = new ArrayList(tasks.size());
        tasks.forEach(tCallable -> mappedCollection.add(this.wrap((Callable)tCallable)));
        return this.delegate.invokeAny(mappedCollection);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList mappedCollection = new ArrayList(tasks.size());
        tasks.forEach(tCallable -> mappedCollection.add(this.wrap((Callable)tCallable)));
        return this.delegate.invokeAny(mappedCollection, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.wrap(command));
    }

    private <T> Callable<T> wrap(Callable<T> task) {
        return () -> {
            @Nullable KrystalExecutor oldValue = THREAD_LOCAL.get();
            THREAD_LOCAL.set(this.kryonExecutor);
            try {
                Object v = task.call();
                return v;
            }
            finally {
                THREAD_LOCAL.set(oldValue);
            }
        };
    }

    private Runnable wrap(Runnable task) {
        return () -> {
            @Nullable KrystalExecutor oldValue = THREAD_LOCAL.get();
            THREAD_LOCAL.set(this.kryonExecutor);
            try {
                task.run();
            }
            finally {
                THREAD_LOCAL.set(oldValue);
            }
        };
    }
}

