/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.kryon;

import com.flipkart.krystal.core.GraphExecutionData;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.facets.Facet;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.facets.resolution.ResolverDefinition;
import com.flipkart.krystal.krystex.GraphExecutionLogic;
import com.flipkart.krystal.krystex.LogicDefinition;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonDefinitionRegistry;
import com.flipkart.krystal.krystex.kryon.KryonDefinitionView;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.resolution.CreateNewRequest;
import com.flipkart.krystal.krystex.resolution.FacetsFromRequest;
import com.flipkart.krystal.krystex.resolution.Resolver;
import com.flipkart.krystal.tags.ElementTags;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;

public record VajramKryonDefinition(VajramID vajramID, ImmutableSet<Facet> facets, KryonLogicId outputLogicId, ImmutableMap<ResolverDefinition, Resolver> resolversByDefinition, LogicDefinition<CreateNewRequest> createNewRequest, LogicDefinition<FacetsFromRequest> facetsFromRequest, KryonDefinitionRegistry kryonDefinitionRegistry, GraphExecutionLogic graphExecutionLogic, KryonDefinitionView view, ElementTags tags) implements KryonDefinition
{
    public VajramKryonDefinition(VajramID vajramID, Set<? extends Facet> facets, KryonLogicId outputLogicId, ImmutableMap<ResolverDefinition, Resolver> resolversByDefinition, LogicDefinition<CreateNewRequest> createNewRequest, LogicDefinition<FacetsFromRequest> facetsFromRequest, KryonDefinitionRegistry kryonDefinitionRegistry, GraphExecutionLogic graphExecutionLogic, ElementTags tags) {
        this(vajramID, (ImmutableSet<Facet>)ImmutableSet.copyOf(facets), outputLogicId, resolversByDefinition, createNewRequest, facetsFromRequest, kryonDefinitionRegistry, graphExecutionLogic, KryonDefinitionView.createView(facets, resolversByDefinition), tags);
    }

    public VajramKryonDefinition {
        view.resolverDefinitionsByDependencies().forEach((dep, resolvers) -> {
            if (resolvers.stream().filter(r -> r.definition().canFanout()).count() > 1L) {
                throw new IllegalStateException("Multiple fanout resolvers found for dependency %s of vajram %s. This is not supported.".formatted(dep, vajramID.id()));
            }
        });
    }

    public ImmutableSet<Dependency> dependencies() {
        return this.view.dependencies();
    }

    public <T> OutputLogicDefinition<T> getOutputLogicDefinition() {
        return this.kryonDefinitionRegistry().logicDefinitionRegistry().getOutputLogic(this.outputLogicId());
    }

    public void executeGraph(GraphExecutionData graphExecutionData) {
        this.graphExecutionLogic.executeGraph(graphExecutionData);
    }

    @Override
    public ImmutableMap<Integer, Facet> facetsById() {
        return this.view.facetsById();
    }

    @Override
    public ImmutableSet<Facet> facetsByType(FacetType facetType) {
        return (ImmutableSet)this.view.facetsByType().getOrDefault((Object)facetType, (Object)ImmutableSet.of());
    }

    public ImmutableMap<Optional<Facet>, ImmutableSet<Resolver>> resolverDefinitionsByInput() {
        return this.view.resolverDefinitionsBySource();
    }

    public ImmutableSet<Dependency> dependenciesWithNoResolvers() {
        return this.view.dependenciesWithNoResolvers();
    }

    public ImmutableMap<Dependency, ImmutableSet<Resolver>> resolverDefinitionsByDependencies() {
        return this.view.resolverDefinitionsByDependencies();
    }

    public Set<Facet> givenFacets() {
        return this.view.givenFacets();
    }

    public ImmutableMap<Facet, ImmutableSet<Dependency>> dependenciesByBoundFacet() {
        return this.view.dependenciesByBoundFacet();
    }

    public ImmutableSet<Dependency> dependenciesWithNoFacetResolvers() {
        return this.view.dependenciesWithNoFacetResolvers();
    }

    public ImmutableMap<Dependency, ImmutableSet<Facet>> dependencyToBoundFacetsMapping() {
        return this.view.dependencyToBoundFacetsMapping();
    }
}

