/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.testfixtures;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.except.IllegalModificationException;
import com.flipkart.krystal.facets.InputMirror;
import com.flipkart.krystal.krystex.testfixtures.SimpleImmutRequest;
import com.flipkart.krystal.krystex.testfixtures.SimpleRequest;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SimpleRequestBuilder<T>
implements ImmutableRequest.Builder<T> {
    private final ImmutableSet<? extends InputMirror> _facets;
    private final Map<Integer, Errable<Object>> _data;
    private final VajramID _vajramID;

    public SimpleRequestBuilder(Set<? extends InputMirror> _facets, VajramID vajramID) {
        this(_facets, new LinkedHashMap<Integer, Errable<Object>>(), vajramID);
    }

    public SimpleRequestBuilder(Set<? extends InputMirror> _facets, Map<Integer, Errable<Object>> data, VajramID vajramID) {
        this._facets = ImmutableSet.copyOf(_facets);
        this._data = data;
        this._vajramID = vajramID;
    }

    public Errable<Object> _get(int facetId) {
        return this._data.getOrDefault(facetId, (Errable<Object>)Errable.nil());
    }

    public Map<Integer, Errable<Object>> _asMap() {
        return this._data;
    }

    public ImmutableSet<? extends InputMirror> _facets() {
        return this._facets;
    }

    public boolean _hasValue(int facetId) {
        return this._data.containsKey(facetId);
    }

    public SimpleImmutRequest<T> _build() {
        return new SimpleImmutRequest(this._data, this._vajramID);
    }

    public SimpleRequestBuilder<T> _set(int facetId, FacetValue value) {
        if (!(value instanceof Errable)) {
            throw new IllegalArgumentException("Expected Errable but found %s".formatted(value.getClass()));
        }
        Errable errable = (Errable)value;
        if (this._data.containsKey(facetId)) {
            throw new IllegalModificationException();
        }
        this._data.put(facetId, (Errable<Object>)errable);
        return this;
    }

    public SimpleRequestBuilder<T> _newCopy() {
        return new SimpleRequestBuilder<T>((Set<InputMirror>)this._facets, (Map<Integer, Errable<Object>>)new LinkedHashMap<Integer, Errable<Object>>(this._data), this._vajramID);
    }

    public SimpleRequestBuilder<T> _asBuilder() {
        return this;
    }

    public VajramID _vajramID() {
        return this._vajramID;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleRequest)) {
            return false;
        }
        SimpleRequest other = (SimpleRequest)o;
        return Objects.equals(this._data, other._asMap());
    }

    public int hashCode() {
        return Objects.hash(this._data);
    }
}

