/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.testfixtures;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.FacetValuesBuilder;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.JavaType;
import com.flipkart.krystal.facets.Facet;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.facets.InputMirror;
import com.flipkart.krystal.krystex.testfixtures.FacetValuesMap;
import com.flipkart.krystal.krystex.testfixtures.FacetValuesMapBuilder;
import com.flipkart.krystal.krystex.testfixtures.SimpleDep;
import com.flipkart.krystal.krystex.testfixtures.SimpleRequest;
import com.flipkart.krystal.krystex.testfixtures.SimpleRequestBuilder;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class SimpleFacet
implements Facet,
InputMirror {
    private static int count;
    private final int id;
    private final String name;
    private final FacetType facetType;

    public static SimpleFacet input(int facetId) {
        return new SimpleFacet(facetId, "input" + count++, FacetType.INPUT);
    }

    public static SimpleDep dependency(int facetId, VajramID ofVajramID, VajramID onVajramID) {
        return new SimpleDep(facetId, "dep" + count++, ofVajramID, onVajramID);
    }

    public SimpleFacet(int id, String name, FacetType facetType) {
        this.id = id;
        this.name = name;
        this.facetType = facetType;
    }

    public FacetType facetType() {
        return this.facetType;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public @Nullable FacetValue getFacetValue(FacetValues facetValues) {
        return (FacetValue)((FacetValuesMap)facetValues)._asMap().get((Object)this.id());
    }

    public void setFacetValue(FacetValuesBuilder facets, FacetValue value) {
        ((FacetValuesMapBuilder)facets)._set(this.id(), value);
    }

    public String documentation() {
        return this.facetType + " doc";
    }

    public @Nullable Object getFromRequest(Request request) {
        return ((SimpleRequest)request)._asMap().get(this.id());
    }

    public void setToRequest(ImmutableRequest.Builder request, @Nullable Object value) {
        ((SimpleRequestBuilder)request)._asMap().put(this.id(), (Errable<Object>)Errable.withValue((Object)value));
    }

    public DataType<?> type() {
        return JavaType.create(Object.class, (DataType[])new DataType[0]);
    }

    public VajramID ofVajramID() {
        return VajramID.vajramID((String)"testVajram");
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleFacet that = (SimpleFacet)o;
        return this.id == that.id && this.facetType == that.facetType;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.facetType);
    }
}

