/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.krystex.LogicDefinition;
import com.flipkart.krystal.krystex.decoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.decoration.MainLogicDecoratorConfig;
import com.flipkart.krystal.krystex.node.DependantChain;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.flipkart.krystal.logic.LogicTag;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MainLogicDefinition<T>
extends LogicDefinition {
    private final Map<String, MainLogicDecoratorConfig> requestScopedLogicDecoratorConfigs = new HashMap<String, MainLogicDecoratorConfig>();
    private final Map<String, MainLogicDecoratorConfig> sessionScopedLogicDecoratorConfigs = new HashMap<String, MainLogicDecoratorConfig>();
    private final Map<String, Map<String, MainLogicDecorator>> sessionScopedDecorators = new LinkedHashMap<String, Map<String, MainLogicDecorator>>();

    public MainLogicDefinition(NodeLogicId nodeLogicId, Set<String> inputs, ImmutableMap<String, LogicTag> logicTags) {
        super(nodeLogicId, inputs, logicTags);
    }

    public abstract ImmutableMap<Inputs, CompletableFuture<T>> execute(ImmutableList<Inputs> var1);

    public ImmutableMap<String, MainLogicDecoratorConfig> getRequestScopedLogicDecoratorConfigs() {
        return ImmutableMap.copyOf(this.requestScopedLogicDecoratorConfigs);
    }

    public ImmutableMap<String, MainLogicDecorator> getSessionScopedLogicDecorators(NodeDefinition nodeDefinition, @Nullable DependantChain dependants) {
        LinkedHashMap decorators = new LinkedHashMap();
        this.sessionScopedLogicDecoratorConfigs.forEach((s, decoratorConfig) -> {
            LogicExecutionContext logicExecutionContext = new LogicExecutionContext(nodeDefinition.nodeId(), (ImmutableMap<String, LogicTag>)this.logicTags(), dependants, nodeDefinition.nodeDefinitionRegistry());
            if (decoratorConfig.shouldDecorate().test(logicExecutionContext)) {
                String instanceId = decoratorConfig.instanceIdGenerator().apply(logicExecutionContext);
                decorators.put(s, this.sessionScopedDecorators.computeIfAbsent((String)s, k -> new LinkedHashMap()).computeIfAbsent(instanceId, k -> decoratorConfig.factory().apply(new MainLogicDecoratorConfig.DecoratorContext(instanceId, logicExecutionContext))));
            }
        });
        return ImmutableMap.copyOf(decorators);
    }

    public void registerRequestScopedDecorator(MainLogicDecoratorConfig decoratorConfig) {
        this.requestScopedLogicDecoratorConfigs.put(decoratorConfig.decoratorType(), decoratorConfig);
    }

    public void registerSessionScopedLogicDecorator(MainLogicDecoratorConfig decoratorConfig) {
        this.sessionScopedLogicDecoratorConfigs.put(decoratorConfig.decoratorType(), decoratorConfig);
    }
}

