/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.decorators;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.internal.SemaphoreBulkhead;
import io.github.resilience4j.decorators.Decorators;
import java.util.Optional;

public final class Resilience4JBulkhead
implements MainLogicDecorator {
    public static final String DECORATOR_TYPE = Resilience4JBulkhead.class.getName();
    private final String instanceId;
    private Bulkhead bulkhead;

    public Resilience4JBulkhead(String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public MainLogic<Object> decorateLogic(MainLogic<Object> logicToDecorate) {
        Bulkhead bulkhead = this.bulkhead;
        if (bulkhead != null) {
            return arg_0 -> ((Decorators.DecorateFunction)Decorators.ofFunction(logicToDecorate::execute).withBulkhead(bulkhead)).apply(arg_0);
        }
        return logicToDecorate;
    }

    public void onConfigUpdate(ConfigProvider configProvider) {
        this.updateBulkhead(configProvider);
    }

    @Override
    public String getId() {
        return this.instanceId;
    }

    private void init(ConfigProvider configProvider) {
        this.bulkhead = this.getBulkheadConfig(configProvider).map(bulkheadConfig -> new SemaphoreBulkhead(this.instanceId + ".bulkhead", bulkheadConfig)).orElse(null);
    }

    private void updateBulkhead(ConfigProvider configProvider) {
        Bulkhead bulkhead = this.bulkhead;
        Optional<BulkheadConfig> newBulkheadConfig = this.getBulkheadConfig(configProvider);
        if (!Optional.ofNullable(bulkhead).map(Bulkhead::getBulkheadConfig).equals(newBulkheadConfig)) {
            if (bulkhead != null && newBulkheadConfig.isPresent()) {
                bulkhead.changeConfig(newBulkheadConfig.get());
            } else {
                this.init(configProvider);
            }
        }
    }

    private Optional<BulkheadConfig> getBulkheadConfig(ConfigProvider configProvider) {
        boolean bulkheadEnabled = configProvider.getConfig(this.instanceId + ".bulkhead.enabled").orElse(true);
        if (!bulkheadEnabled) {
            return Optional.empty();
        }
        BulkheadConfig.Builder builder = BulkheadConfig.custom().writableStackTraceEnabled(false);
        configProvider.getConfig(this.instanceId + ".bulkhead.max_concurrency").ifPresent(arg_0 -> ((BulkheadConfig.Builder)builder).maxConcurrentCalls(arg_0));
        return Optional.of(builder.build());
    }
}

